/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AirItineraryReceiptData;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ContractActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ExtRuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.FeePaymentTypeActionProvider;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TechnicalFeeActionsProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.handlers.BaseAirPropertySet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseCommissionActionSet
implements Serializable,
CommissionActionsProvider,
ContractActionsProvider,
FeePaymentTypeActionProvider,
TechnicalFeeActionsProvider {
    private static final long serialVersionUID = 6598961103490532526L;
    private final Map<EntityReference<? extends BaseCommissionProperties>, String> cacheCategories = new HashMap<EntityReference<? extends BaseCommissionProperties>, String>();
    private final Map<String, Boolean> prodUid2IncludeBonus = new HashMap<String, Boolean>();
    private final Map<String, Boolean> prodUid2TransferTechFee = new HashMap<String, Boolean>();
    private final RuleProxy<?, ?> proxy;
    private final BaseAirPropertySet propertySet;
    private String commissionCurrencyCode;
    private Double commissionRate;
    private BigDecimal commissionValue;
    protected EntityReference<ContractRelationDescription> contractRelationDescription;
    private final Map<String, RuleResultValue> results = new LinkedHashMap<String, RuleResultValue>();
    private final Set<PaymentType> allowedPaymentTypes = new LinkedHashSet<PaymentType>();
    private final List<String> tourCodes = new ArrayList<String>();
    private boolean overrideTourCodes;
    private AirItineraryReceiptData itineraryReceiptData;
    protected String equiveCurrencyCode = null;
    private Boolean selectContract;
    private Boolean translateSupplierFee;
    private boolean sabreExcludeCommissionQualifier;
    private PaymentType feePaymentType;

    public BaseCommissionActionSet(RuleProxy<?, ?> px, BaseAirPropertySet propSet) {
        this.proxy = px;
        this.propertySet = propSet;
    }

    protected RuleProxy<?, ?> getProxy() {
        return this.proxy;
    }

    protected BaseAirPropertySet getPropertySet() {
        return this.propertySet;
    }

    public Map<String, Boolean> getProdUid2IncludeBonus() {
        return this.prodUid2IncludeBonus;
    }

    public Map<String, Boolean> getProdUid2TransferTechFee() {
        return this.prodUid2TransferTechFee;
    }

    public void addAllowedPaymentType(String paymentTypeStr) {
        PaymentType pt = (PaymentType)CollectionUtil.findEnumConstant(PaymentType.class, (String)paymentTypeStr);
        if (pt != null) {
            this.allowedPaymentTypes.add(pt);
        }
    }

    public Set<PaymentType> getAllowedPaymentTypes() {
        return this.allowedPaymentTypes;
    }

    public void setTourCodes(List<String> values) {
        this.overrideTourCodes = true;
        this.tourCodes.clear();
        if (values != null) {
            this.tourCodes.addAll(values);
        }
    }

    public List<String> getTourCodes() {
        return this.tourCodes;
    }

    public boolean areTourCodesOverridden() {
        return this.overrideTourCodes;
    }

    public void setReceiptTemplates(Collection<EntityReference<TemplateDocument>> receiptTemplates) {
    }

    public AirItineraryReceiptData getItineraryReceiptData() {
        return this.itineraryReceiptData;
    }

    public void setItineraryReceiptData(AirItineraryReceiptData itineraryReceiptData) {
        this.itineraryReceiptData = itineraryReceiptData;
    }

    public BigDecimal getCommissionValue() {
        return this.commissionValue;
    }

    public boolean setCommission(double value, String currency, String target, String[] fops) {
        if (!this.isApplicable(target, fops)) {
            return false;
        }
        if (TextUtil.isBlank((String)currency) || "%".equals(currency)) {
            this.commissionRate = value;
            return true;
        }
        this.commissionValue = BigDecimal.valueOf(value);
        this.commissionCurrencyCode = currency;
        this.commissionValue = BigDecimal.valueOf(value);
        return true;
    }

    public boolean isSabreExcludeCommissionQualifier() {
        return this.sabreExcludeCommissionQualifier;
    }

    public void setSabreExcludeCommissionQualifier(boolean value) {
        this.sabreExcludeCommissionQualifier = value;
    }

    private boolean isApplicable(String target, String[] fops) {
        block0: for (String fop : fops) {
            if (fop == null) continue;
            for (String pt : this.propertySet.getTCHPaymentTypes()) {
                if (!pt.equals(fop)) continue;
                continue block0;
            }
            return false;
        }
        return TextUtil.isSame((String)this.propertySet.getTargetType(), (String)target);
    }

    public void setCommissionCurrencyCode(String value) {
        this.commissionCurrencyCode = value;
    }

    public Double getCommissionRate() {
        return this.commissionRate;
    }

    public void setCommissionRate(double value) {
        this.commissionRate = value;
    }

    public void setCommissionValue(double value) {
        this.commissionValue = BigDecimal.valueOf(value);
    }

    public String getCommissionCurrencyCode() {
        return this.commissionCurrencyCode;
    }

    public void calculateCommissionByRate(boolean totalRate, double value) {
        this.commissionValue = this.calculateFeeByRateInternal(totalRate, value);
        this.commissionCurrencyCode = this.getEquivalentCurrencyCode();
        this.commissionRate = value;
    }

    private BigDecimal calculateFeeByRateInternal(boolean totalRate, double value) {
        return totalRate ? this.propertySet.getPrice().multiply(BigDecimal.valueOf(value)).divide(BigDecimal.valueOf(100L)) : BigDecimal.valueOf(this.propertySet.getFare()).multiply(BigDecimal.valueOf(value)).divide(BigDecimal.valueOf(100L));
    }

    public void calculateCommissionByValue(boolean perSegment, double oneWayValue, double roundTripValue) throws Exception {
        this.commissionValue = this.calculateFeeByValueInternal(perSegment, oneWayValue, roundTripValue);
        this.commissionCurrencyCode = this.getEquivalentCurrencyCode();
        this.commissionRate = null;
    }

    private BigDecimal calculateFeeByValueInternal(boolean perSegment, double oneWayValue, double roundTripValue) {
        if (perSegment) {
            return BigDecimal.valueOf(this.propertySet.getNumOfSegments()).multiply(BigDecimal.valueOf(Math.max(oneWayValue, roundTripValue)));
        }
        if (this.propertySet.isOneWayTicket()) {
            return BigDecimal.valueOf(oneWayValue);
        }
        return BigDecimal.valueOf(roundTripValue);
    }

    public void setCommission(String category, String className, String uid, double value, String currencyCode) {
        RuleResultValue res = new RuleResultValue();
        res.setCurrencyCode(currencyCode);
        res.setValue(value);
        res.setTarget(this.createReference(className, uid));
        this.results.put(category, res);
    }

    public boolean setCommission(String category, String className, String uid, double value, String currencyCode, String target, String[] fops) {
        if (!this.isApplicable(target, fops)) {
            return false;
        }
        RuleResultValue res = new RuleResultValue();
        res.setCurrencyCode(currencyCode);
        res.setValue(value);
        res.setTarget(this.createReference(className, uid));
        this.results.put(category, res);
        return true;
    }

    public Map<String, RuleResultValue> getResults() {
        return this.results;
    }

    public boolean accept(String category, String className, String uid) throws Exception {
        return this.accept(category, this.createReference(className, uid));
    }

    protected List<Commission> createCommissions(EntityReference<ContractRelationDescription> description, String currencyCode, List<Commission> hiddenFees, Collection<ValidationMessage> messages) throws Exception {
        this.contractRelationDescription = description;
        this.equiveCurrencyCode = currencyCode;
        Pair<AppliedRulesData> ruleResults = BaseCommissionActionSet.analyzeRulesResults(this.results.values(), messages);
        AppliedRulesData hiddenFeesResults = (AppliedRulesData)ruleResults.getFirst();
        AppliedRulesData standardCommissionsResults = (AppliedRulesData)ruleResults.getLast();
        ArrayList<Commission> result = new ArrayList<Commission>();
        ArrayList<Commission> allHiddenFees = new ArrayList<Commission>(hiddenFees);
        List<Commission> newHiddenFees = this.createCommissions(hiddenFeesResults, allHiddenFees, messages);
        allHiddenFees.addAll(newHiddenFees);
        result.addAll(newHiddenFees);
        result.addAll(this.createCommissions(standardCommissionsResults, allHiddenFees, messages));
        if (this.commissionValue != null || this.commissionRate != null) {
            Commission commission = new Commission();
            commission.setContractType(GeneralProductHelper.getContractType(this.contractRelationDescription));
            if (this.commissionValue != null && this.commissionCurrencyCode != null) {
                Money money = new Money();
                money.setCurrency(this.commissionCurrencyCode);
                money.setValue(this.commissionValue);
                commission.setAmount(money);
            }
            if (this.commissionRate != null) {
                commission.setRate(this.commissionRate);
            }
            commission.setRoundingMode(RoundingMode.MATH);
            commission.setRoundingValue(RoundingValue.V_0_1);
            this.updateEquivalentAmount(commission, null, null, hiddenFees, false, messages);
            result.add(commission);
        }
        result.sort(new Comparator<Commission>(){

            @Override
            public int compare(Commission o1, Commission o2) {
                return this.getIndex((EntityReference<? extends BaseCommissionProperties>)o1.getCommissionProperties()) - this.getIndex((EntityReference<? extends BaseCommissionProperties>)o2.getCommissionProperties());
            }

            private int getIndex(EntityReference<? extends BaseCommissionProperties> commissionProperties) {
                if (commissionProperties == null) {
                    return 0;
                }
                if (CommissionProperties.class.equals((Object)commissionProperties.getType())) {
                    return 1;
                }
                if (FeeProperties.class.equals((Object)commissionProperties.getType())) {
                    return 2;
                }
                if (DiscountProperties.class.equals((Object)commissionProperties.getType())) {
                    return 3;
                }
                return 4;
            }
        });
        return result;
    }

    private List<Commission> createCommissions(AppliedRulesData rulesData, List<Commission> hiddenFees, Collection<ValidationMessage> messages) throws Exception {
        ArrayList<Commission> commissions = new ArrayList<Commission>();
        HashMap<String, RuleResultValue> minCommissions = new HashMap<String, RuleResultValue>(rulesData.minCommissions);
        HashMap<String, RuleResultValue> manuallyCalculatedCommissions = new HashMap<String, RuleResultValue>(rulesData.manuallyCalculatedCommissions);
        for (Map.Entry<String, RuleResultValue> entry : rulesData.standardCommissions.entrySet()) {
            Commission maxCommission;
            RuleResultValue ruleResult = entry.getValue();
            Commission commission = this.calculateCommissionAmount(ruleResult, hiddenFees, messages);
            if (commission == null) continue;
            manuallyCalculatedCommissions.remove(entry.getKey());
            ruleResult = rulesData.maxCommissions.get(entry.getKey());
            if (ruleResult != null && (maxCommission = this.calculateCommissionAmount(ruleResult, hiddenFees, messages)) != null && Math.abs(commission.getEquivalentAmount().doubleValue()) - Math.abs(maxCommission.getEquivalentAmount().doubleValue()) > 0.001) {
                commission = maxCommission;
            }
            if ((ruleResult = rulesData.minCommissions.get(entry.getKey())) != null) {
                minCommissions.remove(entry.getKey());
                Commission minCommission = this.calculateCommissionAmount(ruleResult, hiddenFees, messages);
                if (minCommission != null && Math.abs(minCommission.getEquivalentAmount().doubleValue()) - Math.abs(commission.getEquivalentAmount().doubleValue()) > 0.001) {
                    commission = minCommission;
                }
            }
            commissions.add(commission);
        }
        for (RuleResultValue ruleResult : minCommissions.values()) {
            Commission minCommission = this.calculateCommissionAmount(ruleResult, hiddenFees, messages);
            if (minCommission == null) continue;
            commissions.add(minCommission);
        }
        for (RuleResultValue ruleResult : manuallyCalculatedCommissions.values()) {
            Commission manuallyCalculatedCommission = this.calculateCommissionAmount(ruleResult, hiddenFees, messages);
            if (manuallyCalculatedCommission == null) continue;
            commissions.add(manuallyCalculatedCommission);
        }
        return commissions;
    }

    public static Pair<AppliedRulesData> analyzeRulesResults(Collection<RuleResultValue> values, Collection<ValidationMessage> messages) throws Exception {
        Pair result = new Pair((Object)new AppliedRulesData(), (Object)new AppliedRulesData());
        for (RuleResultValue value : values) {
            FeeProperties prop;
            EntityContainer ctr = EntityStorage.get().resolve(value.getTarget());
            boolean hidden = false;
            boolean mininum = false;
            boolean maximum = false;
            boolean manuallyCalculated = false;
            if (ctr == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.BCAS_CANT_DEFINE_COMMISSION_PROPERTIES, (Object[])new Object[]{value.getTarget()}));
                continue;
            }
            if (ctr.getEntity() instanceof FeeProperties) {
                prop = (FeeProperties)ctr.getEntity();
                hidden = prop.isHidden();
                mininum = prop.isMinimum() || prop.getType() == FeeType.MINIMUM;
                maximum = prop.getType() == FeeType.MAXIMUM;
                boolean bl = manuallyCalculated = prop.getType() == FeeType.MANUALLY_CALCULATED;
            }
            if (ctr.getEntity() instanceof CommissionProperties) {
                prop = (CommissionProperties)ctr.getEntity();
                mininum = prop.isMinimum();
                manuallyCalculated = prop.isManuallyCalculated();
            }
            if (ctr.getEntity() instanceof DiscountProperties) {
                prop = (DiscountProperties)ctr.getEntity();
                mininum = prop.getType() == DiscountType.MINIMUM;
                manuallyCalculated = prop.getType() == DiscountType.MANUALLY_CALCULATED;
            }
            AppliedRulesData data = hidden ? (AppliedRulesData)result.getFirst() : (AppliedRulesData)result.getLast();
            String category = RulesHelper.getRuleCategoryValueForActionSet((EntityReference)value.getTarget());
            if (mininum) {
                data.minCommissions.put(category, value);
                continue;
            }
            if (maximum) {
                data.maxCommissions.put(category, value);
                continue;
            }
            if (manuallyCalculated) {
                data.manuallyCalculatedCommissions.put(category, value);
                continue;
            }
            data.standardCommissions.put(category, value);
        }
        return result;
    }

    protected Commission calculateCommissionAmount(RuleResultValue value, List<Commission> hiddenFees, Collection<ValidationMessage> messages) throws Exception {
        Commission result = new Commission();
        return this.updateCommissionAmount(result, value, hiddenFees, messages) ? result : null;
    }

    protected boolean updateCommissionAmount(Commission result, RuleResultValue value, List<Commission> hiddenFees, Collection<ValidationMessage> messages) throws Exception {
        ContractType contractType = GeneralProductHelper.getContractType(this.contractRelationDescription);
        result.setContractType(contractType);
        EntityContainer ctr = EntityStorage.get().resolve(value.getTarget());
        if (null == ctr) {
            throw Xeption.forDeveloper((String)("no commission found, uid=" + value.getTarget()), (Object[])new Object[0]);
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
        if (prop instanceof FeeProperties && ((FeeProperties)prop).getType() == FeeType.MANUALLY_CALCULATED && this.getPropertySet().getManualFeeAppliedFlags().get(contractType) != null && this.getPropertySet().getManualFeeAppliedFlags().get(contractType).booleanValue()) {
            return false;
        }
        if (prop instanceof CommissionProperties && ((CommissionProperties)prop).isManuallyCalculated() && this.getPropertySet().getManualCommissionAppliedFlags().get(contractType) != null && this.getPropertySet().getManualCommissionAppliedFlags().get(contractType).booleanValue()) {
            return false;
        }
        if (prop instanceof DiscountProperties && ((DiscountProperties)prop).getType() == DiscountType.MANUALLY_CALCULATED && this.getPropertySet().getManualDiscountAppliedFlags().get(contractType) != null && this.getPropertySet().getManualDiscountAppliedFlags().get(contractType).booleanValue()) {
            return false;
        }
        result.setCommissionProperties(ctr.toReference());
        String currencyCode = value.getCurrencyCode();
        CalculationBasis basis = null;
        boolean useDifference = false;
        if (prop.getRoundingMode() != null) {
            result.setRoundingMode(prop.getRoundingMode());
        }
        if (prop.getRoundingValue() != null) {
            result.setRoundingValue(prop.getRoundingValue());
        }
        if (prop instanceof CommissionProperties || prop instanceof DiscountProperties) {
            if ("%".equals(currencyCode) || TextUtil.isBlank((String)currencyCode)) {
                result.setRate(Double.valueOf(value.getValue()));
                if (prop instanceof DiscountProperties) {
                    basis = ((DiscountProperties)prop).getCalculationBasis();
                }
                if (prop instanceof CommissionProperties) {
                    basis = ((CommissionProperties)prop).getCalculationBasis();
                }
            } else {
                String currency = this.getCurrency(currencyCode, messages);
                Money money = new Money();
                money.setCurrency(currency);
                BigDecimal amount = BigDecimal.valueOf(value.getValue());
                String productCategory = this.getPropertySet().getProductCategory();
                CalculationType calculationType = CalculationType.TICKET;
                if (prop instanceof CommissionProperties) {
                    if (ProductCategory.AIR.name().equals(productCategory) || ProductCategory.MCO.name().equals(productCategory) && MCOCategory.PTA.name().equals(this.getPropertySet().getMcoCategory())) {
                        calculationType = ((CommissionProperties)prop).getCalculationType();
                    }
                } else {
                    calculationType = ((DiscountProperties)prop).getCalculationType();
                }
                if (value.isForceSegmentCalculation()) {
                    calculationType = CalculationType.SEGMENT;
                }
                if (calculationType == null) {
                    calculationType = CalculationType.TICKET;
                }
                switch (calculationType) {
                    case SEGMENT: {
                        amount = amount.multiply(BigDecimal.valueOf(this.getPropertySet().getNumOfSegments()));
                        break;
                    }
                    case SEGMENT_TARIFF: {
                        amount = amount.multiply(BigDecimal.valueOf(this.getPropertySet().getNumOfSegmentTariffs()));
                        break;
                    }
                }
                money.setValue(amount);
                result.setAmount(money);
            }
            if (prop instanceof CommissionProperties) {
                CommissionProperties commProp = (CommissionProperties)prop;
                this.fixCommissionRate(result, commProp);
            }
            if (prop instanceof DiscountProperties) {
                DiscountProperties discProp = (DiscountProperties)prop;
                this.fixDiscountRate(result, discProp);
            }
        } else if (prop instanceof FeeProperties) {
            FeeProperties feeProp = (FeeProperties)prop;
            if (feeProp.getCalculationType() == CalculationType.SEGMENT) {
                String currency = this.getCurrency(currencyCode, messages);
                Money money = new Money();
                money.setCurrency(currency);
                money.setValue(BigDecimal.valueOf(value.getValue()).multiply(BigDecimal.valueOf(this.propertySet.getNumOfSegments())));
                result.setAmount(money);
            } else if ("%".equals(currencyCode) || TextUtil.isBlank((String)currencyCode)) {
                result.setRate(Double.valueOf(value.getValue()));
                basis = feeProp.getCalculationBasis();
                useDifference = feeProp.isCalculateFromDifference();
            } else {
                String currency = this.getCurrency(currencyCode, messages);
                Money money = new Money();
                money.setCurrency(currency);
                money.setValue(BigDecimal.valueOf(value.getValue()));
                result.setAmount(money);
            }
            this.updateAmountWithVatRate(result, (BaseCommissionProperties)feeProp);
            this.fixFeeRate(result, feeProp);
        } else if (prop instanceof PaymentFeeProperties) {
            if ("%".equals(currencyCode) || TextUtil.isBlank((String)currencyCode)) {
                result.setRate(Double.valueOf(value.getValue()));
                return true;
            }
            String currency = this.getCurrency(currencyCode, messages);
            Money money = new Money();
            money.setCurrency(currency);
            money.setValue(BigDecimal.valueOf(value.getValue()));
            result.setAmount(money);
        } else {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.BCAS_UNKNOWN_COMMISSION_TYPE, (Object[])new Object[]{value.getTarget()}));
            return false;
        }
        if (result.getRate() != null && basis == null) {
            basis = CalculationBasis.FARE;
        }
        this.updateEquivalentAmount(result, prop, basis, hiddenFees, useDifference, messages);
        return true;
    }

    protected <T extends BaseCommission> boolean isCommission(T commission) {
        return commission.getCommissionProperties() != null && CommissionProperties.class.isAssignableFrom(commission.getCommissionProperties().getType());
    }

    protected <T extends BaseCommission> boolean isTechnicalFee(T commission) {
        return GeneralProductHelper.isTechFee((EntityReference)commission.getCommissionProperties());
    }

    protected <U extends BaseContractRelationData> List<U> getPreviousRelations(List<U> allContractRelations, U contractRelation) {
        ArrayList<Object> previousRelations = new ArrayList<Object>();
        int idx = allContractRelations.indexOf(contractRelation);
        if (idx == 0 || GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.TECHNICAL_PROVIDER) {
            return previousRelations;
        }
        BaseContractRelationData previousRelation = (BaseContractRelationData)allContractRelations.get(idx - 1);
        previousRelations.add(previousRelation);
        if (GeneralProductHelper.getContractType((EntityReference)previousRelation.getDescription()) == ContractType.TECHNICAL_PROVIDER) {
            previousRelations.add(allContractRelations.get(idx - 2));
        }
        return previousRelations;
    }

    protected abstract void fixDiscountRate(Commission var1, DiscountProperties var2);

    protected abstract void fixCommissionRate(Commission var1, CommissionProperties var2);

    protected abstract void fixFeeRate(Commission var1, FeeProperties var2);

    protected abstract BigDecimal updateRuleValueWithVatRate(BigDecimal var1, Commission var2, BaseCommissionProperties var3);

    protected abstract void updateAmountWithVatRate(Commission var1, BaseCommissionProperties var2);

    protected void updateEquivalentAmount(Commission commission, BaseCommissionProperties properties, CalculationBasis basis, List<Commission> hiddenFees, boolean useDifference, Collection<ValidationMessage> messages) {
        Money money;
        String eqvCode = this.getEquivalentCurrencyCode();
        BigDecimal result = BigDecimal.ZERO;
        if (commission.getRate() != null) {
            BigDecimal fare = this.getBasis(basis, hiddenFees, useDifference);
            result = result.add(BigDecimal.valueOf(commission.getRate()).multiply(fare).divide(BigDecimal.valueOf(100L), 5, java.math.RoundingMode.HALF_UP));
            result = RulesHelper.roundDouble((BigDecimal)result, (RoundingMode)commission.getRoundingMode(), (RoundingValue)commission.getRoundingValue());
            result = this.updateRuleValueWithVatRate(result, commission, properties);
        }
        if ((money = commission.getAmount()) != null && money.getCurrency() != null && money.getValue() != null) {
            BigDecimal value = money.getValue();
            String currencyCode = money.getCurrency();
            if (!currencyCode.equals(eqvCode)) {
                value = value.multiply(this.getCurrencyRate(eqvCode, currencyCode, RulesHelper.isFeeForRefund((EntityReference)commission.getCommissionProperties()), messages));
            }
            result = result.add(value);
        }
        commission.setEquivalentAmount(RulesHelper.roundDouble((BigDecimal)result, (RoundingMode)commission.getRoundingMode(), (RoundingValue)commission.getRoundingValue()));
        commission.setContractEquivalentAmount(commission.getEquivalentAmount());
    }

    protected abstract BigDecimal getBasis(CalculationBasis var1, List<Commission> var2, boolean var3);

    private String getCurrency(String currencyCode, Collection<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)currencyCode)) {
            String curCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.BCAS_USING_DEFAULT_CURRENCY, (Object[])new Object[]{curCode}));
            return curCode;
        }
        return currencyCode;
    }

    protected abstract boolean accept(FeeProperties var1);

    protected abstract boolean accept(DiscountProperties var1);

    protected abstract boolean accept(PaymentFeeProperties var1);

    protected abstract BigDecimal getCurrencyRate(String var1, boolean var2, Collection<ValidationMessage> var3);

    protected abstract BigDecimal getCurrencyRate(String var1, String var2, boolean var3, Collection<ValidationMessage> var4);

    protected String getEquivalentCurrencyCode() {
        return this.equiveCurrencyCode != null ? this.equiveCurrencyCode : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
    }

    private EntityReference<? extends BaseCommissionProperties> createReference(String className, String uid) {
        try {
            return new EntityReference(uid, XHelper.getClass((String)className), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(String category, EntityReference<? extends BaseCommissionProperties> target) throws Exception {
        RuleLogTracer tracer;
        block13: {
            FeeProperties feeProp;
            BaseCommissionProperties prop;
            block12: {
                block11: {
                    DiscountProperties discProp;
                    block10: {
                        EntityContainer ctr;
                        block9: {
                            block8: {
                                boolean bl;
                                tracer = this.getProxy().getTracer();
                                tracer.traceEnteringMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
                                try {
                                    if (!this.results.containsKey(category)) break block8;
                                    tracer.traceLogic("results already contain the category, returning false");
                                    bl = false;
                                }
                                catch (Throwable throwable) {
                                    tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
                                    throw throwable;
                                }
                                tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
                                return bl;
                            }
                            ctr = EntityStorage.get().resolve(target);
                            if (ctr != null) break block9;
                            tracer.traceLogic("unable to load commission properties,returning false");
                            boolean bl = false;
                            tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
                            return bl;
                        }
                        prop = (BaseCommissionProperties)ctr.getEntity();
                        if (!(prop instanceof CommissionProperties)) break block10;
                        CommissionProperties commProp = (CommissionProperties)prop;
                        boolean bl = this.accept(commProp);
                        tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
                        return bl;
                    }
                    if (!(prop instanceof DiscountProperties) || this.accept(discProp = (DiscountProperties)prop)) break block11;
                    boolean bl = false;
                    tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
                    return bl;
                }
                if (!(prop instanceof FeeProperties) || this.accept(feeProp = (FeeProperties)prop)) break block12;
                boolean bl = false;
                tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
                return bl;
            }
            if (!(prop instanceof PaymentFeeProperties) || this.accept((PaymentFeeProperties)(feeProp = (PaymentFeeProperties)prop))) break block13;
            boolean bl = false;
            tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
            return bl;
        }
        tracer.traceLogic("returning true");
        boolean bl = true;
        tracer.traceExitingMethod(BaseCommissionActionSet.class, String.format("accept(%s, %s)", category, target), new String[0]);
        return bl;
    }

    protected abstract boolean accept(CommissionProperties var1);

    public Map<EntityReference<? extends BaseCommissionProperties>, String> getCachedCategories() {
        return this.cacheCategories;
    }

    public void setCommission(String category, RuleResultValue ruleResultValue) {
        ExtRuleResultValue res;
        if (ruleResultValue instanceof ExtRuleResultValue) {
            res = new ExtRuleResultValue();
            res.setPercentage(((ExtRuleResultValue)ruleResultValue).getPercentage());
        } else {
            res = new RuleResultValue();
        }
        res.setCurrencyCode(ruleResultValue.getCurrencyCode());
        res.setValue(ruleResultValue.getValue());
        res.setTarget(ruleResultValue.getTarget());
        this.results.put(category, (RuleResultValue)res);
    }

    public boolean setCommission(String category, EntityReference<? extends BaseCommissionProperties> comm, double value, String currencyCode, String target, boolean forceSegmentCalculation, String[] fops) {
        if (!this.isApplicable(target, fops)) {
            return false;
        }
        RuleResultValue res = new RuleResultValue();
        res.setCurrencyCode(currencyCode);
        res.setValue(value);
        res.setTarget(comm);
        res.setForceSegmentCalculation(forceSegmentCalculation);
        this.results.put(category, res);
        return true;
    }

    public static <C extends BaseCommission> List<C> getHiddenFees(List<C> commissions) {
        ArrayList<BaseCommission> result = new ArrayList<BaseCommission>();
        for (BaseCommission comm : commissions) {
            if (!GeneralProductHelper.isHiddenFee((EntityReference)comm.getCommissionProperties())) continue;
            result.add(comm);
        }
        return result;
    }

    public void selectContract(boolean select) {
        this.selectContract = select;
    }

    public Boolean isContractSelected() {
        return this.selectContract;
    }

    public void translateSupplierFee(boolean translateSupplierFee) {
        this.translateSupplierFee = translateSupplierFee;
    }

    public Boolean isTranslateSupplierFee() {
        return this.translateSupplierFee;
    }

    public void setFeePaymentType(PaymentType feePaymentType) {
        this.feePaymentType = feePaymentType;
    }

    public PaymentType getFeePaymentType() {
        return this.feePaymentType;
    }

    public static class AppliedRulesData {
        public final Map<String, RuleResultValue> minCommissions = new LinkedHashMap<String, RuleResultValue>();
        public final Map<String, RuleResultValue> maxCommissions = new LinkedHashMap<String, RuleResultValue>();
        public final Map<String, RuleResultValue> standardCommissions = new LinkedHashMap<String, RuleResultValue>();
        public final Map<String, RuleResultValue> manuallyCalculatedCommissions = new LinkedHashMap<String, RuleResultValue>();
    }
}

