/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.CarRentalProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class CarRentalProductActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = -5184922202805479958L;

    public CarRentalProductActionSet(RuleProxy<CarRentalProductPropertySet, CarRentalProductActionSet> proxy, CarRentalProduct ticket) {
        super(proxy, (BaseProduct)ticket, CarRentalProductActionSet.createHandler(ticket));
    }

    private static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final CarRentalProduct ticket) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            @Override
            public boolean isOneWayTicket() {
                return true;
            }

            @Override
            public boolean isForcedRefund() {
                return true;
            }

            @Override
            public List<ValidationMessage> getValidationMessages() {
                return ticket.getValidationMessages();
            }

            @Override
            public TicketType getTicketType() {
                return ticket.getTicketType();
            }

            @Override
            public BigDecimal getAdditionalFare() {
                return null;
            }

            @Override
            public String getTargetType() {
                return "TICKET";
            }

            @Override
            public ProductStatus getStatus() {
                return ticket.getStatus();
            }

            @Override
            public int getSegmentsCount() {
                return 1;
            }

            @Override
            public ProductType getProductType() {
                return ProductType.CAR_RENTAL;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return ticket.getPreviousProduct() != null ? CarRentalProductActionSet.createHandler(ticket.getPreviousProduct()) : null;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return ticket.getNextProduct() != null ? CarRentalProductActionSet.createHandler(ticket.getNextProduct()) : null;
            }

            @Override
            public Set<String> getPaymentTypes() {
                return null;
            }

            @Override
            public Date getIssueDate() {
                return ticket.getIssueDate();
            }

            @Override
            public EntityReference<SalesPoint> getSalesPoint() {
                return ticket.getSalesPoint();
            }

            @Override
            public int getSegmentTariffsCount() {
                return 0;
            }

            @Override
            public int getTravellersCount() {
                return ticket.getTravellers().size();
            }
        };
    }
}

