/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.CarRentalProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class CarRentalProductPropertySet
implements CarRentalProductPropertiesProvider,
ClientCreditCardVendorProvider,
UDIDsPropertyProvider {
    private final RuleProxy<CarRentalProductPropertySet, ?> proxy;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> departureLocations = new HashSet<String>();
    private final Set<String> arriveLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    protected CarRentalProduct product;
    private EntityReference<Organization> supplier;
    private Double totalPrice;
    private String agencyCode;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private String clientCreditCardVendor;
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;

    public CarRentalProductPropertySet(RuleProxy<CarRentalProductPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    public void init(CarRentalProduct ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            this.product = ticket;
            this.agent = ticket.getAgent();
            this.bookingAgent = ticket.getReservation().getBookingAgent();
            this.client = ticket.getReservation().getBookingFile().getCustomerProfile();
            CommonProductHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference<Organization>)CarRentalProductHelper.getSubagency((CarRentalProduct)ticket));
            this.agencyCode = CommonProductHelper.getAgencyCode(ticket);
            this.departureLocations.clear();
            this.arriveLocations.clear();
            this.visitedCities.clear();
            Set<String> geoCodes = this.collectGeoCodes((DictionaryReference<GeoLocation>)this.product.getStartLocation());
            this.departureLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[0]));
            geoCodes = this.collectGeoCodes((DictionaryReference<GeoLocation>)this.product.getEndLocation());
            this.arriveLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[0]));
            this.supplier = CarRentalProductHelper.getSupplier((CarRentalProduct)this.product);
            BigDecimal bgTotalPrice = CarRentalProductHelper.getTotalPrice((CarRentalProduct)this.product);
            this.totalPrice = bgTotalPrice != null ? bgTotalPrice.doubleValue() : 0.0;
            this.setTravelSubject(ProductHandler.of((BaseProduct)this.product).findTravelSubject((BaseProduct)this.product));
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)this.product));
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)this.product));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
            this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor(this.product);
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public Set<String> getSubagencyCodes() {
        return null;
    }

    public Set<String> getProfileGroups() {
        return null;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public CarRentalProduct getProduct() {
        return this.product;
    }

    public Money getEquivalentFare() {
        return this.product.getEquivalentFare();
    }

    public Date getDepartureDate() {
        return this.product.getStartDate();
    }

    public Set<String> getArrivalLocations() {
        return this.arriveLocations;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public String getGdsName() {
        return Optional.ofNullable(this.product.getReservation()).map(CommonReservationGdsNameInfoHelper::getRulesGdsName).map(Enum::name).orElse(null);
    }

    private Set<String> collectGeoCodes(DictionaryReference<GeoLocation> geoLocRef) {
        if (geoLocRef == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(RulesHelper.collectGeoCodes(Collections.singleton(geoLocRef.getCode()), (boolean)true));
    }

    public TicketType getTicketType() {
        return this.product.getTicketType();
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.product.getBlankOwner();
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public EntityReference<Person> getTicketingAgent() {
        return this.product.getAgent();
    }

    public EntityReference<SalesPoint> getSalesPoint() {
        return this.product.getSalesPoint();
    }

    public DictionaryReference<CarClass> getCarClass() {
        return this.product.getCarClass();
    }

    public boolean withDriver() {
        return this.product.isWithDriver();
    }

    public Double getTotalPrice() {
        return this.totalPrice;
    }

    public String getCarVendorCode() {
        return null;
    }

    public Integer getRentDuration() {
        return null;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public List<CostCode> getCostCodes() {
        return StatisticsHelper.getAllCostCodes((StatisticalData)this.product.getStatisticalData());
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }

    public void setTravelSubject(TravelSubject travelSubject) {
        this.travelSubject = travelSubject;
    }

    public Set<String> getPassengerTypeCategories() {
        return Collections.emptySet();
    }
}

