/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.DeliveryPropertiesProvider;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.DeliveryPropertySet;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeliveryActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = -15195997032574474L;
    private Delivery delivery = null;
    private final DeliveryPropertiesProvider ps;

    public DeliveryActionSet(RuleProxy<DeliveryPropertySet, DeliveryActionSet> proxy, DeliveryPropertiesProvider propertySet, Delivery ticket) {
        super(proxy, (BaseProduct)ticket, DeliveryActionSet.createHandler(ticket, propertySet));
        this.ps = propertySet;
        this.delivery = ticket;
    }

    private static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final Delivery ticket, DeliveryPropertiesProvider propertySet) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            @Override
            public boolean isOneWayTicket() {
                return true;
            }

            @Override
            public boolean isForcedRefund() {
                return false;
            }

            @Override
            public List<ValidationMessage> getValidationMessages() {
                return ticket.getValidationMessages();
            }

            @Override
            public TicketType getTicketType() {
                return TicketType.OWN;
            }

            @Override
            public String getTargetType() {
                return "TICKET";
            }

            @Override
            public ProductStatus getStatus() {
                ProductStatus status = DeliveryHelper.getProductStatus((Delivery)ticket);
                return status == ProductStatus.BOOKING ? ProductStatus.SELL : status;
            }

            @Override
            public int getSegmentsCount() {
                return 0;
            }

            @Override
            public ProductType getProductType() {
                return ProductType.DELIVERY;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return null;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return null;
            }

            @Override
            public Set<String> getPaymentTypes() {
                HashSet<String> result = new HashSet<String>();
                for (GeneralProductFop fop : ticket.getClientFops()) {
                    if (fop.getType() == null) continue;
                    result.add(fop.getType().name());
                }
                return result;
            }

            @Override
            public Date getIssueDate() {
                return ticket.getIssueDate();
            }

            @Override
            public EntityReference<SalesPoint> getSalesPoint() {
                return ticket.getSalesPoint();
            }

            @Override
            public int getSegmentTariffsCount() {
                return 0;
            }

            @Override
            public BigDecimal getAdditionalFare() {
                return null;
            }
        };
    }

    @Override
    public List<GeneralProductCommission> createCommissions(GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> allContractRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData, Collection<ValidationMessage> messages) throws Exception {
        List<GeneralProductCommission> result = super.createCommissions(contractRelation, allContractRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, messages);
        if (!this.ps.isFopSet()) {
            if (this.ps.getPaymentType() == PaymentType.CASH) {
                for (GeneralProductFop fop : this.delivery.getClientFops()) {
                    fop.setOperationDate(null);
                    fop.setAgent(null);
                }
            }
            if (this.ps.getPaymentType() != null) {
                for (GeneralProductFop fop : this.delivery.getClientFops()) {
                    fop.setType(this.ps.getPaymentType());
                }
            }
            if (this.ps.getFopAgent() != null) {
                for (GeneralProductFop fop : this.delivery.getClientFops()) {
                    fop.setAgent(this.ps.getFopAgent());
                }
            }
            if (this.ps.getFopOperationDate() != null) {
                for (GeneralProductFop fop : this.delivery.getClientFops()) {
                    fop.setOperationDate(this.ps.getFopOperationDate());
                }
            }
        }
        return result;
    }
}

