/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryRegion;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.DeliveryPropertiesProvider;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DeliveryPropertySet
implements DeliveryPropertiesProvider {
    private BigDecimal totalCost;
    private boolean urgent;
    private DictionaryReference<DeliveryRegion> deliveryRegion;
    private final RuleProxy<DeliveryPropertySet, ?> proxy;
    private boolean fopSet = false;
    private Date fopOperationDate = null;
    private EntityReference<Person> fopAgent = null;
    private EntityReference<Person> bookingAgent;
    private PaymentType paymentType = null;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);

    public DeliveryPropertySet(RuleProxy<DeliveryPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Delivery ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            this.totalCost = BigDecimal.ZERO;
            for (DeliveryItem item : ticket.getDeliveryItems()) {
                if (item.getCost() == null) continue;
                this.totalCost = this.totalCost.add(item.getCost());
            }
            this.urgent = ticket.isUrgent();
            this.deliveryRegion = ticket.getDeliveryRegion();
            Iterator it = ticket.getClientFops().iterator();
            while (it.hasNext()) {
                GeneralProductFop fop = (GeneralProductFop)it.next();
                if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                    this.fopSet = true;
                } else {
                    it.remove();
                }
                this.paymentType = fop.getType();
                this.fopOperationDate = fop.getOperationDate();
                this.fopAgent = fop.getAgent();
            }
            this.bookingAgent = ticket.getReservation().getBookingAgent();
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)ticket));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public RuleProxy<DeliveryPropertySet, ?> getProxy() {
        return this.proxy;
    }

    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    public boolean isUrgent() {
        return this.urgent;
    }

    public DictionaryReference<DeliveryRegion> getDeliveryRegion() {
        return this.deliveryRegion;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public boolean isFopSet() {
        return this.fopSet;
    }

    public EntityReference<Person> getFopAgent() {
        return this.fopAgent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public Date getFopOperationDate() {
        return this.fopOperationDate;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }
}

