/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AirItineraryReceiptData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.ExtraFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeCalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ContractActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ExtRuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.FeePaymentTypeActionProvider;
import com.gridnine.xtrip.common.model.rules.standard.PayerActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SupplierActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.rate.RateHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.handlers.BaseCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSetCustomizer;
import com.gridnine.xtrip.server.model.handlers.InitializeFopProxy;
import com.gridnine.xtrip.server.model.handlers.RulesFopHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralProductCommissionActionSet
implements Serializable,
CommissionActionsProvider,
ContractActionsProvider,
FeePaymentTypeActionProvider,
SupplierActionsProvider,
PayerActionsProvider {
    private static volatile GeneralProductCommissionActionSetCustomizer customizer;
    private static final List<CalculationBasis> withPenaltyBasis;
    private static final List<CalculationBasis> withTotalBasis;
    private static final long serialVersionUID = -5971128252587654102L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CommissionActionProxy actionProxy;
    protected final InitializeFopProxy initFopProxy;
    protected final RuleProxy<?, ?> proxy;
    private final Map<String, RuleResultValue> results = new LinkedHashMap<String, RuleResultValue>();
    private final Map<EntityReference<? extends BaseCommissionProperties>, String> cacheCategories = new HashMap<EntityReference<? extends BaseCommissionProperties>, String>();
    private final List<String> tourCodes = new ArrayList<String>();
    private boolean overrideTourCodes;
    private Collection<EntityReference<TemplateDocument>> receiptTemplates;
    protected String equiveCurrencyCode = null;
    private final BaseProduct baseProduct;
    private Boolean selectContract;
    private Boolean transferSupplierFee;
    private PaymentType feePaymentType;
    private EntityReference<Organization> supplier;
    private EntityReference<Organization> blankOwner;
    private EntityReference<Organization> payer;
    private boolean sabreExcludeCommissionQualifier;
    protected double[] vatRates;
    protected double[] previousVatRates;
    private final Set<PaymentType> allowedPaymentTypes = new LinkedHashSet<PaymentType>();

    public GeneralProductCommissionActionSet(RuleProxy<?, ?> px, BaseProduct baseProduct, CommissionActionProxy cProxy) {
        this.proxy = px;
        this.actionProxy = cProxy;
        this.initFopProxy = new InitializeFopProxy(this.actionProxy);
        this.baseProduct = baseProduct;
    }

    public BaseProduct getBaseProduct() {
        return this.baseProduct;
    }

    public static BigDecimal getBasis(CalculationBasis basis, GeneralProductContractRelationData contractRelation, BigDecimal additionalFare, BaseProduct product, Collection<GeneralProductCommission> hiddenFees) {
        if (basis == CalculationBasis.PAYMENT_SUM_TO_SUPPLIER) {
            if (contractRelation.getDescription() == null || GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.VENDOR) {
                return BigDecimal.ZERO;
            }
            BigDecimal result = null;
            for (GeneralProductContractRelationData relation : GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product)) {
                if (result == null) {
                    if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.VENDOR) continue;
                    result = BigDecimal.ZERO;
                    for (GeneralProductFop fop : relation.getFops()) {
                        result = result.add(fop.getEquivalentAmount());
                    }
                    continue;
                }
                ExchangeRateData exchangeRateData = relation.getGeneralData().getRate();
                if (exchangeRateData != null) {
                    result = MulticurrencyHelper.convert((BigDecimal)result, (ExchangeRateData)exchangeRateData);
                }
                if (!contractRelation.getDescription().equals((Object)relation.getDescription())) continue;
                break;
            }
            return result == null ? BigDecimal.ZERO : result;
        }
        if (basis == CalculationBasis.TAXES) {
            return GeneralProductHelper.getEquivalentTaxesAmount((Collection)contractRelation.getServiceData().getDetalization().getTaxes());
        }
        if (basis == CalculationBasis.PENALTY) {
            return MiscUtil.guarded((BigDecimal)contractRelation.getServiceData().getDetalization().getPenalty());
        }
        boolean withTotal = withTotalBasis.contains(basis);
        boolean withPenalties = withPenaltyBasis.contains(basis);
        BigDecimal result = MiscUtil.guarded((BigDecimal)GeneralProductCommissionActionSet.getHiddenEquivalentFare(hiddenFees));
        result = withTotal ? MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, contractRelation.getServiceData().getTotalPrice()})) : MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, contractRelation.getServiceData().getDetalization().getFare(), additionalFare}));
        if (withPenalties) {
            result = result.add(MiscUtil.guarded((BigDecimal)contractRelation.getServiceData().getDetalization().getPenalty()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accept(FeeProperties feeProp) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        if (!feeProp.getRouteTypes().isEmpty()) {
            if (this.actionProxy.isOneWayTicket() && !feeProp.getRouteTypes().contains(RouteType.ONE_WAY)) {
                tracer.traceLogic("ticket is a one way ticket, but route types does not contain ONE_WAY, returning false");
                return false;
            }
            if (!this.actionProxy.isOneWayTicket() && !feeProp.getRouteTypes().contains(RouteType.ROUND_TRIP)) {
                tracer.traceLogic("ticket is a round trip ticket, but route types does not contain ROUND_TRIP, returning false");
                return false;
            }
        }
        ProductStatus productStatus = this.actionProxy.getStatus();
        try {
            ProductType productType = this.actionProxy.getProductType();
            if (productType != null) {
                tracer.traceLogic(() -> String.format("productType = %sfee.productCategories = %s ", productType, Arrays.toString(feeProp.getProductTypes().toArray())));
                if (!feeProp.getProductTypes().isEmpty() && !feeProp.getProductTypes().contains(productType)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (productStatus == null) {
                boolean res = feeProp.getOperation() == null;
                tracer.traceLogic("product status is null, returning " + res);
                boolean bl = res;
                return bl;
            }
            AcceptanceCheckResult checkResult = this.checkAccepts(feeProp);
            if (checkResult == null) {
                throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
            }
            if (!StringUtils.isBlank((String)checkResult.explanation)) {
                tracer.traceLogic(checkResult.explanation);
            } else {
                tracer.traceLogic(() -> String.format("product status is %s, feeProperties.operation == %s, returning %s", productStatus, feeProp.getOperation(), checkResult.accept));
            }
            boolean bl = checkResult.accept;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    protected AcceptanceCheckResult checkAccepts(FeeProperties feeProp) {
        switch (this.actionProxy.getStatus()) {
            case BOOKING: {
                return AcceptanceCheckResult.of(feeProp.getOperation() == Operation.SELL);
            }
            case SELL: {
                if (feeProp.getOperation() == Operation.SELL) {
                    return AcceptanceCheckResult.of(true);
                }
                if (feeProp.getOperation() == Operation.EXCHANGE && this.actionProxy.getPreviousProduct() != null && this.actionProxy.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    return AcceptanceCheckResult.of(true, "product status is SELL, exchanged product is present, returning true");
                }
                return AcceptanceCheckResult.of(false);
            }
            case REFUND: {
                boolean accept;
                boolean bl = accept = feeProp.getOperation() == Operation.REFUND;
                if (accept && this.actionProxy.getProductType() == ProductType.HOTEL_RESERVATION) {
                    accept = !this.actionProxy.isForcedRefund();
                }
                return AcceptanceCheckResult.of(accept);
            }
            case EXCHANGE: {
                return AcceptanceCheckResult.of(false);
            }
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(this.actionProxy.getStatus())) {
            return AcceptanceCheckResult.of(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accept(DiscountProperties discProp) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        try {
            ProductStatus productStatus = this.actionProxy.getStatus();
            AcceptanceCheckResult checkResult = this.checkAccepts(discProp);
            if (checkResult == null) {
                throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
            }
            if (!StringUtils.isBlank((String)checkResult.explanation)) {
                tracer.traceLogic(checkResult.explanation);
            } else {
                tracer.traceLogic(() -> String.format("product status is %s, discountProperties.operation == %s, returning %s", productStatus, discProp.getOperation(), checkResult.accept));
            }
            boolean bl = checkResult.accept;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    protected AcceptanceCheckResult checkAccepts(DiscountProperties discProp) {
        switch (this.actionProxy.getStatus()) {
            case BOOKING: 
            case EXCHANGE: {
                return AcceptanceCheckResult.of(discProp.getOperation() == Operation.SELL);
            }
            case SELL: {
                if (discProp.getOperation() == Operation.SELL) {
                    return AcceptanceCheckResult.of(true);
                }
                if (discProp.getOperation() == Operation.EXCHANGE && this.actionProxy.getPreviousProduct() != null && this.actionProxy.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    return AcceptanceCheckResult.of(true, "product status is SELL, exchanged product is present, returning true");
                }
                return AcceptanceCheckResult.of(false);
            }
            case REFUND: {
                return AcceptanceCheckResult.of(discProp.getOperation() == Operation.REFUND);
            }
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(this.actionProxy.getStatus())) {
            return AcceptanceCheckResult.of(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accept(CommissionProperties commProp) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        ProductType productType = this.actionProxy.getProductType();
        if (productType != null) {
            tracer.traceLogic(() -> String.format("productType = %scomm.productCategories = %s ", productType, Arrays.toString(commProp.getProductTypes().toArray())));
            if (!commProp.getProductTypes().isEmpty() && !commProp.getProductTypes().contains(productType)) {
                return false;
            }
        }
        ProductStatus productStatus = this.actionProxy.getStatus();
        try {
            AcceptanceCheckResult checkResult = this.checkAccepts(commProp);
            if (checkResult == null) {
                throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
            }
            if (!StringUtils.isBlank((String)checkResult.explanation)) {
                tracer.traceLogic(checkResult.explanation);
            } else {
                tracer.traceLogic(() -> String.format("product status is %s, commissionProperties.operation == %s, returning %s", productStatus, commProp.getOperation(), checkResult.accept));
            }
            boolean bl = checkResult.accept;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    protected AcceptanceCheckResult checkAccepts(CommissionProperties commProp) {
        switch (this.actionProxy.getStatus()) {
            case BOOKING: 
            case EXCHANGE: {
                return AcceptanceCheckResult.of(commProp.getOperation() == Operation.SELL);
            }
            case SELL: {
                if (commProp.getOperation() == Operation.SELL) {
                    return AcceptanceCheckResult.of(true);
                }
                if (commProp.getOperation() == Operation.EXCHANGE && this.actionProxy.getPreviousProduct() != null && this.actionProxy.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    return AcceptanceCheckResult.of(true, "product status is SELL, exchanged product is present, returning true");
                }
                return AcceptanceCheckResult.of(false);
            }
            case REFUND: {
                return AcceptanceCheckResult.of(commProp.getOperation() == Operation.REFUND);
            }
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(this.actionProxy.getStatus())) {
            return AcceptanceCheckResult.of(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accept(PaymentFeeProperties feeProp) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        ProductStatus productStatus = this.actionProxy.getStatus();
        try {
            if (productStatus == null) {
                boolean bl = false;
                return bl;
            }
            AcceptanceCheckResult checkResult = this.checkAccepts(feeProp);
            if (checkResult == null) {
                throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
            }
            if (!StringUtils.isBlank((String)checkResult.explanation)) {
                tracer.traceLogic(checkResult.explanation);
            } else {
                tracer.traceLogic(() -> String.format("product status is %s, returning %s", productStatus, checkResult.accept));
            }
            boolean bl = checkResult.accept;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(GeneralProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    protected AcceptanceCheckResult checkAccepts(PaymentFeeProperties feeProp) {
        ProductStatus productStatus = this.actionProxy.getStatus();
        switch (productStatus) {
            case REFUND: {
                return AcceptanceCheckResult.of(feeProp.isChargeOnRefund(), "product is REFUND, fee.chargeOnRefund = " + feeProp.isChargeOnRefund() + " returning " + feeProp.isChargeOnRefund());
            }
            case BOOKING: 
            case SELL: {
                return AcceptanceCheckResult.of(true, "product is " + productStatus + ", returning true");
            }
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(productStatus)) {
            return AcceptanceCheckResult.of(false);
        }
        return null;
    }

    public boolean hasRefundCommissions() {
        for (RuleResultValue rr : this.getResults().values()) {
            EntityContainer commissionCtr = EntityStorage.get().resolve(rr.getTarget());
            if (null == commissionCtr) continue;
            BaseCommissionProperties commissionProperties = (BaseCommissionProperties)commissionCtr.getEntity();
            if (commissionProperties instanceof FeeProperties) {
                FeeProperties feeProperties = (FeeProperties)commissionProperties;
                if (this.actionProxy.getStatus() == ProductStatus.REFUND && feeProperties.getOperation() == Operation.REFUND) {
                    return true;
                }
                if (this.actionProxy.getStatus() == ProductStatus.EXCHANGE && feeProperties.getOperation() == Operation.EXCHANGE) {
                    return true;
                }
            }
            if (commissionProperties instanceof CommissionProperties) {
                CommissionProperties commProperties = (CommissionProperties)commissionProperties;
                if (this.actionProxy.getStatus() == ProductStatus.REFUND && commProperties.getOperation() == Operation.REFUND) {
                    return true;
                }
                if (this.actionProxy.getStatus() == ProductStatus.EXCHANGE && commProperties.getOperation() == Operation.EXCHANGE) {
                    return true;
                }
            }
            if (!(commissionProperties instanceof DiscountProperties)) continue;
            DiscountProperties discProperties = (DiscountProperties)commissionProperties;
            if (this.actionProxy.getStatus() == ProductStatus.REFUND && discProperties.getOperation() == Operation.REFUND) {
                return true;
            }
            if (this.actionProxy.getStatus() != ProductStatus.EXCHANGE || discProperties.getOperation() != Operation.EXCHANGE) continue;
            return true;
        }
        return false;
    }

    public List<GeneralProductCommission> createCommissions(GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> allContractRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData, Collection<ValidationMessage> messages) throws Exception {
        return this.createCommissions(contractRelation, allContractRelations, previousProductContractRelations, true, separateSupplierFees, rateData, messages);
    }

    public List<GeneralProductCommission> createCommissions(GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> allContractRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData, Collection<ValidationMessage> messages) throws Exception {
        return this.createCommissions(contractRelation, allContractRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, PaymentType.CASH, messages);
    }

    private List<GeneralProductCommission> createCommissions(GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> allContractRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData, PaymentType defaultPaymentType, Collection<ValidationMessage> messages) throws Exception {
        FopData supplierFopData;
        FopData fopData;
        this.equiveCurrencyCode = contractRelation.getGeneralData().getCurrency() == null ? DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB") : contractRelation.getGeneralData().getCurrency().getCode();
        this.vatRates = this.getVatRatesFromContract(contractRelation, this.baseProduct);
        int index = allContractRelations.indexOf(contractRelation);
        if (index > 0) {
            this.previousVatRates = this.getVatRatesFromContract(allContractRelations.get(index - 1), this.baseProduct);
        }
        ArrayList<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
        if (this.actionProxy.getStatus() == ProductStatus.REFUND || this.actionProxy.getStatus() == ProductStatus.EXCHANGE) {
            this.updateRefundedCommissions(commissions, contractRelation, previousProductContractRelations, messages);
        }
        List<GeneralProductCommission> additionalCommissions = this.getAdditionalCommissions(contractRelation, allContractRelations, translateSupplierFees, rateData);
        commissions.addAll(additionalCommissions);
        List<GeneralProductCommission> newCommissions = this.createNewCommissions(contractRelation, BaseCommissionActionSet.getHiddenFees(commissions), previousProductContractRelations, messages);
        this.reduceNewCommissions(newCommissions);
        ArrayList<GeneralProductCommission> tempList = new ArrayList<GeneralProductCommission>(commissions);
        commissions.clear();
        commissions.addAll(newCommissions);
        commissions.addAll(tempList);
        ArrayList<GeneralProductCommission> paymentFees = new ArrayList<GeneralProductCommission>();
        Iterator it = commissions.iterator();
        while (it.hasNext()) {
            GeneralProductCommission comm = (GeneralProductCommission)it.next();
            if (comm.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
            paymentFees.add(comm);
            it.remove();
        }
        ArrayList<GeneralProductCommission> result = new ArrayList<GeneralProductCommission>(commissions);
        contractRelation.getCommissions().addAll(commissions);
        BigDecimal totalFees = BigDecimal.ZERO;
        BigDecimal totalTranslatedFees = BigDecimal.ZERO;
        BigDecimal totalFeesForRefund = BigDecimal.ZERO;
        BigDecimal totalDiscount = BigDecimal.ZERO;
        ArrayList<GeneralProductCommission> fees = new ArrayList<GeneralProductCommission>();
        ArrayList<GeneralProductCommission> translatedFees = new ArrayList<GeneralProductCommission>();
        ArrayList<GeneralProductCommission> feesForRefund = new ArrayList<GeneralProductCommission>();
        ArrayList<GeneralProductCommission> discounts = new ArrayList<GeneralProductCommission>();
        ArrayList<GeneralProductCommission> hiddenFees = new ArrayList<GeneralProductCommission>();
        for (GeneralProductCommission comm : commissions) {
            if (comm.getCommissionProperties() != null && FeeProperties.class.getName().equals(comm.getCommissionProperties().getType().getName()) && comm.getEquivalentAmount() != null) {
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null) continue;
                if (((FeeProperties)ctr.getEntity()).isHidden()) {
                    hiddenFees.add(comm);
                } else if (((FeeProperties)ctr.getEntity()).getOperation() == Operation.SELL) {
                    if (separateSupplierFees && additionalCommissions.contains(comm)) {
                        totalTranslatedFees = totalTranslatedFees.add(comm.getEquivalentAmount());
                        translatedFees.add(comm);
                    } else {
                        totalFees = totalFees.add(comm.getEquivalentAmount());
                        fees.add(comm);
                    }
                } else {
                    totalFeesForRefund = totalFeesForRefund.add(comm.getEquivalentAmount());
                    feesForRefund.add(comm);
                }
            }
            if (comm.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)comm.getCommissionProperties().getType()) || comm.getEquivalentAmount() == null) continue;
            discounts.add(comm);
            totalDiscount = totalDiscount.add(comm.getEquivalentAmount());
        }
        for (GeneralProductCommission comm : contractRelation.getCommissions()) {
            EntityContainer commPropCtr;
            if (comm.getCommissionProperties() == null || !FeeProperties.class.equals((Object)comm.getCommissionProperties().getType()) || (commPropCtr = EntityStorage.get().resolve(comm.getCommissionProperties())) == null || !((FeeProperties)commPropCtr.getEntity()).isHidden() || ((FeeProperties)commPropCtr.getEntity()).getType() != FeeType.MANUALLY_CALCULATED || hiddenFees.contains(comm)) continue;
            hiddenFees.add(comm);
        }
        if (!separateSupplierFees) {
            supplierFopData = fopData = this.getFopData(null, contractRelation, null, defaultPaymentType);
        } else {
            int idx = allContractRelations.indexOf(contractRelation);
            if (idx == 0) {
                supplierFopData = fopData = this.getFopData(null, contractRelation, null, defaultPaymentType);
            } else {
                GeneralProductContractRelationData previousRelation = allContractRelations.get(idx - 1);
                fopData = this.getFopData(false, contractRelation, previousRelation, defaultPaymentType);
                supplierFopData = this.getFopData(true, contractRelation, previousRelation, defaultPaymentType);
                if (null == fopData && null == supplierFopData) {
                    supplierFopData = fopData = this.getFopData(null, contractRelation, previousRelation, defaultPaymentType);
                } else if (null == fopData) {
                    fopData = supplierFopData;
                } else if (null == supplierFopData) {
                    supplierFopData = fopData;
                }
            }
            if (fopData.getCard() == supplierFopData.getCard() && !translatedFees.isEmpty()) {
                supplierFopData.setCard((Card)XCloneHelper.clone((XCloneable)supplierFopData.getCard(), (boolean)true));
            }
        }
        List fops = contractRelation.getFops();
        GeneralProductFop pfForHidden = null;
        Iterator it2 = fops.iterator();
        while (it2.hasNext()) {
            GeneralProductFop pf = (GeneralProductFop)it2.next();
            boolean removed = false;
            for (GeneralProductCommission comm : pf.getCommissions()) {
                if (comm.getCommissionProperties() != null && FeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) {
                    FeeProperties feeProp;
                    EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                    if (ctr != null && (feeProp = (FeeProperties)ctr.getEntity()).isHidden()) {
                        BigDecimal fopAmount = MiscUtil.guarded((BigDecimal)pf.getEquivalentAmount());
                        fopAmount = fopAmount.subtract(MiscUtil.guarded((BigDecimal)comm.getEquivalentAmount()));
                        pf.setEquivalentAmount(fopAmount);
                        pfForHidden = pf;
                        continue;
                    }
                    it2.remove();
                    removed = true;
                    break;
                }
                if (comm.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
                it2.remove();
                removed = true;
                break;
            }
            if (pfForHidden != null && pf.getType() != PaymentType.TICKET || removed) continue;
            pfForHidden = pf;
        }
        if (pfForHidden != null) {
            pfForHidden.getCommissions().clear();
        }
        this.addHiddenCommissionsToFop(pfForHidden, hiddenFees);
        Date operationDate = fopData.getOperationDate();
        PaymentType paymentType = fopData.getPaymentType();
        EntityReference<Person> agent = fopData.getAgent();
        Card card = fopData.getCard();
        EntityReference<Organization> payer = fopData.getPayer();
        if (!hiddenFees.isEmpty() && pfForHidden != null && pfForHidden.getType() == PaymentType.TICKET) {
            this.checkHiddenFeesFop(pfForHidden, contractRelation, previousProductContractRelations, paymentType, operationDate, card, agent, payer);
        }
        if (!translatedFees.isEmpty()) {
            RulesFopHelper.addFops(fops, totalTranslatedFees, translatedFees, supplierFopData.getPaymentType(), supplierFopData.getOperationDate(), supplierFopData.getCard(), supplierFopData.getAgent(), supplierFopData.getPayer());
        }
        RulesFopHelper.addFops(fops, totalFees, fees, paymentType, operationDate, card, agent, payer);
        RulesFopHelper.addFops(fops, totalFeesForRefund, feesForRefund, paymentType, operationDate, card, agent, payer);
        RulesFopHelper.addFops(fops, totalDiscount.negate(), discounts, paymentType, operationDate, card, agent, payer);
        result.addAll(this.getPaymentFees(paymentFees, contractRelation, allContractRelations, previousProductContractRelations, messages));
        for (ValidationMessage message : messages) {
            boolean found = false;
            for (ValidationMessage vm : this.actionProxy.getValidationMessages()) {
                if (vm.getSeverity() != message.getSeverity() || !message.getMessage().equals((Object)vm.getMessage())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.actionProxy.getValidationMessages().add(message);
        }
        return result;
    }

    private FopData getFopData(Boolean supplierFees, GeneralProductContractRelationData contractRelation, GeneralProductContractRelationData previousRelation, PaymentType defaultPaymentType) {
        ValueHolder ptHolder = new ValueHolder();
        ValueHolder feePtHolder = new ValueHolder();
        ValueHolder opDateHolder = new ValueHolder();
        ValueHolder agentHolder = new ValueHolder();
        ValueHolder payerHolder = new ValueHolder();
        ValueHolder cardHolder = new ValueHolder();
        List fops = contractRelation.getFops();
        if (!RulesFopHelper.initializeFopParameters(this.initFopProxy, GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.CLIENT, fops, (ValueHolder<PaymentType>)ptHolder, (ValueHolder<PaymentType>)feePtHolder, (ValueHolder<Date>)opDateHolder, (ValueHolder<EntityReference<Person>>)agentHolder, (ValueHolder<Card>)cardHolder, (ValueHolder<EntityReference<Organization>>)payerHolder, FeeProperties.class, supplierFees, previousRelation != null ? previousRelation.getCommissions() : null) && supplierFees != null) {
            return null;
        }
        if (customizer != null && feePtHolder.getValue() == null) {
            feePtHolder.setValue((Object)customizer.getDefaultFeePaymentType(this.baseProduct, this.proxy, (EntityReference<ContractRelationDescription>)contractRelation.getDescription(), (PaymentType)ptHolder.getValue()));
        }
        Date operationDate = (Date)opDateHolder.getValue();
        PaymentType paymentType = (PaymentType)feePtHolder.getValue();
        if (paymentType == null) {
            paymentType = (PaymentType)ptHolder.getValue();
            if (paymentType == PaymentType.CREDIT_CARD) {
                paymentType = PaymentType.CREDIT_CARD_AGENCY;
            } else if (paymentType == PaymentType.MTD || paymentType == null) {
                paymentType = defaultPaymentType;
            }
        }
        EntityReference agent = (EntityReference)agentHolder.getValue();
        Card card = (Card)cardHolder.getValue();
        EntityReference payer = (EntityReference)payerHolder.getValue();
        return new FopData(operationDate, paymentType, (EntityReference<Person>)agent, card, (EntityReference<Organization>)payer);
    }

    private void checkHiddenFeesFop(GeneralProductFop pfForHidden, GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> previousProductContractRelations, PaymentType paymentType, Date operationDate, Card card, EntityReference<Person> agent, EntityReference<Organization> payer) {
        GeneralProductContractRelationData previousProductContractRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(previousProductContractRelations, (EntityReference)contractRelation.getDescription());
        if (previousProductContractRelation == null) {
            return;
        }
        BigDecimal exchangedFopAmount = BigDecimal.ZERO;
        for (GeneralProductFop previousFop : previousProductContractRelation.getFops()) {
            exchangedFopAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{exchangedFopAmount, previousFop.getEquivalentAmount()});
        }
        BigDecimal delta = exchangedFopAmount.subtract(pfForHidden.getEquivalentAmount());
        if (delta.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        pfForHidden.setEquivalentAmount(exchangedFopAmount);
        GeneralProductFop deltaFop = null;
        for (GeneralProductFop fop : contractRelation.getFops()) {
            if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop) || fop == pfForHidden) continue;
            deltaFop = fop;
            break;
        }
        if (deltaFop == null) {
            deltaFop = new GeneralProductFop();
            deltaFop.setType(paymentType == null || paymentType == PaymentType.TICKET ? PaymentType.CASH : paymentType);
            if (card != null) {
                deltaFop.setCard(card);
            }
            deltaFop.setOperationDate(operationDate);
            deltaFop.setAgent(agent);
            deltaFop.setEquivalentAmount(BigDecimal.ZERO);
            deltaFop.setPayer(payer);
            contractRelation.getFops().add(deltaFop);
        }
        deltaFop.setEquivalentAmount(deltaFop.getEquivalentAmount().subtract(delta));
    }

    private List<GeneralProductCommission> createNewCommissions(GeneralProductContractRelationData contractRelation, List<GeneralProductCommission> hiddenFees, List<GeneralProductContractRelationData> previousProductContractRelations, Collection<ValidationMessage> messages) throws Exception {
        Pair<BaseCommissionActionSet.AppliedRulesData> ruleResults = BaseCommissionActionSet.analyzeRulesResults(this.results.values(), messages);
        BaseCommissionActionSet.AppliedRulesData hiddenFeesResults = (BaseCommissionActionSet.AppliedRulesData)ruleResults.getFirst();
        BaseCommissionActionSet.AppliedRulesData standardCommissionsResults = (BaseCommissionActionSet.AppliedRulesData)ruleResults.getLast();
        ArrayList<GeneralProductCommission> allHiddenFees = new ArrayList<GeneralProductCommission>(hiddenFees);
        List<GeneralProductCommission> newHiddenFees = this.createCommissions(hiddenFeesResults, contractRelation, previousProductContractRelations, allHiddenFees, messages);
        allHiddenFees.addAll(newHiddenFees);
        ArrayList<GeneralProductCommission> result = new ArrayList<GeneralProductCommission>();
        result.addAll(newHiddenFees);
        result.addAll(this.createCommissions(standardCommissionsResults, contractRelation, previousProductContractRelations, allHiddenFees, messages));
        result.sort(new Comparator<GeneralProductCommission>(){

            @Override
            public int compare(GeneralProductCommission o1, GeneralProductCommission o2) {
                return this.getIndex((EntityReference<? extends BaseCommissionProperties>)o1.getCommissionProperties()) - this.getIndex((EntityReference<? extends BaseCommissionProperties>)o2.getCommissionProperties());
            }

            private int getIndex(EntityReference<? extends BaseCommissionProperties> commissionProperties) {
                if (commissionProperties == null) {
                    return 0;
                }
                if (CommissionProperties.class.equals((Object)commissionProperties.getType())) {
                    return 1;
                }
                if (FeeProperties.class.equals((Object)commissionProperties.getType())) {
                    return 2;
                }
                if (DiscountProperties.class.equals((Object)commissionProperties.getType())) {
                    return 3;
                }
                return 4;
            }
        });
        return result;
    }

    private List<GeneralProductCommission> createCommissions(BaseCommissionActionSet.AppliedRulesData rulesData, GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> previousProductContractRelations, List<GeneralProductCommission> hiddenFees, Collection<ValidationMessage> messages) throws Exception {
        ArrayList<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
        HashMap<String, RuleResultValue> minCommissions = new HashMap<String, RuleResultValue>(rulesData.minCommissions);
        HashMap<String, RuleResultValue> manuallyCalculatedCommissions = new HashMap<String, RuleResultValue>(rulesData.manuallyCalculatedCommissions);
        for (Map.Entry<String, RuleResultValue> entry : rulesData.standardCommissions.entrySet()) {
            GeneralProductCommission maxCommission;
            RuleResultValue ruleResult = entry.getValue();
            GeneralProductCommission commission = this.calculateCommissionAmount(ruleResult, contractRelation, previousProductContractRelations, hiddenFees, messages);
            if (commission == null) continue;
            manuallyCalculatedCommissions.remove(entry.getKey());
            ruleResult = rulesData.maxCommissions.get(entry.getKey());
            if (ruleResult != null && (maxCommission = this.calculateCommissionAmount(ruleResult, contractRelation, previousProductContractRelations, hiddenFees, messages)) != null && Math.abs(commission.getEquivalentAmount().doubleValue()) - Math.abs(maxCommission.getEquivalentAmount().doubleValue()) > 0.001) {
                commission = maxCommission;
            }
            if ((ruleResult = rulesData.minCommissions.get(entry.getKey())) != null) {
                minCommissions.remove(entry.getKey());
                GeneralProductCommission minCommission = this.calculateCommissionAmount(ruleResult, contractRelation, previousProductContractRelations, hiddenFees, messages);
                if (minCommission != null && Math.abs(minCommission.getEquivalentAmount().doubleValue()) - Math.abs(commission.getEquivalentAmount().doubleValue()) > 0.001) {
                    commission = minCommission;
                }
            }
            commissions.add(commission);
        }
        for (RuleResultValue ruleResult : minCommissions.values()) {
            GeneralProductCommission minCommission = this.calculateCommissionAmount(ruleResult, contractRelation, previousProductContractRelations, hiddenFees, messages);
            if (minCommission == null) continue;
            commissions.add(minCommission);
        }
        for (RuleResultValue ruleResult : manuallyCalculatedCommissions.values()) {
            GeneralProductCommission manuallyCalculatedCommission = this.calculateCommissionAmount(ruleResult, contractRelation, previousProductContractRelations, hiddenFees, messages);
            if (manuallyCalculatedCommission == null) continue;
            commissions.add(manuallyCalculatedCommission);
        }
        return commissions;
    }

    private void addHiddenCommissionsToFop(GeneralProductFop fop, List<GeneralProductCommission> hiddenCommissions) {
        if (fop == null || hiddenCommissions.isEmpty()) {
            return;
        }
        BigDecimal value = fop.getEquivalentAmount() != null ? fop.getEquivalentAmount() : BigDecimal.valueOf(0L);
        for (GeneralProductCommission comm : hiddenCommissions) {
            value = value.add(comm.getEquivalentAmount());
        }
        fop.setEquivalentAmount(value);
        fop.getCommissions().addAll(hiddenCommissions);
    }

    private List<GeneralProductCommission> getAdditionalCommissions(GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> allContractRelations, boolean translateSupplierFees, ExchangeRateData rateData) {
        int idx = allContractRelations.indexOf(contractRelation);
        if (idx == 0) {
            return Collections.emptyList();
        }
        GeneralProductContractRelationData previousRelation = allContractRelations.get(idx - 1);
        ArrayList<GeneralProductCommission> additionalCommissions = new ArrayList<GeneralProductCommission>();
        for (GeneralProductCommission comm : previousRelation.getCommissions()) {
            FeeProperties feeProperties;
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null || !(ctr.getEntity() instanceof FeeProperties) || !(feeProperties = (FeeProperties)ctr.getEntity()).isHidden() && !feeProperties.isTechFee() && (!feeProperties.isChargeToClientForAllContractTypes() || !translateSupplierFees) || (this.actionProxy.getStatus() == ProductStatus.REFUND || this.actionProxy.getStatus() == ProductStatus.EXCHANGE) && feeProperties.getOperation() == Operation.SELL) continue;
            ProductStatus status = ProductHandler.of((BaseProduct)this.baseProduct).getStatus(this.baseProduct);
            GeneralProductCommission addComm = new GeneralProductCommission();
            try {
                BigDecimal equivalentAmount;
                XCloneModelHelper.copy((BaseEntity)comm, (BaseEntity)addComm, (boolean)true);
                addComm.setTransferred(true);
                if (feeProperties.isRecalculateVatForAllContractTypes() && (equivalentAmount = addComm.getRuleValue()) != null) {
                    if (!feeProperties.isVatNotIncluded() && addComm.getVatRate() != null) {
                        VatAmount vatAmount = VatAmount.of((BigDecimal)equivalentAmount, (double)addComm.getVatRate());
                        equivalentAmount = MiscUtil.sub((BigDecimal)equivalentAmount, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
                    }
                    Double vatRate = GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)status);
                    addComm.setVatRate(vatRate);
                    if (vatRate != null) {
                        equivalentAmount = equivalentAmount.add(equivalentAmount.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                    }
                    equivalentAmount = RulesHelper.roundDouble((BigDecimal)equivalentAmount, (RoundingMode)feeProperties.getRoundingMode(), (RoundingValue)feeProperties.getRoundingValue());
                    if (status == ProductStatus.REFUND && feeProperties.getOperation() == Operation.REFUND) {
                        equivalentAmount = equivalentAmount.negate();
                    }
                    addComm.setEquivalentAmount(equivalentAmount);
                    addComm.setContractEquivalentAmount(equivalentAmount);
                    if (addComm.getAmount() != null) {
                        addComm.getAmount().setValue(equivalentAmount);
                    }
                }
                if (rateData != null) {
                    Money amount = new Money();
                    if (previousRelation.getGeneralData().getCurrency() != null) {
                        amount.setCurrency(previousRelation.getGeneralData().getCurrency().getCode());
                    }
                    amount.setValue(addComm.getEquivalentAmount());
                    addComm.setAmount(amount);
                    addComm.setRate(null);
                    addComm.setEquivalentAmount(RulesHelper.convert((BigDecimal)addComm.getEquivalentAmount(), (ExchangeRateData)rateData));
                    addComm.setContractEquivalentAmount(addComm.getEquivalentAmount());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
            addComm.setContractType(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()));
            additionalCommissions.add(addComm);
        }
        return additionalCommissions;
    }

    /*
     * WARNING - void declaration
     */
    private List<GeneralProductCommission> getPaymentFees(List<GeneralProductCommission> paymentFees, GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> allContractRelations, List<GeneralProductContractRelationData> previousProductContractRelations, Collection<ValidationMessage> messages) throws Exception {
        GeneralProductContractRelationData relation;
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)this.baseProduct);
        boolean hasPenalty = Optional.ofNullable(handler.getPenalty(this.baseProduct)).map(val -> val.compareTo(BigDecimal.ZERO) > 0).orElse(false);
        if (this.baseProduct instanceof HotelProduct) {
            hasPenalty = ((HotelProduct)this.baseProduct).getCancellationCharges().stream().anyMatch(charge -> !MiscUtil.isZero((BigDecimal)charge.getPenaltyEquivalentAmount(), (boolean)true) && (charge.getStartDate() == null || new Date().after(charge.getStartDate())));
        }
        ArrayList<GeneralProductCommission> result = new ArrayList<GeneralProductCommission>();
        if (this.actionProxy.getStatus() == ProductStatus.REFUND && this.actionProxy.getPreviousProduct() != null && this.actionProxy.getPreviousProduct().getStatus() == ProductStatus.SELL && (relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(previousProductContractRelations, (EntityReference)contractRelation.getDescription())) != null) {
            for (GeneralProductCommission comm : relation.getCommissions()) {
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null || !ctr.getEntityType().equals(PaymentFeeProperties.class)) continue;
                PaymentFeeProperties prop = (PaymentFeeProperties)ctr.getEntity();
                Set cases = prop.getReturnCases();
                if (!(this.actionProxy.isForcedRefund() && cases.contains(ReturnCase.FORCED_REFUND) || !this.actionProxy.isForcedRefund() && cases.contains(ReturnCase.REFUND)) && (hasPenalty || !cases.contains(ReturnCase.NO_PENALTIES_REFUND))) continue;
                GeneralProductCommission generalProductCommission = new GeneralProductCommission();
                XCloneModelHelper.copy((BaseEntity)comm, (BaseEntity)generalProductCommission, (boolean)true);
                if (generalProductCommission.getRate() != null) {
                    this.updatePaymentFeeAmount(generalProductCommission, contractRelation, messages, false);
                }
                if (generalProductCommission.getEquivalentAmount() == null) continue;
                contractRelation.getCommissions().add(generalProductCommission);
                result.add(generalProductCommission);
            }
        }
        ArrayList<GeneralProductCommission> additionalFees = new ArrayList<GeneralProductCommission>();
        int idx = allContractRelations.indexOf(contractRelation);
        if (idx > 0) {
            GeneralProductContractRelationData previousRelation = allContractRelations.get(idx - 1);
            for (GeneralProductCommission comm : previousRelation.getCommissions()) {
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null || !(ctr.getEntity() instanceof PaymentFeeProperties)) continue;
                GeneralProductCommission generalProductCommission = new GeneralProductCommission();
                try {
                    XCloneModelHelper.copy((BaseEntity)comm, (BaseEntity)generalProductCommission, (boolean)true);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("unable to clone entity ", exception);
                }
                generalProductCommission.setContractType(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()));
                if (generalProductCommission.getRate() == null) {
                    this.updateEquivalentAmount(generalProductCommission, null, null, contractRelation, previousProductContractRelations, false, messages);
                }
                additionalFees.add(generalProductCommission);
            }
            result.addAll(additionalFees);
        }
        HashMap<void, GeneralProductCommission> minCommissions = new HashMap<void, GeneralProductCommission>();
        HashMap<void, GeneralProductCommission> maxCommissions = new HashMap<void, GeneralProductCommission>();
        HashMap<void, GeneralProductCommission> standardCommissions = new HashMap<void, GeneralProductCommission>();
        block12: for (GeneralProductCommission generalProductCommission : paymentFees) {
            void var16_25;
            String string = "";
            PaymentFeeType type = PaymentFeeType.STANDARD;
            EntityContainer bp = null;
            try {
                bp = EntityStorage.get().resolve(generalProductCommission.getCommissionProperties());
            }
            catch (Exception e) {
                this.log.error("unable to resolve commission " + generalProductCommission.getCommissionProperties(), (Throwable)e);
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_ERROR_LOADING_COMMISSION, (Object[])new Object[]{generalProductCommission.getCommissionProperties()}));
            }
            if (bp != null) {
                PaymentFeeProperties pfp = (PaymentFeeProperties)bp.getEntity();
                if (pfp.getPaymentType() != null) {
                    String string2 = pfp.getPaymentType().name();
                }
                if (pfp.getType() != null) {
                    type = pfp.getType();
                }
            }
            this.updatePaymentFeeAmount(generalProductCommission, contractRelation, messages, true);
            if (type != PaymentFeeType.MAXIMUM && generalProductCommission.getEquivalentAmount() == null) continue;
            if (generalProductCommission.getEquivalentAmount() == null) {
                generalProductCommission.setEquivalentAmount(BigDecimal.ZERO);
            }
            switch (type) {
                case MINIMUM: {
                    minCommissions.put(var16_25, generalProductCommission);
                    continue block12;
                }
                case MAXIMUM: {
                    maxCommissions.put(var16_25, generalProductCommission);
                    continue block12;
                }
            }
            standardCommissions.put(var16_25, generalProductCommission);
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Map.Entry entry : new HashMap(standardCommissions).entrySet()) {
            GeneralProductCommission minCom;
            GeneralProductCommission commission = (GeneralProductCommission)entry.getValue();
            GeneralProductCommission max = (GeneralProductCommission)maxCommissions.get(entry.getKey());
            if (max != null && Math.abs(commission.getEquivalentAmount().doubleValue()) - Math.abs(max.getEquivalentAmount().doubleValue()) > 0.001) {
                commission = max;
            }
            if ((minCom = (GeneralProductCommission)minCommissions.get(entry.getKey())) != null) {
                minCommissions.remove(entry.getKey());
                if (Math.abs(minCom.getEquivalentAmount().doubleValue()) - Math.abs(commission.getEquivalentAmount().doubleValue()) > 0.001) {
                    commission = minCom;
                }
            }
            resultList.add(commission);
        }
        resultList.addAll(minCommissions.values());
        contractRelation.getCommissions().addAll(additionalFees);
        result.addAll(additionalFees);
        for (GeneralProductCommission generalProductCommission : resultList) {
            if (generalProductCommission.getEquivalentAmount() == null) continue;
            contractRelation.getCommissions().add(generalProductCommission);
            result.add(generalProductCommission);
        }
        HashMap<PaymentType, Set> hashMap = new HashMap<PaymentType, Set>();
        for (GeneralProductCommission comm : result) {
            try {
                PaymentFeeProperties prop = (PaymentFeeProperties)EntityStorage.get().resolve(comm.getCommissionProperties()).getEntity();
                Set set = hashMap.computeIfAbsent(prop.getPaymentType(), k -> new HashSet());
                set.add(comm);
            }
            catch (Exception e) {
                this.log.error("unable to resolve reference " + comm.getCommissionProperties(), (Throwable)e);
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_CANT_LOAD_COMMISSION_DESCRIPTION, (Object[])new Object[]{comm.getCommissionProperties()}));
            }
        }
        List list = contractRelation.getFops();
        ValueHolder ptHolder = new ValueHolder();
        ValueHolder feePtHolder = new ValueHolder();
        ValueHolder opDateHolder = new ValueHolder();
        ValueHolder agentHolder = new ValueHolder();
        ValueHolder payerHolder = new ValueHolder();
        ValueHolder cardHolder = new ValueHolder();
        RulesFopHelper.initializeFopParameters(this.initFopProxy, GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.CLIENT, list, (ValueHolder<PaymentType>)ptHolder, (ValueHolder<PaymentType>)feePtHolder, (ValueHolder<Date>)opDateHolder, (ValueHolder<EntityReference<Person>>)agentHolder, (ValueHolder<Card>)cardHolder, (ValueHolder<EntityReference<Organization>>)payerHolder, PaymentFeeProperties.class, null, null);
        Iterator it = list.iterator();
        block16: while (it.hasNext()) {
            GeneralProductFop pf = (GeneralProductFop)it.next();
            for (GeneralProductCommission comm : pf.getCommissions()) {
                if (comm.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
                it.remove();
                continue block16;
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Set comms = (Set)entry.getValue();
            BigDecimal sum = BigDecimal.ZERO;
            for (GeneralProductCommission comm : comms) {
                sum = sum.add(comm.getEquivalentAmount());
            }
            if (Math.abs(sum.doubleValue()) < 0.001) continue;
            GeneralProductFop fop = new GeneralProductFop();
            fop.setType((PaymentType)entry.getKey());
            fop.setEquivalentAmount(sum);
            fop.getCommissions().addAll(comms);
            fop.setOperationDate((Date)opDateHolder.getValue());
            fop.setAgent((EntityReference)agentHolder.getValue());
            fop.setCard((Card)cardHolder.getValue());
            fop.setPayer((EntityReference)payerHolder.getValue());
            list.add(fop);
        }
        return result;
    }

    private void updatePaymentFeeAmount(GeneralProductCommission comm, GeneralProductContractRelationData contractRelation, Collection<ValidationMessage> messages, boolean negateOnRefund) {
        comm.setEquivalentAmount(null);
        EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
        if (ctr == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_LOADING_COMMISSION_PROPERTIES_FAILED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        PaymentFeeProperties prop = (PaymentFeeProperties)ctr.getEntity();
        if (prop.getPaymentType() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_COMMISSION_PAYMENT_TYPE_NOT_DEFINED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        List fops = contractRelation.getFops();
        if (comm.getRate() == null) {
            boolean found = false;
            block0: for (GeneralProductFop pf : fops) {
                if (pf.getType() == PaymentType.TICKET) continue;
                for (GeneralProductCommission comm2 : pf.getCommissions()) {
                    if (comm2.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm2.getCommissionProperties().getType())) continue;
                    continue block0;
                }
                if (pf.getType() != prop.getPaymentType()) continue;
                found = true;
                break;
            }
            if (!found) {
                comm.setEquivalentAmount(null);
                return;
            }
            RoundingMode rm = RoundingMode.NONE;
            RoundingValue rv = RoundingValue.V_0_0_1;
            EntityContainer commCtr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (commCtr != null) {
                rm = ((BaseCommissionProperties)commCtr.getEntity()).getRoundingMode();
                rv = ((BaseCommissionProperties)commCtr.getEntity()).getRoundingValue();
            }
            comm.setEquivalentAmount(this.calculateEquivalentAmount(comm.getAmount(), rm, rv, RulesHelper.isFeeForRefund((EntityReference)comm.getCommissionProperties()), messages));
            if (this.actionProxy.getStatus() == ProductStatus.REFUND && negateOnRefund) {
                this.negate(comm);
            }
            return;
        }
        if (prop.getBasis() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_COMMISSION_BASIS_NOT_DEFINED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        BigDecimal basis = BigDecimal.ZERO;
        block2: for (GeneralProductFop pf : fops) {
            if (pf.getType() == PaymentType.TICKET) continue;
            for (GeneralProductCommission comm2 : pf.getCommissions()) {
                if (comm2.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm2.getCommissionProperties().getType()) && (!FeeProperties.class.equals((Object)comm2.getCommissionProperties().getType()) || !PaymentFeeCalculationBasis.PRICE.equals((Object)prop.getBasis()))) continue;
                continue block2;
            }
            if (pf.getType() != prop.getPaymentType() || pf.getEquivalentAmount() == null || prop.getBasis() == PaymentFeeCalculationBasis.FEES && GeneralProductHelper.isServiceFop((GeneralProductFop)pf)) continue;
            basis = basis.add(pf.getEquivalentAmount());
        }
        for (GeneralProductCommission comm2 : contractRelation.getCommissions()) {
            BaseCommissionProperties ett;
            EntityContainer ctr2 = EntityStorage.get().resolve(comm2.getCommissionProperties());
            if (ctr2 == null || !((ett = (BaseCommissionProperties)ctr2.getEntity()) instanceof PaymentFeeProperties)) continue;
            PaymentFeeProperties pfp = (PaymentFeeProperties)ett;
            if (prop.getPaymentType() != pfp.getPaymentType() || comm2.getEquivalentAmount() == null) continue;
            basis = basis.add(comm2.getEquivalentAmount());
        }
        if (Math.abs(basis.doubleValue()) < 0.001) {
            return;
        }
        BigDecimal value = basis.multiply(BigDecimal.valueOf(comm.getRate())).divide(BigDecimal.valueOf(100L), 4, java.math.RoundingMode.HALF_UP);
        if (prop.getBasis() == PaymentFeeCalculationBasis.TRANSACTION) {
            value = value.divide(BigDecimal.valueOf(1.0 - comm.getRate() / 100.0), 4, java.math.RoundingMode.HALF_UP);
        }
        RoundingMode rm = RoundingMode.NONE;
        RoundingValue rv = RoundingValue.V_0_0_1;
        EntityContainer commCtr = EntityStorage.get().resolve(comm.getCommissionProperties());
        if (commCtr != null) {
            rm = ((BaseCommissionProperties)commCtr.getEntity()).getRoundingMode();
            rv = ((BaseCommissionProperties)commCtr.getEntity()).getRoundingValue();
        }
        comm.setEquivalentAmount(this.calculateEquivalentAmount(SystemHelper.getMoney((double)value.doubleValue(), (String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")), rm, rv, RulesHelper.isFeeForRefund((EntityReference)comm.getCommissionProperties()), messages));
        if (this.actionProxy.getStatus() == ProductStatus.REFUND && negateOnRefund) {
            this.negate(comm);
        }
    }

    private void negate(GeneralProductCommission comm) {
        if (comm.getRate() != null) {
            comm.setRate(Double.valueOf(-comm.getRate().doubleValue()));
        }
        if (comm.getAmount() != null && comm.getAmount().getValue() != null) {
            comm.getAmount().setValue(comm.getAmount().getValue().negate());
        }
        if (comm.getEquivalentAmount() != null) {
            comm.setEquivalentAmount(comm.getEquivalentAmount().negate());
        }
    }

    private BigDecimal calculateEquivalentAmount(Money amount, RoundingMode rm, RoundingValue rv, boolean feeForRefund, Collection<ValidationMessage> messages) {
        if (amount == null || amount.getCurrency() == null || amount.getValue() == null) {
            return null;
        }
        String eqvCode = this.getEquivalentCurrencyCode();
        BigDecimal value = amount.getValue();
        String currencyCode = amount.getCurrency();
        if (!currencyCode.equals(eqvCode)) {
            value = value.multiply(this.getCurrencyRate(null, currencyCode, feeForRefund, messages));
        }
        return RulesHelper.roundDouble((BigDecimal)value, (RoundingMode)rm, (RoundingValue)rv);
    }

    private void reduceNewCommissions(List<GeneralProductCommission> newCommissions) {
        boolean specialRefund = this.actionProxy.hasNextSellAfterRefund();
        if (!specialRefund) {
            return;
        }
        Iterator<GeneralProductCommission> i = newCommissions.iterator();
        while (i.hasNext()) {
            GeneralProductCommission comm = i.next();
            if (comm.getCommissionProperties() == null || !FeeProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
            i.remove();
        }
    }

    private void updateRefundedCommissions(Collection<GeneralProductCommission> commissions, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> previousProductContractRelations, Collection<ValidationMessage> messages) throws Exception {
        Iterator<Object> it;
        CommissionProperties commProp;
        EntityContainer ctr;
        GeneralProductCommission comm2;
        if (this.actionProxy.getPreviousProduct() == null) {
            this.log.error("related product is absent, skipping update of fees");
            return;
        }
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)this.baseProduct);
        boolean hasPenalty = Optional.ofNullable(handler.getPenalty(this.baseProduct)).map(val -> val.compareTo(BigDecimal.ZERO) > 0).orElse(false);
        CommissionActionProxy relatedProduct = this.actionProxy.getPreviousProduct();
        if (relatedProduct.getTicketType() != null && relatedProduct.getTicketType() != TicketType.OWN) {
            this.log.debug("related product is not OWN, skipping update of fees");
            return;
        }
        boolean specialRefund = this.actionProxy.hasNextSellAfterRefund();
        ArrayList<GeneralProductCommission> refundedCommissions = new ArrayList<GeneralProductCommission>();
        GeneralProductContractRelationData previousProductRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(previousProductContractRelations, (EntityReference)relation.getDescription());
        if (previousProductRelation != null) {
            for (GeneralProductCommission comm2 : previousProductRelation.getCommissions()) {
                FeeProperties feeProperties;
                ctr = EntityStorage.get().resolve(comm2.getCommissionProperties());
                if (ctr == null) continue;
                if (ctr.getEntityType().equals(CommissionProperties.class)) {
                    commProp = (CommissionProperties)ctr.getEntity();
                    if (commProp.isManuallyCalculated() && this.containsCommissionCategory(relation.getCommissions(), (EntityReference<? extends BaseCommissionProperties>)comm2.getCommissionProperties()) || commProp.isDontReturn()) continue;
                    refundedCommissions.add(comm2);
                    continue;
                }
                if (ctr.getEntityType().equals(DiscountProperties.class)) {
                    DiscountProperties discProp = (DiscountProperties)ctr.getEntity();
                    if (discProp.getType() == DiscountType.MANUALLY_CALCULATED && this.containsCommissionCategory(relation.getCommissions(), (EntityReference<? extends BaseCommissionProperties>)comm2.getCommissionProperties())) continue;
                    refundedCommissions.add(comm2);
                    continue;
                }
                if (ctr.getEntityType().equals(PaymentFeeProperties.class) || (feeProperties = (FeeProperties)ctr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED && this.containsCommissionCategory(relation.getCommissions(), (EntityReference<? extends BaseCommissionProperties>)comm2.getCommissionProperties())) continue;
                Set cases = feeProperties.getReturnCases();
                if (this.actionProxy.getStatus() == ProductStatus.REFUND && !specialRefund && (hasPenalty || !cases.contains(ReturnCase.NO_PENALTIES_REFUND)) && (this.actionProxy.isForcedRefund() && !cases.contains(ReturnCase.FORCED_REFUND) || !this.actionProxy.isForcedRefund() && !cases.contains(ReturnCase.REFUND) || this.includeInPenalty(feeProperties, relation)) || this.actionProxy.getStatus() == ProductStatus.EXCHANGE && (this.actionProxy.isForcedRefund() && !cases.contains(ReturnCase.FORCED_EXCHANGE) || !this.actionProxy.isForcedRefund() && !cases.contains(ReturnCase.EXCHANGE))) continue;
                refundedCommissions.add(comm2);
            }
        }
        if (this.actionProxy.getStatus() == ProductStatus.REFUND && !specialRefund) {
            it = relation.getCommissions().iterator();
            while (it.hasNext()) {
                comm2 = (GeneralProductCommission)it.next();
                ctr = EntityStorage.get().resolve(comm2.getCommissionProperties());
                if (!ctr.getEntityType().equals(CommissionProperties.class) || !(commProp = (CommissionProperties)ctr.getEntity()).isDontReturn()) continue;
                it.remove();
            }
        }
        it = commissions.iterator();
        while (it.hasNext()) {
            DiscountProperties dp;
            CommissionProperties cp;
            FeeProperties fp;
            comm2 = (GeneralProductCommission)it.next();
            ctr = EntityStorage.get().resolve(comm2.getCommissionProperties());
            if (ctr == null || !ctr.getEntityType().isAssignableFrom(FeeProperties.class)) {
                it.remove();
                continue;
            }
            BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
            if (prop instanceof FeeProperties && (fp = (FeeProperties)prop).getOperation() != Operation.REFUND && fp.getOperation() != Operation.EXCHANGE) {
                it.remove();
            }
            if (prop instanceof CommissionProperties && (cp = (CommissionProperties)prop).getOperation() != Operation.REFUND && cp.getOperation() != Operation.EXCHANGE) {
                it.remove();
            }
            if (!(prop instanceof DiscountProperties) || (dp = (DiscountProperties)prop).getOperation() == Operation.REFUND || dp.getOperation() == Operation.EXCHANGE) continue;
            it.remove();
        }
        ArrayList<GeneralProductCommission> refundedHiddenFees = new ArrayList<GeneralProductCommission>();
        for (GeneralProductCommission comm3 : this.reorderCommissions(refundedCommissions)) {
            FeeProperties feeProp;
            BaseCommissionProperties prop;
            GeneralProductCommission item = new GeneralProductCommission();
            XCloneModelHelper.copy((BaseEntity)comm3, (BaseEntity)item, (boolean)true);
            EntityContainer ctr2 = EntityStorage.get().resolve(item.getCommissionProperties());
            BaseCommissionProperties baseCommissionProperties = prop = ctr2 != null ? (BaseCommissionProperties)ctr2.getEntity() : null;
            if (item.getRate() != null || item.getAmount() != null && item.getAmount().getValue() != null && item.getAmount().getCurrency() != null) {
                RuleResultValue res = new RuleResultValue();
                res.setTarget(item.getCommissionProperties());
                boolean calculateFromDifference = false;
                if (prop instanceof FeeProperties) {
                    FeeProperties fprop = (FeeProperties)prop;
                    calculateFromDifference = fprop.isCalculateFromDifference();
                }
                BigDecimal value2 = null;
                if (item.getRate() != null) {
                    res.setCurrencyCode("%");
                    res.setValue(item.getRate().doubleValue());
                } else {
                    res.setCurrencyCode(this.getEquivalentCurrencyCode());
                    BigDecimal value = item.getEquivalentAmount();
                    value2 = item.getAmount().getValue();
                    if (prop instanceof FeeProperties && ((FeeProperties)prop).isVatNotIncluded() && item.getVatRate() != null) {
                        VatAmount vatAmount = VatAmount.of((BigDecimal)value, (double)item.getVatRate());
                        value = MiscUtil.sub((BigDecimal)value, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
                        VatAmount vatAmount2 = VatAmount.of((BigDecimal)value2, (double)item.getVatRate());
                        value2 = MiscUtil.sub((BigDecimal)value2, (BigDecimal[])new BigDecimal[]{vatAmount2.getVatAmount()});
                    }
                    CalculationType calculationType = CalculationType.TICKET;
                    if (prop instanceof FeeProperties) {
                        calculationType = ((FeeProperties)prop).getCalculationType();
                    } else if (prop instanceof CommissionProperties) {
                        calculationType = ((CommissionProperties)prop).getCalculationType();
                    } else if (prop instanceof DiscountProperties) {
                        calculationType = ((DiscountProperties)prop).getCalculationType();
                    }
                    if (calculationType == null) {
                        calculationType = CalculationType.TICKET;
                    }
                    switch (calculationType) {
                        case SEGMENT: {
                            int n = relatedProduct.getSegmentsCount();
                            if (n <= 0) break;
                            value = value.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            value2 = value2.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            break;
                        }
                        case SEGMENT_TARIFF: {
                            int n = relatedProduct.getSegmentTariffsCount();
                            if (n <= 0) break;
                            value = value.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            value2 = value2.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            break;
                        }
                    }
                    res.setValue(value.doubleValue());
                }
                this.updateCommissionAmount(item, res, relation, previousProductContractRelations, refundedHiddenFees, true, messages);
                CalculationBasis basis = null;
                if (prop instanceof FeeProperties) {
                    basis = ((FeeProperties)prop).getCalculationBasis();
                }
                if (prop instanceof DiscountProperties) {
                    basis = ((DiscountProperties)prop).getCalculationBasis();
                }
                if (prop instanceof CommissionProperties) {
                    basis = ((CommissionProperties)prop).getCalculationBasis();
                }
                if (basis == null) {
                    basis = CalculationBasis.FARE;
                }
                this.updateEquivalentAmount(item, refundedHiddenFees, basis, relation, previousProductContractRelations, calculateFromDifference, messages);
                if (item.getRate() == null) {
                    GeneralProductCommission item2 = new GeneralProductCommission();
                    XCloneModelHelper.copy((BaseEntity)comm3, (BaseEntity)item2, (boolean)true);
                    res.setCurrencyCode(item2.getAmount().getCurrency());
                    res.setValue(value2.doubleValue());
                    this.updateCommissionAmount(item2, res, relation, previousProductContractRelations, refundedHiddenFees, true, new ArrayList<ValidationMessage>());
                    item.setAmount(item2.getAmount());
                }
            }
            if (prop instanceof FeeProperties && (feeProp = (FeeProperties)prop).isHidden()) {
                refundedHiddenFees.add(item);
            }
            commissions.add(item);
        }
    }

    private boolean includeInPenalty(FeeProperties feeProperties, GeneralProductContractRelationData contractRelation) {
        boolean result = feeProperties.isHidden();
        result &= feeProperties instanceof ExtraFeeProperties && ((ExtraFeeProperties)feeProperties).getKeepOnReturnWithPenalty() == Boolean.TRUE;
        result &= this.actionProxy.getPreviousProduct().getProductType() == ProductType.HOTEL_RESERVATION;
        return result &= this.penaltiesStarted(contractRelation);
    }

    private boolean penaltiesStarted(GeneralProductContractRelationData contractRelation) {
        BigDecimal penalty = MiscUtil.guarded((BigDecimal)contractRelation.getServiceData().getDetalization().getPenalty());
        return penalty.compareTo(BigDecimal.ZERO) > 0;
    }

    private List<GeneralProductCommission> reorderCommissions(List<GeneralProductCommission> commissions) {
        List<GeneralProductCommission> hiddenFees = BaseCommissionActionSet.getHiddenFees(commissions);
        if (hiddenFees.isEmpty()) {
            return commissions;
        }
        commissions.removeAll(hiddenFees);
        for (GeneralProductCommission comm : hiddenFees) {
            commissions.add(0, comm);
        }
        return commissions;
    }

    private boolean containsCommissionCategory(List<GeneralProductCommission> commissions, EntityReference<? extends BaseCommissionProperties> commissionProperties) {
        if (commissionProperties == null) {
            return false;
        }
        for (GeneralProductCommission comm : commissions) {
            if (!commissionProperties.equals((Object)comm.getCommissionProperties())) continue;
            return true;
        }
        return false;
    }

    protected void fixFeeRate(GeneralProductCommission commission, FeeProperties feeProp) {
        if (this.actionProxy.getStatus() == ProductStatus.REFUND && feeProp.getOperation() == Operation.REFUND) {
            if (commission.getRate() != null) {
                commission.setRate(Double.valueOf(-commission.getRate().doubleValue()));
            }
            if (commission.getAmount() != null) {
                commission.getAmount().setValue(commission.getAmount().getValue().negate());
            }
        }
    }

    protected void fixCommissionRate(GeneralProductCommission commission, CommissionProperties commProp) {
        if (this.actionProxy.getStatus() == ProductStatus.REFUND && commProp.getOperation() == Operation.REFUND) {
            if (commission.getRate() != null) {
                commission.setRate(Double.valueOf(-commission.getRate().doubleValue()));
            }
            if (commission.getAmount() != null) {
                commission.getAmount().setValue(commission.getAmount().getValue().negate());
            }
        }
    }

    protected void fixDiscountRate(GeneralProductCommission commission, DiscountProperties discProp) {
        if (this.actionProxy.getStatus() == ProductStatus.REFUND && discProp.getOperation() == Operation.REFUND) {
            if (commission.getRate() != null) {
                commission.setRate(Double.valueOf(-commission.getRate().doubleValue()));
            }
            if (commission.getAmount() != null) {
                commission.getAmount().setValue(commission.getAmount().getValue().negate());
            }
        }
    }

    protected BigDecimal updateRuleValueWithVatRate(BigDecimal value, GeneralProductCommission commission, BaseCommissionProperties properties) {
        if (properties instanceof FeeProperties) {
            boolean refund;
            commission.setRuleValue(value);
            FeeProperties feeProperties = (FeeProperties)properties;
            ProductStatus productStatus = ProductHandler.of((BaseProduct)this.baseProduct).getStatus(this.baseProduct);
            boolean bl = refund = ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus;
            if (refund && commission.isTransferred()) {
                if (feeProperties.isRecalculateVatForAllContractTypes()) {
                    BigDecimal equivalentAmount = commission.getRuleValue();
                    if (!feeProperties.isVatNotIncluded()) {
                        Double previousVatRate;
                        Double d = previousVatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.previousVatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                        if (previousVatRate != null) {
                            VatAmount vatAmount = VatAmount.of((BigDecimal)equivalentAmount, (double)previousVatRate);
                            equivalentAmount = MiscUtil.sub((BigDecimal)equivalentAmount, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
                        }
                    }
                    Double vatRate = GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                    commission.setVatRate(vatRate);
                    if (vatRate != null) {
                        return equivalentAmount.add(equivalentAmount.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                    }
                } else {
                    Double vatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.previousVatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                    commission.setVatRate(vatRate);
                    if (feeProperties.isVatNotIncluded() && vatRate != null) {
                        return value.add(value.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                    }
                }
            } else {
                Double vatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                commission.setVatRate(vatRate);
                if (feeProperties.isVatNotIncluded() && vatRate != null) {
                    return value.add(value.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                }
            }
        }
        return value;
    }

    protected void updateAmountWithVatRate(GeneralProductCommission commission, BaseCommissionProperties properties) {
        Double vatRate;
        if (commission.getAmount() == null || commission.getAmount().getValue() == null) {
            return;
        }
        if (!(properties instanceof FeeProperties)) {
            return;
        }
        BigDecimal value = commission.getAmount().getValue();
        commission.setRuleValue(value);
        FeeProperties feeProperties = (FeeProperties)properties;
        ProductStatus productStatus = ProductHandler.of((BaseProduct)this.baseProduct).getStatus(this.baseProduct);
        boolean refund = ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus;
        Double d = vatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
        if (refund && commission.isTransferred()) {
            vatRate = feeProperties.isRecalculateVatForAllContractTypes() ? GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus) : (feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.previousVatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus));
        }
        commission.setVatRate(vatRate);
        if (feeProperties.isVatNotIncluded() && vatRate != null) {
            commission.getAmount().setValue(value.add(value.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP)));
        }
    }

    private BigDecimal getBasis(CalculationBasis basis, List<GeneralProductCommission> hiddenFees, GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> previousProductContractRelations, boolean useDifference, boolean hidden) {
        BigDecimal result = GeneralProductCommissionActionSet.getBasis(basis, contractRelation, this.actionProxy.getAdditionalFare(), this.baseProduct, hiddenFees);
        if (!useDifference || this.actionProxy.getPreviousProduct() == null) {
            return result;
        }
        if (this.actionProxy.getPreviousProduct() != null) {
            boolean withTotal = withTotalBasis.contains(basis);
            boolean withPenalties = withPenaltyBasis.contains(basis);
            GeneralProductContractRelationData previousProductRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(previousProductContractRelations, (EntityReference)contractRelation.getDescription());
            if (previousProductRelation != null) {
                if (basis == CalculationBasis.TAXES) {
                    result = result.subtract(GeneralProductHelper.getEquivalentTaxesAmount((Collection)previousProductRelation.getServiceData().getDetalization().getTaxes()));
                } else if (basis == CalculationBasis.PENALTY) {
                    result = result.subtract(MiscUtil.guarded((BigDecimal)previousProductRelation.getServiceData().getDetalization().getPenalty()));
                } else {
                    if (!hidden) {
                        result = result.subtract(GeneralProductCommissionActionSet.getHiddenEquivalentFare(BaseCommissionActionSet.getHiddenFees(previousProductRelation.getCommissions())));
                    }
                    result = withTotal ? result.subtract(MiscUtil.guarded((BigDecimal)previousProductRelation.getServiceData().getTotalPrice())).subtract(MiscUtil.guarded((BigDecimal)this.actionProxy.getPreviousProduct().getAdditionalFare())) : result.subtract(MiscUtil.guarded((BigDecimal)previousProductRelation.getServiceData().getDetalization().getFare())).subtract(MiscUtil.guarded((BigDecimal)this.actionProxy.getPreviousProduct().getAdditionalFare()));
                    if (withPenalties) {
                        result = result.subtract(MiscUtil.guarded((BigDecimal)previousProductRelation.getServiceData().getDetalization().getPenalty()));
                    }
                }
            }
        }
        return result;
    }

    private static BigDecimal getHiddenEquivalentFare(Collection<GeneralProductCommission> hiddenFees) {
        return GeneralProductHelper.calculateCommissionsEquivalentValue(hiddenFees);
    }

    private BigDecimal getCurrencyRate(String baseCurrencyCode, String currencyCode, boolean feeForRefund, Collection<ValidationMessage> messages) {
        return RateHelper.getCurrencyRate((String)baseCurrencyCode, (String)currencyCode, (BaseProduct)this.baseProduct, (boolean)feeForRefund, messages);
    }

    public void setCommission(String category, String className, String uid, double value, String currencyCode) {
        RuleResultValue res = new RuleResultValue();
        res.setCurrencyCode(currencyCode);
        res.setValue(value);
        res.setTarget(this.createReference(className, uid));
        this.results.put(category, res);
    }

    public boolean setCommission(String category, String className, String uid, double value, String currencyCode, String target, String[] fops) {
        if (!this.isApplicable(target, fops)) {
            return false;
        }
        RuleResultValue res = new RuleResultValue();
        res.setCurrencyCode(currencyCode);
        res.setValue(value);
        res.setTarget(this.createReference(className, uid));
        this.results.put(category, res);
        return true;
    }

    private boolean isApplicable(String target, String[] fops) {
        block0: for (String fop : fops) {
            for (String pt : this.actionProxy.getPaymentTypes()) {
                if (!pt.equals(fop)) continue;
                continue block0;
            }
            return false;
        }
        return TextUtil.isSame((String)this.actionProxy.getTargetType(), (String)target);
    }

    public Map<String, RuleResultValue> getResults() {
        return this.results;
    }

    public boolean accept(String category, String className, String uid) throws Exception {
        return this.accept(category, this.createReference(className, uid));
    }

    private boolean isMinimumCommission(BaseCommissionProperties entity) {
        if (entity instanceof CommissionProperties) {
            CommissionProperties comm = (CommissionProperties)entity;
            return comm.isMinimum();
        }
        if (entity instanceof DiscountProperties) {
            DiscountProperties comm = (DiscountProperties)entity;
            return comm.getType() == DiscountType.MINIMUM;
        }
        if (entity instanceof FeeProperties) {
            FeeProperties comm = (FeeProperties)entity;
            return comm.getType() == FeeType.MINIMUM;
        }
        return false;
    }

    private boolean isMaximumCommission(BaseCommissionProperties entity) {
        if (entity instanceof FeeProperties) {
            FeeProperties comm = (FeeProperties)entity;
            return comm.getType() == FeeType.MAXIMUM;
        }
        return false;
    }

    private GeneralProductCommission calculateCommissionAmount(RuleResultValue value, GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> previousProductContractRelations, List<GeneralProductCommission> hiddenFees, Collection<ValidationMessage> messages) throws Exception {
        GeneralProductCommission result = new GeneralProductCommission();
        return this.updateCommissionAmount(result, value, contractRelation, previousProductContractRelations, hiddenFees, false, messages) ? result : null;
    }

    protected boolean updateCommissionAmount(GeneralProductCommission result, RuleResultValue value, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> previousProductContractRelations, List<GeneralProductCommission> hiddenFees, boolean refunded, Collection<ValidationMessage> messages) throws Exception {
        String currency;
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        result.setContractType(contractType);
        EntityContainer ctr = EntityStorage.get().resolve(value.getTarget());
        BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
        if (prop instanceof FeeProperties && ((FeeProperties)prop).getType() == FeeType.MANUALLY_CALCULATED && this.baseProduct.getManualFeeAppliedFlags().get(contractType) != null && ((Boolean)this.baseProduct.getManualFeeAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof CommissionProperties && ((CommissionProperties)prop).isManuallyCalculated() && this.baseProduct.getManualCommissionAppliedFlags().get(contractType) != null && ((Boolean)this.baseProduct.getManualCommissionAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof DiscountProperties && ((DiscountProperties)prop).getType() == DiscountType.MANUALLY_CALCULATED && this.baseProduct.getManualDiscountAppliedFlags().get(contractType) != null && ((Boolean)this.baseProduct.getManualDiscountAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        result.setCommissionProperties(ctr.toReference());
        String currencyCode = value.getCurrencyCode();
        CalculationBasis basis = null;
        boolean useDifference = false;
        if (prop instanceof CommissionProperties || prop instanceof DiscountProperties) {
            if ("%".equals(currencyCode)) {
                result.setRate(Double.valueOf(value.getValue()));
                basis = prop instanceof DiscountProperties ? ((DiscountProperties)prop).getCalculationBasis() : ((CommissionProperties)prop).getCalculationBasis();
            } else {
                currency = this.getCurrency(currencyCode, messages);
                Money money = new Money();
                money.setCurrency(currency);
                BigDecimal amount = BigDecimal.valueOf(value.getValue());
                CalculationType calculationType = prop instanceof CommissionProperties ? ((CommissionProperties)prop).getCalculationType() : ((DiscountProperties)prop).getCalculationType();
                if (value.isForceSegmentCalculation()) {
                    calculationType = CalculationType.SEGMENT;
                }
                if (calculationType == null) {
                    calculationType = CalculationType.TICKET;
                }
                switch (calculationType) {
                    case SEGMENT: {
                        amount = amount.multiply(BigDecimal.valueOf(this.actionProxy.getSegmentsCount()));
                        break;
                    }
                    case SEGMENT_TARIFF: {
                        amount = amount.multiply(BigDecimal.valueOf(this.actionProxy.getSegmentTariffsCount()));
                        break;
                    }
                    case HOTEL_TRAVELLER: {
                        amount = amount.multiply(BigDecimal.valueOf(this.actionProxy.getTravellersCount()));
                        break;
                    }
                }
                money.setValue(amount);
                result.setAmount(money);
            }
            if (prop instanceof CommissionProperties) {
                this.fixCommissionRate(result, (CommissionProperties)prop);
            }
            if (prop instanceof DiscountProperties) {
                this.fixDiscountRate(result, (DiscountProperties)prop);
            }
        } else if (prop instanceof FeeProperties) {
            FeeProperties feeProp = (FeeProperties)prop;
            if (feeProp.getCalculationType() == CalculationType.SEGMENT) {
                String currency2 = this.getCurrency(currencyCode, messages);
                Money money = new Money();
                money.setCurrency(currency2);
                money.setValue(BigDecimal.valueOf(value.getValue()).multiply(BigDecimal.valueOf(this.actionProxy.getSegmentsCount())));
                result.setAmount(money);
            } else if (feeProp.getCalculationType() == CalculationType.HOTEL_TRAVELLER) {
                String currency3 = this.getCurrency(currencyCode, messages);
                Money money = new Money();
                money.setCurrency(currency3);
                money.setValue(BigDecimal.valueOf(value.getValue()).multiply(BigDecimal.valueOf(this.actionProxy.getTravellersCount())));
                result.setAmount(money);
            } else if ("%".equals(currencyCode)) {
                result.setRate(Double.valueOf(value.getValue()));
                basis = feeProp.getCalculationBasis();
                useDifference = feeProp.isCalculateFromDifference();
            } else {
                String currency4 = this.getCurrency(currencyCode, messages);
                Money money = new Money();
                money.setCurrency(currency4);
                money.setValue(BigDecimal.valueOf(value.getValue()));
                result.setAmount(money);
            }
            this.updateAmountWithVatRate(result, (BaseCommissionProperties)feeProp);
            this.fixFeeRate(result, feeProp);
        } else if (prop instanceof PaymentFeeProperties) {
            if ("%".equals(currencyCode)) {
                result.setRate(Double.valueOf(value.getValue()));
                return true;
            }
            currency = this.getCurrency(currencyCode, messages);
            Money money = new Money();
            money.setCurrency(currency);
            money.setValue(BigDecimal.valueOf(value.getValue()));
            result.setAmount(money);
        } else {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPCAS_UNKNOWN_COMMISSION_TYPE, (Object[])new Object[]{value.getTarget()}));
            return false;
        }
        this.updateEquivalentAmount(result, hiddenFees, basis, relation, previousProductContractRelations, useDifference, messages);
        if (value instanceof ExtRuleResultValue) {
            ExtRuleResultValue extValue = (ExtRuleResultValue)value;
            result.setPercentage(extValue.getPercentage());
        }
        return true;
    }

    protected void updateEquivalentAmount(GeneralProductCommission commission, List<GeneralProductCommission> hiddenFees, CalculationBasis basis, GeneralProductContractRelationData contractRelation, List<GeneralProductContractRelationData> previousProductContractRelations, boolean useDifference, Collection<ValidationMessage> messages) {
        Money money;
        EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
        if (null == ctr) {
            throw Xeption.forDeveloper((String)("no commission found, uid= " + commission.getCommissionProperties()), (Object[])new Object[0]);
        }
        BaseCommissionProperties properties = (BaseCommissionProperties)ctr.getEntity();
        String eqvCode = this.getEquivalentCurrencyCode();
        BigDecimal result = BigDecimal.ZERO;
        if (commission.getRate() != null) {
            boolean isHidden = properties instanceof FeeProperties && ((FeeProperties)properties).isHidden();
            BigDecimal fare = this.getBasis(basis, hiddenFees, contractRelation, previousProductContractRelations, useDifference, isHidden);
            result = result.add(BigDecimal.valueOf(commission.getRate()).multiply(fare).divide(BigDecimal.valueOf(100L), 4, java.math.RoundingMode.HALF_UP));
            result = RulesHelper.roundDouble((BigDecimal)result, (RoundingMode)properties.getRoundingMode(), (RoundingValue)properties.getRoundingValue());
            result = this.updateRuleValueWithVatRate(result, commission, properties);
        }
        if ((money = commission.getAmount()) != null && money.getCurrency() != null && money.getValue() != null) {
            BigDecimal value = money.getValue();
            String currencyCode = money.getCurrency();
            if (!currencyCode.equals(eqvCode)) {
                value = value.multiply(this.getCurrencyRate(eqvCode, currencyCode, RulesHelper.isFeeForRefund((EntityReference)commission.getCommissionProperties()), messages));
            }
            result = result.add(value);
        }
        commission.setEquivalentAmount(RulesHelper.roundDouble((BigDecimal)result, (RoundingMode)properties.getRoundingMode(), (RoundingValue)properties.getRoundingValue()));
        commission.setContractEquivalentAmount(commission.getEquivalentAmount());
    }

    protected String getCurrency(String currencyCode, Collection<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)currencyCode)) {
            String curCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPCAS_USING_DEFAULT_CURRENCY, (Object[])new Object[]{curCode}));
            return curCode;
        }
        return currencyCode;
    }

    private String getEquivalentCurrencyCode() {
        return this.equiveCurrencyCode != null ? this.equiveCurrencyCode : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
    }

    private EntityReference<? extends BaseCommissionProperties> createReference(String className, String uid) {
        try {
            return new EntityReference(uid, XHelper.getClass((String)className), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(String category, EntityReference<? extends BaseCommissionProperties> target) throws Exception {
        RuleLogTracer tracer;
        block13: {
            BaseCommissionProperties prop;
            block12: {
                block11: {
                    block10: {
                        EntityContainer ctr;
                        block9: {
                            block8: {
                                boolean bl;
                                tracer = this.proxy.getTracer();
                                tracer.traceEnteringMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
                                try {
                                    if (!this.results.containsKey(category)) break block8;
                                    tracer.traceLogic("results already contain the category, returning false");
                                    bl = false;
                                }
                                catch (Throwable throwable) {
                                    tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
                                    throw throwable;
                                }
                                tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
                                return bl;
                            }
                            ctr = EntityStorage.get().resolve(target);
                            if (ctr != null) break block9;
                            tracer.traceLogic("unable to load commission properties,returning false");
                            boolean bl = false;
                            tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
                            return bl;
                        }
                        prop = (BaseCommissionProperties)ctr.getEntity();
                        if (!(prop instanceof CommissionProperties)) break block10;
                        boolean bl = this.accept((CommissionProperties)prop);
                        tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
                        return bl;
                    }
                    if (!(prop instanceof DiscountProperties)) break block11;
                    boolean bl = this.accept((DiscountProperties)prop);
                    tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
                    return bl;
                }
                if (!(prop instanceof FeeProperties)) break block12;
                boolean bl = this.accept((FeeProperties)prop);
                tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
                return bl;
            }
            if (!(prop instanceof PaymentFeeProperties)) break block13;
            boolean bl = this.accept((PaymentFeeProperties)prop);
            tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
            return bl;
        }
        tracer.traceLogic("returning true");
        boolean bl = true;
        tracer.traceExitingMethod(BaseCommissionActionSet.class, "accept", new String[]{category, target.toString()});
        return bl;
    }

    public void addAllowedPaymentType(String paymentTypeStr) {
        PaymentType pt = (PaymentType)CollectionUtil.findEnumConstant(PaymentType.class, (String)paymentTypeStr);
        if (pt != null) {
            this.allowedPaymentTypes.add(pt);
        }
    }

    public Set<PaymentType> getAllowedPaymentTypes() {
        return this.allowedPaymentTypes;
    }

    public Map<EntityReference<? extends BaseCommissionProperties>, String> getCachedCategories() {
        return this.cacheCategories;
    }

    public void setCommission(String category, RuleResultValue ruleResultValue) {
        ExtRuleResultValue res;
        if (ruleResultValue instanceof ExtRuleResultValue) {
            res = new ExtRuleResultValue();
            res.setPercentage(((ExtRuleResultValue)ruleResultValue).getPercentage());
        } else {
            res = new RuleResultValue();
        }
        res.setCurrencyCode(ruleResultValue.getCurrencyCode());
        res.setValue(ruleResultValue.getValue());
        res.setTarget(ruleResultValue.getTarget());
        this.results.put(category, (RuleResultValue)res);
    }

    public boolean setCommission(String category, EntityReference<? extends BaseCommissionProperties> comm, double value, String currencyCode, String target, boolean forceSegmentCalculation, String[] fops) {
        if (!this.isApplicable(target, fops)) {
            return false;
        }
        RuleResultValue res = new RuleResultValue();
        res.setCurrencyCode(currencyCode);
        res.setValue(value);
        res.setTarget(comm);
        res.setForceSegmentCalculation(forceSegmentCalculation);
        this.results.put(category, res);
        return true;
    }

    public boolean isSabreExcludeCommissionQualifier() {
        return this.sabreExcludeCommissionQualifier;
    }

    public void setSabreExcludeCommissionQualifier(boolean value) {
        this.sabreExcludeCommissionQualifier = value;
    }

    public List<String> getTourCodes() {
        return this.tourCodes;
    }

    public boolean areTourCodesOverridden() {
        return this.overrideTourCodes;
    }

    public void setTourCodes(List<String> values) {
        this.overrideTourCodes = true;
        this.tourCodes.clear();
        if (values != null) {
            this.tourCodes.addAll(values);
        }
    }

    public Collection<EntityReference<TemplateDocument>> getReceiptTemplates() {
        return this.receiptTemplates;
    }

    public void setReceiptTemplates(Collection<EntityReference<TemplateDocument>> receiptTemplates) {
        this.receiptTemplates = receiptTemplates;
    }

    public void setItineraryReceiptData(AirItineraryReceiptData template) {
    }

    public void selectContract(boolean select) {
        this.selectContract = select;
    }

    public Boolean isContractSelected() {
        return this.selectContract;
    }

    public void translateSupplierFee(boolean translateSupplierFee) {
        this.transferSupplierFee = translateSupplierFee;
    }

    public Boolean isTranslateSupplierFee() {
        return this.transferSupplierFee;
    }

    public void setFeePaymentType(PaymentType feePaymentType) {
        this.feePaymentType = feePaymentType;
    }

    public PaymentType getFeePaymentType() {
        return this.feePaymentType;
    }

    public void setPayer(EntityReference<Organization> payer) {
        this.payer = payer;
    }

    public EntityReference<Organization> getPayer() {
        return this.payer;
    }

    public void setSupplier(EntityReference<Organization> supplier) {
        this.supplier = supplier;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public void setBlankOwner(EntityReference<Organization> blankOwner) {
        this.blankOwner = blankOwner;
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    private double[] getVatRatesFromContract(GeneralProductContractRelationData contractRelation, BaseProduct product) {
        EntityReference payer = contractRelation.getFops().stream().filter(f -> f.getType() != PaymentType.TICKET).map(GeneralProductFop::getPayer).filter(Objects::nonNull).findFirst().orElse(null);
        return GeneralProductHelper.getFeeVatRate((BaseProduct)product, (EntityReference)contractRelation.getDescription(), (ContractRelationVatDetalization)contractRelation.getServiceData().getDetalization().getVat(), (EntityReference)payer);
    }

    static {
        withPenaltyBasis = Arrays.asList(CalculationBasis.FARE_AND_PENALTY, CalculationBasis.TOTAL_AND_PENALTY);
        withTotalBasis = Arrays.asList(CalculationBasis.TOTAL, CalculationBasis.TOTAL_AND_PENALTY);
        String className = System.getProperty("general-product-commission-action-set-customizer.className");
        if (!TextUtil.isBlank((String)className)) {
            customizer = (GeneralProductCommissionActionSetCustomizer)XHelper.getInstance((String)className, (Object[])new Object[0]);
        }
    }

    public static interface CommissionActionProxy {
        public boolean isOneWayTicket();

        public int getSegmentTariffsCount();

        public Set<String> getPaymentTypes();

        public String getTargetType();

        public Date getIssueDate();

        public int getSegmentsCount();

        public TicketType getTicketType();

        public List<ValidationMessage> getValidationMessages();

        public boolean isForcedRefund();

        public CommissionActionProxy getPreviousProduct();

        public CommissionActionProxy getNextProduct();

        default public boolean hasNextSellAfterRefund() {
            return false;
        }

        public ProductType getProductType();

        public ProductStatus getStatus();

        public EntityReference<SalesPoint> getSalesPoint();

        public BigDecimal getAdditionalFare();

        default public int getTravellersCount() {
            return 1;
        }
    }

    private static class FopData {
        private final Date operationDate;
        private final PaymentType paymentType;
        private final EntityReference<Person> agent;
        private Card card;
        private final EntityReference<Organization> payer;

        public FopData(Date operationDate, PaymentType paymentType, EntityReference<Person> agent, Card card, EntityReference<Organization> payer) {
            this.operationDate = operationDate;
            this.paymentType = paymentType;
            this.agent = agent;
            this.card = card;
            this.payer = payer;
        }

        public Date getOperationDate() {
            return this.operationDate;
        }

        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public Card getCard() {
            return this.card;
        }

        public void setCard(Card card) {
            this.card = card;
        }

        public EntityReference<Organization> getPayer() {
            return this.payer;
        }
    }

    public static class AcceptanceCheckResult {
        public final boolean accept;
        public final String explanation;

        private AcceptanceCheckResult(boolean accept, String message) {
            this.accept = accept;
            this.explanation = message;
        }

        public static AcceptanceCheckResult of(boolean accept, String explanation) {
            return new AcceptanceCheckResult(accept, explanation);
        }

        public static AcceptanceCheckResult of(boolean accept) {
            return AcceptanceCheckResult.of(accept, null);
        }
    }
}

