/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.HotelVoucherData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.HotelPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HotelActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = 8806509241791994112L;
    private EntityReference<Organization> subagency;
    private HotelVoucherData hotelVoucherData;

    public HotelActionSet(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelPropertySet propertySet, HotelProduct item) {
        super(proxy, (BaseProduct)item, HotelActionSet.createHandler(item, propertySet, HotelActionSet.getPaymentTypes(item)));
    }

    public HotelActionSet(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelProduct item, GeneralProductCommissionActionSet.CommissionActionProxy cProxy) {
        super(proxy, (BaseProduct)item, cProxy);
    }

    public static Set<String> getPaymentTypes(HotelProduct item) {
        HashSet<String> result = new HashSet<String>();
        for (HotelProductFop fop : HotelProductHelper.getClientFops((HotelProduct)item)) {
            if (fop.getType() == null) continue;
            result.add(fop.getType().name());
        }
        return result;
    }

    @Override
    protected boolean updateCommissionAmount(GeneralProductCommission result, RuleResultValue value, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> previousProductContractRelations, List<GeneralProductCommission> hiddenFees, boolean refunded, Collection<ValidationMessage> messages) throws Exception {
        EntityContainer ctr = EntityStorage.get().resolve(value.getTarget());
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
        if (prop instanceof FeeProperties && ((FeeProperties)prop).getType() == FeeType.MANUALLY_CALCULATED && this.getBaseProduct().getManualFeeAppliedFlags().get(contractType) != null && ((Boolean)this.getBaseProduct().getManualFeeAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof CommissionProperties && ((CommissionProperties)prop).isManuallyCalculated() && this.getBaseProduct().getManualCommissionAppliedFlags().get(contractType) != null && ((Boolean)this.getBaseProduct().getManualCommissionAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof DiscountProperties && ((DiscountProperties)prop).getType() == DiscountType.MANUALLY_CALCULATED && this.getBaseProduct().getManualDiscountAppliedFlags().get(contractType) != null && ((Boolean)this.getBaseProduct().getManualDiscountAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof FeeProperties || prop instanceof DiscountProperties) {
            CalculationType calculationType = null;
            if (prop instanceof FeeProperties) {
                calculationType = ((FeeProperties)prop).getCalculationType();
            } else if (prop instanceof DiscountProperties) {
                calculationType = ((DiscountProperties)prop).getCalculationType();
            }
            if (calculationType == CalculationType.HOTEL_TRAVELLER) {
                int personCount = ((HotelPropertySet)this.proxy.getPropertySet()).getPersonsCount();
                Money money = new Money();
                if (!refunded) {
                    money.setValue(BigDecimal.valueOf(value.getValue()).multiply(BigDecimal.valueOf(personCount)));
                } else {
                    money.setValue(BigDecimal.valueOf(value.getValue()));
                }
                money.setCurrency(this.getCurrency(value.getCurrencyCode(), messages));
                result.setCommissionProperties(ctr.toReference());
                result.setContractType(contractType);
                result.setAmount(money);
                this.updateAmountWithVatRate(result, prop);
                this.updateEquivalentAmount(result, hiddenFees, null, relation, previousProductContractRelations, false, messages);
                return true;
            }
            if (calculationType == CalculationType.HOTEL_DAILY) {
                int stayDuration = ((HotelPropertySet)this.proxy.getPropertySet()).getStayDuration();
                Money money = new Money();
                money.setValue(BigDecimal.valueOf(value.getValue()).multiply(BigDecimal.valueOf(stayDuration)));
                money.setCurrency(this.getCurrency(value.getCurrencyCode(), messages));
                result.setCommissionProperties(ctr.toReference());
                result.setContractType(contractType);
                result.setAmount(money);
                this.updateAmountWithVatRate(result, prop);
                this.updateEquivalentAmount(result, hiddenFees, null, relation, previousProductContractRelations, false, messages);
                return true;
            }
        }
        return super.updateCommissionAmount(result, value, relation, previousProductContractRelations, hiddenFees, refunded, messages);
    }

    public static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final HotelProduct ticket, final HotelPropertiesProvider propertySet, final Set<String> paymentTypes) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            @Override
            public boolean isOneWayTicket() {
                return true;
            }

            @Override
            public boolean isForcedRefund() {
                return false;
            }

            @Override
            public List<ValidationMessage> getValidationMessages() {
                return ticket.getValidationMessages();
            }

            @Override
            public TicketType getTicketType() {
                return ticket.getTicketType() == null ? TicketType.OWN : ticket.getTicketType();
            }

            @Override
            public String getTargetType() {
                return "TICKET";
            }

            @Override
            public ProductStatus getStatus() {
                return ticket.getStatus();
            }

            @Override
            public int getSegmentsCount() {
                return ticket.getRooms().size();
            }

            @Override
            public ProductType getProductType() {
                return ProductType.HOTEL_RESERVATION;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return ticket.getPreviousProduct() != null ? HotelActionSet.createHandler(ticket.getPreviousProduct(), propertySet, HotelActionSet.getPaymentTypes(ticket.getPreviousProduct())) : null;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return ticket.getNextProduct() != null ? HotelActionSet.createHandler(ticket.getNextProduct(), propertySet, HotelActionSet.getPaymentTypes(ticket.getNextProduct())) : null;
            }

            @Override
            public Set<String> getPaymentTypes() {
                return paymentTypes;
            }

            @Override
            public Date getIssueDate() {
                return ticket.getIssueDate();
            }

            @Override
            public EntityReference<SalesPoint> getSalesPoint() {
                return ticket.getSalesPoint();
            }

            @Override
            public int getSegmentTariffsCount() {
                return 0;
            }

            @Override
            public BigDecimal getAdditionalFare() {
                BigDecimal eqAddSvc = HotelProductHelper.calculateAddServicesEquivalentAmount((HotelProduct)ticket);
                GeneralProductCommission gpc = HotelProductHelper.getVendorFee((HotelProduct)ticket, (ContractType)ContractType.CLIENT);
                if (gpc != null) {
                    return MiscUtil.sum((BigDecimal[])new BigDecimal[]{eqAddSvc, gpc.getEquivalentAmount()});
                }
                return MiscUtil.guarded((BigDecimal)eqAddSvc);
            }

            @Override
            public int getTravellersCount() {
                return ticket.getTravellers().size();
            }
        };
    }

    public HotelVoucherData getHotelVoucherData() {
        return this.hotelVoucherData;
    }

    public void setHotelVoucherData(HotelVoucherData voucherData) {
        this.hotelVoucherData = voucherData;
    }

    public EntityReference<Organization> getSubagency() {
        return this.subagency;
    }

    public void setSubagency(EntityReference<Organization> subagency) {
        this.subagency = subagency;
    }
}

