/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.HotelPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.PayersPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ReservationPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesContextPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.SubagentPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravellersPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySetContext;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HotelPropertySet
implements HotelPropertiesProvider,
SalesContextPropertiesProvider,
PayersPropertiesProvider,
ProductPropertiesProvider,
UDIDsPropertyProvider,
TravellersPropertyProvider,
TicketTypePropertiesProvider,
ProductStatusPropertiesProvider,
EmployeeCategoriesProvider,
ClientCreditCardVendorProvider,
ReservationPropertiesProvider,
SubagentPropertiesProvider,
TravelSubjectPropertiesProvider {
    private final RuleProxy<? extends HotelPropertySet, ?> proxy;
    private final List<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
    private final Set<String> locationCodes = new HashSet<String>();
    private final Set<String> roomNames = new HashSet<String>();
    private final Set<String> roomTypes = new HashSet<String>();
    private final Set<String> passengerTypes = new HashSet<String>();
    private final Set<String> passengerTypeCategories = new HashSet<String>();
    private final Set<String> additionalServiceTypes = new HashSet<String>();
    private final Set<String> bookingContent = new HashSet<String>();
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();
    private Integer stars;
    private BigDecimal equivalentFare;
    private String providerName;
    private String subProviderCode;
    private String hotelName;
    private String hotelPropertyId;
    private String seller;
    private int roomsCount;
    private Date checkInDate;
    private Date bookingDate;
    private int stayDuration;
    private String hotelChainCode;
    private String clientTariffCode;
    private String salesPointUid;
    private String countryCode;
    private String cityCode;
    private int personsCount;
    protected HotelProduct product;
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    private EntityReference<Organization> subagency;
    private String supplierUid;
    private Boolean vat;
    private Double vatRate;
    private final List<EntityReference<Person>> travellers = new ArrayList<EntityReference<Person>>();
    private final List<EmployeeCategory> employeeCategories = new ArrayList<EmployeeCategory>();
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private String clientCreditCardVendor;
    private String agencyCode;
    private String reservationType;
    private EntityReference<? extends BaseGdsAccount> gdsAccount;
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;

    public HotelPropertySet(RuleProxy<? extends HotelPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    public void init(EntityReference<? extends BaseGdsAccount> gdsAccount) {
        this.gdsAccount = gdsAccount;
    }

    public void init(HotelProduct product) {
        this.init(product, HotelRulesHelper.getHotelRulesHandler().createPropertySetContext(product));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(HotelProduct product, HotelPropertySetContext context) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            this.product = product;
            this.agencyCode = context.getAgencyCode();
            this.agent = product.getCashier();
            this.bookingAgent = Optional.ofNullable(product.getReservation()).map(Reservation::getBookingAgent).orElse(null);
            if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
                this.client = product.getReservation().getBookingFile().getCustomerProfile();
            }
            this.subagency = context.getSubagency();
            this.subagencyCodes.addAll(context.getSubagencyCodes());
            this.profileGroups.addAll(context.getProfileGroups());
            this.stars = product.getHotelStars();
            this.equivalentFare = HotelProductHelper.getEquivalentFare((HotelProduct)product);
            this.commissions.clear();
            this.commissions.addAll(HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, null));
            this.providerName = product.getProvider() == null ? null : product.getProvider().name();
            String string = this.subProviderCode = product.getSubProvider() == null ? null : product.getSubProvider().getCode();
            if (product.getHotelCountry() != null) {
                this.countryCode = product.getHotelCountry().getCode();
            }
            if (product.getHotelLocation() != null) {
                this.cityCode = product.getHotelLocation().getCode();
            }
            this.locationCodes.addAll(context.getLocationCodes());
            this.hotelName = product.getHotelName();
            this.hotelPropertyId = product.getHotelPropertyId();
            this.seller = product.getSeller();
            this.roomsCount = product.getRooms().size();
            for (Room room : product.getRooms()) {
                if (TextUtil.nonBlank((String)room.getRoomName())) {
                    this.roomNames.add(room.getRoomName().toLowerCase());
                }
                if (this.checkInDate == null) {
                    this.checkInDate = room.getCheckInDate();
                }
                if (room.getCheckOutDate() != null && room.getCheckInDate() != null) {
                    this.stayDuration = HotelProductHelper.calculateNights((Date)room.getCheckInDate(), (Date)room.getCheckOutDate());
                }
                if (TextUtil.isBlank((String)room.getRoomSize())) continue;
                this.roomTypes.addAll(DictHelper.findAllRoomSizeCodesByAnyCode((String)room.getRoomSize()));
            }
            this.hotelChainCode = product.getHotelChainCode();
            this.clientTariffCode = product.getClientTariffCode();
            for (AdditionalService additionalService : product.getAdditionalServices()) {
                if (additionalService.getType() == null) continue;
                this.additionalServiceTypes.add(additionalService.getType().name());
            }
            this.passengerTypeCategories.clear();
            for (PassengerTypeReference ptr : product.getTravellersPassengerTypes()) {
                if (ptr == null || ptr.getPassengerType() == null) continue;
                this.passengerTypes.add(ptr.getPassengerType().getCode());
                this.passengerTypeCategories.addAll(RulesHelper.getPassengerTypeCategoryCodes((DictionaryReference)ptr.getPassengerType()));
            }
            this.travelSubject = ProductHandler.of((BaseProduct)product).findTravelSubject((BaseProduct)product);
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)product));
            if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
                for (Reservation reservation : product.getReservation().getBookingFile().getReservations()) {
                    for (BaseProduct bp : reservation.getProducts()) {
                        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                        ProductType pt = handler.getProductType(bp);
                        if (pt == null) continue;
                        this.bookingContent.add(pt.name());
                    }
                }
            }
            this.salesPointUid = product.getSalesPoint() != null ? product.getSalesPoint().getUid() : null;
            EntityReference supplier = HotelProductHelper.getSupplier((HotelProduct)product);
            this.supplierUid = supplier != null ? supplier.getUid() : null;
            this.personsCount = product.getTravellers().size();
            this.bookingDate = Optional.ofNullable(product.getReservation()).map(Reservation::getResDate).orElse(null);
            this.payers.addAll(context.getPayers());
            product.getTravellers().stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.travellers::add);
            this.employeeCategories.addAll(context.getEmployeeCategories());
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)product.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)product.getReservation()));
            this.vat = product.getRooms().stream().filter(Objects::nonNull).map(r -> r.getVat() != null ? r.getVat() : r.getEquivalentVatPrice() != null && BigDecimal.ZERO.compareTo(r.getEquivalentVatPrice()) != 0).findFirst().orElse(null);
            this.vatRate = product.getRooms().stream().filter(Objects::nonNull).map(Room::getEquivVatRate).filter(Objects::nonNull).findFirst().orElse(-1.0);
            this.clientCreditCardVendor = context.getClientCreditCardVendor();
            this.reservationType = RulesHelper.getEnumName(product.getReservation() != null ? product.getReservation().getType() : null);
            this.setGdsAccount();
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    private void setGdsAccount() {
        this.gdsAccount = Optional.ofNullable(this.product.getReservation()).map(reservation -> reservation.getGdsNameInfo().getOnlineGdsAccount()).orElse(null);
    }

    public Integer getHotelStars() {
        return this.stars;
    }

    public HotelType getHotelType() {
        return this.product.getHotelType();
    }

    public List<GeneralProductCommission> getCommissions() {
        return this.commissions;
    }

    public BigDecimal getEquivalentFare() {
        return this.equivalentFare;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getSubProviderCode() {
        return this.subProviderCode;
    }

    public double getFare() {
        return this.equivalentFare == null ? 0.0 : this.equivalentFare.doubleValue();
    }

    public Set<String> getLocationCodes() {
        return this.locationCodes;
    }

    public String getHotelName() {
        return this.hotelName;
    }

    public String getHotelPropertyId() {
        return this.hotelPropertyId;
    }

    public int getRoomsCount() {
        return this.roomsCount;
    }

    public Set<String> getRoomNames() {
        return this.roomNames;
    }

    public Date getCheckInDate() {
        return this.checkInDate;
    }

    public Date getBookingDate() {
        return this.bookingDate;
    }

    public int getStayDuration() {
        return this.stayDuration;
    }

    public String getHotelChainCode() {
        return this.hotelChainCode;
    }

    public String getClientTariffCode() {
        return this.clientTariffCode;
    }

    public Set<String> getAdditionalServiceTypes() {
        return this.additionalServiceTypes;
    }

    public Set<String> getBookingContent() {
        return this.bookingContent;
    }

    public String getSalesPointUid() {
        return this.salesPointUid;
    }

    public String getSupplierUid() {
        return this.supplierUid;
    }

    public void setSupplierUid(String supplierUid) {
        this.supplierUid = supplierUid;
    }

    public int getPersonsCount() {
        return this.personsCount;
    }

    public Set<String> getPassengerTypes() {
        return this.passengerTypes;
    }

    public Set<String> getPassengerTypeCategories() {
        return this.passengerTypeCategories;
    }

    public Set<String> getRoomTypes() {
        return this.roomTypes;
    }

    public HotelProduct getProduct() {
        return this.product;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public Boolean getVat() {
        return this.vat;
    }

    public Double getVatRate() {
        return this.vatRate;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public boolean isForcedRefund() {
        return ProductPropertiesHelper.isForcedRefund(this.product);
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public List<CostCode> getCostCodes() {
        return StatisticsHelper.getAllCostCodes((StatisticalData)this.product.getStatisticalData());
    }

    public Collection<EntityReference<Person>> getTravellers() {
        return this.travellers;
    }

    public TicketType getTicketType() {
        return this.product.getTicketType();
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return this.employeeCategories;
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getReservationType() {
        return this.reservationType;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public String getSeller() {
        return this.seller;
    }

    public EntityReference<Organization> getSubagency() {
        return this.subagency;
    }

    public void setSubagency(EntityReference<Organization> subagency) {
        this.subagency = subagency;
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }
}

