/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.server.model.handlers.PayersCollector;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HotelPropertySetContext {
    private final String agencyCode;
    private final EntityReference<Organization> subagency;
    private final String clientCreditCardVendor;
    private final List<EmployeeCategory> employeeCategories;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final Set<String> locationCodes = new HashSet<String>();
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();

    public HotelPropertySetContext(HotelProduct product) {
        this.agencyCode = CommonProductHelper.getAgencyCode(product);
        this.subagency = HotelProductHelper.getSubagency((HotelProduct)product);
        this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor(product);
        this.employeeCategories = GeneralProductHelper.getEmployeeCategories((BaseProduct)product);
        CommonProductHelper.addSubagencyCodes(this.subagencyCodes, this.subagency);
        CommonProductHelper.addProfileGroups(this.profileGroups, (EntityReference<? extends BaseProfile>)product.getCashier());
        CommonProductHelper.addProfileGroups(this.profileGroups, (EntityReference<? extends BaseProfile>)((EntityReference)Optional.ofNullable(product.getReservation()).map(Reservation::getBookingFile).map(BookingFile::getCustomerProfile).orElse(null)));
        if (product.getHotelCountry() != null) {
            this.locationCodes.add(product.getHotelCountry().getCode());
            Country country = (Country)DictionaryCache.get().resolveReference(product.getHotelCountry());
            if (country != null) {
                country.getRegions().stream().filter(Objects::nonNull).map(DictionaryReference::getCode).filter(Objects::nonNull).forEach(this.locationCodes::add);
            }
        }
        if (product.getHotelLocation() != null) {
            this.locationCodes.addAll(RulesHelper.collectGeoCodes(Collections.singleton(product.getHotelLocation().getCode()), (boolean)true));
        }
        this.payers.addAll(PayersCollector.collect(product));
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public EntityReference<Organization> getSubagency() {
        return this.subagency;
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return this.employeeCategories;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public Set<String> getLocationCodes() {
        return this.locationCodes;
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }
}

