/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.InsuranceAccidentPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.InsuranceAccidentPropertySet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class InsuranceAccidentActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = 1880786408962032416L;

    public InsuranceAccidentActionSet(RuleProxy<InsuranceAccidentPropertySet, InsuranceAccidentActionSet> proxy, InsuranceAccidentPropertiesProvider propertySet, InsuranceAccident ticket) {
        super(proxy, (BaseProduct)ticket, InsuranceAccidentActionSet.createHandler(ticket, propertySet));
    }

    private static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final InsuranceAccident ticket, final InsuranceAccidentPropertiesProvider propertySet) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            @Override
            public boolean isOneWayTicket() {
                return true;
            }

            @Override
            public boolean isForcedRefund() {
                return true;
            }

            @Override
            public List<ValidationMessage> getValidationMessages() {
                return ticket.getValidationMessages();
            }

            @Override
            public TicketType getTicketType() {
                return ticket.getTicketType();
            }

            @Override
            public String getTargetType() {
                return "TICKET";
            }

            @Override
            public ProductStatus getStatus() {
                return ticket.getStatus();
            }

            @Override
            public int getSegmentsCount() {
                return 0;
            }

            @Override
            public ProductType getProductType() {
                return ProductType.INSURANCE_ACCIDENT;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return ticket.getPreviousProduct() != null ? InsuranceAccidentActionSet.createHandler(ticket.getPreviousProduct(), propertySet) : null;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return ticket.getNextProduct() != null ? InsuranceAccidentActionSet.createHandler(ticket.getNextProduct(), propertySet) : null;
            }

            @Override
            public Set<String> getPaymentTypes() {
                return propertySet.getClientPaymentTypes();
            }

            @Override
            public Date getIssueDate() {
                return ticket.getIssueDate();
            }

            @Override
            public EntityReference<SalesPoint> getSalesPoint() {
                return ticket.getSalesPoint();
            }

            @Override
            public int getSegmentTariffsCount() {
                return 0;
            }

            @Override
            public BigDecimal getAdditionalFare() {
                return null;
            }
        };
    }
}

