/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.InsuranceAccidentPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ReservationPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class InsuranceAccidentPropertySet
implements Serializable,
InsuranceAccidentPropertiesProvider,
TicketTypePropertiesProvider,
EmployeeCategoriesProvider,
ReservationPropertiesProvider,
ProductStatusPropertiesProvider {
    private static final long serialVersionUID = 5866821851068635355L;
    private String passengerType;
    private String salesPointUid;
    private Date issueDate;
    private String pnr;
    private String pcc;
    private boolean eticket;
    private double paymentSum;
    private final Set<String> vendorPaymentTypes = new HashSet<String>();
    private final Set<String> clientPaymentTypes = new HashSet<String>();
    private final RuleProxy<InsuranceAccidentPropertySet, ?> proxy;
    private String gdsName;
    private TicketType ticketType;
    protected InsuranceAccident product;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> supplier;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);

    public InsuranceAccidentPropertySet(RuleProxy<InsuranceAccidentPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(InsuranceAccident ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            String enumName;
            this.salesPointUid = ticket.getSalesPoint() != null ? ticket.getSalesPoint().getUid() : null;
            this.gdsName = Optional.ofNullable(ticket.getReservation()).map(CommonReservationGdsNameInfoHelper::getRulesGdsName).map(Enum::name).orElse(null);
            this.product = ticket;
            this.bookingAgent = ticket.getReservation().getBookingAgent();
            this.supplier = InsuranceAccidentHelper.getSupplier((InsuranceAccident)ticket);
            this.passengerType = RulesHelper.getDictCode((DictionaryReference)ticket.getPassengerType());
            this.issueDate = ticket.getIssueDate();
            this.pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)ticket.getReservation());
            this.pcc = ticket.getPcc();
            this.eticket = ticket.isEticket();
            if (ticket.getEquivalentSum() != null) {
                this.paymentSum = ticket.getEquivalentSum().doubleValue();
            }
            for (GeneralProductFop fop : InsuranceAccidentHelper.getVendorFops((InsuranceAccident)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.vendorPaymentTypes.add(enumName);
            }
            for (GeneralProductFop fop : InsuranceAccidentHelper.getClientFops((InsuranceAccident)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.clientPaymentTypes.add(enumName);
            }
            this.ticketType = ticket.getTicketType();
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)ticket));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public String getPassengerType() {
        return this.passengerType;
    }

    public String getSalesPointUid() {
        return this.salesPointUid;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getPnr() {
        return this.pnr;
    }

    public String getPcc() {
        return this.pcc;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public Set<String> getVendorPaymentTypes() {
        return this.vendorPaymentTypes;
    }

    public Set<String> getClientPaymentTypes() {
        return this.clientPaymentTypes;
    }

    public RuleProxy<InsuranceAccidentPropertySet, ?> getProxy() {
        return this.proxy;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public double getPaymentSum() {
        return this.paymentSum;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }
}

