/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.InsuranceTouristicPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.PayersPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ReservationPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.PayersCollector;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InsuranceTouristicPropertySet
implements InsuranceTouristicPropertiesProvider,
PayersPropertiesProvider,
UDIDsPropertyProvider,
TicketTypePropertiesProvider,
EmployeeCategoriesProvider,
ClientCreditCardVendorProvider,
ReservationPropertiesProvider,
ProductStatusPropertiesProvider {
    private String salesPointUid;
    private Date issueDate;
    private String pnr;
    private boolean eticket;
    private double paymentSum;
    private final Set<String> vendorPaymentTypes = new HashSet<String>();
    private final Set<String> clientPaymentTypes = new HashSet<String>();
    private final RuleProxy<InsuranceTouristicPropertySet, ?> proxy;
    private final List<CostCode> costCodes = new ArrayList<CostCode>();
    private TicketType ticketType;
    protected InsuranceTouristic product;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private String clientCreditCardVendor;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> supplier;
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();

    public InsuranceTouristicPropertySet(RuleProxy<InsuranceTouristicPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(InsuranceTouristic ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            String enumName;
            this.product = ticket;
            this.bookingAgent = ticket.getReservation().getBookingAgent();
            this.supplier = InsuranceTouristicHelper.getSupplier((InsuranceTouristic)ticket);
            this.salesPointUid = ticket.getSalesPoint() != null ? ticket.getSalesPoint().getUid() : null;
            this.issueDate = ticket.getIssueDate();
            this.pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)ticket.getReservation());
            this.eticket = BookingHelper.isEticket((DictionaryReference)ticket.getBlankType());
            if (ticket.getEquivalentSum() != null) {
                this.paymentSum = ticket.getEquivalentSum().doubleValue();
            }
            for (GeneralProductFop fop : InsuranceTouristicHelper.getVendorFops((InsuranceTouristic)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.vendorPaymentTypes.add(enumName);
            }
            for (GeneralProductFop fop : InsuranceTouristicHelper.getClientFops((InsuranceTouristic)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.clientPaymentTypes.add(enumName);
            }
            this.payers.addAll(PayersCollector.collect(ticket));
            this.costCodes.addAll(StatisticsHelper.getAllCostCodes((StatisticalData)ticket.getStatisticalData()));
            this.ticketType = ticket.getTicketType();
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)ticket));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor(ticket);
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public String getSalesPointUid() {
        return this.salesPointUid;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getPnr() {
        return this.pnr;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public Set<String> getVendorPaymentTypes() {
        return this.vendorPaymentTypes;
    }

    public Set<String> getClientPaymentTypes() {
        return this.clientPaymentTypes;
    }

    public RuleProxy<InsuranceTouristicPropertySet, ?> getProxy() {
        return this.proxy;
    }

    public double getPaymentSum() {
        return this.paymentSum;
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public List<CostCode> getCostCodes() {
        return this.costCodes;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }
}

