/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayersCollector {
    private static Logger log = LoggerFactory.getLogger(PayersCollector.class);

    public static <P extends BaseProduct> Collection<EntityReference<Organization>> collect(P baseProduct) {
        ProductHandler handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
        List relations = handler.getUnmodifiableContractRelations(baseProduct);
        Set<EntityReference<Organization>> payers = relations.stream().flatMap(gr -> gr.getFops().stream()).map(GeneralProductFop::getPayer).filter(Objects::nonNull).collect(Collectors.toSet());
        log.trace("Payers collected " + payers.stream().map(EntityReference::getUid).collect(Collectors.joining(",", "[", "]")));
        return payers;
    }
}

