/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeCalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RefexType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.pg.SplitPaymentRegistry;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.pg.UpdateProductFopsHandler;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.rate.RateHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.interceptors.InterceptorsHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.handlers.AirRulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.BaseCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSetCustomizer;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSetInterceptor;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.VoidProductVirtualizationHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductCommissionActionSet
extends BaseCommissionActionSet {
    private static volatile ProductCommissionActionSetCustomizer customizer;
    private static final List<CalculationBasis> withFareBasis;
    private static final List<CalculationBasis> withPenaltyBasis;
    private static final List<CalculationBasis> withTaxesBasis;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = -4324135463890029895L;
    private final Product product;
    private boolean autoGetCouponStatusEnabled;
    private boolean autoCreateCertificateOfCompletedFlight;
    private EntityReference<?> gdsAccount;
    protected double[] vatRates;
    protected double[] previousVatRates;

    public ProductCommissionActionSet(RuleProxy<?, ?> px, ProductPropertySet propSet) {
        super(px, propSet);
        this.product = propSet.getProduct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean accept(FeeProperties feeProp) {
        RuleLogTracer tracer = this.getProxy().getTracer();
        tracer.traceEnteringMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        if (!feeProp.getRouteTypes().isEmpty()) {
            if (this.getPropertySet().isOneWayTicket() && !feeProp.getRouteTypes().contains(RouteType.ONE_WAY)) {
                tracer.traceLogic("ticket is a one way ticket, but route types does not contain ONE_WAY, returning false");
                return false;
            }
            if (!this.getPropertySet().isOneWayTicket() && !feeProp.getRouteTypes().contains(RouteType.ROUND_TRIP)) {
                tracer.traceLogic("ticket is a round trip ticket, but route types does not contain ROUND_TRIP, returning false");
                return false;
            }
        }
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        ProductStatus productStatus = actionProxy.getStatus(this.product);
        try {
            ProductType productType = AirProductHelper.getProductType((Product)this.product);
            tracer.traceLogic(String.format("product.productCategory = %s, product.mcoCategory = %s, productType = %sfee.productCategories = %s ", this.product.getProductCategory(), this.product.getMcoCategory(), productType, Arrays.toString(feeProp.getProductTypes().toArray())));
            if (productType != null) {
                if (!feeProp.getProductTypes().isEmpty() && !feeProp.getProductTypes().contains(productType)) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!feeProp.getProductTypes().isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (productStatus == null) {
                boolean res = feeProp.getOperation() == null;
                tracer.traceLogic("product status is null, returning " + res);
                boolean bl = res;
                return bl;
            }
            tracer.traceLogic("product status is " + productStatus);
            tracer.traceLogic("feeProperties.operation == " + feeProp.getOperation());
            switch (productStatus) {
                case BOOKING: {
                    if (feeProp.getOperation() != Operation.SELL) break;
                    tracer.traceLogic("product status is " + productStatus + ", fee.operation == SELL, returning true");
                    boolean bl = true;
                    return bl;
                }
                case SELL: {
                    if (feeProp.getOperation() == Operation.SELL) {
                        tracer.traceLogic("product status is SELL, fee.operation == SELL, returning true");
                        boolean bl = true;
                        return bl;
                    }
                    if (feeProp.getOperation() != Operation.EXCHANGE || this.product.getPreviousProduct() == null || actionProxy.getStatus(this.product.getPreviousProduct()) != ProductStatus.EXCHANGE) break;
                    tracer.traceLogic("product status is SELL, exchanged product is present, returning true");
                    boolean bl = true;
                    return bl;
                }
                case REFUND: {
                    if (feeProp.getOperation() != Operation.REFUND) break;
                    tracer.traceLogic("product status is REFUND, fee.operation == REFUND, returning true");
                    boolean bl = true;
                    return bl;
                }
                case EXCHANGE: {
                    break;
                }
                case VOID: {
                    if (feeProp.getOperation() != Operation.VOID) break;
                    tracer.traceLogic("product status is " + productStatus + ", fee.operation == VOID, returning true");
                    boolean bl = true;
                    return bl;
                }
                case VOID_BOOKING: {
                    if (feeProp.getOperation() != Operation.VOID_BOOKING) break;
                    tracer.traceLogic("product status is " + productStatus + ", fee.operation == CANCEL, returning true");
                    boolean bl = true;
                    return bl;
                }
                default: {
                    throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
                }
            }
            tracer.traceLogic("returning false");
            boolean bl = false;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean accept(PaymentFeeProperties feeProp) {
        RuleLogTracer tracer = this.getProxy().getTracer();
        tracer.traceEnteringMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        try {
            tracer.traceLogic("product status is " + productStatus);
            if (productStatus == null) {
                boolean bl = false;
                return bl;
            }
            switch (productStatus) {
                case REFUND: {
                    tracer.traceLogic("product is REFUND, fee.chargeOnRefund = " + feeProp.isChargeOnRefund() + " returning " + feeProp.isChargeOnRefund());
                    boolean bl = feeProp.isChargeOnRefund();
                    return bl;
                }
                case BOOKING: 
                case SELL: {
                    tracer.traceLogic("product is simple BOOKING or SELL, returning true");
                    boolean bl = true;
                    return bl;
                }
                case EXCHANGE: 
                case VOID: 
                case VOID_BOOKING: {
                    break;
                }
                default: {
                    throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
                }
            }
            tracer.traceLogic("returning false");
            boolean bl = false;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    public boolean hasRefundCommissions() {
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        for (RuleResultValue rr : this.getResults().values()) {
            EntityContainer commissionCtr = EntityStorage.get().resolve(rr.getTarget());
            if (null == commissionCtr) continue;
            BaseCommissionProperties commissionProperties = (BaseCommissionProperties)commissionCtr.getEntity();
            if (commissionProperties instanceof FeeProperties) {
                FeeProperties feeProperties = (FeeProperties)commissionProperties;
                if (ProductStatus.REFUND == productStatus && feeProperties.getOperation() == Operation.REFUND) {
                    return true;
                }
                if (ProductStatus.EXCHANGE == productStatus && feeProperties.getOperation() == Operation.EXCHANGE) {
                    return true;
                }
            }
            if (commissionProperties instanceof CommissionProperties) {
                CommissionProperties commProperties = (CommissionProperties)commissionProperties;
                if (ProductStatus.REFUND == productStatus && commProperties.getOperation() == Operation.REFUND) {
                    return true;
                }
                if (ProductStatus.EXCHANGE == productStatus && commProperties.getOperation() == Operation.EXCHANGE) {
                    return true;
                }
            }
            if (!(commissionProperties instanceof DiscountProperties)) continue;
            DiscountProperties discProperties = (DiscountProperties)commissionProperties;
            if (ProductStatus.REFUND == productStatus && discProperties.getOperation() == Operation.REFUND) {
                return true;
            }
            if (ProductStatus.EXCHANGE != productStatus || discProperties.getOperation() != Operation.EXCHANGE) continue;
            return true;
        }
        return false;
    }

    public List<Commission> createCommissions(AirProductContractRelationData contractRelation, boolean separateSupplierFees, ExchangeRateData rateData, List<AirProductContractRelationData> allContractRelations, Collection<ValidationMessage> messages) throws Exception {
        return this.createCommissions(contractRelation, true, separateSupplierFees, rateData, allContractRelations, messages);
    }

    public List<Commission> createCommissions(AirProductContractRelationData contractRelation, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData, List<AirProductContractRelationData> allContractRelations, Collection<ValidationMessage> messages) throws Exception {
        String currencyCode = contractRelation.getGeneralData().getCurrency() == null ? DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB") : contractRelation.getGeneralData().getCurrency().getCode();
        this.contractRelationDescription = contractRelation.getDescription();
        this.equiveCurrencyCode = currencyCode;
        this.vatRates = this.getVatRatesFromContract(contractRelation, this.product);
        int idx = allContractRelations.indexOf(contractRelation);
        if (idx > 0) {
            this.previousVatRates = this.getVatRatesFromContract(allContractRelations.get(idx - 1), this.product);
        }
        ArrayList<Commission> commissions = new ArrayList<Commission>();
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        if (ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus) {
            this.updateRefundedCommissions(this.product, commissions, contractRelation, messages);
        }
        List<Commission> additionalCommissions = this.transferParentCommissions(contractRelation, rateData, allContractRelations, translateSupplierFees);
        commissions.addAll(additionalCommissions);
        ArrayList<Commission> newCommissions = Collections.EMPTY_LIST;
        if (!VoidProductVirtualizationHelper.isFakeRefund(this.product)) {
            newCommissions = new ArrayList<Commission>(super.createCommissions((EntityReference<ContractRelationDescription>)contractRelation.getDescription(), currencyCode, BaseCommissionActionSet.getHiddenFees(commissions), messages));
        }
        if (ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus) {
            List<Commission> commissionsForRefund = this.getCommissionsForRefund((Collection<Commission>)newCommissions);
            Iterator iterator = newCommissions.iterator();
            while (iterator.hasNext()) {
                PaymentFeeProperties feeProp;
                EntityContainer ctr;
                Commission commission = (Commission)iterator.next();
                if (commissionsForRefund.contains(commission) || ProductStatus.REFUND == productStatus && (ctr = EntityStorage.get().resolve(commission.getCommissionProperties())).getEntity() instanceof PaymentFeeProperties && (feeProp = (PaymentFeeProperties)ctr.getEntity()).isChargeOnRefund()) continue;
                iterator.remove();
            }
        }
        ArrayList<Commission> tempList = new ArrayList<Commission>(commissions);
        commissions.clear();
        commissions.addAll(newCommissions);
        commissions.addAll(tempList);
        ArrayList<Commission> paymentFees = new ArrayList<Commission>();
        Iterator it = commissions.iterator();
        while (it.hasNext()) {
            Commission comm = (Commission)it.next();
            if (comm.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
            paymentFees.add(comm);
            it.remove();
        }
        ArrayList<Commission> result = new ArrayList<Commission>();
        Iterator it2 = commissions.iterator();
        while (it2.hasNext()) {
            Commission comm = (Commission)it2.next();
            if (comm.getEquivalentAmount() == null) {
                this.getProxy().getTracer().traceWarn(String.format("commission %s has null equivalent amount", comm.getCommissionProperties()), null);
                it2.remove();
                continue;
            }
            contractRelation.getCommissions().add(comm);
            result.add(comm);
        }
        this.updateFops(contractRelation, additionalCommissions, separateSupplierFees, allContractRelations);
        result.addAll(this.getPaymentFees(paymentFees, contractRelation, allContractRelations, messages));
        for (ValidationMessage message : messages) {
            boolean found = false;
            for (ValidationMessage vm : this.product.getValidationMessages()) {
                if (vm.getSeverity() != message.getSeverity() || !message.getMessage().equals((Object)vm.getMessage())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.product.getValidationMessages().add(message);
        }
        this.cleanupExchangeCommissions(this.product, contractRelation, result);
        if (Boolean.FALSE.equals(this.getProdUid2IncludeBonus().get(this.getProdUid()))) {
            this.handleAgencyBonus(contractRelation, result);
        }
        return result;
    }

    private List<Commission> transferParentCommissions(AirProductContractRelationData contractRelation, ExchangeRateData rateData, List<AirProductContractRelationData> allContractRelations, boolean translateSupplierFees) throws Exception {
        ArrayList<Commission> additionalCommissions = new ArrayList<Commission>();
        int idx = allContractRelations.indexOf(contractRelation);
        if (idx > 0) {
            ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
            for (AirProductContractRelationData previousRelation : this.getPreviousRelations(allContractRelations, contractRelation)) {
                for (Commission comm : previousRelation.getCommissions()) {
                    BigDecimal equivalentAmount;
                    FeeProperties feeProperties;
                    EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                    if (ctr == null || !(ctr.getEntity() instanceof FeeProperties) || !(feeProperties = (FeeProperties)ctr.getEntity()).isHidden() && (!feeProperties.isTechFee() || Boolean.FALSE.equals(this.getProdUid2TransferTechFee().get(this.getProdUid()))) && (!feeProperties.isChargeToClientForAllContractTypes() || !translateSupplierFees) || (ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus) && feeProperties.getOperation() == Operation.SELL) continue;
                    SegmentTariff st = comm.getSegmentTariff();
                    comm.setSegmentTariff(null);
                    Commission addComm = (Commission)XCloneHelper.clone((XCloneable)comm, (boolean)true);
                    addComm.setTransferred(true);
                    comm.setSegmentTariff(st);
                    addComm.setSegmentTariff(st);
                    addComm.setContractType(GeneralProductHelper.getContractType((EntityReference)this.contractRelationDescription));
                    if (feeProperties.isRecalculateVatForAllContractTypes() && (equivalentAmount = addComm.getRuleValue()) != null) {
                        if (!feeProperties.isVatNotIncluded() && addComm.getVatRate() != null) {
                            VatAmount vatAmount = VatAmount.of((BigDecimal)equivalentAmount, (double)addComm.getVatRate());
                            equivalentAmount = MiscUtil.sub((BigDecimal)equivalentAmount, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
                        }
                        Double vatRate = GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                        addComm.setVatRate(vatRate);
                        if (vatRate != null) {
                            equivalentAmount = equivalentAmount.add(equivalentAmount.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                        }
                        equivalentAmount = RulesHelper.roundDouble((BigDecimal)equivalentAmount, (RoundingMode)addComm.getRoundingMode(), (RoundingValue)addComm.getRoundingValue());
                        if (productStatus == ProductStatus.REFUND && feeProperties.getOperation() == Operation.REFUND) {
                            equivalentAmount = equivalentAmount.negate();
                        }
                        addComm.setEquivalentAmount(equivalentAmount);
                        addComm.setContractEquivalentAmount(equivalentAmount);
                        if (addComm.getAmount() != null) {
                            addComm.getAmount().setValue(equivalentAmount);
                        }
                    }
                    if (rateData != null) {
                        Money amount = new Money();
                        amount.setCurrency(previousRelation.getGeneralData().getCurrency().getCode());
                        amount.setValue(addComm.getEquivalentAmount());
                        addComm.setAmount(amount);
                        addComm.setRate(null);
                        addComm.setEquivalentAmount(RulesHelper.convert((BigDecimal)addComm.getEquivalentAmount(), (ExchangeRateData)rateData));
                        addComm.setContractEquivalentAmount(addComm.getEquivalentAmount());
                    }
                    additionalCommissions.add(addComm);
                }
            }
        }
        return additionalCommissions;
    }

    private void handleAgencyBonus(AirProductContractRelationData technicalFeeRelation, List<Commission> commissions) {
        List agencyBonuses = commissions.stream().filter(this::isCommission).collect(Collectors.toList());
        for (Commission agencyBonus : agencyBonuses) {
            String currencyCode = Optional.ofNullable(agencyBonus.getAmount()).map(Money::getCurrency).orElse(null);
            List<Commission> technicalFees = commissions.stream().filter(this::isTechnicalFee).filter(item -> MiscUtil.equals(Optional.ofNullable(item.getAmount()).map(Money::getCurrency).orElse(null), (Object)currencyCode)).collect(Collectors.toList());
            if (technicalFees.isEmpty()) continue;
            technicalFees.forEach(fee -> {
                fee.getAmount().setValue(fee.getAmount().getValue().subtract(agencyBonus.getAmount().getValue()));
                fee.setEquivalentAmount(fee.getEquivalentAmount().subtract(agencyBonus.getEquivalentAmount()));
                fee.setContractEquivalentAmount(fee.getContractEquivalentAmount().subtract(agencyBonus.getContractEquivalentAmount()));
            });
            commissions.remove(agencyBonus);
            technicalFeeRelation.getFops().stream().filter(fop -> fop.getCommissions().stream().anyMatch(this::isTechnicalFee)).filter(fop -> fop.getCommissions().stream().anyMatch(commission -> MiscUtil.equals(Optional.ofNullable(commission.getAmount()).map(Money::getCurrency).orElse(null), (Object)currencyCode))).forEach(fop -> fop.getAmount().setValue(fop.getAmount().getValue().subtract(agencyBonus.getEquivalentAmount())));
        }
    }

    private void cleanupExchangeCommissions(Product prod, AirProductContractRelationData contractRelation, List<Commission> result) throws Exception {
        BigDecimal ef2;
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        if (actionProxy.getStatus(prod) != ProductStatus.SELL || prod.getPreviousProduct() == null || actionProxy.getStatus(prod.getPreviousProduct()) != ProductStatus.EXCHANGE) {
            return;
        }
        BigDecimal ef = AirProductHelper.getEquivalentFare((Product)prod);
        if (ef == null) {
            ef = BigDecimal.ZERO;
        }
        if ((ef2 = AirProductHelper.getEquivalentFare((Product)prod.getPreviousProduct())) == null) {
            ef2 = BigDecimal.ZERO;
        }
        if (ef.compareTo(ef2) <= 0) {
            return;
        }
        Iterator it = contractRelation.getCommissions().iterator();
        while (it.hasNext()) {
            CommissionProperties cp;
            Commission comm = (Commission)it.next();
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null || !(ctr.getEntity() instanceof CommissionProperties) || !(cp = (CommissionProperties)ctr.getEntity()).isIgnoreFareDifferenceForExchange()) continue;
            it.remove();
            result.remove(comm);
        }
        AirProductContractRelationData relatedCR = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)this.product.getPreviousProduct()), (EntityReference)contractRelation.getDescription());
        if (relatedCR != null) {
            for (Commission comm : relatedCR.getCommissions()) {
                CommissionProperties cp;
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null || !(ctr.getEntity() instanceof CommissionProperties) || !(cp = (CommissionProperties)ctr.getEntity()).isIgnoreFareDifferenceForExchange()) continue;
                Commission comm2 = this.cloneCommission(comm, false);
                contractRelation.getCommissions().add(comm2);
                result.add(comm2);
            }
        }
    }

    private void updateFops(AirProductContractRelationData contractRelation, List<Commission> additionalCommissions, boolean separateSupplierFees, List<AirProductContractRelationData> allContractRelations) throws Exception {
        FopData supplierFopData;
        FopData fopData;
        BigDecimal totalFees = BigDecimal.ZERO;
        BigDecimal totalTranslatedFees = BigDecimal.ZERO;
        BigDecimal totalFeesForRefund = BigDecimal.ZERO;
        ArrayList<Commission> fees = new ArrayList<Commission>();
        ArrayList<Commission> translatedFees = new ArrayList<Commission>();
        ArrayList<Commission> feesForRefund = new ArrayList<Commission>();
        ArrayList<Commission> hiddenFees = new ArrayList<Commission>();
        for (Commission comm : contractRelation.getCommissions()) {
            if (comm.getCommissionProperties() == null || !FeeProperties.class.getName().equals(comm.getCommissionProperties().getType().getName()) || comm.getEquivalentAmount() == null) continue;
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr != null && ((FeeProperties)ctr.getEntity()).isHidden()) {
                hiddenFees.add(comm);
                continue;
            }
            if (ctr == null || ((FeeProperties)ctr.getEntity()).getOperation() == Operation.SELL) {
                if (separateSupplierFees && additionalCommissions.contains(comm)) {
                    totalTranslatedFees = totalTranslatedFees.add(comm.getEquivalentAmount());
                    translatedFees.add(comm);
                    continue;
                }
                totalFees = totalFees.add(comm.getEquivalentAmount());
                fees.add(comm);
                continue;
            }
            totalFeesForRefund = totalFeesForRefund.add(comm.getEquivalentAmount());
            feesForRefund.add(comm);
        }
        BigDecimal totalDiscount = BigDecimal.ZERO;
        ArrayList<Commission> discounts = new ArrayList<Commission>();
        for (Commission comm : contractRelation.getCommissions()) {
            if (comm.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)comm.getCommissionProperties().getType()) || comm.getEquivalentAmount() == null) continue;
            totalDiscount = totalDiscount.add(comm.getEquivalentAmount());
            discounts.add(comm);
        }
        if (!separateSupplierFees) {
            supplierFopData = fopData = this.getFopData(null, contractRelation, null);
        } else {
            int idx = allContractRelations.indexOf(contractRelation);
            if (idx == 0) {
                supplierFopData = fopData = this.getFopData(null, contractRelation, null);
            } else {
                AirProductContractRelationData previousRelation = allContractRelations.get(idx - 1);
                fopData = this.getFopData(false, contractRelation, previousRelation);
                supplierFopData = this.getFopData(true, contractRelation, previousRelation);
                if (null == fopData && null == supplierFopData) {
                    supplierFopData = fopData = this.getFopData(null, contractRelation, previousRelation);
                } else if (null == fopData) {
                    fopData = supplierFopData;
                } else if (null == supplierFopData) {
                    supplierFopData = fopData;
                }
            }
            if (fopData.getCard() == supplierFopData.getCard() && !translatedFees.isEmpty()) {
                supplierFopData.setCard((Card)XCloneHelper.clone((XCloneable)supplierFopData.getCard(), (boolean)true));
            }
        }
        List fops = contractRelation.getFops();
        ProductFop pfForHidden = null;
        Iterator it = fops.iterator();
        while (it.hasNext()) {
            ProductFop pf = (ProductFop)it.next();
            boolean removed = false;
            for (Commission comm : pf.getCommissions()) {
                if (comm.getCommissionProperties() != null && FeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) {
                    FeeProperties feeProp;
                    EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                    if (ctr != null && (feeProp = (FeeProperties)ctr.getEntity()).isHidden()) {
                        BigDecimal fopAmount = pf.getAmount().getValue();
                        fopAmount = fopAmount.subtract(comm.getEquivalentAmount());
                        pf.getAmount().setValue(fopAmount);
                        pfForHidden = pf;
                        continue;
                    }
                    it.remove();
                    removed = true;
                    break;
                }
                if (comm.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
                it.remove();
                removed = true;
                break;
            }
            if (pfForHidden != null || pf.getType() == PaymentType.TICKET || removed) continue;
            pfForHidden = pf;
        }
        if (pfForHidden != null) {
            pfForHidden.getCommissions().clear();
        }
        Date operationDate = fopData.getOperationDate();
        PaymentType paymentType = fopData.getPaymentType();
        EntityReference<Person> agent = fopData.getAgent();
        Card card = fopData.getCard();
        EntityReference<Organization> payer = fopData.getPayer();
        if (!translatedFees.isEmpty()) {
            this.addFops(fops, totalTranslatedFees, translatedFees, supplierFopData.getPaymentType(), supplierFopData.getOperationDate(), supplierFopData.getCard(), supplierFopData.getAgent(), supplierFopData.getPayer());
        }
        this.addFops(fops, totalFees, fees, paymentType, operationDate, card, agent, payer);
        this.addFops(fops, totalFeesForRefund, feesForRefund, paymentType, operationDate, card, agent, payer);
        this.addFops(fops, totalDiscount.negate(), discounts, paymentType, operationDate, card, agent, payer);
        this.addHiddenCommissionsToFop(pfForHidden, hiddenFees);
        this.customUpdateProductFops(fops, contractRelation);
    }

    private FopData getFopData(Boolean supplierFees, AirProductContractRelationData contractRelation, AirProductContractRelationData previousRelation) {
        ValueHolder ptHolder = new ValueHolder();
        ValueHolder feePtHolder = new ValueHolder();
        ValueHolder opDateHolder = new ValueHolder();
        ValueHolder agentHolder = new ValueHolder();
        ValueHolder payerHolder = new ValueHolder();
        ValueHolder cardHolder = new ValueHolder();
        if (!this.initializeFopParameters(GeneralProductHelper.getContractType((EntityReference)this.contractRelationDescription) == ContractType.CLIENT, contractRelation.getFops(), (ValueHolder<PaymentType>)ptHolder, (ValueHolder<PaymentType>)feePtHolder, (ValueHolder<Date>)opDateHolder, (ValueHolder<EntityReference<Person>>)agentHolder, (ValueHolder<Card>)cardHolder, (ValueHolder<EntityReference<Organization>>)payerHolder, FeeProperties.class, supplierFees, previousRelation != null ? previousRelation.getCommissions() : null) && supplierFees != null) {
            return null;
        }
        PaymentType paymentType = (PaymentType)feePtHolder.getValue();
        if (paymentType == null && customizer != null && (paymentType = customizer.getDefaultFeePaymentType(this.product, this.getProxy(), (EntityReference<ContractRelationDescription>)this.contractRelationDescription, (PaymentType)ptHolder.getValue())) != null && cardHolder.getValue() != null) {
            ((Card)cardHolder.getValue()).setSecurityCode(null);
        }
        if (paymentType == null) {
            paymentType = (PaymentType)ptHolder.getValue();
            if (paymentType == PaymentType.CREDIT_CARD) {
                paymentType = PaymentType.CREDIT_CARD_AGENCY;
                if (cardHolder.getValue() != null) {
                    ((Card)cardHolder.getValue()).setSecurityCode(null);
                }
            } else if (paymentType == PaymentType.MTD || paymentType == null) {
                paymentType = PaymentType.CASH;
            }
        }
        Date operationDate = (Date)opDateHolder.getValue();
        EntityReference agent = (EntityReference)agentHolder.getValue();
        Card card = (Card)cardHolder.getValue();
        EntityReference payer = (EntityReference)payerHolder.getValue();
        return new FopData(operationDate, paymentType, (EntityReference<Person>)agent, card, (EntityReference<Organization>)payer);
    }

    private void addHiddenCommissionsToFop(ProductFop fop, List<Commission> hiddenCommissions) {
        if (fop == null || hiddenCommissions.isEmpty()) {
            return;
        }
        BigDecimal value = fop.getAmount().getValue();
        for (Commission comm : hiddenCommissions) {
            value = value.add(comm.getEquivalentAmount());
        }
        fop.getAmount().setValue(value);
        fop.getCommissions().addAll(hiddenCommissions);
    }

    private void addFops(List<ProductFop> fops, BigDecimal totalCommission, List<Commission> commissions, PaymentType paymentType, Date operationDate, Card card, EntityReference<Person> agent, EntityReference<Organization> payer) {
        if (Math.abs(totalCommission.doubleValue()) <= 0.0) {
            return;
        }
        ProductFop fop = new ProductFop();
        fop.setType(paymentType);
        if (card != null) {
            fop.setCard(card);
        }
        fop.setOperationDate(operationDate);
        fop.setAgent(agent);
        fop.setAmount(SystemHelper.getMoney((double)totalCommission.doubleValue(), (String)this.getEquivalentCurrencyCode()));
        fop.setPayer(payer);
        fop.getCommissions().addAll(commissions);
        fops.add(fop);
    }

    private SplitPaymentSupport isSplitOrSupplierPaymentType(PaymentType paymentType) {
        SplitPaymentSupport splitOrSupplierPaymentType = null;
        if (Environment.isPublished(SplitPaymentRegistry.class)) {
            SplitPaymentRegistry splitPaymentRegistry = (SplitPaymentRegistry)Environment.getPublished(SplitPaymentRegistry.class);
            splitOrSupplierPaymentType = splitPaymentRegistry.isSplitOrSupplierPaymentType(paymentType);
        }
        return splitOrSupplierPaymentType;
    }

    private void customUpdateProductFops(List<ProductFop> fops, AirProductContractRelationData contractRelation) {
        if (Environment.isPublished(UpdateProductFopsHandler.class)) {
            UpdateProductFopsHandler registry = (UpdateProductFopsHandler)Environment.getPublished(UpdateProductFopsHandler.class);
            registry.updateProductFops(fops, this.product, contractRelation);
        }
    }

    private boolean initializeFopParameters(boolean createPaymentDate, List<ProductFop> fops, ValueHolder<PaymentType> ptHolder, ValueHolder<PaymentType> feePtHolder, ValueHolder<Date> opDateHolder, ValueHolder<EntityReference<Person>> agentHolder, ValueHolder<Card> cardHolder, ValueHolder<EntityReference<Organization>> payerHolder, Class<?> cls, Boolean supplierFees, List<Commission> prevCommissions) {
        for (ProductFop pf : fops) {
            for (Commission comm : pf.getCommissions()) {
                FopPaymentInfo fopPaymentInfo;
                if (comm.getCommissionProperties() == null || !cls.equals(comm.getCommissionProperties().getType()) || supplierFees != null && prevCommissions != null && supplierFees != AirProductHelper.isSupplierFee((Commission)comm, prevCommissions)) continue;
                SplitPaymentSupport splitOrSupplierPaymentType = this.isSplitOrSupplierPaymentType(pf.getType());
                if (splitOrSupplierPaymentType != null) {
                    feePtHolder.setValue((Object)splitOrSupplierPaymentType.getSplitAgencyPaymentType());
                } else {
                    feePtHolder.setValue((Object)pf.getType());
                }
                payerHolder.setValue((Object)pf.getPayer());
                FopPaymentInfo fopPaymentInfo2 = fopPaymentInfo = createPaymentDate ? ProfileHelper.getFopPaymentInfo((EntityReference)this.product.getSalesPoint(), (PaymentType)pf.getType()) : null;
                if (fopPaymentInfo == null || fopPaymentInfo.isCreatePaymentDate()) {
                    opDateHolder.setValue((Object)pf.getOperationDate());
                    agentHolder.setValue((Object)pf.getAgent());
                } else {
                    opDateHolder.setValue(null);
                    agentHolder.setValue(null);
                }
                cardHolder.setValue((Object)pf.getCard());
                return true;
            }
        }
        ProductFop productFop = null;
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        if (ProductStatus.SELL == actionProxy.getStatus(this.product) && this.product.getPreviousProduct() != null && actionProxy.getStatus(this.product.getPreviousProduct()) == ProductStatus.EXCHANGE) {
            for (ProductFop fop : fops) {
                if (fop.getType() == PaymentType.TICKET && this.product.getPreviousProduct().getTicketType() != TicketType.NOT_OWN) continue;
                productFop = fop;
                break;
            }
        } else {
            ProductFop productFop2 = productFop = fops.isEmpty() ? null : fops.get(0);
        }
        if (productFop != null) {
            FopPaymentInfo fopPaymentInfo;
            SplitPaymentSupport splitOrSupplierPaymentType = this.isSplitOrSupplierPaymentType(productFop.getType());
            if (splitOrSupplierPaymentType != null) {
                feePtHolder.setValue((Object)splitOrSupplierPaymentType.getSplitAgencyPaymentType());
            } else if (productFop.getType() != PaymentType.TICKET) {
                ptHolder.setValue((Object)productFop.getType());
            }
            payerHolder.setValue((Object)productFop.getPayer());
            FopPaymentInfo fopPaymentInfo3 = fopPaymentInfo = createPaymentDate ? ProfileHelper.getFopPaymentInfo((EntityReference)this.product.getSalesPoint(), (PaymentType)productFop.getType()) : null;
            if (fopPaymentInfo == null || fopPaymentInfo.isCreatePaymentDate()) {
                opDateHolder.setValue((Object)productFop.getOperationDate());
                agentHolder.setValue((Object)productFop.getAgent());
            } else {
                opDateHolder.setValue(null);
                agentHolder.setValue(null);
            }
            if (cardHolder.getValue() == null && productFop.getCard() != null) {
                try {
                    cardHolder.setValue((Object)XCloneHelper.clone((XCloneable)productFop.getCard(), (boolean)true));
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("unable to copy Card info", (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private List<Commission> getPaymentFees(List<Commission> paymentFees, AirProductContractRelationData contractRelation, List<AirProductContractRelationData> allContractRelations, Collection<ValidationMessage> messages) throws Exception {
        AirProductContractRelationData relation;
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)this.product);
        boolean hasPenalty = Optional.ofNullable(handler.getPenalty((BaseProduct)this.product)).map(val -> val.compareTo(BigDecimal.ZERO) > 0).orElse(false);
        hasPenalty |= handler.getRelatedProducts((BaseProduct)this.product).stream().filter(AirProductHelper::isEmdProduct).anyMatch(emdProd -> ((Product)emdProd).getMcoCategory() == MCOCategory.PENALTY);
        ArrayList<Commission> result = new ArrayList<Commission>();
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        if (actionProxy.getStatus(this.product) == ProductStatus.REFUND && this.product.getPreviousProduct() != null && actionProxy.getStatus(this.product.getPreviousProduct()) == ProductStatus.SELL && (relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)this.product.getPreviousProduct()), (EntityReference)this.contractRelationDescription)) != null) {
            for (Commission comm : relation.getCommissions()) {
                boolean isRetainedSellFee;
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null || !ctr.getEntityType().equals(PaymentFeeProperties.class)) continue;
                PaymentFeeProperties prop = (PaymentFeeProperties)ctr.getEntity();
                Set cases = prop.getReturnCases();
                boolean isRefund = !this.product.isForcedRefund() && cases.contains(ReturnCase.REFUND);
                boolean bl = this.product.isForcedRefund() && cases.contains(ReturnCase.FORCED_REFUND);
                boolean isNoPenaltiesRefund = !hasPenalty && cases.contains(ReturnCase.NO_PENALTIES_REFUND);
                boolean bl2 = isRetainedSellFee = VoidProductVirtualizationHelper.isFakeRefund(this.product) && !cases.contains(ReturnCase.VOID);
                if ((!isRefund && !bl && !isNoPenaltiesRefund || VoidProductVirtualizationHelper.isFakeRefund(this.product)) && !isRetainedSellFee) continue;
                Commission item = new Commission();
                SegmentTariff st = comm.getSegmentTariff();
                comm.setSegmentTariff(null);
                try {
                    XCloneModelHelper.copy((BaseEntity)comm, (BaseEntity)item, (boolean)true);
                }
                catch (Exception e) {
                    this.log.error("unable to copy segment tariff", (Throwable)e);
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_SEGMENT_FARE_COPY_FAILED));
                    continue;
                }
                comm.setSegmentTariff(st);
                if (item.getRate() != null) {
                    this.updatePaymentFeeAmount(item, contractRelation, messages, false);
                }
                if (item.getEquivalentAmount() == null) continue;
                contractRelation.getCommissions().add(item);
                result.add(item);
            }
        }
        ArrayList<Commission> additionalFees = new ArrayList<Commission>();
        int idx = allContractRelations.indexOf(contractRelation);
        if (idx > 0) {
            AirProductContractRelationData previousRelation = allContractRelations.get(idx - 1);
            for (Commission comm : previousRelation.getCommissions()) {
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null || !(ctr.getEntity() instanceof PaymentFeeProperties)) continue;
                SegmentTariff st = comm.getSegmentTariff();
                comm.setSegmentTariff(null);
                Commission commission = (Commission)XCloneHelper.clone((XCloneable)comm, (boolean)true);
                comm.setSegmentTariff(st);
                commission.setSegmentTariff(st);
                commission.setContractType(GeneralProductHelper.getContractType((EntityReference)this.contractRelationDescription));
                if (commission.getRate() == null) {
                    this.updateEquivalentAmount(commission, (BaseCommissionProperties)ctr.getEntity(), null, null, false, messages);
                }
                additionalFees.add(commission);
            }
            result.addAll(additionalFees);
        }
        HashMap<void, Commission> minCommissions = new HashMap<void, Commission>();
        HashMap<void, Commission> maxCommissions = new HashMap<void, Commission>();
        HashMap<void, Commission> standardCommissions = new HashMap<void, Commission>();
        block12: for (Commission value : paymentFees) {
            void var16_24;
            String string = "";
            PaymentFeeType type = PaymentFeeType.STANDARD;
            EntityContainer bp = null;
            try {
                bp = EntityStorage.get().resolve(value.getCommissionProperties());
            }
            catch (Exception e) {
                this.log.error("unable to resolve commission " + value.getCommissionProperties(), (Throwable)e);
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_ERROR_LOADING_COMMISSION, (Object[])new Object[]{value.getCommissionProperties()}));
            }
            if (bp != null) {
                PaymentFeeProperties pfp = (PaymentFeeProperties)bp.getEntity();
                if (pfp.getPaymentType() != null) {
                    String string2 = pfp.getPaymentType().name();
                }
                if (pfp.getType() != null) {
                    type = pfp.getType();
                }
            }
            this.updatePaymentFeeAmount(value, contractRelation, messages, true);
            if (type != PaymentFeeType.MAXIMUM && value.getEquivalentAmount() == null) continue;
            if (value.getEquivalentAmount() == null) {
                value.setEquivalentAmount(BigDecimal.ZERO);
            }
            switch (type) {
                case MINIMUM: {
                    minCommissions.put(var16_24, value);
                    continue block12;
                }
                case MAXIMUM: {
                    maxCommissions.put(var16_24, value);
                    continue block12;
                }
            }
            standardCommissions.put(var16_24, value);
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Map.Entry entry : new HashMap(standardCommissions).entrySet()) {
            Commission minCom;
            Commission commission = (Commission)entry.getValue();
            Commission max = (Commission)maxCommissions.get(entry.getKey());
            if (max != null && Math.abs(commission.getEquivalentAmount().doubleValue()) - Math.abs(max.getEquivalentAmount().doubleValue()) > 0.001) {
                commission = max;
            }
            if ((minCom = (Commission)minCommissions.get(entry.getKey())) != null) {
                minCommissions.remove(entry.getKey());
                if (Math.abs(minCom.getEquivalentAmount().doubleValue()) - Math.abs(commission.getEquivalentAmount().doubleValue()) > 0.001) {
                    commission = minCom;
                }
            }
            resultList.add(commission);
        }
        resultList.addAll(minCommissions.values());
        contractRelation.getCommissions().addAll(additionalFees);
        result.addAll(additionalFees);
        for (Commission commission : resultList) {
            if (commission.getEquivalentAmount() == null) continue;
            contractRelation.getCommissions().add(commission);
            result.add(commission);
        }
        HashMap<PaymentType, Set> map = new HashMap<PaymentType, Set>();
        for (Commission comm : result) {
            try {
                PaymentFeeProperties prop = (PaymentFeeProperties)EntityStorage.get().resolve(comm.getCommissionProperties()).getEntity();
                Set set = map.computeIfAbsent(prop.getPaymentType(), k -> new HashSet());
                set.add(comm);
            }
            catch (Exception e) {
                this.log.error("unable to resolve reference " + comm.getCommissionProperties(), (Throwable)e);
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_CANT_LOAD_COMMISSION_DESCRIPTION, (Object[])new Object[]{comm.getCommissionProperties()}));
            }
        }
        List list = contractRelation.getFops();
        ValueHolder ptHolder = new ValueHolder();
        ValueHolder feePtHolder = new ValueHolder();
        ValueHolder opDateHolder = new ValueHolder();
        ValueHolder agentHolder = new ValueHolder();
        ValueHolder payerHolder = new ValueHolder();
        ValueHolder cardHolder = new ValueHolder();
        this.initializeFopParameters(GeneralProductHelper.getContractType((EntityReference)this.contractRelationDescription) == ContractType.CLIENT, list, (ValueHolder<PaymentType>)ptHolder, (ValueHolder<PaymentType>)feePtHolder, (ValueHolder<Date>)opDateHolder, (ValueHolder<EntityReference<Person>>)agentHolder, (ValueHolder<Card>)cardHolder, (ValueHolder<EntityReference<Organization>>)payerHolder, PaymentFeeProperties.class, null, null);
        Iterator it = list.iterator();
        block16: while (it.hasNext()) {
            ProductFop pf = (ProductFop)it.next();
            for (Commission comm : pf.getCommissions()) {
                if (comm.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
                it.remove();
                continue block16;
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Set comms = (Set)entry.getValue();
            BigDecimal sum = BigDecimal.ZERO;
            for (Commission comm : comms) {
                sum = sum.add(comm.getEquivalentAmount());
            }
            if (Math.abs(sum.doubleValue()) < 0.001) continue;
            ProductFop fop = new ProductFop();
            fop.setType((PaymentType)entry.getKey());
            fop.setAmount(SystemHelper.getMoney((double)sum.doubleValue(), (String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
            fop.getCommissions().addAll(comms);
            fop.setOperationDate((Date)opDateHolder.getValue());
            fop.setAgent((EntityReference)agentHolder.getValue());
            fop.setPayer((EntityReference)payerHolder.getValue());
            fop.setCard((Card)cardHolder.getValue());
            list.add(fop);
        }
        return result;
    }

    public Product getProduct() {
        return this.product;
    }

    public void updatePaymentFeeAmount(Commission comm, AirProductContractRelationData contractRelation, Collection<ValidationMessage> messages, boolean negateOnRefund) {
        comm.setEquivalentAmount(null);
        EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
        if (ctr == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_LOADING_COMMISSION_PROPERTIES_FAILED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        PaymentFeeProperties prop = (PaymentFeeProperties)ctr.getEntity();
        if (prop.getPaymentType() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_COMMISSION_PAYMENT_TYPE_NOT_DEFINED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        if (comm.getRate() == null) {
            boolean found = false;
            block0: for (ProductFop pf : contractRelation.getFops()) {
                if (pf.getType() == PaymentType.TICKET) continue;
                for (Commission comm2 : pf.getCommissions()) {
                    if (comm2.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm2.getCommissionProperties().getType())) continue;
                    continue block0;
                }
                if (pf.getType() != prop.getPaymentType()) continue;
                found = true;
                break;
            }
            if (!found) {
                comm.setEquivalentAmount(null);
                return;
            }
            comm.setEquivalentAmount(this.calculateEquivalentAmount(comm.getAmount(), comm.getRoundingMode(), comm.getRoundingValue(), RulesHelper.isFeeForRefund((EntityReference)comm.getCommissionProperties()), messages));
            comm.setContractEquivalentAmount(comm.getEquivalentAmount());
            if (ProductStatus.REFUND == productStatus && negateOnRefund) {
                this.negate(comm);
            }
            return;
        }
        if (prop.getBasis() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_COMMISSION_BASIS_NOT_DEFINED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        BigDecimal basis = BigDecimal.ZERO;
        block2: for (ProductFop pf : contractRelation.getFops()) {
            if (pf.getType() == PaymentType.TICKET) continue;
            for (Commission comm2 : pf.getCommissions()) {
                if (comm2.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm2.getCommissionProperties().getType()) && (!FeeProperties.class.equals((Object)comm2.getCommissionProperties().getType()) || !PaymentFeeCalculationBasis.PRICE.equals((Object)prop.getBasis()))) continue;
                continue block2;
            }
            if (pf.getType() != prop.getPaymentType() || pf.getAmount() == null || pf.getAmount().getValue() == null || prop.getBasis() == PaymentFeeCalculationBasis.FEES && AirProductHelper.isServiceFop((ProductFop)pf)) continue;
            basis = basis.add(pf.getAmount().getValue());
        }
        for (Commission comm2 : contractRelation.getCommissions()) {
            BaseCommissionProperties ett;
            EntityContainer ctr2 = EntityStorage.get().resolve(comm2.getCommissionProperties());
            if (ctr2 == null || !((ett = (BaseCommissionProperties)ctr2.getEntity()) instanceof PaymentFeeProperties)) continue;
            PaymentFeeProperties pfp = (PaymentFeeProperties)ett;
            if (prop.getPaymentType() != pfp.getPaymentType() || comm2.getEquivalentAmount() == null) continue;
            basis = basis.add(comm2.getEquivalentAmount());
        }
        if (Math.abs(basis.doubleValue()) < 0.001) {
            return;
        }
        BigDecimal value = basis.multiply(BigDecimal.valueOf(comm.getRate())).divide(BigDecimal.valueOf(100L), 3, java.math.RoundingMode.HALF_UP);
        if (prop.getBasis() == PaymentFeeCalculationBasis.TRANSACTION) {
            value = value.divide(BigDecimal.valueOf(1.0 - comm.getRate() / 100.0), 3, java.math.RoundingMode.HALF_UP);
        }
        comm.setEquivalentAmount(this.calculateEquivalentAmount(SystemHelper.getMoney((double)value.doubleValue(), (String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")), comm.getRoundingMode(), comm.getRoundingValue(), RulesHelper.isFeeForRefund((EntityReference)comm.getCommissionProperties()), messages));
        comm.setContractEquivalentAmount(comm.getEquivalentAmount());
        if (ProductStatus.REFUND == productStatus && negateOnRefund) {
            this.negate(comm);
        }
    }

    private void negate(Commission comm) {
        if (comm.getRate() != null) {
            comm.setRate(Double.valueOf(-comm.getRate().doubleValue()));
        }
        if (comm.getAmount() != null && comm.getAmount().getValue() != null) {
            comm.getAmount().setValue(comm.getAmount().getValue().negate());
        }
        if (comm.getEquivalentAmount() != null) {
            comm.setEquivalentAmount(comm.getEquivalentAmount().negate());
            comm.setContractEquivalentAmount(comm.getEquivalentAmount());
        }
    }

    private BigDecimal calculateEquivalentAmount(Money amount, RoundingMode rm, RoundingValue rv, boolean feeForRefund, Collection<ValidationMessage> messages) {
        if (amount == null || amount.getCurrency() == null || amount.getValue() == null) {
            return null;
        }
        String eqvCode = this.getEquivalentCurrencyCode();
        BigDecimal value = amount.getValue();
        String currencyCode = amount.getCurrency();
        if (!currencyCode.equals(eqvCode)) {
            value = value.multiply(this.getCurrencyRate(currencyCode, feeForRefund, messages));
        }
        return RulesHelper.roundDouble((BigDecimal)value, (RoundingMode)rm, (RoundingValue)rv);
    }

    private void updateRefundedCommissions(Product product, Collection<Commission> commissions, AirProductContractRelationData contractRelation, Collection<ValidationMessage> messages) throws Exception {
        if (this.product.getPreviousProduct() == null) {
            this.log.error("related product is absent, skipping update of fees");
            return;
        }
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        if (actionProxy.getStatus(product) == ProductStatus.REFUND) {
            Iterator it = contractRelation.getCommissions().iterator();
            while (it.hasNext()) {
                CommissionProperties commProp;
                Commission comm = (Commission)it.next();
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (!ctr.getEntityType().equals(CommissionProperties.class) || !(commProp = (CommissionProperties)ctr.getEntity()).isDontReturn()) continue;
                it.remove();
            }
        }
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        boolean hasPenalty = Optional.ofNullable(handler.getPenalty((BaseProduct)product)).map(val -> val.compareTo(BigDecimal.ZERO) > 0).orElse(false);
        hasPenalty |= handler.getRelatedProducts((BaseProduct)product).stream().filter(AirProductHelper::isEmdProduct).anyMatch(emdProd -> ((Product)emdProd).getMcoCategory() == MCOCategory.PENALTY);
        Product relatedProduct = this.product.getPreviousProduct();
        ArrayList<Commission> refundedCommissions = new ArrayList<Commission>();
        EntityReference additionalFeeRef = new EntityReference("additional_fare_fee", FeeProperties.class, L10nResourcesManager.getStr((String)Messages.AirRulesHelper_extrasCollectionRate, (Object[])new Object[0]));
        boolean partialRefund = this.product.getSegmentTariffs().size() < this.product.getPreviousProduct().getSegmentTariffs().size();
        List<Commission> sellCommissions = this.getSellCommissions(this.product, messages);
        for (Commission comm : sellCommissions) {
            boolean isNoPenaltiesRefund;
            FeeProperties feeProperties;
            DiscountProperties commProp;
            if (additionalFeeRef.equals((Object)comm.getCommissionProperties()) || comm.getEquivalentAmount() == null || BigDecimal.ZERO.compareTo(comm.getEquivalentAmount()) == 0) continue;
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null) {
                if (VoidProductVirtualizationHelper.isFakeRefund(this.product)) continue;
                refundedCommissions.add(comm);
                continue;
            }
            if (VoidProductVirtualizationHelper.isFakeRefund(this.product) && !ctr.getEntityType().equals(FeeProperties.class)) continue;
            if (ctr.getEntityType().equals(DiscountProperties.class)) {
                commProp = (DiscountProperties)ctr.getEntity();
                if (commProp.getType() == DiscountType.MANUALLY_CALCULATED && this.containsCommissionCategory(contractRelation.getCommissions(), (EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties())) continue;
                refundedCommissions.add(comm);
                continue;
            }
            if (CommissionProperties.class.equals((Object)ctr.getEntityType())) {
                commProp = (CommissionProperties)ctr.getEntity();
                if (commProp.isManuallyCalculated() && this.containsCommissionCategory(contractRelation.getCommissions(), (EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties()) || commProp.isDontReturn() || actionProxy.getStatus(this.product) == ProductStatus.EXCHANGE) continue;
                refundedCommissions.add(comm);
                continue;
            }
            if (ctr.getEntityType().equals(PaymentFeeProperties.class) || (feeProperties = (FeeProperties)ctr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED && this.containsCommissionCategory(contractRelation.getCommissions(), (EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties())) continue;
            Set cases = feeProperties.getReturnCases();
            Set refexTypes = feeProperties.getRefexTypes();
            boolean bl = isNoPenaltiesRefund = !hasPenalty && cases.contains(ReturnCase.NO_PENALTIES_REFUND);
            if (VoidProductVirtualizationHelper.isFakeRefund(this.product)) {
                boolean isRetainedSellFee = !cases.contains(ReturnCase.VOID) && feeProperties.getOperation() == Operation.SELL;
                if (isRetainedSellFee) continue;
                refundedCommissions.add(comm);
                continue;
            }
            if (actionProxy.getStatus(this.product) == ProductStatus.REFUND && !isNoPenaltiesRefund && (this.product.isForcedRefund() && !cases.contains(ReturnCase.FORCED_REFUND) || !this.product.isForcedRefund() && !cases.contains(ReturnCase.REFUND) || partialRefund && !refexTypes.contains(RefexType.PARTIAL) || !partialRefund && !refexTypes.contains(RefexType.FULL)) || actionProxy.getStatus(this.product) == ProductStatus.EXCHANGE && (this.product.isForcedRefund() && !cases.contains(ReturnCase.FORCED_EXCHANGE) || !this.product.isForcedRefund() && !cases.contains(ReturnCase.EXCHANGE) || partialRefund && !refexTypes.contains(RefexType.PARTIAL) || !partialRefund && !refexTypes.contains(RefexType.FULL)) || (actionProxy.getStatus(this.product) == ProductStatus.REFUND || actionProxy.getStatus(this.product) == ProductStatus.EXCHANGE) && !this.checkRefundedCommission(comm)) continue;
            refundedCommissions.add(comm);
        }
        ArrayList<Commission> correctedRefundedCommissions = new ArrayList<Commission>();
        ArrayList<Commission> refundedHiddenFees = new ArrayList<Commission>();
        for (Commission comm : this.reorderCommissions(refundedCommissions)) {
            FeeProperties feeProp;
            BaseCommissionProperties prop;
            Commission item = this.cloneCommission(comm, partialRefund);
            if (item == null) continue;
            EntityContainer ctr = EntityStorage.get().resolve(item.getCommissionProperties());
            BaseCommissionProperties baseCommissionProperties = prop = ctr != null ? (BaseCommissionProperties)ctr.getEntity() : null;
            if (item.getRate() != null || item.getAmount() != null && item.getAmount().getValue() != null && item.getAmount().getCurrency() != null) {
                RuleResultValue res = new RuleResultValue();
                res.setTarget(item.getCommissionProperties());
                boolean calculateFromDifference = false;
                if (prop instanceof FeeProperties) {
                    FeeProperties fprop = (FeeProperties)prop;
                    calculateFromDifference = fprop.isCalculateFromDifference();
                }
                BigDecimal value2 = null;
                if (item.getRate() != null) {
                    res.setCurrencyCode("%");
                    res.setValue(item.getRate().doubleValue());
                } else {
                    res.setCurrencyCode(this.getEquivalentCurrencyCode());
                    BigDecimal value = item.getEquivalentAmount();
                    value2 = item.getAmount().getValue();
                    if (prop instanceof FeeProperties && ((FeeProperties)prop).isVatNotIncluded() && item.getVatRate() != null) {
                        VatAmount vatAmount = VatAmount.of((BigDecimal)value, (double)item.getVatRate());
                        value = MiscUtil.sub((BigDecimal)value, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
                        VatAmount vatAmount2 = VatAmount.of((BigDecimal)value2, (double)item.getVatRate());
                        value2 = MiscUtil.sub((BigDecimal)value2, (BigDecimal[])new BigDecimal[]{vatAmount2.getVatAmount()});
                    }
                    CalculationType calculationType = CalculationType.TICKET;
                    if (prop instanceof FeeProperties) {
                        calculationType = ((FeeProperties)prop).getCalculationType();
                    } else if (prop instanceof CommissionProperties) {
                        calculationType = ((CommissionProperties)prop).getCalculationType();
                    } else if (prop instanceof DiscountProperties) {
                        calculationType = ((DiscountProperties)prop).getCalculationType();
                    }
                    if (calculationType == null) {
                        calculationType = CalculationType.TICKET;
                    }
                    switch (calculationType) {
                        case SEGMENT: {
                            int n = 0;
                            for (SegmentTariff st2 : relatedProduct.getSegmentTariffs()) {
                                n += st2.getSegments().size();
                            }
                            if (n <= 0) break;
                            value = value.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            value2 = value2.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            break;
                        }
                        case SEGMENT_TARIFF: {
                            int n = relatedProduct.getSegmentTariffs().size();
                            if (n <= 0) break;
                            value = value.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            value2 = value2.divide(BigDecimal.valueOf(n), 2, java.math.RoundingMode.HALF_UP);
                            break;
                        }
                    }
                    res.setValue(value.doubleValue());
                }
                CalculationBasis basis = CalculationBasis.FARE;
                if (prop instanceof FeeProperties) {
                    basis = ((FeeProperties)prop).getCalculationBasis();
                }
                if (prop instanceof DiscountProperties) {
                    basis = ((DiscountProperties)prop).getCalculationBasis();
                }
                this.updateCommissionAmount(item, res, refundedHiddenFees, messages);
                this.updateEquivalentAmount(item, prop, basis, refundedHiddenFees, calculateFromDifference, messages);
                if (item.getRate() == null) {
                    Commission item2 = this.cloneCommission(comm, partialRefund);
                    res.setCurrencyCode(item2.getAmount().getCurrency());
                    res.setValue(value2.doubleValue());
                    this.updateCommissionAmount(item2, res, refundedHiddenFees, new ArrayList<ValidationMessage>());
                    item.setAmount(item2.getAmount());
                }
            }
            correctedRefundedCommissions.add(item);
            if (!(prop instanceof FeeProperties) || !(feeProp = (FeeProperties)prop).isHidden()) continue;
            refundedHiddenFees.add(item);
        }
        if (GeneralProductHelper.getContractType((EntityReference)this.contractRelationDescription) == ContractType.VENDOR && AirProductHelper.isTCHTicket((Product)this.product)) {
            List<Commission> feesForRefund = this.getCommissionsForRefund(commissions);
            commissions.clear();
            commissions.addAll(feesForRefund);
            commissions.addAll(correctedRefundedCommissions);
            return;
        }
        if (relatedProduct.getTicketType() != null && relatedProduct.getTicketType() != TicketType.OWN) {
            this.log.debug("related product is not OWN, skipping update of fees");
            return;
        }
        BigDecimal refundedFare = AirProductHelper.getEquivalentFare((Product)this.product);
        if (refundedFare == null) {
            refundedFare = BigDecimal.ZERO;
        }
        Iterator it = correctedRefundedCommissions.iterator();
        while (it.hasNext()) {
            Commission commission = (Commission)it.next();
            if (commission.getCommissionProperties() == null || !CommissionProperties.class.equals((Object)commission.getCommissionProperties().getType()) || BigDecimal.ZERO.compareTo(refundedFare) != 0) continue;
            it.remove();
        }
        List<Commission> feesForRefund = this.getCommissionsForRefund(commissions);
        commissions.clear();
        commissions.addAll(feesForRefund);
        commissions.addAll(correctedRefundedCommissions);
    }

    private List<Commission> getSellCommissions(Product prod, Collection<ValidationMessage> messages) {
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        if (actionProxy.getStatus(this.product) == ProductStatus.REFUND && this.product.getPreviousProduct() != null && this.product.getPreviousProduct().getPreviousProduct() != null && actionProxy.getStatus(this.product.getPreviousProduct().getPreviousProduct()) == ProductStatus.EXCHANGE) {
            ArrayList<Commission> result = new ArrayList<Commission>();
            Product firstSell = this.getFirstSell(this.product.getPreviousProduct(), false);
            if (firstSell != null) {
                AirProductContractRelationData relation;
                if (firstSell.getTicketType() == TicketType.FAKE) {
                    String firstSellNumber = firstSell.getSystemNumber();
                    firstSell = this.getFirstSell(this.product.getPreviousProduct(), true);
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_FIRST_SELL_IS_FAKE, (Object[])new Object[]{firstSellNumber, firstSell.getSystemNumber()}));
                }
                if ((relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)firstSell), (EntityReference)this.contractRelationDescription)) != null) {
                    result.addAll(GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, null, null));
                    relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)this.product.getPreviousProduct()), (EntityReference)this.contractRelationDescription);
                    if (relation != null) {
                        Collection commissions = GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, null, null);
                        ArrayList fees = new ArrayList(relation.getCommissions());
                        fees.removeAll(commissions);
                        result.addAll(fees);
                    }
                }
            }
            return result;
        }
        ArrayList<Commission> result = new ArrayList<Commission>();
        Product relatedProduct = prod.getPreviousProduct();
        AirProductContractRelationData relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)relatedProduct), (EntityReference)this.contractRelationDescription);
        if (relation != null) {
            result.addAll(relation.getCommissions());
        }
        return result;
    }

    private Product getFirstSell(Product secondSell, boolean notFake) {
        Product sell;
        Product product = sell = secondSell.getPreviousProduct() != null ? secondSell.getPreviousProduct().getPreviousProduct() : null;
        if (sell == null) {
            return null;
        }
        if (sell.getPreviousProduct() == null) {
            if (notFake && sell.getTicketType() == TicketType.FAKE) {
                return secondSell;
            }
            return sell;
        }
        Product previousSell = this.getFirstSell(sell, notFake);
        if (notFake && (previousSell == null || previousSell.getTicketType() == TicketType.FAKE)) {
            return sell;
        }
        return previousSell;
    }

    private List<Commission> reorderCommissions(List<Commission> commissions) {
        List<Commission> hiddenFees = BaseCommissionActionSet.getHiddenFees(commissions);
        if (hiddenFees.isEmpty()) {
            return commissions;
        }
        commissions.removeAll(hiddenFees);
        for (Commission comm : hiddenFees) {
            commissions.add(0, comm);
        }
        return commissions;
    }

    private boolean checkRefundedCommission(Commission commission) throws Exception {
        Product p;
        ValueHolder result = new ValueHolder((Object)true);
        Exception exception = InterceptorsHelper.performInterception(ProductCommissionActionSetInterceptor.class, (arg_0, arg_1) -> ProductCommissionActionSet.lambda$checkRefundedCommission$11(result, p = this.product, commission, arg_0, arg_1), (Object[])new Object[0]);
        if (exception != null) {
            throw exception;
        }
        return (Boolean)result.getValue();
    }

    private boolean containsCommissionCategory(List<Commission> commissions, EntityReference<? extends BaseCommissionProperties> commissionProperties) {
        if (commissionProperties == null) {
            return false;
        }
        for (Commission comm : commissions) {
            if (!commissionProperties.equals((Object)comm.getCommissionProperties())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Commission cloneCommission(Commission comm, boolean partialRefund) throws Exception {
        Commission item = new Commission();
        SegmentTariff st = comm.getSegmentTariff();
        comm.setSegmentTariff(null);
        try {
            XCloneModelHelper.copy((BaseEntity)comm, (BaseEntity)item, (boolean)true);
            if (st != null) {
                SegmentTariff newSegmentTariff = null;
                if (!st.getSegments().isEmpty()) {
                    Segment seg = (Segment)st.getSegments().get(0);
                    int num = seg.getRecordNumber();
                    for (SegmentTariff st2 : this.product.getSegmentTariffs()) {
                        if (st2.getSegments().isEmpty()) continue;
                        Segment seg2 = (Segment)st2.getSegments().get(0);
                        if (!TextUtil.isSame((String)seg.getFareBasis(), (String)seg2.getFareBasis()) || seg2.getRecordNumber() != num) continue;
                        newSegmentTariff = st2;
                        break;
                    }
                }
                if (newSegmentTariff == null && partialRefund) {
                    Commission commission = null;
                    return commission;
                }
                item.setSegmentTariff(newSegmentTariff);
            }
        }
        finally {
            comm.setSegmentTariff(st);
        }
        return item;
    }

    private List<Commission> getCommissionsForRefund(Collection<Commission> commissions) {
        ArrayList<Commission> result = new ArrayList<Commission>();
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        for (Commission comm : commissions) {
            EntityContainer commissionCtr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (commissionCtr == null) {
                this.log.warn(String.format("unable to load commission description for ticket %s", this.product.getSystemNumber()));
                continue;
            }
            BaseCommissionProperties commissionProperties = (BaseCommissionProperties)commissionCtr.getEntity();
            if (commissionProperties instanceof FeeProperties) {
                FeeProperties feeProperties = (FeeProperties)commissionProperties;
                if (ProductStatus.REFUND == productStatus && feeProperties.getOperation() == Operation.REFUND) {
                    result.add(comm);
                    continue;
                }
                if (ProductStatus.EXCHANGE == productStatus && feeProperties.getOperation() == Operation.EXCHANGE) {
                    result.add(comm);
                    continue;
                }
            }
            if (commissionProperties instanceof CommissionProperties) {
                CommissionProperties commProperties = (CommissionProperties)commissionProperties;
                if (ProductStatus.REFUND == productStatus && commProperties.getOperation() == Operation.REFUND) {
                    result.add(comm);
                    continue;
                }
                if (ProductStatus.EXCHANGE == productStatus && commProperties.getOperation() == Operation.EXCHANGE) {
                    result.add(comm);
                    continue;
                }
            }
            if (!(commissionProperties instanceof DiscountProperties)) continue;
            DiscountProperties discProperties = (DiscountProperties)commissionProperties;
            if (ProductStatus.REFUND == productStatus && discProperties.getOperation() == Operation.REFUND) {
                result.add(comm);
                continue;
            }
            if (ProductStatus.EXCHANGE != productStatus || discProperties.getOperation() != Operation.EXCHANGE) continue;
            result.add(comm);
        }
        return result;
    }

    @Override
    protected void fixFeeRate(Commission commission, FeeProperties feeProp) {
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        if (ProductStatus.REFUND == productStatus && feeProp.getOperation() == Operation.REFUND) {
            if (commission.getRate() != null) {
                commission.setRate(Double.valueOf(-commission.getRate().doubleValue()));
            }
            if (commission.getAmount() != null) {
                commission.getAmount().setValue(commission.getAmount().getValue().negate());
            }
        }
    }

    @Override
    protected void fixCommissionRate(Commission commission, CommissionProperties commProp) {
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        if (ProductStatus.REFUND == productStatus && commProp.getOperation() == Operation.REFUND) {
            if (commission.getRate() != null) {
                commission.setRate(Double.valueOf(-commission.getRate().doubleValue()));
            }
            if (commission.getAmount() != null) {
                commission.getAmount().setValue(commission.getAmount().getValue().negate());
            }
        }
    }

    @Override
    protected void fixDiscountRate(Commission commission, DiscountProperties discProp) {
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        if (ProductStatus.REFUND == productStatus && discProp.getOperation() == Operation.REFUND) {
            if (commission.getRate() != null) {
                commission.setRate(Double.valueOf(-commission.getRate().doubleValue()));
            }
            if (commission.getAmount() != null) {
                commission.getAmount().setValue(commission.getAmount().getValue().negate());
            }
        }
    }

    @Override
    protected BigDecimal updateRuleValueWithVatRate(BigDecimal value, Commission commission, BaseCommissionProperties properties) {
        if (properties instanceof FeeProperties) {
            boolean refund;
            commission.setRuleValue(value);
            FeeProperties feeProperties = (FeeProperties)properties;
            ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
            boolean bl = refund = ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus;
            if (refund && commission.isTransferred()) {
                if (feeProperties.isRecalculateVatForAllContractTypes()) {
                    BigDecimal equivalentAmount = commission.getRuleValue();
                    if (!feeProperties.isVatNotIncluded()) {
                        Double previousVatRate;
                        Double d = previousVatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.previousVatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                        if (previousVatRate != null) {
                            VatAmount vatAmount = VatAmount.of((BigDecimal)equivalentAmount, (double)previousVatRate);
                            equivalentAmount = MiscUtil.sub((BigDecimal)equivalentAmount, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
                        }
                    }
                    Double vatRate = GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)this.product.getStatus());
                    commission.setVatRate(vatRate);
                    if (vatRate != null) {
                        return equivalentAmount.add(equivalentAmount.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                    }
                } else {
                    Double vatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.previousVatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                    commission.setVatRate(vatRate);
                    if (feeProperties.isVatNotIncluded() && vatRate != null) {
                        return value.add(value.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                    }
                }
            } else {
                Double vatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
                commission.setVatRate(vatRate);
                if (feeProperties.isVatNotIncluded() && vatRate != null) {
                    return value.add(value.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP));
                }
            }
        }
        return value;
    }

    @Override
    protected void updateAmountWithVatRate(Commission commission, BaseCommissionProperties properties) {
        Double vatRate;
        if (commission.getAmount() == null || commission.getAmount().getValue() == null) {
            return;
        }
        if (!(properties instanceof FeeProperties)) {
            return;
        }
        BigDecimal value = commission.getAmount().getValue();
        commission.setRuleValue(value);
        FeeProperties feeProperties = (FeeProperties)properties;
        ProductStatus productStatus = ProductCommissionActionProxy.get().getStatus(this.product);
        boolean refund = ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus;
        Double d = vatRate = feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus);
        if (refund && commission.isTransferred()) {
            vatRate = feeProperties.isRecalculateVatForAllContractTypes() ? GeneralProductHelper.getFeeVatRate((double[])this.vatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus) : (feeProperties.isExternalFee() ? feeProperties.getExternalFeeVatRate() : GeneralProductHelper.getFeeVatRate((double[])this.previousVatRates, (FeeProperties)feeProperties, (ProductStatus)productStatus));
        }
        commission.setVatRate(vatRate);
        if (feeProperties.isVatNotIncluded() && vatRate != null) {
            commission.getAmount().setValue(value.add(value.multiply(BigDecimal.valueOf(vatRate)).divide(BigDecimal.valueOf(100L), 2, java.math.RoundingMode.HALF_UP)));
        }
    }

    @Override
    protected BigDecimal getBasis(CalculationBasis basis, List<Commission> hiddenFees, boolean useDifference) {
        ValueHolder amount;
        AirRulesProductHandler h = AirRulesProductHandler.get();
        if (h != null && h.getBasis(this.product, (EntityReference<ContractRelationDescription>)this.contractRelationDescription, basis, hiddenFees, useDifference, (ValueHolder<BigDecimal>)(amount = new ValueHolder()))) {
            return MiscUtil.guarded((BigDecimal)((BigDecimal)amount.getValue()));
        }
        if (basis == CalculationBasis.PAYMENT_SUM_TO_SUPPLIER) {
            if (this.contractRelationDescription == null || GeneralProductHelper.getContractType((EntityReference)this.contractRelationDescription) == ContractType.VENDOR) {
                return BigDecimal.ZERO;
            }
            BigDecimal result = null;
            for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)this.product)) {
                if (result == null) {
                    if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.VENDOR) continue;
                    result = BigDecimal.ZERO;
                    for (ProductFop fop : relation.getFops()) {
                        result = result.add(fop.getAmount().getValue());
                    }
                    continue;
                }
                ExchangeRateData exchangeRateData = relation.getGeneralData().getRate();
                if (exchangeRateData != null) {
                    result = MulticurrencyHelper.convert((BigDecimal)result, (ExchangeRateData)exchangeRateData);
                }
                if (!this.contractRelationDescription.equals((Object)relation.getDescription())) continue;
                break;
            }
            return result == null ? BigDecimal.ZERO : result;
        }
        boolean withFare = withFareBasis.contains(basis);
        boolean withTaxes = withTaxesBasis.contains(basis);
        boolean withPenalties = withPenaltyBasis.contains(basis);
        BigDecimal result = BigDecimal.ZERO;
        if (withFare) {
            result = result.add(MiscUtil.guarded((BigDecimal)this.getFare(this.product)));
        }
        if (withPenalties) {
            result = result.add(MiscUtil.guarded((BigDecimal)this.getPenalty(this.product)));
        }
        if (withTaxes) {
            result = result.add(this.getTaxesEquivalentAmount(this.product, hiddenFees));
        }
        if (!useDifference || this.product.getPreviousProduct() == null) {
            return result;
        }
        result = result.subtract(MiscUtil.guarded((BigDecimal)this.getFare(this.product.getPreviousProduct())));
        if (withPenalties) {
            result = result.subtract(MiscUtil.guarded((BigDecimal)this.getPenalty(this.product.getPreviousProduct())));
        }
        if (withTaxes) {
            ArrayList<Commission> hiddenFeesFromRelatedProduct = new ArrayList<Commission>();
            Product previousProduct = this.product.getPreviousProduct();
            AirProductContractRelationData relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)previousProduct), (EntityReference)this.contractRelationDescription);
            if (relation != null) {
                hiddenFeesFromRelatedProduct.addAll(BaseCommissionActionSet.getHiddenFees(relation.getCommissions()));
            }
            result = result.subtract(this.getTaxesEquivalentAmount(this.product.getPreviousProduct(), hiddenFeesFromRelatedProduct));
        }
        if (result.compareTo(BigDecimal.ZERO) < 0) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    @Override
    protected boolean updateCommissionAmount(Commission commission, RuleResultValue value, List<Commission> hiddenFees, Collection<ValidationMessage> messages) throws Exception {
        boolean exchange;
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        boolean bl = exchange = actionProxy.getStatus(this.product) == ProductStatus.SELL && this.product.getPreviousProduct() != null && actionProxy.getStatus(this.product.getPreviousProduct()) == ProductStatus.EXCHANGE;
        if (!exchange || commission.getCommissionProperties() == null || !CommissionProperties.class.equals((Object)commission.getCommissionProperties().getType())) {
            return super.updateCommissionAmount(commission, value, hiddenFees, messages);
        }
        EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
        if (ctr == null || ((BaseCommissionProperties)ctr.getEntity()).isRate()) {
            return super.updateCommissionAmount(commission, value, hiddenFees, messages);
        }
        return false;
    }

    @Override
    protected void updateEquivalentAmount(Commission commission, BaseCommissionProperties properties, CalculationBasis basis, List<Commission> hiddenFees, boolean useDifference, Collection<ValidationMessage> messages) {
        boolean exchange;
        ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
        boolean bl = exchange = actionProxy.getStatus(this.product) == ProductStatus.SELL && this.product.getPreviousProduct() != null && actionProxy.getStatus(this.product.getPreviousProduct()) == ProductStatus.EXCHANGE;
        if (!exchange || commission.getCommissionProperties() == null || !CommissionProperties.class.equals((Object)commission.getCommissionProperties().getType())) {
            super.updateEquivalentAmount(commission, properties, basis, hiddenFees, useDifference, messages);
            return;
        }
        if (commission.getRate() != null) {
            super.updateEquivalentAmount(commission, properties, CalculationBasis.FARE, hiddenFees, true, messages);
            return;
        }
        if (TextUtil.isSame((String)this.product.getCarrierNumber(), (String)"555") || TextUtil.isSame((String)this.product.getCarrierNumber(), (String)"421") || AirProductHelper.isTCHTicket((Product)this.product)) {
            super.updateEquivalentAmount(commission, properties, CalculationBasis.FARE, hiddenFees, true, messages);
            return;
        }
        super.updateEquivalentAmount(commission, properties, basis, hiddenFees, useDifference, messages);
    }

    private BigDecimal getTaxesEquivalentAmount(Product prod, List<Commission> hiddenFees) {
        AirProductContractRelationData relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prod), (EntityReference)this.contractRelationDescription);
        BigDecimal res = BigDecimal.ZERO;
        if (relation == null) {
            this.log.warn(String.format("no relation of type %s can be found in prod %s", this.contractRelationDescription, AirProductHelper.getProductTitle((Product)prod)));
            res = AirProductTaxHelper.getEquivalentTaxesAmount((Product)prod);
        } else {
            List simpleTaxes = relation.getServiceData().getDetalization().getTaxes();
            for (SimpleTax tax : simpleTaxes) {
                if (tax.getAmount() == null) continue;
                res = res.add(tax.getAmount());
            }
        }
        for (Commission comm : hiddenFees) {
            FeeProperties feeProp = (FeeProperties)EntityStorage.get().resolve(comm.getCommissionProperties()).getEntity();
            if (TextUtil.isBlank((String)feeProp.getHiddenFeeTaxCode())) continue;
            res = res.add(comm.getEquivalentAmount());
        }
        return res;
    }

    private BigDecimal getPenalty(Product prod) {
        AirProductContractRelationData relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prod), (EntityReference)this.contractRelationDescription);
        if (relation == null) {
            this.log.warn(String.format("no relation of type %s can be found in prod %s", this.contractRelationDescription, AirProductHelper.getProductTitle((Product)prod)));
            return prod.getPenalty();
        }
        return relation.getServiceData().getDetalization().getPenaltyWithMcoValue();
    }

    private BigDecimal getFare(Product prod) {
        AirProductContractRelationData relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prod), (EntityReference)this.contractRelationDescription);
        if (relation == null) {
            this.log.warn(String.format("no relation of type %s can be found in prod %s", this.contractRelationDescription, AirProductHelper.getProductTitle((Product)prod)));
            return Optional.ofNullable(AirProductHelper.getEquivalentFare((Product)prod)).orElse(BigDecimal.ZERO);
        }
        return relation.getServiceData().getDetalization().getFare();
    }

    @Override
    protected BigDecimal getCurrencyRate(String currencyCode, boolean feeForRefund, Collection<ValidationMessage> messages) {
        return this.getCurrencyRate(null, currencyCode, feeForRefund, messages);
    }

    @Override
    protected BigDecimal getCurrencyRate(String baseCurrencyCode, String currencyCode, boolean feeForRefund, Collection<ValidationMessage> messages) {
        return RateHelper.getCurrencyRate((String)baseCurrencyCode, (String)currencyCode, (Product)this.product, (boolean)feeForRefund, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean accept(DiscountProperties discountProp) {
        RuleLogTracer tracer = this.getProxy().getTracer();
        tracer.traceEnteringMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        try {
            ProductCommissionActionProxy actionProxy = ProductCommissionActionProxy.get();
            ProductStatus productStatus = actionProxy.getStatus(this.product);
            if (productStatus == null) {
                boolean res = discountProp.getOperation() == null;
                tracer.traceLogic("product status is null, returning " + res);
                boolean bl = res;
                return bl;
            }
            tracer.traceLogic("product status is " + productStatus);
            tracer.traceLogic("discountProperties.operation == " + discountProp.getOperation());
            switch (productStatus) {
                case BOOKING: {
                    if (discountProp.getOperation() != Operation.SELL) break;
                    tracer.traceLogic("product status is " + productStatus + ", discount.operation == SELL, returning true");
                    boolean bl = true;
                    return bl;
                }
                case SELL: {
                    if (discountProp.getOperation() == Operation.SELL) {
                        tracer.traceLogic("product status is SELL, discount.operation == SELL, returning true");
                        boolean bl = true;
                        return bl;
                    }
                    if (discountProp.getOperation() != Operation.EXCHANGE || this.product.getPreviousProduct() == null || actionProxy.getStatus(this.product.getPreviousProduct()) != ProductStatus.EXCHANGE) break;
                    tracer.traceLogic("product status is SELL, exchanged product is present, returning true");
                    boolean bl = true;
                    return bl;
                }
                case REFUND: {
                    if (discountProp.getOperation() != Operation.REFUND) break;
                    tracer.traceLogic("product status is REFUND, discount.operation == REFUND, returning true");
                    boolean bl = true;
                    return bl;
                }
                case EXCHANGE: {
                    if (discountProp.getOperation() != Operation.SELL) break;
                    tracer.traceLogic("product status is EXCHANGE, discount.operation == SELL, returning true");
                    boolean bl = true;
                    return bl;
                }
                case VOID: 
                case VOID_BOOKING: {
                    break;
                }
                default: {
                    throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
                }
            }
            tracer.traceLogic("returning false");
            boolean bl = false;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean accept(CommissionProperties commissionProp) {
        RuleLogTracer tracer = this.getProxy().getTracer();
        tracer.traceEnteringMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        try {
            ProductCommissionActionProxy actionProxy;
            ProductStatus productStatus;
            ProductType productType = AirProductHelper.getProductType((Product)this.product);
            if (productType != null) {
                tracer.traceLogic(String.format("product.productCategory = %s, product.mcoCategory = %s, productType = %scomm.productCategories = %s ", this.product.getProductCategory(), this.product.getMcoCategory(), productType, Arrays.toString(commissionProp.getProductTypes().toArray())));
                if (!commissionProp.getProductTypes().isEmpty() && !commissionProp.getProductTypes().contains(productType)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if ((productStatus = (actionProxy = ProductCommissionActionProxy.get()).getStatus(this.product)) == null) {
                boolean res = commissionProp.getOperation() == null;
                tracer.traceLogic("product status is null, returning " + res);
                boolean bl = res;
                return bl;
            }
            tracer.traceLogic("product status is " + productStatus);
            tracer.traceLogic("commissionProperties.operation == " + commissionProp.getOperation());
            switch (productStatus) {
                case BOOKING: {
                    if (commissionProp.getOperation() != Operation.SELL) break;
                    tracer.traceLogic("product status is " + productStatus + ", commission.operation == SELL, returning true");
                    boolean bl = true;
                    return bl;
                }
                case SELL: {
                    if (commissionProp.getOperation() == Operation.SELL) {
                        tracer.traceLogic("product status is SELL, commission.operation == SELL, returning true");
                        boolean bl = true;
                        return bl;
                    }
                    if (commissionProp.getOperation() != Operation.EXCHANGE || this.product.getPreviousProduct() == null || actionProxy.getStatus(this.product.getPreviousProduct()) != ProductStatus.EXCHANGE) break;
                    tracer.traceLogic("product status is SELL, exchanged product is present, returning true");
                    boolean bl = true;
                    return bl;
                }
                case REFUND: {
                    if (commissionProp.getOperation() != Operation.REFUND) break;
                    tracer.traceLogic("product status is REFUND, commission.operation == REFUND, returning true");
                    boolean bl = true;
                    return bl;
                }
                case EXCHANGE: {
                    if (commissionProp.getOperation() != Operation.SELL) break;
                    tracer.traceLogic("product status is EXCHANGE, commission.operation == SELL, returning true");
                    boolean bl = true;
                    return bl;
                }
                case VOID: 
                case VOID_BOOKING: {
                    break;
                }
                default: {
                    throw Xeption.forDeveloper((String)"unexpected product status {0}", (Object[])new Object[]{productStatus});
                }
            }
            tracer.traceLogic("returning false");
            boolean bl = false;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(ProductCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    public boolean isAutoGetCouponStatusEnabled() {
        return this.autoGetCouponStatusEnabled;
    }

    public void setAutoGetCouponStatus(boolean value) {
        this.autoGetCouponStatusEnabled = value;
    }

    public boolean isAutoCreateCertificateOfCompletedFlightEnabled() {
        return this.autoCreateCertificateOfCompletedFlight;
    }

    public void setAutoCreateCertificateOfCompletedFlight(boolean value) {
        this.autoCreateCertificateOfCompletedFlight = value;
    }

    public EntityReference<?> getGdsAccount() {
        return this.gdsAccount;
    }

    public void setGdsAccount(EntityReference<?> gdsAccount) {
        this.gdsAccount = gdsAccount;
    }

    public String getProdUid() {
        return this.product.getUid();
    }

    private double[] getVatRatesFromContract(AirProductContractRelationData contractRelation, Product product) {
        EntityReference payer = contractRelation.getFops().stream().filter(f -> f.getType() != PaymentType.TICKET).map(ProductFop::getPayer).filter(Objects::nonNull).findFirst().orElse(null);
        return GeneralProductHelper.getFeeVatRate((BaseProduct)product, (EntityReference)contractRelation.getDescription(), (ContractRelationVatDetalization)contractRelation.getServiceData().getDetalization().getVat(), (EntityReference)payer);
    }

    private static /* synthetic */ void lambda$checkRefundedCommission$11(ValueHolder result, Product p, Commission commission, ProductCommissionActionSetInterceptor interceptor, Object[] arguments) throws Exception {
        result.setValue((Object)interceptor.checkRefundedCommission(p, commission));
    }

    static {
        withFareBasis = Arrays.asList(CalculationBasis.FARE, CalculationBasis.FARE_AND_PENALTY, CalculationBasis.TOTAL, CalculationBasis.TOTAL_AND_PENALTY);
        withPenaltyBasis = Arrays.asList(CalculationBasis.FARE_AND_PENALTY, CalculationBasis.TOTAL_AND_PENALTY, CalculationBasis.PENALTY);
        withTaxesBasis = Arrays.asList(CalculationBasis.TOTAL, CalculationBasis.TOTAL_AND_PENALTY, CalculationBasis.TAXES);
        String className = System.getProperty("product-commission-action-set-customizer.className");
        if (!TextUtil.isBlank((String)className)) {
            customizer = (ProductCommissionActionSetCustomizer)XHelper.getInstance((String)className, (Object[])new Object[0]);
        }
    }

    public static class ProductCommissionActionProxy {
        public ProductStatus getStatus(Product product) {
            return product.getStatus();
        }

        public static ProductCommissionActionProxy get() {
            if (!Environment.isTest()) {
                return Holder.INSTANCE;
            }
            return Holder.newInstance();
        }

        private static class Holder {
            public static final ProductCommissionActionProxy INSTANCE = Holder.newInstance();

            private Holder() {
            }

            private static ProductCommissionActionProxy newInstance() {
                return Environment.isPublished(ProductCommissionActionProxy.class) ? (ProductCommissionActionProxy)Environment.getPublished(ProductCommissionActionProxy.class) : new ProductCommissionActionProxy();
            }
        }
    }

    private static class FopData {
        private final Date operationDate;
        private final PaymentType paymentType;
        private final EntityReference<Person> agent;
        private Card card;
        private final EntityReference<Organization> payer;

        public FopData(Date operationDate, PaymentType paymentType, EntityReference<Person> agent, Card card, EntityReference<Organization> payer) {
            this.operationDate = operationDate;
            this.paymentType = paymentType;
            this.agent = agent;
            this.card = card;
            this.payer = payer;
        }

        public Date getOperationDate() {
            return this.operationDate;
        }

        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public Card getCard() {
            return this.card;
        }

        public void setCard(Card card) {
            this.card = card;
        }

        public EntityReference<Organization> getPayer() {
            return this.payer;
        }
    }
}

