/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.List;

public class ProductPropertiesHelper {
    public static boolean isForcedRefund(Product product) {
        boolean result = false;
        if (product.getStatus() == ProductStatus.REFUND) {
            result = product.isForcedRefund();
        } else if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            result = product.getPreviousProduct().isForcedRefund();
        }
        return result;
    }

    public static boolean isForcedRefund(HotelProduct product) {
        boolean result = false;
        ProductBillingTransactionsHandler<?> transactionHandler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findProductBillingTransactionHandler(product.getClass());
        switch (transactionHandler.getStatus(product)) {
            case REFUND: {
                result = product.isForcedRefund();
                break;
            }
            case SELL: {
                HotelProduct pp = product.getPreviousProduct();
                result = pp != null && pp.getStatus() == ProductStatus.EXCHANGE && pp.isForcedRefund();
                break;
            }
        }
        return result;
    }

    public static <P extends BaseProduct> String getClientCreditCardVendor(P prod) {
        if (prod == null) {
            return null;
        }
        List relations = GeneralProductHelper.getHandler(prod).getUnmodifiableContractRelations(prod);
        GeneralProductContractRelationData rel = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.CLIENT);
        if (rel != null) {
            for (GeneralProductFop fop : rel.getFops()) {
                if (fop.getCard() == null || fop.getCard().getVendor() == null) continue;
                return fop.getCard().getVendor().name();
            }
        }
        return null;
    }
}

