/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.FlightDistance;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ContractRelationHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Constants;
import com.gridnine.xtrip.common.model.rules.standard.PayersPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TechnicalFeePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TimeLimitPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravellersPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.interceptors.InterceptorsHelper;
import com.gridnine.xtrip.server.model.handlers.BaseAirPropertySet;
import com.gridnine.xtrip.server.model.handlers.PayersCollector;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySetInterceptor;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductPropertySet
extends BaseAirPropertySet
implements PayersPropertiesProvider,
TravellersPropertyProvider,
UDIDsPropertyProvider,
TicketTypePropertiesProvider,
ProductStatusPropertiesProvider,
TimeLimitPropertyProvider,
TechnicalFeePropertiesProvider {
    private boolean tchTicket;
    private String salesOriginProvider;
    private String salesOriginContent;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = -6212021180724788310L;
    private static final Pattern tchSpecialSchemePattern = Pattern.compile("([0-9]{2})C");
    private final Collection<EntityReference<Person>> travellers = new ArrayList<EntityReference<Person>>();
    private final RuleProxy<? extends ProductPropertySet, ?> proxy;
    private Product product;
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();

    public Collection<EntityReference<Person>> getTravellers() {
        return this.travellers;
    }

    private static boolean isSameCarriers(DictionaryReference<Airline> ref1, DictionaryReference<Airline> ref2) {
        String code2;
        if (ref1 == null) {
            return ref2 == null;
        }
        if (ref2 == null) {
            return false;
        }
        String code1 = ref1.getCode();
        if (code1.equals(code2 = ref2.getCode())) {
            return true;
        }
        for (Airline ac1 : DictHelper.getAirlinesByAnyCode((String)code1, null)) {
            for (Airline ac2 : DictHelper.getAirlinesByAnyCode((String)code2, null)) {
                if (!ac1.equals((Object)ac2)) continue;
                return true;
            }
        }
        return false;
    }

    private Airline addAirlines(Set<String> collection, DictionaryReference<Airline> airlineRef, String airlineNum, String ticketNo, String propertyName) {
        Airline blankOwner;
        if (!TextUtil.isBlank((String)airlineNum) && collection != null) {
            collection.add(airlineNum);
        }
        if ((blankOwner = (Airline)DictionaryCache.get().resolveReference(airlineRef)) == null && !TextUtil.isBlank((String)airlineNum)) {
            this.log.warn(propertyName + " is empty in product " + ticketNo + ". Airline number " + airlineNum + " will be used");
            List arls = DictHelper.getAirlinesByNumber((String)airlineNum, (Date)this.product.getIssueDate());
            if (!arls.isEmpty()) {
                blankOwner = (Airline)arls.get(0);
            }
            if (arls.size() > 1) {
                this.log.warn("more than one airlines for " + propertyName + " found for number " + airlineNum);
            }
        }
        if (blankOwner != null) {
            Map codeVariants = blankOwner.getCodeVariants();
            if (!codeVariants.isEmpty()) {
                for (Map.Entry entry : codeVariants.entrySet()) {
                    String value = (String)entry.getValue();
                    if (TextUtil.isBlank((String)value) || collection == null) continue;
                    collection.add(value);
                }
            } else if (collection != null) {
                collection.add(blankOwner.getCode());
            }
            if (!TextUtil.isBlank((String)blankOwner.getAirlineNumber()) && collection != null) {
                collection.add(blankOwner.getAirlineNumber().trim());
            }
            return blankOwner;
        }
        if (airlineRef != null && collection != null) {
            collection.add(airlineRef.getCode());
        }
        return null;
    }

    public ProductPropertySet(RuleProxy<? extends ProductPropertySet, ?> ruleProxy) {
        this.proxy = ruleProxy;
    }

    public Product getProduct() {
        return this.product;
    }

    public void init(Product prod) throws Exception {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(this.getClass(), "init()", new String[0]);
        try {
            EntityContainer ctr;
            Product refund;
            this.setAgencyCode(CommonProductHelper.getAgencyCode(prod));
            this.performAdditionalInitialization(prod);
            this.setIssuedForVoucher(prod.getPreviousProduct() != null && prod.getPreviousProduct().getMcoCategory() == MCOCategory.VOUCHER);
            this.addSubagencyCodes((EntityReference<Organization>)AirProductHelper.getSubagency((Product)prod));
            this.setAgent((EntityReference<Person>)prod.getCashier());
            this.setBookingAgent((EntityReference<Person>)prod.getReservation().getBookingAgent());
            this.salesOriginProvider = RulesHelper.getEnumName((Enum)prod.getSalesOriginProvider());
            this.salesOriginContent = RulesHelper.getEnumName((Enum)prod.getSalesOriginContent());
            if (prod.getReservation() != null && prod.getReservation().getBookingFile() != null) {
                this.setClient((EntityReference<Organization>)prod.getReservation().getBookingFile().getCustomerProfile());
            }
            ProductCategory prCat = prod.getProductCategory();
            MCOCategory mcoCat = prod.getMcoCategory();
            if (mcoCat != null) {
                this.setMainDocumentType(this.getMainDocumentType(prod));
            }
            this.product = prod;
            List vendorFops = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prod), (ContractType)ContractType.VENDOR).getFops();
            List clientFops = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prod), (ContractType)ContractType.CLIENT).getFops();
            if ((prCat == ProductCategory.EXCESS_BAGAGE || prCat == ProductCategory.MCO && (mcoCat == MCOCategory.PENALTY || mcoCat == MCOCategory.REBOOKING || mcoCat == MCOCategory.INFORMATION)) && (refund = AirProductHelper.findRelatedAirProduct((Product)prod, null, (boolean)false)) != null) {
                this.init(refund);
                this.setBaseFare(AirProductHelper.getBaseFare((Product)prod));
                this.setTargetType(this.getTargetType(prod));
                this.setIssueDate(prod.getIssueDate());
                this.setFare(RulesHelper.getDoubleValue((BigDecimal)AirProductHelper.getEquivalentFare((Product)prod)));
                this.setTourCode(RulesHelper.getString((String)prod.getTourCode()));
                this.product = prod;
                this.getPaymentTypes().clear();
                this.getTCHPaymentTypes().clear();
                this.updatePaymentTypes(vendorFops.isEmpty() ? clientFops : vendorFops, prod);
                if (prod.getMcoToProductMapping().getProductUid() != null) {
                    this.setNumOfSegments(prod.getMcoToProductMapping().getSegments().size());
                }
                this.setProductCategory(RulesHelper.getEnumName((Enum)prCat));
                this.setMcoCategory(RulesHelper.getEnumName((Enum)mcoCat));
                return;
            }
            Map<String, Object> params = this.initializeProductFields(prod);
            AirlineReference carrierReference = (AirlineReference)params.get("carrier");
            String systemNumber = prod.getSystemNumber();
            this.initializeSegmentFields(prod.getSegmentTariffs(), carrierReference, systemNumber, prod.getIssueDate());
            this.setPrice(BookingHelper.calculateEquivalentFare((BaseProduct)this.product, (boolean)true));
            this.setPriceCurrency(prod.getGdsCurrency());
            this.setTravelSubject(ProductHandler.of((BaseProduct)this.product).findTravelSubject((BaseProduct)this.product));
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)this.product));
            if (this.product.getReservation() != null && this.product.getReservation().getBookingFile() != null && (ctr = EntityStorage.get().resolve(this.product.getReservation().getBookingFile().getAgency())) != null) {
                this.setSimpleTaxed(((Organization)ctr.getEntity()).isSimpleTaxed());
            }
            if (this.product.getTraveller() != null) {
                this.setHasAirlineBonusCards(this.product.getTraveller().getAirlineBonusCards().size() > 0);
            }
            this.applyTravelDuration(prod);
            this.initIssuedInExchange(prod);
            this.initExtendedProperties(prod);
            this.setFirstSegmentDepartureDate(AirProductHelper.getFirstDepartureDate((Product)prod));
            Segment firstSegment = AirProductHelper.getFirstSegment((Product)prod);
            if (firstSegment == null) {
                tracer.traceWarn("unable to find first segment", null);
                this.log.warn("unable to find first segment of product " + systemNumber);
            }
            this.setFirstSegmentDepartureLocation((DictionaryReference<GeoLocation>)(firstSegment == null ? null : firstSegment.getDepartureLocation()));
            this.setHoursBeforeDepartureSupplier(this::calculateHoursBeforeDeparture);
            this.setHoursBeforeSellAndDepartureSupplier(this::calculateHourseBeforeSellAndDepature);
            this.payers.addAll(PayersCollector.collect(this.product));
            if (this.product.getTraveller() != null && this.product.getTraveller().getPassenger() != null) {
                this.travellers.add((EntityReference<Person>)this.product.getTraveller().getPassenger());
            }
            this.getEmployeeCategoriesHolder().setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)prod));
            this.getCreatedByClientHolder().setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)prod.getReservation()));
            this.getEmployersOfBookingAgentHolder().setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)prod.getReservation()));
            this.setOfflineFee(prod.isOfflineFee());
            this.setAccountCode(prod.getReservation().getAccountCode());
        }
        catch (Exception e) {
            tracer.traceError("unable to initialize property set", (Throwable)e);
            throw e;
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    private TicketType getMainDocumentType(Product prod) {
        Product rp = AirProductHelper.findRelatedAirProduct((Product)prod, null, (boolean)true);
        return rp == null ? null : rp.getTicketType();
    }

    protected void initIssuedInExchange(Product prod) {
        this.setIssuedInExchange(prod.getStatus() == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE);
    }

    protected void initExtendedProperties(Product prod) {
    }

    private void performAdditionalInitialization(Product prod) {
        InterceptorsHelper.performInterception(ProductPropertySetInterceptor.class, (interceptor, arguments) -> interceptor.initPropertySet(prod, this), (Object[])new Object[0]);
    }

    private void initializeSegmentFields(List<SegmentTariff> segmentTariffs, AirlineReference carrierReference, String systemNumber, Date issueDate) {
        boolean firstSegment = true;
        String arrivalCityCode = null;
        DictionaryReference arrival = null;
        String firstDepartureCityCode = null;
        ArrayList<String> cities = new ArrayList<String>();
        int numOfInterlineSegments = 0;
        String turnoverCityCode = null;
        DictionaryReference turnoverLocation = null;
        DictionaryReference lastRoutePoint = null;
        boolean startingFlagInitialized = false;
        block0: for (SegmentTariff st : this.product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!seg.isStarting()) continue;
                startingFlagInitialized = true;
                break block0;
            }
        }
        this.setNumOfSegmentTariffs(segmentTariffs.size());
        Integer flightDistance = null;
        ArrayList lvgl = new ArrayList();
        this.setBrandName(null);
        for (SegmentTariff segmentTariff : segmentTariffs) {
            int numOfSegments = segmentTariff.getSegments().size();
            for (int m = 0; m < numOfSegments; ++m) {
                GeoLocation arrivalCity;
                Date endDate;
                boolean surfaceSegment;
                GeoLocation departureCity;
                Segment segment = (Segment)segmentTariff.getSegments().get(m);
                if (segment.getFlightDistanceMiles() != null && (flightDistance == null || flightDistance.compareTo(segment.getFlightDistanceMiles()) < 0)) {
                    flightDistance = segment.getFlightDistanceMiles();
                }
                this.setNumOfSegments(this.getNumOfSegments() + 1);
                String departureCityCode = null;
                DictionaryReference departure = segment.getDepartureLocation();
                if (departure != null && (departureCity = DictHelper.findCityByAirport((String)(departureCityCode = departure.getCode()))) != null) {
                    departureCityCode = departureCity.getCode();
                }
                lastRoutePoint = segment.getArriveLocation();
                boolean bl = surfaceSegment = !firstSegment && !TextUtil.isSame(arrivalCityCode, (String)departureCityCode);
                if (surfaceSegment) {
                    this.getInterlineCarriers().add(null);
                    this.getSurfaceSegments().add(Boolean.TRUE);
                    this.getDepartureDates().add(null);
                    this.getFareBasises().add(null);
                    this.getFlightNumbers().add(null);
                    this.getServiceClasses().add(null);
                    this.getBookingClasses().add(null);
                    Set codes1 = RulesHelper.collectGeoCodes((DictionaryReference)departure, (boolean)true, (boolean)true);
                    this.getOpenJawEnd().addAll(codes1);
                    this.getOpenJawLoc().addAll(codes1);
                    Set codes2 = RulesHelper.collectGeoCodes(arrival, (boolean)true, (boolean)true);
                    this.getOpenJawStart().addAll(codes2);
                    this.getOpenJawLoc().addAll(codes2);
                    cities.add(departureCityCode);
                    this.getConnectedFlights().add(null);
                    this.getDomesticFlightsAC().add(null);
                }
                if (firstSegment) {
                    if (departure != null) {
                        this.getDepartureLocations().addAll(RulesHelper.collectGeoCodes((DictionaryReference)departure, (boolean)true, (boolean)true, (boolean)true));
                    }
                    cities.add(departureCityCode);
                    firstDepartureCityCode = departureCityCode;
                    this.addAirlines(this.getFirstSegmentAirline(), (DictionaryReference<Airline>)segment.getAirline(), null, systemNumber, "First segment airline");
                    if (segment.getFareDetails() != null) {
                        this.setBrandName(segment.getFareDetails().getBrandName());
                    }
                    firstSegment = false;
                }
                if (startingFlagInitialized) {
                    this.getConnectedFlights().add(!segment.isStarting());
                } else {
                    this.getConnectedFlights().add(segmentTariff.getSegments().size() > 1 && m < segmentTariff.getSegments().size() - 1);
                }
                this.setHasTransferTariffs(this.isHasTransferTariffs() || segmentTariff.getSegments().size() > 1);
                this.getFlightNumbers().add(RulesHelper.getString((String)segment.getFlightNo()));
                ClassOfService classOfService = DictHelper.findClassOfService((Segment)segment, (Date)issueDate);
                if (classOfService != null) {
                    this.getServiceClasses().add(classOfService.name());
                } else {
                    this.getServiceClasses().add(null);
                }
                this.getSurfaceSegments().add(Boolean.FALSE);
                Date startDate = segment.getStartDate();
                this.getDepartureDates().add(startDate);
                String fareBasis = RulesHelper.getString((String)segment.getFareBasis());
                this.getFareBasises().add(fareBasis);
                String classOfServiceCode = AirProductHelper.getClassOfServiceCode((Segment)segment);
                this.getBookingClasses().add(TextUtil.isBlank((String)classOfServiceCode) ? null : classOfServiceCode.trim().toUpperCase());
                DictionaryReference airlineReference = segment.getAirline();
                boolean sameCarriers = ProductPropertySet.isSameCarriers((DictionaryReference<Airline>)carrierReference, (DictionaryReference<Airline>)airlineReference);
                boolean interline = !sameCarriers;
                this.setInterline(this.isInterline() | interline);
                HashSet<String> segCarrierCodes = new HashSet<String>();
                if (airlineReference != null) {
                    this.addAirlines(segCarrierCodes, (DictionaryReference<Airline>)airlineReference, null, systemNumber, "Segment airline");
                    this.getAirlines().addAll(segCarrierCodes);
                    this.getSegmentAirlines().add(segCarrierCodes.toArray(new String[0]));
                    if (interline) {
                        this.getInterlineCarriers().add(segCarrierCodes.toArray(new String[0]));
                    } else {
                        this.getInterlineCarriers().add(null);
                    }
                } else {
                    this.getInterlineCarriers().add(null);
                    this.getSegmentAirlines().add(new String[0]);
                }
                DictionaryReference board = segment.getBoard();
                if (board != null) {
                    this.getAircraftsCodes().add(board.getCode());
                }
                DictionaryReference segmentOperatingAirline = segment.getCodeShareCarrier();
                HashSet<String> segmentOperatingAirlineCodes = new HashSet<String>();
                if (segmentOperatingAirline == null) {
                    segmentOperatingAirline = airlineReference;
                }
                if (segmentOperatingAirline != null) {
                    this.addAirlines(segmentOperatingAirlineCodes, (DictionaryReference<Airline>)segmentOperatingAirline, null, systemNumber, "Segment operating airline");
                    this.getSegmentOperatingAirlines().add(segmentOperatingAirlineCodes.toArray(new String[0]));
                } else {
                    this.getSegmentOperatingAirlines().add(new String[0]);
                }
                if (segment.isCodeShare()) {
                    this.setHasCodeSharing(true);
                    ((AbstractCollection)((Object)this.getCodeShareAirlines())).addAll(segmentOperatingAirlineCodes);
                }
                if (segment.getCodeShareCarrier() != null) {
                    this.addAirlines(this.getOperatingAirlines(), (DictionaryReference<Airline>)segment.getCodeShareCarrier(), null, systemNumber, "Operating airline");
                } else if (segment.getAirline() != null) {
                    this.addAirlines(this.getOperatingAirlines(), (DictionaryReference<Airline>)segment.getAirline(), null, systemNumber, "Operating airline");
                }
                if (startDate != null && (this.getDepartureDate() == null || this.getDepartureDate().after(startDate))) {
                    this.setDepartureDate(startDate);
                }
                if ((endDate = segment.getEndDate()) != null && (this.getArrivalDate() == null || this.getArrivalDate().before(endDate))) {
                    this.setArrivalDate(endDate);
                }
                if ((arrival = segment.getArriveLocation()) != null && (arrivalCity = DictHelper.findCityByAirport((String)(arrivalCityCode = arrival.getCode()))) != null) {
                    arrivalCityCode = arrivalCity.getCode();
                }
                if (interline) {
                    ++numOfInterlineSegments;
                }
                HashSet dcs = new HashSet();
                if (departure != null) {
                    dcs.addAll(RulesHelper.collectGeoCodes((DictionaryReference)departure, (boolean)true, (boolean)true, (boolean)true));
                }
                if (!(arrivalCityCode == null || m != numOfSegments - 1 || turnoverCityCode != null && cities.contains(arrivalCityCode))) {
                    turnoverCityCode = arrivalCityCode;
                    turnoverLocation = arrival;
                }
                cities.add(arrivalCityCode);
                HashSet acs = new HashSet();
                if (arrival != null) {
                    acs.addAll(RulesHelper.collectGeoCodes((DictionaryReference)arrival, (boolean)true, (boolean)true, (boolean)true));
                }
                ArrayList<String[]> lst = new ArrayList<String[]>();
                lst.add(dcs.toArray(new String[0]));
                lst.add(acs.toArray(new String[0]));
                this.getFlightSegments().add(lst);
                this.getAllLocations().addAll(dcs);
                this.getAllLocations().addAll(acs);
                this.getDomesticFlightsAC().add(this.isDomesticFlightAC((DictionaryReference<Airline>)airlineReference, (DictionaryReference<GeoLocation>)departure, (DictionaryReference<GeoLocation>)arrival));
                if (segment.getLuggageInfo() != null && !segment.getLuggageInfo().isNil() && segment.getLuggageInfo().getQuantity() != null) {
                    this.setHasLuggage(true);
                }
                ArrayList<DictionaryReference> referenceList = new ArrayList<DictionaryReference>();
                referenceList.add(departure);
                referenceList.add(arrival);
                for (DictionaryReference reference : referenceList) {
                    if (reference == null) continue;
                    HashSet<String> geoCodes = new HashSet<String>();
                    geoCodes.add(reference.getCode());
                    geoCodes.addAll(RulesHelper.collectGeoCodes(geoCodes, (boolean)true));
                    geoCodes.addAll(RulesHelper.collectGeoCodes((DictionaryReference)reference, (boolean)true, (boolean)true));
                    if (!lvgl.isEmpty() && ((Set)lvgl.get(lvgl.size() - 1)).equals(geoCodes)) continue;
                    lvgl.add(geoCodes);
                }
            }
        }
        this.getVisitedGeolocations().addAll(RulesHelper.fillVisitedGeolocations(lvgl));
        this.getLastRoutePointCodes().addAll(RulesHelper.collectGeoCodes(lastRoutePoint, (boolean)true, (boolean)true));
        this.setOneWayTicket(!MiscUtil.equals((Object)DictHelper.findCityByAirport(firstDepartureCityCode), (Object)DictHelper.findCityByAirport(arrivalCityCode)));
        this.setHasOpenJaw(!this.getOpenJawLoc().isEmpty());
        for (String city : cities) {
            HashSet<String> geoCodes = new HashSet<String>();
            if (!TextUtil.isBlank((String)city)) {
                geoCodes.add(city);
                geoCodes.addAll(RulesHelper.collectGeoCodes(geoCodes, (boolean)true));
            }
            this.getVisitedCities().add(geoCodes.toArray(new String[0]));
        }
        this.getArrivalLocations().clear();
        if (turnoverLocation != null) {
            this.getArrivalLocations().addAll(RulesHelper.collectGeoCodes(turnoverLocation, (boolean)true, (boolean)true, (boolean)true));
        }
        this.setNumOfInterlineSegments(numOfInterlineSegments);
        if (flightDistance != null) {
            int flightDistanceKm = (int)Math.abs((double)flightDistance.intValue() * 1.60934);
            if (flightDistanceKm <= 1500) {
                this.setFlightDistance(FlightDistance.SHORT);
            } else if (flightDistanceKm <= 4000) {
                this.setFlightDistance(FlightDistance.MEDIUM);
            } else {
                this.setFlightDistance(FlightDistance.LONG);
            }
        }
    }

    private Map<String, Object> initializeProductFields(Product prod) {
        Product pr;
        List contractRelations = AirProductHelper.getContractRelations((Product)prod);
        List vendorFops = AirProductHelper.findContractRelation((List)contractRelations, (ContractType)ContractType.VENDOR).getFops();
        List clientFops = AirProductHelper.findContractRelation((List)contractRelations, (ContractType)ContractType.CLIENT).getFops();
        this.setM2AgreementCode(this.getM2AgreementCode(prod.getTourCode()));
        this.setSupplier((EntityReference<Organization>)AirProductHelper.getSupplier((Product)prod));
        ProductCategory prCat = prod.getProductCategory();
        MCOCategory mcoCat = prod.getMcoCategory();
        this.setProductCategory(RulesHelper.getEnumName((Enum)prCat));
        this.setMcoCategory(RulesHelper.getEnumName((Enum)mcoCat));
        this.setGroupFare(AirProductHelper.isGroupTicket((Product)prod));
        this.setBaseFare(AirProductHelper.getBaseFare((Product)prod));
        this.setTariffType(RulesHelper.getEnumName((Enum)prod.getTariffType()));
        this.setPassengerType(RulesHelper.getDictCode((DictionaryReference)prod.getPassengerType()));
        this.getPassengerTypeCategories().clear();
        this.getPassengerTypeCategories().addAll(RulesHelper.getPassengerTypeCategoryCodes((DictionaryReference)prod.getPassengerType()));
        this.getSpecialTariffs().clear();
        this.getSpecialTariffs().addAll(prod.getSpecialTariffs().stream().filter(Objects::nonNull).map(Enum::name).collect(Collectors.toSet()));
        this.setTransatlanticFlight(RulesHelper.isTransatlanticFlight((Product)this.product));
        if (AirProductHelper.isIssuedInExchange((Product)prod)) {
            this.setFareDifference(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)prod)).subtract(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)prod.getPreviousProduct()))));
            this.setTotalDifference(MiscUtil.guarded((BigDecimal)AirProductHelper.calculateTotalEquivalentFare((Product)prod)).subtract(MiscUtil.guarded((BigDecimal)AirProductHelper.calculateTotalEquivalentFare((Product)prod.getPreviousProduct()))));
        }
        this.setClientCreditCardVendor(ProductPropertiesHelper.getClientCreditCardVendor(prod));
        this.setTourCode(RulesHelper.getString((String)prod.getTourCode()));
        this.setContractCode(RulesHelper.getString((String)prod.getTripartiteContractDetails().getContractCode()));
        this.setGdsName(RulesHelper.getEnumName((Enum)Optional.ofNullable(prod.getReservation()).map(CommonReservationGdsNameInfoHelper::getRulesGdsName).orElse(null)));
        this.setReservationType(RulesHelper.getEnumName(prod.getReservation() != null ? prod.getReservation().getType() : null));
        this.setPcc(prod.getPcc());
        this.setBranchUid(prod.getBranch() != null ? prod.getBranch().getUid() : null);
        this.setSalesPointUid(prod.getSalesPoint() != null ? prod.getSalesPoint().getUid() : null);
        this.setForcedRefund(ProductPropertiesHelper.isForcedRefund(prod));
        String systemNumber = prod.getSystemNumber();
        Airline blankOwner = this.addAirlines(this.getBlankOwners(), (DictionaryReference<Airline>)ProfileHelper.findAirline((EntityReference)prod.getBlankOwnerRef()), prod.getBlankOwnerNumber(), systemNumber, "blank owner");
        if (blankOwner != null && "\u04281".equals(blankOwner.getCode())) {
            this.setAgencyTchCode(prod.getAgencyCode());
            this.tchTicket = true;
        }
        this.setTargetType(this.getTargetType(this.product));
        this.setCarrierNumber(RulesHelper.getString((String)prod.getCarrierNumber()));
        DictionaryReference carrierReference = prod.getCarrier();
        Airline primaryCarrier = this.addAirlines(this.getCarriers(), (DictionaryReference<Airline>)carrierReference, this.getCarrierNumber(), systemNumber, "responsible carrier");
        if (this.product.getBlankType() != null) {
            this.setBlankType(this.product.getBlankType().getCode());
        }
        this.getAllValidatingCarriersCodes().add(this.getCarriers().toArray(new String[0]));
        if (primaryCarrier != null && primaryCarrier.getCountry() != null) {
            DictionaryReference countryRef = primaryCarrier.getCountry();
            this.getPrimaryCarrierCountry().add(countryRef.getCode());
            Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
            if (country == null) {
                this.log.warn(String.format("unable to resolve country reference with code %s", countryRef.getCode()));
            } else {
                this.getPrimaryCarrierCountry().addAll(country.getCodeVariants().values());
            }
        }
        EntityContainer ctr = EntityStorage.get().resolve(prod.getSalesPoint());
        this.addCountryCodes(this.getSalesPointCountryCodes(), ctr == null ? null : ((SalesPoint)ctr.getEntity()).getAddresses());
        EntityContainer agencyCtr = EntityStorage.get().resolve(AirProductHelper.getAgency((Product)prod));
        this.addCountryCodes(this.getAgencyCountryCodes(), agencyCtr == null ? null : ProfileHelper.getOrganizationAddresses((Organization)((Organization)agencyCtr.getEntity()), (Date)prod.getIssueDate()));
        switch (AirProductHelper.calculateTransportationType((Product)prod)) {
            case DOMESTIC: 
            case NONE: {
                this.setTransportationType(Constants.TRANSPORTATION_DOMESTIC.name());
                break;
            }
            default: {
                this.setTransportationType(Constants.TRANSPORTATION_INTRENATIONAL.name());
            }
        }
        this.setPnr(RulesHelper.getString((String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)prod.getReservation())));
        this.setValidator(RulesHelper.getString((String)prod.getValidatorCode()));
        this.setEticket(this.isEticket() | prod.isEticket());
        this.updatePaymentTypes(vendorFops.isEmpty() ? clientFops : vendorFops, prod.getPreviousProduct());
        this.updateClientPaymentTypes(prod);
        this.setIssueDate(prod.getIssueDate());
        this.setCurrentDate(new Date());
        ProductStatus status = prod.getStatus();
        if ((status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) && (pr = prod.getPreviousProduct()) != null) {
            this.setIssueDate(pr.getIssueDate());
            ProductHandler handler = HandlersRegistry.get().findProductHandler(pr.getClass());
            VatAmount price = handler.calculateProductPrice((BaseProduct)pr, ContractType.CLIENT);
            if (price != null) {
                this.setSellTotal(RulesHelper.getDoubleValue((BigDecimal)price.getTotal()));
            } else {
                this.setSellTotal(0.0);
            }
        }
        if (status == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            BigDecimal addCollectTotal = MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getEquivalentFare((Product)prod), MiscUtil.negate((BigDecimal)AirProductHelper.getEquivalentFare((Product)prod.getPreviousProduct()))});
            this.setAddCollectTotal(addCollectTotal != null ? addCollectTotal.doubleValue() : 0.0);
        }
        this.setFare(RulesHelper.getDoubleValue((BigDecimal)AirProductHelper.getEquivalentFare((Product)prod)));
        BigDecimal nuc = AirProductHelper.getNucFare((Product)prod);
        BigDecimal roe = AirProductHelper.getNucRoe((Product)prod);
        if (this.getFare() == 0.0 && nuc != null && roe != null) {
            this.setFare(this.getBaseFare() != null ? nuc.multiply(roe).multiply(AirProductHelper.calculateFareRate((Product)prod)).doubleValue() : 0.0);
        }
        for (Tax tax : prod.getTaxes()) {
            if (TextUtil.isBlank((String)tax.getCode())) continue;
            this.getTaxCodes().add(tax.getCode().trim().toUpperCase());
        }
        for (ProductFop fop : vendorFops) {
            if (fop.getType() != PaymentType.CREDIT && fop.getType() != PaymentType.INTERLINE && fop.getType() != PaymentType.MTD) continue;
            this.setPassengerStatus(RulesHelper.getEnumName((Enum)fop.getPassengerStatus()));
            break;
        }
        if (this.product.getReservation() != null && this.product.getReservation().getBookingFile() != null) {
            for (Reservation reservation : this.product.getReservation().getBookingFile().getReservations()) {
                for (BaseProduct bp : reservation.getProducts()) {
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                    ProductType pt = handler.getProductType(bp);
                    if (pt == null) continue;
                    this.getBookingContent().add(pt.name());
                }
            }
        }
        this.setGdsCurrency(prod.getGdsCurrency());
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("carrier", carrierReference);
        this.setRfisc(this.product.getRfisc());
        this.setErsp(this.product.getErsp());
        this.getManualFeeAppliedFlags().putAll(this.product.getManualFeeAppliedFlags());
        this.getManualCommissionAppliedFlags().putAll(this.product.getManualCommissionAppliedFlags());
        this.getManualDiscountAppliedFlags().putAll(this.product.getManualDiscountAppliedFlags());
        return result;
    }

    private String getM2AgreementCode(String tourCode) {
        int number;
        if (TextUtil.isBlank((String)tourCode)) {
            return null;
        }
        Matcher m2 = tchSpecialSchemePattern.matcher(tourCode);
        if (m2.find() && (number = Integer.parseInt(m2.group(1))) >= 51 && number <= 90) {
            return tourCode;
        }
        return null;
    }

    private String getTargetType(Product prod) {
        ProductCategory prCat = prod.getProductCategory();
        if (prCat == null) {
            return "";
        }
        switch (prCat) {
            case AIR: {
                return ProductCategory.AIR.name();
            }
            case MCO: {
                MCOCategory mcoCat = prod.getMcoCategory();
                if (mcoCat == null) {
                    return "";
                }
                if (mcoCat == MCOCategory.REBOOKING) {
                    return MCOCategory.PENALTY.name();
                }
                if (mcoCat == MCOCategory.EXCESS_LUGGAGE) {
                    return ProductCategory.EXCESS_BAGAGE.name();
                }
                if (mcoCat == MCOCategory.ADDITIONAL_SERVICES && this.tchTicket) {
                    return ProductCategory.AIR.name();
                }
                return mcoCat.name();
            }
            case KRS: {
                return ProductCategory.KRS.name();
            }
            case EXCESS_BAGAGE: {
                return ProductCategory.EXCESS_BAGAGE.name();
            }
        }
        return null;
    }

    private void updateClientPaymentTypes(Product prod) {
        for (ProductFop fop : AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prod), (ContractType)ContractType.CLIENT).getFops()) {
            if (fop.getType() == PaymentType.TICKET && prod.getPreviousProduct() != null) {
                this.updateClientPaymentTypes(prod.getPreviousProduct());
                continue;
            }
            if (fop.getType() == null) continue;
            this.getClientPaymentTypes().add(fop.getType().name());
        }
    }

    private void addCountryCodes(Set<String> codes, List<Address> addresses) {
        Country country;
        Address addr;
        Iterator<Address> iterator;
        CountryReference ref = null;
        if (addresses != null && (iterator = addresses.iterator()).hasNext() && (addr = iterator.next()).getCountry() != null) {
            ref = addr.getCountry();
        }
        if (ref == null) {
            ref = new CountryReference("RU");
        }
        if ((country = (Country)DictionaryCache.get().resolveReference(ref)) == null) {
            this.log.warn(String.format("unable to resolve country reference with code %s", ref.getCode()));
        } else {
            codes.addAll(country.getCodeVariants().values());
        }
    }

    private void updatePaymentTypes(Collection<ProductFop> fops, Product relatedProduct) {
        for (ProductFop fop : fops) {
            PaymentType paymentType = fop.getType();
            if (paymentType == null) continue;
            if (paymentType == PaymentType.TICKET && relatedProduct != null) {
                List relatedRelations = AirProductHelper.getContractRelations((Product)relatedProduct);
                List vendorFops = AirProductHelper.findContractRelation((List)relatedRelations, (ContractType)ContractType.VENDOR).getFops();
                List clientFops = AirProductHelper.findContractRelation((List)relatedRelations, (ContractType)ContractType.CLIENT).getFops();
                this.getPaymentTypes().add(paymentType.name());
                this.updatePaymentTypes(vendorFops.isEmpty() ? clientFops : vendorFops, relatedProduct.getPreviousProduct());
                continue;
            }
            this.getPaymentTypes().add(paymentType.name());
            this.getTCHPaymentTypes().add(this.getTchPaymentType(paymentType).name());
        }
    }

    private PaymentType getTchPaymentType(PaymentType type) {
        if (type == PaymentType.CREDIT_CARD_TCH) {
            return PaymentType.CASH;
        }
        return type;
    }

    private void applyTravelDuration(Product prod) {
        int duration = 0;
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment fs : st.getSegments()) {
                duration += fs.getFlightDuration() == null ? 0 : fs.getFlightDuration();
            }
        }
        this.setTravelDuration(duration);
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public void updateContractRelationData(AirProductContractRelationData contractRelation) {
        if (contractRelation.getServiceData().getTotalPrice() != null) {
            BigDecimal price = contractRelation.getServiceData().getTotalPrice();
            this.setPrice(price);
            this.setPriceCurrency(ContractRelationHelper.currencyCode((ContractRelationGeneralData)contractRelation.getGeneralData()));
        }
    }

    public List<CostCode> getCostCodes() {
        return StatisticsHelper.getAllCostCodes((StatisticalData)this.product.getStatisticalData());
    }

    public TicketType getTicketType() {
        return this.product.getTicketType();
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public boolean isTimeLimitFromSupplierReceived() {
        Reservation reservation = this.product.getReservation();
        return reservation != null && reservation.getPqTimeLimit() != null;
    }

    public boolean isTimeLimitFromSupplierAfterDeparture() {
        return this.product.getReservation().getPqTimeLimit().toInstant().atZone(ZoneId.systemDefault()).isAfter(DictHelper.getZonedDateTime((Date)this.getFirstSegmentDepartureDate(), this.getFirstSegmentDepartureLocation(), (boolean)false));
    }

    public String getSalesOriginProvider() {
        return this.salesOriginProvider;
    }

    public String getSalesOriginContent() {
        return this.salesOriginContent;
    }
}

