/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.RuleSettingsPropertySet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class RuleSettingsActionSet
implements Serializable {
    private static final long serialVersionUID = 2548597735058085713L;
    private final RuleProxy<RuleSettingsPropertySet, ?> proxy;
    private final RuleSettings ruleSettings;
    private final List<RuleResult> ruleResults = new ArrayList<RuleResult>();

    public RuleSettingsActionSet(RuleSettings rs, RuleProxy<RuleSettingsPropertySet, ?> aProxy) {
        this.proxy = aProxy;
        this.ruleSettings = rs;
        this.proxy.getTracer().traceLogic("initialized");
    }

    public void setReducedPercent(double value) {
        block0: for (RuleResult result : this.ruleSettings.getResults()) {
            if (!(result.getValue() instanceof RuleResultValue)) {
                this.proxy.getTracer().traceWarn("wrong type of result value", null);
                continue;
            }
            RuleResultValue rrv = (RuleResultValue)result.getValue();
            if (result.getAction() == Actions.SIMPLE_COMMISSION) {
                if (rrv.getCurrencyCode() != null && !"%".equals(rrv.getCurrencyCode())) {
                    this.proxy.getTracer().traceWarn("wrong currency code " + rrv.getCurrencyCode(), null);
                    continue;
                }
                if (rrv.getValue() < value) {
                    this.proxy.getTracer().traceWarn(String.format("current value %s is less than reduced %s", Double.toString(rrv.getValue()), Double.toString(value)), null);
                    continue;
                }
                RuleResultValue reducedValue = new RuleResultValue();
                reducedValue.setTarget(rrv.getTarget());
                reducedValue.setCurrencyCode("%");
                reducedValue.setValue(rrv.getValue() - value);
                RuleResult reducedResult = new RuleResult();
                reducedResult.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
                reducedResult.setValue((Object)reducedValue);
                this.proxy.getTracer().traceLogic(String.format("commission changed %s -> %s", Double.toString(rrv.getValue()), Double.toString(reducedValue.getValue())));
                this.ruleResults.add(reducedResult);
                continue;
            }
            if (result.getAction() != Actions.FOP_COMMISSION) continue;
            if (rrv.getFopValues() == null || rrv.getFopValues().length != 2) {
                this.proxy.getTracer().traceWarn("wrong value", null);
                continue;
            }
            LinkedHashSet<Double> oldPercents = new LinkedHashSet<Double>();
            LinkedHashSet<Double> newPercents = new LinkedHashSet<Double>();
            Double[][] doubleValues = (Double[][])rrv.getFopValues()[0];
            String[][] codes = (String[][])rrv.getFopValues()[1];
            Double[][] newValues = new Double[RulesHelper.paymentTypes.length][RulesHelper.targetTypes.length];
            for (int n = 0; n < RulesHelper.paymentTypes.length; ++n) {
                for (int m = 0; m < RulesHelper.targetTypes.length; ++m) {
                    if (codes[n][m] != null && !"%".equals(codes[n][m])) {
                        this.proxy.getTracer().traceWarn("wrong currency code", null);
                        continue block0;
                    }
                    if (doubleValues[n][m] == null && codes[n][m] != null) {
                        this.proxy.getTracer().traceWarn("wrong value", null);
                    }
                    if (doubleValues[n][m] < value) {
                        this.proxy.getTracer().traceWarn(String.format("current value %s is less than reduced %s", doubleValues[n][m].toString(), Double.toString(value)), null);
                        continue block0;
                    }
                    newValues[n][m] = doubleValues[n][m] - value;
                    oldPercents.add(doubleValues[n][m]);
                    newPercents.add(newValues[n][m]);
                }
            }
            this.proxy.getTracer().traceLogic(String.format("commission changed %s -> %s", oldPercents, newPercents));
            RuleResultValue reducedValue = new RuleResultValue();
            reducedValue.setTarget(rrv.getTarget());
            reducedValue.setFopValues(new Object[]{newValues, codes.clone()});
            RuleResult reducedResult = new RuleResult();
            reducedResult.setAction((RuleAction)Actions.FOP_COMMISSION);
            reducedResult.setValue((Object)reducedValue);
            this.ruleResults.add(reducedResult);
        }
    }

    public void updateResults() {
        this.ruleSettings.getResults().clear();
        this.ruleSettings.getResults().addAll(this.ruleResults);
    }
}

