/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentRegistry;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.InitializeFopProxy;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesFopHelper {
    private static final Logger log = LoggerFactory.getLogger(RulesFopHelper.class);
    private static ThreadLocal<FopInitData> fopInitData = new ThreadLocal<FopInitData>(){

        @Override
        protected FopInitData initialValue() {
            return new FopInitData();
        }
    };

    public static void setDefaultPayer(EntityReference<Organization> payer) {
        fopInitData.get().setPayer(payer);
    }

    public static void addFops(List<GeneralProductFop> fops, BigDecimal totalCommission, List<GeneralProductCommission> commissions, ContractType contractType, InitializeFopProxy initFopProxy) {
        ValueHolder ptHolder = new ValueHolder();
        ValueHolder feePtHolder = new ValueHolder();
        ValueHolder opDateHolder = new ValueHolder();
        ValueHolder agentHolder = new ValueHolder();
        ValueHolder payerHolder = new ValueHolder();
        ValueHolder cardHolder = new ValueHolder();
        RulesFopHelper.initializeFopParameters(initFopProxy, contractType == ContractType.CLIENT, fops, (ValueHolder<PaymentType>)ptHolder, (ValueHolder<PaymentType>)feePtHolder, (ValueHolder<Date>)opDateHolder, (ValueHolder<EntityReference<Person>>)agentHolder, (ValueHolder<Card>)cardHolder, (ValueHolder<EntityReference<Organization>>)payerHolder, FeeProperties.class, null, null);
        Date operationDate = (Date)opDateHolder.getValue();
        PaymentType paymentType = (PaymentType)feePtHolder.getValue();
        if (paymentType == null) {
            paymentType = (PaymentType)ptHolder.getValue();
            if (paymentType == PaymentType.CREDIT_CARD) {
                paymentType = PaymentType.CREDIT_CARD_AGENCY;
            } else if (paymentType == PaymentType.MTD || paymentType == null) {
                paymentType = PaymentType.CASH;
            }
        }
        EntityReference agent = (EntityReference)agentHolder.getValue();
        Card card = (Card)cardHolder.getValue();
        RulesFopHelper.addFops(fops, totalCommission, commissions, paymentType, operationDate, card, (EntityReference<Person>)agent, (EntityReference<Organization>)((EntityReference)payerHolder.getValue()));
    }

    public static boolean initializeFopParameters(InitializeFopProxy initFopProxy, boolean createPaymentDate, List<GeneralProductFop> fops, ValueHolder<PaymentType> ptHolder, ValueHolder<PaymentType> feePtHolder, ValueHolder<Date> opDateHolder, ValueHolder<EntityReference<Person>> agentHolder, ValueHolder<Card> cardHolder, ValueHolder<EntityReference<Organization>> payerHolder, Class<?> cls, Boolean supplierFees, List<GeneralProductCommission> prevCommissions) {
        for (GeneralProductFop generalProductFop : fops) {
            if (GeneralProductHelper.isServiceFop((GeneralProductFop)generalProductFop)) continue;
            for (GeneralProductCommission comm : generalProductFop.getCommissions()) {
                if (comm.getCommissionProperties() == null || !cls.equals(comm.getCommissionProperties().getType()) || supplierFees != null && prevCommissions != null && supplierFees != GeneralProductHelper.isSupplierFee((GeneralProductCommission)comm, prevCommissions)) continue;
                SplitPaymentSupport splitOrSupplierPaymentType = RulesFopHelper.isSplitOrSupplierPaymentType(generalProductFop.getType());
                if (splitOrSupplierPaymentType != null) {
                    feePtHolder.setValue((Object)splitOrSupplierPaymentType.getSplitAgencyPaymentType());
                } else {
                    feePtHolder.setValue((Object)generalProductFop.getType());
                }
                FopPaymentInfo fopPaymentInfo = createPaymentDate ? ProfileHelper.getFopPaymentInfo(initFopProxy.getSalesPoint(), (PaymentType)generalProductFop.getType()) : null;
                payerHolder.setValue((Object)generalProductFop.getPayer());
                if (fopPaymentInfo == null || fopPaymentInfo.isCreatePaymentDate()) {
                    opDateHolder.setValue((Object)generalProductFop.getOperationDate());
                    agentHolder.setValue((Object)generalProductFop.getAgent());
                } else {
                    opDateHolder.setValue(null);
                    agentHolder.setValue(null);
                }
                cardHolder.setValue((Object)generalProductFop.getCard());
                return true;
            }
        }
        GeneralProductFop productFop = null;
        if (initFopProxy.getProductStatus() == ProductStatus.SELL && initFopProxy.getPreviousProductStatus() == ProductStatus.EXCHANGE) {
            for (GeneralProductFop fop : fops) {
                if (fop.getType() == PaymentType.TICKET) continue;
                productFop = fop;
                break;
            }
        } else {
            GeneralProductFop generalProductFop = productFop = fops.isEmpty() ? null : fops.get(0);
        }
        if (productFop != null) {
            FopPaymentInfo fopPaymentInfo;
            SplitPaymentSupport splitPaymentSupport = RulesFopHelper.isSplitOrSupplierPaymentType(productFop.getType());
            if (splitPaymentSupport != null) {
                feePtHolder.setValue((Object)splitPaymentSupport.getSplitAgencyPaymentType());
            } else {
                ptHolder.setValue((Object)productFop.getType());
            }
            payerHolder.setValue((Object)productFop.getPayer());
            FopPaymentInfo fopPaymentInfo2 = fopPaymentInfo = createPaymentDate ? ProfileHelper.getFopPaymentInfo(initFopProxy.getSalesPoint(), (PaymentType)productFop.getType()) : null;
            if (fopPaymentInfo == null || fopPaymentInfo.isCreatePaymentDate()) {
                opDateHolder.setValue((Object)productFop.getOperationDate());
                agentHolder.setValue((Object)productFop.getAgent());
            } else {
                opDateHolder.setValue(null);
                agentHolder.setValue(null);
            }
            if (cardHolder.getValue() == null && productFop.getCard() != null) {
                try {
                    cardHolder.setValue((Object)XCloneHelper.clone((XCloneable)productFop.getCard(), (boolean)true));
                }
                catch (Exception e) {
                    log.error("unable to copy Card info", (Throwable)e);
                }
            }
        } else {
            payerHolder.setValue(fopInitData.get().getPayer());
        }
        return false;
    }

    private static SplitPaymentSupport isSplitOrSupplierPaymentType(PaymentType paymentType) {
        SplitPaymentSupport splitOrSupplierPaymentType = null;
        if (Environment.isPublished(SplitPaymentRegistry.class)) {
            SplitPaymentRegistry splitPaymentRegistry = (SplitPaymentRegistry)Environment.getPublished(SplitPaymentRegistry.class);
            splitOrSupplierPaymentType = splitPaymentRegistry.isSplitOrSupplierPaymentType(paymentType);
        }
        return splitOrSupplierPaymentType;
    }

    public static void addFops(List<GeneralProductFop> fops, BigDecimal totalCommission, List<GeneralProductCommission> commissions, PaymentType paymentType, Date operationDate, Card card, EntityReference<Person> agent, EntityReference<Organization> payer) {
        if (Math.abs(totalCommission.doubleValue()) <= 0.0) {
            return;
        }
        GeneralProductFop fop = new GeneralProductFop();
        fop.setType(paymentType);
        if (card != null) {
            fop.setCard(card);
        }
        fop.setOperationDate(operationDate);
        fop.setAgent(agent);
        fop.setEquivalentAmount(totalCommission);
        fop.setPayer(payer);
        fop.getCommissions().addAll(commissions);
        fops.add(fop);
    }

    public static class FopInitData {
        private EntityReference<Organization> payer;

        public EntityReference<Organization> getPayer() {
            return this.payer;
        }

        public void setPayer(EntityReference<Organization> payer) {
            this.payer = payer;
        }
    }
}

