/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.export.BaseCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseCommonExportSettings;
import com.gridnine.xtrip.common.model.export.BaseConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.model.export.BaseExportSettingsWithCommonSettingsRootEntityExportHandler;
import com.gridnine.xtrip.server.model.export.ConnectionHandler;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.export.standard.booking.ProductExportHandler;
import com.gridnine.xtrip.server.model.handlers.CommissionProxyHandler;
import com.gridnine.xtrip.server.model.handlers.DeleteEntityHandler;
import com.gridnine.xtrip.server.model.handlers.NomeclatureRulesHandler;
import com.gridnine.xtrip.server.model.handlers.ProductReferencesHandler;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistryConfigurator;
import com.gridnine.xtrip.server.model.handlers.clone.HotelProductUpdateHandler;
import com.gridnine.xtrip.server.model.handlers.finance.PaymentDocumentBillingTransactionsHandler;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import com.gridnine.xtrip.server.model.tasks.TaskProcessHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHandlersRegistry
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<TaskProcessHandler<?>>> taskProcessHandlers = new HashMap();
    private final Map<Class<?>, ProductBillingTransactionsHandler<?>> productBillingTransactionsHandlers = new HashMap();
    private final Map<Class<?>, PaymentDocumentBillingTransactionsHandler<?>> paymentDocumentBillingTransactionsHandlers = new HashMap();
    private final Map<String, RulesHandler> rulesHandlers = new HashMap<String, RulesHandler>();
    private final Map<Class<?>, StockControlProductHandler<?, ?, ?>> stockControlHandlers = new HashMap();
    private final Map<Class<?>, ExportHandler<?>> commonSettingsToExportHandlerMap = new LinkedHashMap();
    private final Map<Class<?>, ExportHandler<?>> settingsToExportHandlerMap = new LinkedHashMap();
    private final Map<Class<?>, ConnectionHandler<?, ?>> settingsToConnectionHandlersMap = new LinkedHashMap();
    private final Map<Class<?>, ConnectionHandler<?, ?>> commonSettingsToConnectionHandlersMap = new LinkedHashMap();
    private final Map<String, ProductValidationHandler<?>> productValidationHandlers = new HashMap();
    private final Map<String, CommissionProxyHandler<?, ?, ?>> rulesCommissionProxyHandlers = new HashMap();
    private final Map<String, NomeclatureRulesHandler<?>> nomenclatureRulesHandlers = new HashMap();
    private final Map<String, ProductReferencesHandler> productReferencesHandler = new HashMap<String, ProductReferencesHandler>();
    private final Map<String, DeleteEntityHandler<?>> deleteEntitiesHandlers = new HashMap();
    private final Map<Class<?>, List<CommonIndexHandler<?, ?, ?>>> commonIndexHandlers = new HashMap();
    private final Map<Class<?>, ProductExportHandler> productExportHandlers = new HashMap();
    private final Map<String, HotelProductUpdateHandler> hotelProductUpdateHandlers = new HashMap<String, HotelProductUpdateHandler>();

    public static ServerHandlersRegistry get() {
        return (ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class);
    }

    public void dispose() {
        this.taskProcessHandlers.clear();
        this.productBillingTransactionsHandlers.clear();
        this.paymentDocumentBillingTransactionsHandlers.clear();
        this.rulesHandlers.clear();
        this.stockControlHandlers.clear();
        this.commonSettingsToExportHandlerMap.clear();
        this.settingsToExportHandlerMap.clear();
        this.settingsToConnectionHandlersMap.clear();
        this.commonSettingsToConnectionHandlersMap.clear();
        this.nomenclatureRulesHandlers.clear();
        this.productReferencesHandler.clear();
        this.deleteEntitiesHandlers.clear();
        this.commonIndexHandlers.clear();
    }

    public <E extends BaseEntity, H extends TaskProcessHandler<E>> void registerTaskProcessHandler(H handler) {
        List<TaskProcessHandler<?>> registeredHandlers = this.taskProcessHandlers.get(handler.getId());
        if (registeredHandlers == null) {
            registeredHandlers = new ArrayList();
            this.taskProcessHandlers.put(handler.getId(), registeredHandlers);
        }
        registeredHandlers.add(handler);
        this.log.info(String.format("task process handler %s with id was successfully registered", handler.getClass(), handler.getId()));
    }

    public <E extends BaseEntity> List<TaskProcessHandler<E>> findTaskProcessHandler(String id) {
        ArrayList handlers = new ArrayList();
        if (this.taskProcessHandlers.containsKey(id)) {
            for (TaskProcessHandler<?> handler : this.taskProcessHandlers.get(id)) {
                handlers.add(handler);
            }
        }
        return handlers;
    }

    public <P extends BaseProduct, H extends NomeclatureRulesHandler<P>> void registerNomenclatureRulesHandler(H handler) {
        this.nomenclatureRulesHandlers.put(handler.getProductClass().getName(), handler);
        this.log.info(String.format("nomeclature rules handler handler %s fro class %s was successfully registered", handler.getClass(), handler.getProductClass().getName()));
    }

    public <P extends BaseProduct, H extends NomeclatureRulesHandler<P>> H findNomenclatureRulesHandler(Class<P> clazz) {
        return (H)this.nomenclatureRulesHandlers.get(clazz.getName());
    }

    public <E extends BaseEntity> DeleteEntityHandler<E> findDeleteEntitiesHandler(Class<E> type) {
        return this.deleteEntitiesHandlers.get(type.getName());
    }

    public void register(DeleteEntityHandler<?> handler) {
        this.deleteEntitiesHandlers.put(handler.getEntityClass().getName(), handler);
        this.log.info(String.format("registered delete entity handler %s for class %s", handler.getClass(), handler.getEntityClass().getName()));
    }

    public void register(ProductReferencesHandler handler) {
        this.productReferencesHandler.put(handler.getUid(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler.getClass(), handler.getUid()));
    }

    public Collection<ProductReferencesHandler> getAllProductReferencesHandlers() {
        return this.productReferencesHandler.values();
    }

    public <P extends BaseProduct, H extends ProductBillingTransactionsHandler<P>> void registerProductBillingTransactionHandler(H handler) {
        ProductBillingTransactionsHandler<?> registeredHandler = this.productBillingTransactionsHandlers.get(handler.getProductClass());
        if (registeredHandler != null) {
            this.log.warn(String.format("product billing transaction handler for product of type %s was already registered", handler.getProductClass()));
            return;
        }
        this.productBillingTransactionsHandlers.put(handler.getProductClass(), handler);
        this.log.info(String.format("product billing transaction handler for product of type %s was successfully registered", handler.getProductClass()));
    }

    public <P extends BaseProduct> ProductBillingTransactionsHandler<P> findProductBillingTransactionHandler(Class<? extends P> productCls) {
        return this.productBillingTransactionsHandlers.get(productCls);
    }

    public Collection<ProductBillingTransactionsHandler<?>> getAllProductBillingTransactionHandlers() {
        return this.productBillingTransactionsHandlers.values();
    }

    public <P extends BaseProduct> void unregisterProductBillingTransactionHandler(Class<P> productCls) {
        ProductBillingTransactionsHandler<?> registeredHandler = this.productBillingTransactionsHandlers.get(productCls);
        if (registeredHandler == null) {
            this.log.warn(String.format("product billing transaction handler for product of type %s is not yet registered", productCls));
            return;
        }
        this.productBillingTransactionsHandlers.remove(productCls);
        this.log.info(String.format("product billing transaction handler for product of type %s was successfully unregistered", productCls));
    }

    public <P extends BasePaymentDocument, H extends PaymentDocumentBillingTransactionsHandler<P>> void registerPaymentDocumentBillingTransactionHandler(H handler) {
        PaymentDocumentBillingTransactionsHandler<?> registeredHandler = this.paymentDocumentBillingTransactionsHandlers.get(handler.getDocumentClass());
        if (registeredHandler != null) {
            this.log.warn(String.format("payment document billing transaction handler for document of type %s was already registered", handler.getDocumentClass()));
            return;
        }
        this.paymentDocumentBillingTransactionsHandlers.put(handler.getDocumentClass(), handler);
        this.log.info(String.format("payment document billing transaction handler for document of type %s was successfully registered", handler.getDocumentClass()));
    }

    public <P extends BasePaymentDocument> PaymentDocumentBillingTransactionsHandler<P> findPaymentDocumentBillingTransactionHandler(Class<P> documentCls) {
        return this.paymentDocumentBillingTransactionsHandlers.get(documentCls);
    }

    public Collection<PaymentDocumentBillingTransactionsHandler<?>> getAllPaymentDocumentBillingTransactionHandlers() {
        return this.paymentDocumentBillingTransactionsHandlers.values();
    }

    public <P extends BasePaymentDocument> void unregisterPaymentDocumentBillingTransactionHandler(Class<P> documentCls) {
        PaymentDocumentBillingTransactionsHandler<?> registeredHandler = this.paymentDocumentBillingTransactionsHandlers.get(documentCls);
        if (registeredHandler == null) {
            this.log.warn(String.format("payment document billing transaction handler for document of type %s is not yet registered", documentCls));
            return;
        }
        this.paymentDocumentBillingTransactionsHandlers.remove(documentCls);
        this.log.info(String.format("payment document billing transaction handler for document of type %s was successfully unregistered", documentCls));
    }

    public void registerRulesHandler(RulesHandler handler) {
        RulesHandler registeredHandler = this.rulesHandlers.get(handler.getId());
        if (registeredHandler != null) {
            this.log.warn(String.format("rules handler with id %s was already registered", handler.getId()));
            return;
        }
        this.rulesHandlers.put(handler.getId(), handler);
        this.log.info(String.format("rules handler with id %s was successfully registered", handler.getId()));
    }

    public void unregisterRulesHandler(String id) {
        RulesHandler registeredHandler = this.rulesHandlers.remove(id);
        if (registeredHandler != null) {
            this.log.info(String.format("rules handler with id %s was successfully unregistered", id));
        }
    }

    public Collection<RulesHandler> getAllRulesHandlers() {
        return Collections.unmodifiableCollection(this.rulesHandlers.values());
    }

    public <P extends BaseProduct, I extends EntityIndex<BookingFile>, F extends Fop, H extends StockControlProductHandler<P, I, F>> void registerStockControlHandler(H handler) {
        StockControlProductHandler<?, ?, ?> registeredHandler = this.stockControlHandlers.get(handler.getProductClass());
        if (registeredHandler != null) {
            this.log.warn(String.format("stock control handler for product of type %s was already registered", handler.getProductClass()));
            return;
        }
        this.stockControlHandlers.put(handler.getProductClass(), handler);
        this.log.info(String.format("stock control handler for product of type %s was successfully registered", handler.getProductClass()));
    }

    public <P extends BaseProduct, I extends EntityIndex<BookingFile>, F extends Fop> StockControlProductHandler<P, I, F> findStockControlHandler(Class<P> productCls) {
        return this.stockControlHandlers.get(productCls);
    }

    public <P extends BaseProduct> void unregisterStockControlHandler(Class<P> productCls) {
        StockControlProductHandler<?, ?, ?> registeredHandler = this.stockControlHandlers.get(productCls);
        if (registeredHandler == null) {
            this.log.warn(String.format("stock control handler for product of type %s is not yet registered", productCls));
            return;
        }
        this.stockControlHandlers.remove(productCls);
        this.log.info(String.format("stock control handler for product of type %s was successfully unregistered", productCls));
    }

    public Collection<StockControlProductHandler<?, ?, ?>> getAllStockControlHandlers() {
        return Collections.unmodifiableCollection(this.stockControlHandlers.values());
    }

    public <S extends BaseExportSettings> void registerExportHandler(ExportHandler<S> handler) {
        ExportHandler<?> registeredHandler = this.settingsToExportHandlerMap.get(handler.getSettingsClass());
        if (registeredHandler != null) {
            this.log.warn(String.format("export handler for settings %s was already registered", handler.getSettingsClass()));
            return;
        }
        this.settingsToExportHandlerMap.put(handler.getSettingsClass(), handler);
        if (handler instanceof BaseExportSettingsWithCommonSettingsRootEntityExportHandler) {
            this.commonSettingsToExportHandlerMap.put(((BaseExportSettingsWithCommonSettingsRootEntityExportHandler)handler).getCommonSettingsClass(), handler);
        }
        this.log.info(String.format("export handler for settings of type %s was successfully registered", handler.getSettingsClass()));
    }

    public <S extends BaseExportSettings> ExportHandler<S> findExportHandlerBySettings(Class<S> cls) {
        return this.settingsToExportHandlerMap.get(cls);
    }

    public <S extends BaseExportSettings, C extends BaseCommonExportSettings> ExportHandler<S> findExportHandlerByCommonSettings(Class<C> cls) {
        return this.commonSettingsToExportHandlerMap.get(cls);
    }

    public <E extends BaseExportSettings> void unregisterExportHandler(Class<E> cls) {
        ExportHandler<?> registeredHandler = this.settingsToExportHandlerMap.get(cls);
        if (registeredHandler == null) {
            this.log.warn(String.format("export handler for settings of type %s is not registered yet", cls));
            return;
        }
        this.settingsToExportHandlerMap.remove(cls);
        if (registeredHandler instanceof BaseExportSettingsWithCommonSettingsRootEntityExportHandler) {
            this.commonSettingsToExportHandlerMap.remove(((BaseExportSettingsWithCommonSettingsRootEntityExportHandler)registeredHandler).getCommonSettingsClass());
        }
        this.log.info(String.format("export handler for settings of type %s was successfully unregistered", cls));
    }

    public <S extends BaseConnectionSettings, C extends BaseCommonConnectionSettings> ConnectionHandler<S, C> findConnectionHandlerBySettings(Class<S> cls) {
        return this.settingsToConnectionHandlersMap.get(cls);
    }

    public <S extends BaseConnectionSettings, C extends BaseCommonConnectionSettings> ConnectionHandler<S, C> findConnectionHandlerByCommonSettings(Class<C> cls) {
        return this.commonSettingsToConnectionHandlersMap.get(cls);
    }

    public <E extends BaseConnectionSettings> void unregisterConnectionHandler(Class<E> cls) {
        ConnectionHandler<?, ?> registeredHandler = this.settingsToConnectionHandlersMap.get(cls);
        if (registeredHandler == null) {
            this.log.warn(String.format("connection handler for settings of type %s is not registered yet", cls));
            return;
        }
        this.settingsToConnectionHandlersMap.remove(cls);
        this.commonSettingsToConnectionHandlersMap.remove(registeredHandler.getCommonSettingsClass());
        this.log.info(String.format("connection handler for settings of type %s was successfully unregistered", cls));
    }

    public <S extends BaseConnectionSettings, C extends BaseCommonConnectionSettings> void registerConnectiontHandler(ConnectionHandler<S, C> handler) {
        ConnectionHandler<?, ?> registeredHandler = this.settingsToConnectionHandlersMap.get(handler.getSettingsClass());
        if (registeredHandler != null) {
            this.log.warn(String.format("connection handler for settings %s was already registered", handler.getSettingsClass()));
            return;
        }
        this.settingsToConnectionHandlersMap.put(handler.getSettingsClass(), handler);
        this.commonSettingsToConnectionHandlersMap.put(handler.getCommonSettingsClass(), handler);
        this.log.info(String.format("connection handler for settings of type %s was successfully registered", handler.getSettingsClass()));
    }

    public void executeStandardConfigurators() {
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server.model", (String)"ServerHandlersRegistryConfigurator")) {
            try {
                ((ServerHandlersRegistryConfigurator)JpfUtil.getClass((Extension)ext).newInstance()).configure(this);
            }
            catch (Exception e) {
                this.log.error("failed executing registry configurator from extension " + ext, (Throwable)e);
            }
        }
    }

    public void register(ProductValidationHandler<?> handler) {
        if (this.productValidationHandlers.containsKey(handler.getProductClass().getName())) {
            this.log.warn(String.format("validation handler %s with id %s already registered", handler, handler.getProductClass().getName()));
            return;
        }
        this.productValidationHandlers.put(handler.getProductClass().getName(), handler);
        this.log.info(String.format("registered validation handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public void unregister(ProductValidationHandler<?> handler) {
        this.productValidationHandlers.remove(handler.getProductClass().getName());
        this.log.info(String.format("unregistered validation handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public <P extends BaseProduct> ProductValidationHandler<P> findProductValidationHandler(Class<? extends P> cls) {
        return this.productValidationHandlers.get(cls.getName());
    }

    public Collection<ProductValidationHandler<?>> getAllProductValidationHandlers() {
        return this.productValidationHandlers.values();
    }

    public <T extends BaseProduct, P, A> CommissionProxyHandler<T, P, A> getCommissionProxyHandler(Class<T> clazz) {
        return this.rulesCommissionProxyHandlers.get(clazz.getName());
    }

    public <T extends BaseProduct, P, A> void register(CommissionProxyHandler<T, P, A> handler) {
        this.rulesCommissionProxyHandlers.put(handler.getProductClass().getName(), handler);
    }

    public void unregisterCommissionProxyHandler(Class<?> handlerClass) {
        this.rulesCommissionProxyHandlers.entrySet().removeIf(e -> handlerClass.getName().equals(((CommissionProxyHandler)e.getValue()).getClass().getName()));
    }

    public <E extends BaseEntity, R extends BaseEntity, I extends EntityIndex<R>, H extends CommonIndexHandler<E, R, I>> void registerCommonIndexHandler(H handler) {
        this.commonIndexHandlers.computeIfAbsent(handler.getCommonIndexClass(), key -> new ArrayList()).add(handler);
        this.log.info(String.format("common product index handler %s with index class %s was successfully registered", handler.getClass(), handler.getCommonIndexClass()));
    }

    public <E extends BaseEntity, R extends BaseEntity, I extends EntityIndex<R>> List<CommonIndexHandler<E, R, I>> findCommonIndexHandlers(Class<I> type) {
        ArrayList handlers = new ArrayList();
        if (this.commonIndexHandlers.containsKey(type)) {
            for (CommonIndexHandler<?, ?, ?> handler : this.commonIndexHandlers.get(type)) {
                handlers.add(handler);
            }
        }
        return handlers;
    }

    public void register(ProductExportHandler handler) {
        ProductExportHandler registeredHandler = this.productExportHandlers.get(handler.getProductExportClass());
        if (registeredHandler != null) {
            this.log.warn(String.format("product export handler for class %s was already registered", handler.getProductExportClass()));
            return;
        }
        this.productExportHandlers.put(handler.getProductExportClass(), handler);
        this.log.info(String.format("product export handler for class %s was successfully registered", handler.getProductExportClass()));
    }

    public void unregisterProductExportHandler(Class<? extends BaseEntityExport> cls) {
        ProductExportHandler registeredHandler = this.productExportHandlers.get(cls);
        if (registeredHandler == null) {
            this.log.warn(String.format("product export handler for class %s is not registered yet", cls));
            return;
        }
        this.productExportHandlers.remove(cls);
        this.log.info(String.format("product export handler for class %s was successfully unregistered", cls));
    }

    public Collection<ProductExportHandler> getAllProductExportHandlers() {
        return this.productExportHandlers.values();
    }

    public void register(HotelProductUpdateHandler handler) {
        HotelProductUpdateHandler registeredHandler = this.hotelProductUpdateHandlers.get(handler.getId());
        if (registeredHandler != null) {
            this.log.warn(String.format("hotel product update handler with id %s was already registered", handler.getId()));
            return;
        }
        this.hotelProductUpdateHandlers.put(handler.getId(), handler);
        this.log.info(String.format("hotel product update handler with id %s was successfully registered", handler.getId()));
    }

    public void unregister(HotelProductUpdateHandler handler) {
        this.hotelProductUpdateHandlers.remove(handler.getId());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getId()));
    }

    public Collection<HotelProductUpdateHandler> getAllHotelProductUpdateHandlers() {
        return this.hotelProductUpdateHandlers.values();
    }
}

