/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.OnCreateFopListener;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TaxiProductPropertiesProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.PayersCollector;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TaxiProductPropertySet
implements TaxiProductPropertiesProvider {
    private final RuleProxy<TaxiProductPropertySet, ?> proxy;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> departureLocations = new HashSet<String>();
    private final Set<String> arriveLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    protected TaxiProduct product;
    private String gdsName;
    private BigDecimal equivalentSum;
    private EntityReference<Organization> supplier;
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();
    private final Collection<EntityReference<Person>> travellers = new ArrayList<EntityReference<Person>>();
    private final Set<String> clientPaymentTypes = new HashSet<String>();
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private String agencyCode;
    final List<CostCode> costCodes = new ArrayList<CostCode>();
    private String clientCreditCardVendor;
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;

    public TaxiProductPropertySet(RuleProxy<TaxiProductPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(TaxiProduct ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            this.product = ticket;
            this.agent = ticket.getAgent();
            this.bookingAgent = ticket.getReservation().getBookingAgent();
            this.client = ticket.getReservation().getBookingFile().getCustomerProfile();
            this.agencyCode = CommonProductHelper.getAgencyCode(ticket);
            this.supplier = TaxiHelper.getSupplier((TaxiProduct)ticket);
            this.gdsName = Optional.ofNullable(CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)this.product.getReservation())).map(Enum::name).orElse(null);
            CommonProductHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference<Organization>)GeneralProductHelper.getSubagency((BaseProduct)ticket));
            if (this.product.getEquivalentFare() != null) {
                this.equivalentSum = this.product.getEquivalentFare().getValue();
            }
            this.payers.addAll(PayersCollector.collect(this.product));
            this.departureLocations.clear();
            this.arriveLocations.clear();
            this.visitedCities.clear();
            Set<String> geoCodes = this.collectGeoCodes((DictionaryReference<GeoLocation>)this.product.getCity());
            this.departureLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[0]));
            HandlersRegistry.get().findProductHandler(TaxiProduct.class).getTravellers((BaseProduct)this.product).stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.travellers::add);
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)this.product));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
            GeneralProductHelper.getClientFops((BaseProduct)ticket).forEach(fop -> {
                String enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (StringUtils.isNotBlank((String)enumName)) {
                    this.clientPaymentTypes.add(enumName);
                }
            });
            if (this.clientPaymentTypes.isEmpty() && !GeneralProductHelper.getHandler((BaseProduct)this.product).isFareFopsRelevant((BaseProduct)this.product)) {
                String enumName;
                PaymentType paymentType = OnCreateFopListener.getDefaultPaymentType((BaseProduct)this.product, (ContractType)ContractType.CLIENT);
                if (null == paymentType) {
                    paymentType = PaymentType.CASH;
                }
                if (TextUtil.nonBlank((String)(enumName = RulesHelper.getEnumName((Enum)paymentType)))) {
                    this.clientPaymentTypes.add(enumName);
                }
            }
            ProductHandler productHandler = ProductHandler.of((BaseProduct)this.product);
            this.setTravelSubject(productHandler.findTravelSubject((BaseProduct)this.product));
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)this.product));
            productHandler.getTravellers((BaseProduct)this.product).stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.travellers::add);
            this.costCodes.addAll(StatisticsHelper.getAllCostCodes((StatisticalData)this.product.getStatisticalData()));
            this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor(this.product);
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public DictionaryReference<CarClass> getCarClass() {
        return this.product.getCarClass();
    }

    public BigDecimal getEquivalentSum() {
        return this.equivalentSum;
    }

    public TaxiProduct getProduct() {
        return this.product;
    }

    public Date getDepartureDate() {
        return this.product.getFinishDate();
    }

    public Set<String> getArrivalLocations() {
        return this.arriveLocations;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public String getGdsName() {
        return Optional.ofNullable(this.product.getReservation()).map(CommonReservationGdsNameInfoHelper::getRulesGdsName).map(Enum::name).orElse(null);
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public Money getEquivalentFare() {
        return this.product.getEquivalentFare();
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.product.getBlankOwner();
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    private Set<String> collectGeoCodes(DictionaryReference<GeoLocation> geoLocRef) {
        if (geoLocRef == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(RulesHelper.collectGeoCodes(Collections.singleton(geoLocRef.getCode()), (boolean)true));
    }

    public EntityReference<Person> getTicketingAgent() {
        return this.agent;
    }

    public EntityReference<SalesPoint> getSalesPoint() {
        return this.product.getSalesPoint();
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return null;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public TicketType getTicketType() {
        return this.product.getTicketType();
    }

    public Collection<EntityReference<Person>> getTravellers() {
        return this.travellers;
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public List<CostCode> getCostCodes() {
        return this.costCodes;
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public Set<String> getClientPaymentTypes() {
        return this.clientPaymentTypes;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }

    public void setTravelSubject(TravelSubject travelSubject) {
        this.travelSubject = travelSubject;
    }

    public Set<String> getPassengerTypeCategories() {
        return Collections.emptySet();
    }
}

