/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.TransferPropertySet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class TransferActionSet
extends GeneralProductCommissionActionSet {
    public TransferActionSet(RuleProxy<TransferPropertySet, TransferActionSet> proxy, Transfer ticket) {
        super(proxy, (BaseProduct)ticket, TransferActionSet.createHandler(ticket));
    }

    public TransferActionSet(RuleProxy<TransferPropertySet, TransferActionSet> proxy, Transfer ticket, GeneralProductCommissionActionSet.CommissionActionProxy cProxy) {
        super(proxy, (BaseProduct)ticket, cProxy);
    }

    protected static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final Transfer ticket) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            @Override
            public boolean isOneWayTicket() {
                return true;
            }

            @Override
            public int getSegmentTariffsCount() {
                return 0;
            }

            @Override
            public Set<String> getPaymentTypes() {
                return null;
            }

            @Override
            public String getTargetType() {
                return "TICKET";
            }

            @Override
            public Date getIssueDate() {
                return ticket.getIssueDate();
            }

            @Override
            public int getSegmentsCount() {
                return 1;
            }

            @Override
            public TicketType getTicketType() {
                return ticket.getTicketType();
            }

            @Override
            public List<ValidationMessage> getValidationMessages() {
                return ticket.getValidationMessages();
            }

            @Override
            public boolean isForcedRefund() {
                return true;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return ticket.getPreviousProduct() != null ? TransferActionSet.createHandler(ticket.getPreviousProduct()) : null;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return ticket.getNextProduct() != null ? TransferActionSet.createHandler(ticket.getNextProduct()) : null;
            }

            @Override
            public ProductType getProductType() {
                return ProductType.TRANSFER;
            }

            @Override
            public ProductStatus getStatus() {
                return ticket.getStatus();
            }

            @Override
            public EntityReference<SalesPoint> getSalesPoint() {
                return ticket.getSalesPoint();
            }

            @Override
            public BigDecimal getAdditionalFare() {
                return null;
            }

            @Override
            public int getTravellersCount() {
                return ticket.getTravellers().size();
            }
        };
    }
}

