/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAviaMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPriceWithSource;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TravelPolicyProductPropertySet
extends ProductPropertySet
implements TravelPolicyPropertiesProvider {
    private final Set<EntityReference<Person>> persons = new HashSet<EntityReference<Person>>();
    private BigDecimal clientTotal;
    private Map<EntityReference<TravelPolicyAviaMinimalPriceProperties>, BigDecimal> minimals;
    private String clientCurrency;
    private TravelPolicyMatchType matchType;

    public TravelPolicyProductPropertySet(RuleProxy<? extends ProductPropertySet, ?> ruleProxy) {
        super(ruleProxy);
    }

    @Override
    public void init(Product product) throws Exception {
        super.init(product);
        ProductHandler.of((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.persons::add);
        this.clientTotal = BookingHelper.getTotalPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        this.minimals = product.getTravelPolicyMinimalPrices().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TravelPolicyMinimalPriceWithSource)e.getValue()).getPrice()));
        DictionaryReference currency = GeneralProductHelper.getCurrency((BaseContractRelationData)GeneralProductHelper.getContractRelation((BaseProduct)product, (ContractType)ContractType.CLIENT));
        this.clientCurrency = DictHelper.getCode((DictionaryReference)currency);
    }

    public Set<EntityReference<Person>> getPersons() {
        return this.persons;
    }

    public BigDecimal getClientTotal() {
        return this.clientTotal;
    }

    public BigDecimal getMinimal(EntityReference<BaseTravelPolicyMinimalPriceProperties> propsRef) {
        return this.minimals.get(propsRef);
    }

    public String getClientCurrency() {
        return this.clientCurrency;
    }

    public void setMatchType(TravelPolicyMatchType matchType) {
        this.matchType = matchType;
    }

    public TravelPolicyMatchType getMatchType() {
        return this.matchType;
    }
}

