/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.TransferPropertySet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class TravelPolicyTransferPropertySet
extends TransferPropertySet
implements TravelPolicyPropertiesProvider {
    private final Set<EntityReference<Person>> persons = new HashSet<EntityReference<Person>>();
    private BigDecimal clientTotal;
    private String clientCurrency;
    private TravelPolicyMatchType matchType;

    public TravelPolicyTransferPropertySet(RuleProxy<? extends TransferPropertySet, ?> aProxy) {
        super(aProxy);
    }

    @Override
    public void init(Transfer ticket) {
        super.init(ticket);
        ProductHandler.of((BaseProduct)ticket).getTravellers((BaseProduct)ticket).stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.persons::add);
        this.clientTotal = BookingHelper.getTotalPrice((BaseProduct)ticket, (ContractType)ContractType.CLIENT);
        DictionaryReference currency = GeneralProductHelper.getCurrency((BaseContractRelationData)GeneralProductHelper.getContractRelation((BaseProduct)this.product, (ContractType)ContractType.CLIENT));
        this.clientCurrency = DictHelper.getCode((DictionaryReference)currency);
    }

    public Collection<EntityReference<Person>> getPersons() {
        return this.persons;
    }

    public BigDecimal getClientTotal() {
        return this.clientTotal;
    }

    public BigDecimal getMinimal(EntityReference<BaseTravelPolicyMinimalPriceProperties> propsRef) {
        throw new UnsupportedOperationException();
    }

    public String getClientCurrency() {
        return this.clientCurrency;
    }

    public void setMatchType(TravelPolicyMatchType matchType) {
        this.matchType = matchType;
    }

    public TravelPolicyMatchType getMatchType() {
        return this.matchType;
    }
}

