/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.UniversalProductPropertySet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class UniversalProductActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = -5539057801992324819L;

    public UniversalProductActionSet(RuleProxy<UniversalProductPropertySet, UniversalProductActionSet> proxy, UniversalProductPropertiesProvider propertySet, UniversalProduct ticket) {
        super(proxy, (BaseProduct)ticket, UniversalProductActionSet.createHandler(ticket, propertySet));
    }

    private static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final UniversalProduct ticket, final UniversalProductPropertiesProvider propertySet) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            @Override
            public boolean isOneWayTicket() {
                return true;
            }

            @Override
            public boolean isForcedRefund() {
                return ticket.isForcedRefund();
            }

            @Override
            public List<ValidationMessage> getValidationMessages() {
                return ticket.getValidationMessages();
            }

            @Override
            public TicketType getTicketType() {
                return ticket.getTicketType();
            }

            @Override
            public BigDecimal getAdditionalFare() {
                return null;
            }

            @Override
            public String getTargetType() {
                return "TICKET";
            }

            @Override
            public ProductStatus getStatus() {
                return ticket.getStatus();
            }

            @Override
            public int getSegmentsCount() {
                return 0;
            }

            @Override
            public ProductType getProductType() {
                return ProductType.MISC_PRODUCT;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return ticket.getPreviousProduct() != null ? UniversalProductActionSet.createHandler(ticket.getPreviousProduct(), propertySet) : null;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return ticket.getNextProduct() != null ? UniversalProductActionSet.createHandler(ticket.getNextProduct(), propertySet) : null;
            }

            @Override
            public Set<String> getPaymentTypes() {
                return propertySet.getClientPaymentTypes();
            }

            @Override
            public Date getIssueDate() {
                return ticket.getIssueDate();
            }

            @Override
            public EntityReference<SalesPoint> getSalesPoint() {
                return ticket.getSalesPoint();
            }

            @Override
            public int getSegmentTariffsCount() {
                return 0;
            }

            @Override
            public int getTravellersCount() {
                return ticket.getTravellersUids().size();
            }
        };
    }
}

