/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductPropertySet
implements Serializable,
UniversalProductPropertiesProvider {
    private static final long serialVersionUID = -8985413423795263409L;
    private static final Logger log = LoggerFactory.getLogger(UniversalProductPropertySet.class);
    private static final CollectionUtil.Equator<UniversalProductCustomParameterDescription, String> equator = (o1, o2) -> o1.getId().equals(o2);
    private final Set<String> salesPointCountryCodes = new HashSet<String>();
    private boolean forcedRefund;
    private String salesPointUid;
    private Date issueDate;
    private String pnr;
    private ProductStatus productStatus;
    private boolean eticket;
    private double fare;
    private double total;
    private final Set<String> vendorPaymentTypes = new HashSet<String>();
    private final Set<String> clientPaymentTypes = new HashSet<String>();
    private final RuleProxy<UniversalProductPropertySet, ?> proxy;
    private String gdsName;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> supplier;
    private boolean hasVat;
    private final Map<String, Object> customParameters = new LinkedHashMap<String, Object>();
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);

    public UniversalProductPropertySet(RuleProxy<UniversalProductPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(UniversalProduct ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            String enumName;
            block14: {
                List parameters = ((UniversalProductDescription)EntityStorage.get().resolve(ticket.getDescription()).getEntity()).getCustomParameters();
                this.bookingAgent = ticket.getReservation().getBookingAgent();
                this.supplier = UniversalProductHelper.getSupplier((UniversalProduct)ticket);
                for (Object item : ticket.getCustomParameters()) {
                    GeoLocation loc;
                    GeoLocationReference ref;
                    Set values;
                    String id = item.getId();
                    UniversalProductCustomParameterDescription descr = (UniversalProductCustomParameterDescription)CollectionUtil.find((Collection)parameters, (Object)id, equator);
                    if (GeoLocation.class.getName().equals(descr.getTypeAdditionalInfo())) {
                        values = Collections.emptySet();
                        ref = (GeoLocationReference)item.getValue();
                        loc = (GeoLocation)DictionaryCache.get().resolveReference((DictionaryReference)ref);
                        if (loc != null) {
                            values = RulesHelper.collectGeoCodes(Collections.singleton(ref.getCode()), (boolean)true);
                        }
                        this.customParameters.put(id, values);
                        continue;
                    }
                    if (Country.class.getName().equals(descr.getTypeAdditionalInfo())) {
                        values = new LinkedHashSet();
                        ref = (CountryReference)item.getValue();
                        loc = (Country)DictionaryCache.get().resolveReference((DictionaryReference)ref);
                        if (loc != null) {
                            values.add(ref.getCode());
                            values.addAll(RulesHelper.collectCountryCodes((Country)loc));
                        }
                        this.customParameters.put(id, values);
                        continue;
                    }
                    this.customParameters.put(id, item.getValue());
                }
                try {
                    EntityContainer spCtr = EntityStorage.get().resolve(ticket.getSalesPoint());
                    if (spCtr == null) break block14;
                    this.salesPointUid = spCtr.getUid();
                    for (Address addr : ((SalesPoint)spCtr.getEntity()).getAddresses()) {
                        Country country = (Country)DictionaryCache.get().resolveReference(addr.getCountry());
                        if (country == null) continue;
                        this.salesPointCountryCodes.addAll(country.getCodeVariants().values());
                        break;
                    }
                }
                catch (Exception e) {
                    log.error("unable to resolve salesPoint " + ticket.getSalesPoint(), (Throwable)e);
                }
            }
            if (this.salesPointCountryCodes.isEmpty()) {
                this.salesPointCountryCodes.add("RU");
                this.salesPointCountryCodes.add("\u0420\u0424");
            }
            this.gdsName = Optional.ofNullable(ticket.getReservation()).map(CommonReservationGdsNameInfoHelper::getRulesGdsName).map(Enum::name).orElse(null);
            this.forcedRefund = ticket.isForcedRefund();
            this.issueDate = ticket.getIssueDate();
            this.pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)ticket.getReservation());
            this.productStatus = ticket.getStatus();
            this.eticket = ticket.isEticket();
            this.fare = RulesHelper.getDoubleValue((BigDecimal)ticket.getEquivalentFare());
            this.total = RulesHelper.getDoubleValue((BigDecimal)GeneralProductHelper.getEquivalentTaxAmount((Collection)ticket.getTaxes()).add(ticket.getEquivalentFare() == null ? BigDecimal.ZERO : ticket.getEquivalentFare()));
            for (GeneralProductFop fop : UniversalProductHelper.getVendorFops((UniversalProduct)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.vendorPaymentTypes.add(enumName);
            }
            for (GeneralProductFop fop : UniversalProductHelper.getClientFops((UniversalProduct)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.clientPaymentTypes.add(enumName);
            }
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)ticket));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
            this.hasVat = ticket.isHasVat();
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public Set<String> getSalesPointCountryCodes() {
        return this.salesPointCountryCodes;
    }

    public boolean isForcedRefund() {
        return this.forcedRefund;
    }

    public String getSalesPointUid() {
        return this.salesPointUid;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getPnr() {
        return this.pnr;
    }

    public ProductStatus getProductStatus() {
        return this.productStatus;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public double getFare() {
        return this.fare;
    }

    public double getTotal() {
        return this.total;
    }

    public Set<String> getVendorPaymentTypes() {
        return this.vendorPaymentTypes;
    }

    public Set<String> getClientPaymentTypes() {
        return this.clientPaymentTypes;
    }

    public RuleProxy<UniversalProductPropertySet, ?> getProxy() {
        return this.proxy;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public boolean isHasVat() {
        return this.hasVat;
    }

    public Map<String, Object> getCustomParameters() {
        return this.customParameters;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }
}

