/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.visa.VisaType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.VisaProductPropertiesProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VisaProductPropertySet
implements VisaProductPropertiesProvider,
ClientCreditCardVendorProvider {
    private final RuleProxy<VisaProductPropertySet, ?> proxy;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    private VisaProduct product;
    private String entryTypeName;
    private EntityReference<Organization> supplier;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<Collection<DictionaryReference<GeoRegion>>> regions = new LazyValueHolder(Collections::emptyList);
    private String clientCreditCardVendor;
    private String agencyCode;
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;

    public VisaProductPropertySet(RuleProxy<VisaProductPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    public void init(VisaProduct ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            this.product = ticket;
            this.agent = ticket.getAgent();
            this.bookingAgent = ticket.getReservation().getBookingAgent();
            this.client = ticket.getReservation().getBookingFile().getCustomerProfile();
            this.agencyCode = CommonProductHelper.getAgencyCode(ticket);
            CommonProductHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference<Organization>)VisaProductHelper.getSubagency((VisaProduct)ticket));
            this.setTravelSubject(ProductHandler.of((BaseProduct)this.product).findTravelSubject((BaseProduct)this.product));
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)this.product));
            this.entryTypeName = this.product.getEntryType() == null ? null : this.product.getEntryType().name();
            this.supplier = VisaProductHelper.getSupplier((VisaProduct)this.product);
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)this.product));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.regions.setSupplier(() -> {
                Country country = (Country)DictionaryCache.get().resolveReference(this.product.getCountry());
                return country != null ? country.getRegions() : Collections.emptyList();
            });
            this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor(ticket);
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public Set<String> getSubagencyCodes() {
        return null;
    }

    public Set<String> getProfileGroups() {
        return null;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public VisaProduct getProduct() {
        return this.product;
    }

    public Money getEquivalentFare() {
        return this.product.getEquivalentFare();
    }

    public DictionaryReference<Country> getCountry() {
        return this.product.getCountry();
    }

    public Collection<DictionaryReference<GeoRegion>> getRegions() {
        return (Collection)this.regions.get();
    }

    public DictionaryReference<VisaType> getType() {
        return this.product.getType();
    }

    public String getEntryTypeName() {
        return this.entryTypeName;
    }

    public boolean isExpressService() {
        return this.product.isExpressService();
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.product.getBlankOwner();
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public EntityReference<Person> getTicketingAgent() {
        return this.product.getAgent();
    }

    public EntityReference<SalesPoint> getSalesPoint() {
        return this.product.getSalesPoint();
    }

    public TicketType getTicketType() {
        return this.product.getTicketType();
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }

    public void setTravelSubject(TravelSubject travelSubject) {
        this.travelSubject = travelSubject;
    }

    public Set<String> getPassengerTypeCategories() {
        return Collections.emptySet();
    }
}

