/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.delete;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.DeleteDebitOrdersResult;
import com.gridnine.xtrip.common.model.system.BaseDeleteEntitiesResult;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.handlers.DeleteEntityHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DebitOrderDeleteHandler
implements DeleteEntityHandler<DebitBankTransferOrder> {
    @Override
    public Class<DebitBankTransferOrder> getEntityClass() {
        return DebitBankTransferOrder.class;
    }

    @Override
    public BaseDeleteEntitiesResult delete(Collection<EntityReference<DebitBankTransferOrder>> references) {
        ChangeData changeData = new ChangeData();
        HashMap<String, Collection<EntityReference<DebitBankTransferOrder>>> context = new HashMap<String, Collection<EntityReference<DebitBankTransferOrder>>>();
        context.put(IBusFinanceContextKeys.DEBIT_ORDER_REFERENCES.name(), references);
        IntegrationBusFacade.get().processRouteSync("debit-orders:delete", context);
        Collection messages = ((Map)context.get("messages")).values();
        ChangeData data = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (data != null) {
            changeData.getChanged().addAll(data.getChanged());
            changeData.getDeleted().addAll(data.getDeleted());
        }
        DeleteDebitOrdersResult result = new DeleteDebitOrdersResult();
        result.setChangeData(changeData);
        result.getMessages().clear();
        result.getMessages().addAll(messages);
        return result;
    }
}

