/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.delete;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.DeleteFinanceDocumentsResult;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.system.BaseDeleteEntitiesResult;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.handlers.DeleteEntityHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FinanceDocumentDeleteHandler
implements DeleteEntityHandler<FinanceDocument> {
    @Override
    public Class<FinanceDocument> getEntityClass() {
        return FinanceDocument.class;
    }

    @Override
    public BaseDeleteEntitiesResult delete(Collection<EntityReference<FinanceDocument>> references) {
        ChangeData changeData = new ChangeData();
        HashMap<String, Collection<EntityReference<FinanceDocument>>> context = new HashMap<String, Collection<EntityReference<FinanceDocument>>>();
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name(), references);
        IntegrationBusFacade.get().processRouteSync("finance-documents:delete", context);
        Collection messages = ((Map)context.get("messages")).values();
        ChangeData data = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (data != null) {
            changeData.getChanged().addAll(data.getChanged());
            changeData.getDeleted().addAll(data.getDeleted());
        }
        DeleteFinanceDocumentsResult result = new DeleteFinanceDocumentsResult();
        result.setChangeData(changeData);
        result.getMessages().clear();
        result.getMessages().addAll(messages);
        return result;
    }
}

