/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.delete;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.DeleteShipmentsResult;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.handlers.DeleteEntityHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ShipmentDeleteHandler
implements DeleteEntityHandler<Shipment> {
    @Override
    public Class<Shipment> getEntityClass() {
        return Shipment.class;
    }

    public DeleteShipmentsResult delete(Collection<EntityReference<Shipment>> references) {
        ChangeData changeData = new ChangeData();
        HashMap<String, Collection<Object>> context = new HashMap<String, Collection<Object>>();
        context.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), references);
        IntegrationBusFacade.get().processRouteSync("shipments:delete", context);
        Collection messages = ((Map)context.get("messages")).values();
        Collection documents = context.getOrDefault(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name(), Collections.emptyList());
        ChangeData data = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (data != null) {
            changeData.getChanged().addAll(data.getChanged());
            changeData.getDeleted().addAll(data.getDeleted());
        }
        for (EntityReference document : documents) {
            context.clear();
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), (Collection<Object>)document);
            IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
        }
        DeleteShipmentsResult result = new DeleteShipmentsResult();
        result.setChangeData(changeData);
        result.getMessages().clear();
        result.getMessages().addAll(messages);
        result.getDocuments().clear();
        result.getDocuments().addAll(documents);
        return result;
    }
}

