/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AgencyMemoProductBillingTransactionHandler
implements ProductBillingTransactionsHandler<AgencyMemoProduct> {
    @Override
    public ProductType getProductType(AgencyMemoProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).getProductType((BaseProduct)product);
    }

    @Override
    public Class<AgencyMemoProduct> getProductClass() {
        return AgencyMemoProduct.class;
    }

    @Override
    public TicketType getTicketType(AgencyMemoProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).getTicketType((BaseProduct)product);
    }

    @Override
    public ProductStatus getStatus(AgencyMemoProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).getBaseStatus((BaseProduct)product);
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(AgencyMemoProduct product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(AgencyMemoProduct product) {
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(AgencyMemoProduct product) {
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getSubagentContractRelation((BaseProduct)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(AgencyMemoProduct product) {
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public String getShortName(AgencyMemoProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(AgencyMemoProduct product) {
        return GeneralProductHelper.getSupplier((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getAgency(AgencyMemoProduct product) {
        return GeneralProductHelper.getAgency((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(AgencyMemoProduct product) {
        return GeneralProductHelper.getSubagency((BaseProduct)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(AgencyMemoProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).findSalesPoint((BaseProduct)product);
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

