/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AirProductBillingTransactionHandler
implements ProductBillingTransactionsHandler<Product> {
    @Override
    public ProductType getProductType(Product product) {
        return HandlersRegistry.get().findProductHandler(Product.class).getProductType((BaseProduct)product);
    }

    @Override
    public TicketType getTicketType(Product product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(Product product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(Product product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(Product product) {
        AirProductContractRelationData contractRelation = AirProductHelper.getClientContractRelation((Product)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(Product product) {
        AirProductContractRelationData contractRelation = AirProductHelper.getSubagentContractRelation((Product)product, (boolean)false);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(Product product) {
        AirProductContractRelationData contractRelation = AirProductHelper.getVendorContractRelation((Product)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public String getShortName(Product product) {
        return AirProductHelper.getShortNameString((Product)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(Product product) {
        return AirProductHelper.getSupplier((Product)product);
    }

    @Override
    public EntityReference<Organization> getAgency(Product product) {
        return AirProductHelper.getAgency((Product)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(Product product) {
        return AirProductHelper.getSubagency((Product)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(Product product) {
        return product.getSalesPoint();
    }

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    private List<ProductBillingTransactionsHandler.FopData> createFops(List<ProductFop> fops, final DictionaryReference<CurrencyInfo> currency) {
        ArrayList<ProductBillingTransactionsHandler.FopData> result = new ArrayList<ProductBillingTransactionsHandler.FopData>();
        for (ProductFop fopi : fops) {
            try {
                final ProductFop fop = (ProductFop)XCloneHelper.clone((XCloneable)fopi);
                result.add(new ProductBillingTransactionsHandler.FopData(){
                    private final Money amount;
                    {
                        this.amount = fop.getAmount() != null && fop.getAmount().getValue() != null ? SystemHelper.getMoney((double)fop.getAmount().getValue().doubleValue(), (String)(currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"))) : null;
                    }

                    @Override
                    public String getUid() {
                        return fop.getUid();
                    }

                    @Override
                    public PaymentType getPaymentType() {
                        return fop.getType();
                    }

                    @Override
                    public Date getOperationDate() {
                        return fop.getOperationDate();
                    }

                    @Override
                    public Money getAmount() {
                        return this.amount;
                    }

                    @Override
                    public EntityReference<Person> getAgent() {
                        return fop.getAgent();
                    }

                    @Override
                    public List<ProductBillingTransactionsHandler.CommissionData> getCommissions() {
                        return AirProductBillingTransactionHandler.createCommissions(fop.getCommissions(), (DictionaryReference<CurrencyInfo>)currency);
                    }

                    @Override
                    public Card getCard() {
                        return fop.getCard();
                    }

                    @Override
                    public boolean isRefused() {
                        return fop.isRefused();
                    }
                });
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static List<ProductBillingTransactionsHandler.CommissionData> createCommissions(List<Commission> commissions, final DictionaryReference<CurrencyInfo> currency) {
        ArrayList<ProductBillingTransactionsHandler.CommissionData> result = new ArrayList<ProductBillingTransactionsHandler.CommissionData>();
        for (Commission commissioni : commissions) {
            try {
                final Commission commission = (Commission)XCloneHelper.clone((XCloneable)commissioni);
                result.add(new ProductBillingTransactionsHandler.CommissionData(){
                    private final Money amount;
                    {
                        this.amount = commission.getEquivalentAmount() != null ? SystemHelper.getMoney((double)commission.getEquivalentAmount().doubleValue(), (String)(currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"))) : null;
                    }

                    @Override
                    public EntityReference<? extends BaseCommissionProperties> getCommissionProperties() {
                        return commission.getCommissionProperties();
                    }

                    @Override
                    public Money getAmount() {
                        return this.amount;
                    }
                });
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

