/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class BillingTransactionHandlersHelper {
    public static List<ProductBillingTransactionsHandler.FopData> getFops(List<GeneralProductFop> fops, final DictionaryReference<CurrencyInfo> currency) {
        ArrayList<ProductBillingTransactionsHandler.FopData> result = new ArrayList<ProductBillingTransactionsHandler.FopData>();
        for (GeneralProductFop fopi : fops) {
            try {
                final GeneralProductFop fop = (GeneralProductFop)XCloneHelper.clone((XCloneable)fopi);
                result.add(new ProductBillingTransactionsHandler.FopData(){
                    private final Money amount;
                    {
                        this.amount = fop.getEquivalentAmount() != null ? SystemHelper.getMoney((double)fop.getEquivalentAmount().doubleValue(), (String)(currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"))) : null;
                    }

                    @Override
                    public String getUid() {
                        return fop.getUid();
                    }

                    @Override
                    public PaymentType getPaymentType() {
                        return fop.getType();
                    }

                    @Override
                    public Date getOperationDate() {
                        return fop.getOperationDate();
                    }

                    @Override
                    public Money getAmount() {
                        return this.amount;
                    }

                    @Override
                    public EntityReference<Person> getAgent() {
                        return fop.getAgent();
                    }

                    @Override
                    public List<ProductBillingTransactionsHandler.CommissionData> getCommissions() {
                        return BillingTransactionHandlersHelper.getCommissions(fop.getCommissions(), (DictionaryReference<CurrencyInfo>)currency);
                    }

                    @Override
                    public Card getCard() {
                        return fop.getCard();
                    }

                    @Override
                    public boolean isRefused() {
                        return fop.isRefused();
                    }
                });
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static List<ProductBillingTransactionsHandler.CommissionData> getCommissions(List<GeneralProductCommission> commissions, final DictionaryReference<CurrencyInfo> currency) {
        ArrayList<ProductBillingTransactionsHandler.CommissionData> result = new ArrayList<ProductBillingTransactionsHandler.CommissionData>();
        for (GeneralProductCommission commissioni : commissions) {
            try {
                final GeneralProductCommission commission = (GeneralProductCommission)XCloneHelper.clone((XCloneable)commissioni);
                result.add(new ProductBillingTransactionsHandler.CommissionData(){
                    private final Money amount;
                    {
                        this.amount = commission.getEquivalentAmount() != null ? SystemHelper.getMoney((double)commission.getEquivalentAmount().doubleValue(), (String)(currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"))) : null;
                    }

                    @Override
                    public EntityReference<? extends BaseCommissionProperties> getCommissionProperties() {
                        return commission.getCommissionProperties();
                    }

                    @Override
                    public Money getAmount() {
                        return this.amount;
                    }
                });
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

