/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CarRentalProductBillingTransactionHandler
implements ProductBillingTransactionsHandler<CarRentalProduct> {
    @Override
    public ProductType getProductType(CarRentalProduct product) {
        return HandlersRegistry.get().findProductHandler(CarRentalProduct.class).getProductType((BaseProduct)product);
    }

    @Override
    public Class<CarRentalProduct> getProductClass() {
        return CarRentalProduct.class;
    }

    @Override
    public TicketType getTicketType(CarRentalProduct product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(CarRentalProduct product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(CarRentalProduct product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(CarRentalProduct product) {
        GeneralProductContractRelationData contractRelation = CarRentalProductHelper.getClientContractRelation((CarRentalProduct)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(CarRentalProduct product) {
        GeneralProductContractRelationData contractRelation = CarRentalProductHelper.getSubagentContractRelation((CarRentalProduct)product, (boolean)false);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(CarRentalProduct product) {
        return Collections.emptyList();
    }

    @Override
    public String getShortName(CarRentalProduct product) {
        return HandlersRegistry.get().findProductHandler(CarRentalProduct.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(CarRentalProduct product) {
        return CarRentalProductHelper.getSupplier((CarRentalProduct)product);
    }

    @Override
    public EntityReference<Organization> getAgency(CarRentalProduct product) {
        return CarRentalProductHelper.getAgency((CarRentalProduct)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(CarRentalProduct product) {
        return CarRentalProductHelper.getSubagency((CarRentalProduct)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(CarRentalProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

