/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DeliveryBillingTransactionHandler
implements ProductBillingTransactionsHandler<Delivery> {
    @Override
    public ProductType getProductType(Delivery product) {
        return HandlersRegistry.get().findProductHandler(Delivery.class).getProductType((BaseProduct)product);
    }

    @Override
    public Class<Delivery> getProductClass() {
        return Delivery.class;
    }

    @Override
    public TicketType getTicketType(Delivery product) {
        return TicketType.OWN;
    }

    @Override
    public ProductStatus getStatus(Delivery product) {
        return DeliveryHelper.getProductStatus((Delivery)product);
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(Delivery product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(Delivery product) {
        return BillingTransactionHandlersHelper.getFops(product.getClientFops(), null);
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(Delivery product) {
        return Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(Delivery product) {
        return Collections.emptyList();
    }

    @Override
    public String getShortName(Delivery product) {
        return HandlersRegistry.get().findProductHandler(Delivery.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(Delivery product) {
        return null;
    }

    @Override
    public EntityReference<Organization> getAgency(Delivery product) {
        return product.getAgency();
    }

    @Override
    public EntityReference<Organization> getSubagency(Delivery product) {
        return null;
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(Delivery product) {
        return product.getSalesPoint();
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

