/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class HotelProductBillingTransactionHandler
implements ProductBillingTransactionsHandler<HotelProduct> {
    @Override
    public ProductType getProductType(HotelProduct product) {
        return HandlersRegistry.get().findProductHandler(HotelProduct.class).getProductType((BaseProduct)product);
    }

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }

    @Override
    public TicketType getTicketType(HotelProduct product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(HotelProduct product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(HotelProduct product) {
        return HotelProductHelper.isOnHold((HotelProduct)product) ? BillingTransactionStatus.HOLD : BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(HotelProduct product) {
        HotelProductContractRelationData contractRelation = HotelProductHelper.getClientContractRelation((HotelProduct)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(HotelProduct product) {
        HotelProductContractRelationData contractRelation = HotelProductHelper.getSubagentContractRelation((HotelProduct)product, (boolean)false);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(HotelProduct product) {
        HotelProductContractRelationData contractRelation = HotelProductHelper.getVendorContractRelation((HotelProduct)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public String getShortName(HotelProduct product) {
        StringBuilder shortName = new StringBuilder();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            shortName.append(product.getSystemNumber().trim());
        }
        if (product.getStatus() != null) {
            if (shortName.length() > 0) {
                shortName.append(" - ");
            }
            shortName.append(product.getStatus());
        }
        if (!TextUtil.isBlank((String)product.getHotelName())) {
            if (shortName.length() > 0) {
                shortName.append(" - ");
            }
            shortName.append(product.getHotelName().trim());
        }
        if (product.getHotelLocation() != null) {
            if (shortName.length() > 0) {
                shortName.append(", ");
            }
            shortName.append(product.getHotelLocation());
        }
        return shortName.toString();
    }

    @Override
    public EntityReference<Organization> getSupplier(HotelProduct product) {
        return HotelProductHelper.getSupplier((HotelProduct)product);
    }

    @Override
    public EntityReference<Organization> getAgency(HotelProduct product) {
        return HotelProductHelper.getAgency((HotelProduct)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(HotelProduct product) {
        return HotelProductHelper.getSubagency((HotelProduct)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(HotelProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public boolean isCreateForRetail() {
        return true;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }

    private List<ProductBillingTransactionsHandler.FopData> createFops(List<HotelProductFop> fops, final DictionaryReference<CurrencyInfo> currency) {
        ArrayList<ProductBillingTransactionsHandler.FopData> result = new ArrayList<ProductBillingTransactionsHandler.FopData>();
        for (HotelProductFop fopi : fops) {
            try {
                final HotelProductFop fop = (HotelProductFop)XCloneHelper.clone((XCloneable)fopi);
                result.add(new ProductBillingTransactionsHandler.FopData(){
                    private final Money amount;
                    {
                        this.amount = fop.getAmount() != null && fop.getAmount().getValue() != null ? SystemHelper.getMoney((double)fop.getAmount().getValue().doubleValue(), (String)(currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"))) : null;
                    }

                    @Override
                    public String getUid() {
                        return fop.getUid();
                    }

                    @Override
                    public PaymentType getPaymentType() {
                        return fop.getType();
                    }

                    @Override
                    public Date getOperationDate() {
                        return fop.getOperationDate();
                    }

                    @Override
                    public Money getAmount() {
                        return this.amount;
                    }

                    @Override
                    public EntityReference<Person> getAgent() {
                        return fop.getAgent();
                    }

                    @Override
                    public List<ProductBillingTransactionsHandler.CommissionData> getCommissions() {
                        return BillingTransactionHandlersHelper.getCommissions(fop.getCommissions(), (DictionaryReference<CurrencyInfo>)currency);
                    }

                    @Override
                    public Card getCard() {
                        return fop.getCard();
                    }

                    @Override
                    public boolean isRefused() {
                        return fop.isRefused();
                    }
                });
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

