/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InsuranceAccidentBillingTransactionHandler
implements ProductBillingTransactionsHandler<InsuranceAccident> {
    @Override
    public ProductType getProductType(InsuranceAccident product) {
        return HandlersRegistry.get().findProductHandler(InsuranceAccident.class).getProductType((BaseProduct)product);
    }

    @Override
    public Class<InsuranceAccident> getProductClass() {
        return InsuranceAccident.class;
    }

    @Override
    public TicketType getTicketType(InsuranceAccident product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(InsuranceAccident product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(InsuranceAccident product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(InsuranceAccident product) {
        GeneralProductContractRelationData contractRelation = InsuranceAccidentHelper.getClientContractRelation((InsuranceAccident)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(InsuranceAccident product) {
        GeneralProductContractRelationData contractRelation = InsuranceAccidentHelper.getSubagentContractRelation((InsuranceAccident)product, (boolean)false);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(InsuranceAccident product) {
        GeneralProductContractRelationData contractRelation = InsuranceAccidentHelper.getVendorContractRelation((InsuranceAccident)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public String getShortName(InsuranceAccident product) {
        return HandlersRegistry.get().findProductHandler(InsuranceAccident.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(InsuranceAccident product) {
        return InsuranceAccidentHelper.getSupplier((InsuranceAccident)product);
    }

    @Override
    public EntityReference<Organization> getAgency(InsuranceAccident product) {
        return InsuranceAccidentHelper.getAgency((InsuranceAccident)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(InsuranceAccident product) {
        return InsuranceAccidentHelper.getSubagency((InsuranceAccident)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(InsuranceAccident product) {
        return product.getSalesPoint();
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

