/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InsuranceTouristicBillingTransactionHandler
implements ProductBillingTransactionsHandler<InsuranceTouristic> {
    @Override
    public ProductType getProductType(InsuranceTouristic product) {
        return HandlersRegistry.get().findProductHandler(InsuranceTouristic.class).getProductType((BaseProduct)product);
    }

    @Override
    public Class<InsuranceTouristic> getProductClass() {
        return InsuranceTouristic.class;
    }

    @Override
    public TicketType getTicketType(InsuranceTouristic product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(InsuranceTouristic product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(InsuranceTouristic product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(InsuranceTouristic product) {
        GeneralProductContractRelationData contractRelation = InsuranceTouristicHelper.getClientContractRelation((InsuranceTouristic)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(InsuranceTouristic product) {
        GeneralProductContractRelationData contractRelation = InsuranceTouristicHelper.getSubagentContractRelation((InsuranceTouristic)product, (boolean)false);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(InsuranceTouristic product) {
        GeneralProductContractRelationData contractRelation = InsuranceTouristicHelper.getVendorContractRelation((InsuranceTouristic)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public String getShortName(InsuranceTouristic product) {
        return HandlersRegistry.get().findProductHandler(InsuranceTouristic.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getSupplier((InsuranceTouristic)product);
    }

    @Override
    public EntityReference<Organization> getAgency(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getAgency((InsuranceTouristic)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(InsuranceTouristic product) {
        return InsuranceTouristicHelper.getSubagency((InsuranceTouristic)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(InsuranceTouristic product) {
        return product.getSalesPoint();
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

