/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface ProductBillingTransactionsHandler<P extends BaseProduct> {
    public TicketType getTicketType(P var1);

    public ProductStatus getStatus(P var1);

    public BillingTransactionStatus getBillingTransactionStatus(P var1);

    public List<FopData> getClientFops(P var1);

    public List<FopData> getSubagentFops(P var1);

    public List<FopData> getVendorFops(P var1);

    public String getShortName(P var1);

    public EntityReference<Organization> getSupplier(P var1);

    public EntityReference<Organization> getAgency(P var1);

    public EntityReference<Organization> getSubagency(P var1);

    public EntityReference<SalesPoint> getSalesPoint(P var1);

    public ProductType getProductType(P var1);

    public boolean isCreateForRetail();

    @Deprecated
    public Collection<PaymentType> getAllowedPaymentTypes();

    public Class<P> getProductClass();

    public static interface CommissionData {
        public EntityReference<? extends BaseCommissionProperties> getCommissionProperties();

        public Money getAmount();
    }

    public static interface FopData {
        public String getUid();

        public Money getAmount();

        public Date getOperationDate();

        public PaymentType getPaymentType();

        public EntityReference<Person> getAgent();

        public List<CommissionData> getCommissions();

        public Card getCard();

        public boolean isRefused();
    }
}

