/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ProductVoidingBillingTransactionHandler
implements ProductBillingTransactionsHandler<ProductVoiding> {
    @Override
    public ProductType getProductType(ProductVoiding product) {
        return HandlersRegistry.get().findProductHandler(ProductVoiding.class).getProductType((BaseProduct)product);
    }

    @Override
    public TicketType getTicketType(ProductVoiding product) {
        return TicketType.OWN;
    }

    @Override
    public ProductStatus getStatus(ProductVoiding product) {
        return ProductStatus.SELL;
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(ProductVoiding product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(ProductVoiding product) {
        GeneralProductContractRelationData contractRelation = ProductVoidingHelper.getClientContractRelation((ProductVoiding)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(ProductVoiding product) {
        GeneralProductContractRelationData contractRelation = ProductVoidingHelper.getSubagentContractRelation((ProductVoiding)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(ProductVoiding product) {
        GeneralProductContractRelationData contractRelation = ProductVoidingHelper.getVendorContractRelation((ProductVoiding)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public String getShortName(ProductVoiding product) {
        return HandlersRegistry.get().findProductHandler(ProductVoiding.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(ProductVoiding product) {
        return ProductVoidingHelper.getSupplier((ProductVoiding)product);
    }

    @Override
    public EntityReference<Organization> getAgency(ProductVoiding product) {
        return ProductVoidingHelper.getAgency((ProductVoiding)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(ProductVoiding product) {
        return ProductVoidingHelper.getSubagency((ProductVoiding)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(ProductVoiding product) {
        return ProductVoidingHelper.getSalesPoint((ProductVoiding)product);
    }

    @Override
    public Class<ProductVoiding> getProductClass() {
        return ProductVoiding.class;
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

