/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TransferBillingTransactionHandler
implements ProductBillingTransactionsHandler<Transfer> {
    @Override
    public TicketType getTicketType(Transfer product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(Transfer product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(Transfer product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(Transfer product) {
        GeneralProductContractRelationData contractRelation = TransferHelper.getClientContractRelation((Transfer)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(Transfer product) {
        GeneralProductContractRelationData contractRelation = TransferHelper.getSubagentContractRelation((Transfer)product, (boolean)false);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(Transfer product) {
        return Collections.emptyList();
    }

    @Override
    public String getShortName(Transfer product) {
        return HandlersRegistry.get().findProductHandler(Transfer.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(Transfer product) {
        return TransferHelper.getSupplier((Transfer)product);
    }

    @Override
    public EntityReference<Organization> getAgency(Transfer product) {
        return TransferHelper.getAgency((Transfer)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(Transfer product) {
        return TransferHelper.getSubagency((Transfer)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(Transfer product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductType getProductType(Transfer product) {
        return HandlersRegistry.get().findProductHandler(Transfer.class).getProductType((BaseProduct)product);
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }

    @Override
    public Class<Transfer> getProductClass() {
        return Transfer.class;
    }
}

