/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UniversalProductBillingTransactionHandler
implements ProductBillingTransactionsHandler<UniversalProduct> {
    @Override
    public ProductType getProductType(UniversalProduct product) {
        return HandlersRegistry.get().findProductHandler(UniversalProduct.class).getProductType((BaseProduct)product);
    }

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public TicketType getTicketType(UniversalProduct product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(UniversalProduct product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(UniversalProduct product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(UniversalProduct product) {
        GeneralProductContractRelationData contractRelation = UniversalProductHelper.getClientContractRelation((UniversalProduct)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(UniversalProduct product) {
        GeneralProductContractRelationData contractRelation = UniversalProductHelper.getSubagentContractRelation((UniversalProduct)product, (boolean)false);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(UniversalProduct product) {
        GeneralProductContractRelationData contractRelation = UniversalProductHelper.getVendorContractRelation((UniversalProduct)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public String getShortName(UniversalProduct product) {
        return HandlersRegistry.get().findProductHandler(UniversalProduct.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(UniversalProduct product) {
        return UniversalProductHelper.getSupplier((UniversalProduct)product);
    }

    @Override
    public EntityReference<Organization> getAgency(UniversalProduct product) {
        return UniversalProductHelper.getAgency((UniversalProduct)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(UniversalProduct product) {
        return UniversalProductHelper.getSubagency((UniversalProduct)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(UniversalProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

