/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class VisaProductBillingTransactionHandler
implements ProductBillingTransactionsHandler<VisaProduct> {
    @Override
    public ProductType getProductType(VisaProduct product) {
        return HandlersRegistry.get().findProductHandler(VisaProduct.class).getProductType((BaseProduct)product);
    }

    @Override
    public Class<VisaProduct> getProductClass() {
        return VisaProduct.class;
    }

    @Override
    public TicketType getTicketType(VisaProduct product) {
        return product.getTicketType();
    }

    @Override
    public ProductStatus getStatus(VisaProduct product) {
        return product.getStatus();
    }

    @Override
    public BillingTransactionStatus getBillingTransactionStatus(VisaProduct product) {
        return BillingTransactionStatus.ACTIVE;
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getClientFops(VisaProduct product) {
        GeneralProductContractRelationData contractRelation = VisaProductHelper.getClientContractRelation((VisaProduct)product);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(VisaProduct product) {
        GeneralProductContractRelationData contractRelation = VisaProductHelper.getSubagentContractRelation((VisaProduct)product, (boolean)false);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    @Override
    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(VisaProduct product) {
        return Collections.emptyList();
    }

    @Override
    public String getShortName(VisaProduct product) {
        return HandlersRegistry.get().findProductHandler(VisaProduct.class).generateShortProductName((BaseProduct)product);
    }

    @Override
    public EntityReference<Organization> getSupplier(VisaProduct product) {
        return VisaProductHelper.getSupplier((VisaProduct)product);
    }

    @Override
    public EntityReference<Organization> getAgency(VisaProduct product) {
        return VisaProductHelper.getAgency((VisaProduct)product);
    }

    @Override
    public EntityReference<Organization> getSubagency(VisaProduct product) {
        return VisaProductHelper.getSubagency((VisaProduct)product);
    }

    @Override
    public EntityReference<SalesPoint> getSalesPoint(VisaProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public boolean isCreateForRetail() {
        return false;
    }

    @Override
    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

