/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.handlers.index.CommonProductIndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;

public class StandardCommonProductIndexHandler
extends CommonProductIndexHandler {
    @Override
    public void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, BaseProduct product) {
        GeneralProductContractRelationData vendorContractRelation;
        EntityReference customerProfile;
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        ProductStatus status = productHandler.getStatus(product);
        boolean refund = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE;
        Customer customer = ((BookingFile)etc.getEntity()).getCustomer();
        HashSet customerProfileEmploymentsUids = new HashSet();
        if (customer != null && (customerProfile = customer.getProfile()) != null) {
            customerProfileEmploymentsUids.clear();
            customerProfileEmploymentsUids.addAll(ProfileHelper.getPersonOrganizations(Collections.singletonList(customerProfile), null, null).stream().map(item -> item.getUid()).collect(Collectors.toSet()));
        }
        data.setCustomerProfileEmploymentsUids(customerProfileEmploymentsUids);
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        if (clientContractRelation != null) {
            ContractRelationServiceDataDetalization clientDetalization = clientContractRelation.getServiceData().getDetalization();
            data.setClientFareValue(clientDetalization.getFare());
            data.setClientTaxesValue(GeneralProductHelper.getEquivalentTaxesAmount((Collection)clientDetalization.getTaxes()));
            data.setClientCurrency(GeneralProductHelper.getContractCurrency((GeneralProductContractRelationData)clientContractRelation));
            GeneralProductHelper.getContract((BaseContractRelationData)clientContractRelation).ifPresent(contract -> {
                data.setClientContractNumber(contract.getNumber());
                data.setClientContractAgreementType(contract.getAgreementType());
            });
        }
        if ((vendorContractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product)) != null) {
            GeneralProductHelper.getContract((BaseContractRelationData)vendorContractRelation).ifPresent(contract -> {
                data.setVendorContractNumber(contract.getNumber());
                data.setVendorContractAgreementType(contract.getAgreementType());
            });
        }
        BigDecimal vendorProductPrice = Optional.ofNullable(productHandler.calculateProductPrice(product, ContractType.VENDOR)).map(VatAmount::getTotal).orElse(null);
        BigDecimal vendorCommissionsEquivalent = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR));
        data.setBaseSum(BookingHelper.getCommissionValue((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{vendorProductPrice, MiscUtil.negate((BigDecimal)vendorCommissionsEquivalent)}), (boolean)refund));
        data.setSubagentFopAmount(GeneralProductHelper.getSubagentFopAmount((BaseProduct)product));
        data.setIssuingAgentCode(productHandler.findIssuingAgentCode(product));
        aggregator.aggregate((Object)productHandler.findIssuingAgentCode(product));
        data.setPcc(productHandler.getPCC(product));
        aggregator.aggregate((Object)productHandler.getPCC(product));
        data.setReservationSalesPoint(product.getReservation().getSalesPoint());
        aggregator.aggregate((Object)product.getReservation().getSalesPoint());
        IndexBuilderHelper.updateReservationGdsNameInfo(product.getReservation(), data, aggregator);
        IndexBuilderHelper.updateChangeDataSources(product, data);
    }
}

