/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.productReferences;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemComponent;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.model.handlers.ProductReferencesHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsProductReferencesHandler
implements ProductReferencesHandler {
    @Override
    public String getUid() {
        return "financeDocumentsProductReferencesHandler";
    }

    @Override
    public void changeReferences(Collection<BaseProduct> products, EntityContainer<BookingFile> newBookingFile, Collection<EntityReference<BookingFile>> deletedBookingFiles, Map<Traveller, Traveller> travellersMap, String dataSource) {
        Set shipments = products.stream().flatMap(baseProduct -> baseProduct.getFopDetalizations().values().stream()).flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet<String> processedBillingItemsListUids = new HashSet<String>();
        HashSet<String> processedPaymentItemsListUids = new HashSet<String>();
        HashSet<String> processedFinanceDocumentsUids = new HashSet<String>();
        for (EntityReference shipment : shipments) {
            EntityContainer shipmentContainer = EntityStorage.get().resolve(shipment);
            if (shipmentContainer == null) continue;
            boolean shipmentChanged = false;
            NestedEntityReference categoryProduct = ((Shipment)shipmentContainer.getEntity()).getCategoryProduct();
            if (categoryProduct != null) {
                if (products.stream().map(BaseIdentity::getUid).anyMatch(categoryProduct.getNestedEntityUid()::equals)) {
                    categoryProduct.setUid(newBookingFile.getUid());
                    shipmentChanged = true;
                }
            }
            if (deletedBookingFiles.contains(((Shipment)shipmentContainer.getEntity()).getCategoryBookingFile())) {
                ((Shipment)shipmentContainer.getEntity()).setCategoryBookingFile(newBookingFile.toReference());
                shipmentChanged = true;
            }
            if (shipmentChanged) {
                shipmentContainer.getVersionInfo().setDataSource(dataSource);
                EntityStorage.get().save(shipmentContainer, true);
            }
            List billingItems = ((Shipment)shipmentContainer.getEntity()).getBillingItems();
            for (NestedEntityReference billingItemReference : billingItems) {
                EntityContainer billingItemList;
                if (processedBillingItemsListUids.contains(billingItemReference.getUid()) || (billingItemList = EntityStorage.get().resolve((EntityReference)billingItemReference)) == null) continue;
                boolean billingItemListChanged = false;
                for (BillingItem billingItem : ((BillingItemsList)billingItemList.getEntity()).getData()) {
                    Traveller oldTraveller;
                    boolean productReferenceUpdated = this.updateProductReference((NestedEntityReference<BookingFile, BaseProduct>)billingItem.getProduct(), products, newBookingFile);
                    if (!productReferenceUpdated) continue;
                    billingItemListChanged = true;
                    for (BillingItemComponent component : billingItem.getComponents()) {
                        this.updateProductReference((NestedEntityReference<BookingFile, BaseProduct>)component.getProduct(), products, newBookingFile);
                    }
                    for (NestedEntityReference fopComponentReference : billingItem.getFopComponents()) {
                        boolean fopComponentBelongsToProcessedProducts = products.stream().flatMap(product -> product.getFopDetalizations().values().stream()).flatMap(fopDetalization -> fopDetalization.getComponents().stream()).anyMatch(fopComponent -> fopComponent.getUid().equals(fopComponentReference.getNestedEntityUid()));
                        if (!fopComponentBelongsToProcessedProducts) continue;
                        fopComponentReference.setUid(newBookingFile.getUid());
                    }
                    for (NestedEntityReference fopReference : billingItem.getFops()) {
                        this.updateFopReference((NestedEntityReference<BookingFile, Fop>)fopReference, products, newBookingFile);
                    }
                    NestedEntityReference traveller = billingItem.getTraveller();
                    if (traveller == null || (oldTraveller = (Traveller)travellersMap.keySet().stream().filter(item -> item.getUid().equals(traveller.getNestedEntityUid())).findFirst().orElse(null)) == null) continue;
                    Traveller newTraveller = travellersMap.get(oldTraveller);
                    if (newTraveller != null) {
                        traveller.setNestedEntityUid(newTraveller.getUid());
                        traveller.setCaption(newTraveller.getName());
                    }
                    traveller.setUid(newBookingFile.getUid());
                }
                processedBillingItemsListUids.add(billingItemReference.getUid());
                if (!billingItemListChanged) continue;
                billingItemList.getVersionInfo().setDataSource(dataSource);
                EntityStorage.get().save(billingItemList, true);
            }
            for (EntityReference financeDocumentReference : ((Shipment)shipmentContainer.getEntity()).getFinanceDocuments()) {
                EntityContainer financeDocument;
                if (processedFinanceDocumentsUids.contains(financeDocumentReference.getUid()) || (financeDocument = EntityStorage.get().resolve(financeDocumentReference)) == null) continue;
                boolean financeDocumentChanged = false;
                NestedEntityReference deliveryReference = ((FinanceDocument)financeDocument.getEntity()).getDelivery();
                if (deliveryReference != null) {
                    if (products.stream().map(BaseIdentity::getUid).anyMatch(deliveryReference.getNestedEntityUid()::equals)) {
                        deliveryReference.setUid(newBookingFile.getUid());
                        financeDocumentChanged = true;
                    }
                }
                processedFinanceDocumentsUids.add(financeDocumentReference.getUid());
                if (!financeDocumentChanged) continue;
                financeDocument.getVersionInfo().setDataSource(dataSource);
                EntityStorage.get().save(financeDocument, true);
            }
            for (NestedEntityReference paymentItemReference : ((Shipment)shipmentContainer.getEntity()).getPaymentItems()) {
                EntityContainer paymentItemsList;
                if (processedPaymentItemsListUids.contains(paymentItemReference.getUid()) || (paymentItemsList = EntityStorage.get().resolve((EntityReference)paymentItemReference)) == null) continue;
                boolean paymentItemListChanged = false;
                for (PaymentItem paymentItem : ((PaymentItemsList)paymentItemsList.getEntity()).getData()) {
                    for (NestedEntityReference fopReference : paymentItem.getFops()) {
                        paymentItemListChanged |= this.updateFopReference((NestedEntityReference<BookingFile, Fop>)fopReference, products, newBookingFile);
                    }
                }
                processedPaymentItemsListUids.add(paymentItemReference.getUid());
                if (!paymentItemListChanged) continue;
                paymentItemsList.getVersionInfo().setDataSource(dataSource);
                EntityStorage.get().save(paymentItemsList, true);
            }
        }
    }

    private boolean updateProductReference(NestedEntityReference<BookingFile, BaseProduct> reference, Collection<BaseProduct> processedProducts, EntityContainer<BookingFile> bookingFileContainer) {
        BaseProduct product;
        if (reference != null && (product = (BaseProduct)processedProducts.stream().filter(item -> reference.getNestedEntityUid().equals(item.getUid())).findFirst().orElse(null)) != null) {
            ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
            reference.setCaption(productHandler.generateShortProductName(product));
            reference.setUid(bookingFileContainer.getUid());
            return true;
        }
        return false;
    }

    private boolean updateFopReference(NestedEntityReference<BookingFile, Fop> reference, Collection<BaseProduct> processedProducts, EntityContainer<BookingFile> bookingFileContainer) {
        boolean fopBelongsToProcessedProducts = processedProducts.stream().flatMap(product -> GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product).stream()).flatMap(relation -> relation.getFops().stream()).map(BaseIdentity::getUid).anyMatch(reference.getNestedEntityUid()::equals);
        if (fopBelongsToProcessedProducts) {
            reference.setUid(bookingFileContainer.getUid());
            return true;
        }
        return false;
    }
}

