/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.productReferences;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.model.handlers.ProductReferencesHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ReceiptsProductReferencesHandler
implements ProductReferencesHandler {
    @Override
    public String getUid() {
        return "receiptsProductReferencesHandler";
    }

    @Override
    public void changeReferences(Collection<BaseProduct> products, EntityContainer<BookingFile> newBookingFile, Collection<EntityReference<BookingFile>> deletedBookingFiles, Map<Traveller, Traveller> travellersMap, String dataSource) {
        Set receipts = products.stream().flatMap(baseProduct -> baseProduct.getFopDetalizations().values().stream()).flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).filter(Objects::nonNull).collect(Collectors.toSet());
        for (EntityReference receipt : receipts) {
            EntityContainer receiptContainer = EntityStorage.get().resolve(receipt);
            List receiptLines = ((Receipt)receiptContainer.getEntity()).getReceiptData().getItems();
            boolean receiptChanged = false;
            for (ReceiptLine receiptLine : receiptLines) {
                boolean fopComponentBelongsToProcessedProducts;
                NestedEntityReference fopComponentReference;
                NestedEntityReference fop;
                NestedEntityReference productReference = receiptLine.getProductReference();
                if (productReference != null) {
                    if (products.stream().map(BaseIdentity::getUid).anyMatch(productReference.getNestedEntityUid()::equals)) {
                        productReference.setUid(newBookingFile.getUid());
                        receiptChanged = true;
                    }
                }
                if ((fop = receiptLine.getFop()) != null) {
                    receiptChanged |= this.updateFopReference((NestedEntityReference<BookingFile, Fop>)fop, products, newBookingFile);
                }
                if ((fopComponentReference = receiptLine.getFopComponent()) == null || !(fopComponentBelongsToProcessedProducts = products.stream().flatMap(product -> product.getFopDetalizations().values().stream()).flatMap(fopDetalization -> fopDetalization.getComponents().stream()).anyMatch(fopComponent -> fopComponent.getUid().equals(fopComponentReference.getNestedEntityUid())))) continue;
                fopComponentReference.setUid(newBookingFile.getUid());
                receiptChanged = true;
            }
            EntityReference owner = ((Receipt)receiptContainer.getEntity()).getOwner();
            if (owner != null && BookingFile.class.equals((Object)owner.getType())) {
                ((Receipt)receiptContainer.getEntity()).setOwner(newBookingFile.toReference());
                receiptChanged = true;
            }
            if (!receiptChanged) continue;
            receiptContainer.getVersionInfo().setDataSource(dataSource);
            EntityStorage.get().save(receiptContainer, true);
        }
    }

    private boolean updateFopReference(NestedEntityReference<BookingFile, Fop> reference, Collection<BaseProduct> processedProducts, EntityContainer<BookingFile> bookingFileContainer) {
        boolean fopBelongsToProcessedProducts = processedProducts.stream().flatMap(product -> GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product).stream()).flatMap(relation -> relation.getFops().stream()).map(BaseIdentity::getUid).anyMatch(reference.getNestedEntityUid()::equals);
        if (fopBelongsToProcessedProducts) {
            reference.setUid(bookingFileContainer.getUid());
            return true;
        }
        return false;
    }
}

