/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ContractRelationContractData;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationRemark;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.OnCreateFopListener;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.rules.standard.ContractActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.handlers.AirRulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.AviaTripartiteContractActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.AirSubsidizedContractRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.AirTripartiteContractRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.BspProductVirtualizationHelper;
import com.gridnine.xtrip.server.model.handlers.rules.ClassOfServiceVirtualizationHelper;
import com.gridnine.xtrip.server.model.handlers.rules.ExternalTicketVirtualizationHelper;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.ProductRelatedOrganizations;
import com.gridnine.xtrip.server.model.handlers.rules.S7VirtualizationHelper;
import com.gridnine.xtrip.server.model.handlers.rules.TchDirectContractsHelper;
import com.gridnine.xtrip.server.model.handlers.rules.TchRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.TchSpecialSchemeVirtualizationHelper;
import com.gridnine.xtrip.server.model.handlers.rules.VoidProductVirtualizationHelper;
import com.gridnine.xtrip.server.model.helpers.ObjectCreationSettingsHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AirRulesHelper {
    static final Logger log = LoggerFactory.getLogger(AirRulesHelper.class);

    public static Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingContainer) {
        return AirRulesHelper.getAllowedPaymentTypes(bookingContainer, null, null);
    }

    public static Set<PaymentType> getAllowedPaymentTypes(Reservation reservation) {
        return reservation.getProducts().stream().flatMap(p -> AirRulesHelper.getAllowedPaymentTypes(p, null, null).stream()).collect(Collectors.toSet());
    }

    public static Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingContainer, List<Message> messages) {
        return AirRulesHelper.getAllowedPaymentTypes(bookingContainer, messages, null);
    }

    public static Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingContainer, List<Message> messages, ContractType filterContractType) {
        HashSet<PaymentType> result = new HashSet<PaymentType>();
        for (Reservation res : ((BookingFile)bookingContainer.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                result.addAll(AirRulesHelper.getAllowedPaymentTypes(bp, messages, filterContractType));
            }
        }
        return result;
    }

    public static Set<PaymentType> getAllowedPaymentTypes(BaseProduct bp, List<Message> messages, ContractType filterContractType) {
        if (bp instanceof Product) {
            Product product = (Product)bp;
            RuleProxy<ProductPropertySet, ProductCommissionActionSet> ruleProxy = AirRulesHelper.applyContracts(product, messages, filterContractType);
            return ruleProxy != null ? ((ProductCommissionActionSet)ruleProxy.getActionSet()).getAllowedPaymentTypes() : Collections.emptySet();
        }
        return Collections.emptySet();
    }

    public static RuleProxy<ProductPropertySet, ProductCommissionActionSet> applyContracts(Product product, List<Message> messages, ContractType filterContractType) {
        return AirRulesHelper.applyContracts(product, messages, filterContractType, null, null);
    }

    public static RuleProxy<ProductPropertySet, ProductCommissionActionSet> applyContracts(Product product, List<Message> messages, ContractType filterContractType, RuleAction action, String ruleCategory) {
        ArrayList<RuleProxy<ProductPropertySet, ProductCommissionActionSet>> proxyList = new ArrayList<RuleProxy<ProductPropertySet, ProductCommissionActionSet>>();
        try {
            proxyList.add(AirRulesHelper.createRuleProxy(product, false));
            ArrayList<ValidationMessage> vm = new ArrayList<ValidationMessage>();
            ProductRelatedOrganizations organizations = AirRulesHelper.collectOrganizations(product, vm);
            if (messages != null) {
                for (ValidationMessage item : vm) {
                    Message msg = new Message();
                    msg.setMessage(item.getMessage());
                    msg.setType(MessageType.ERROR);
                    if (item.getSeverity() == null) {
                        msg.setType(MessageType.MESSAGE);
                    } else {
                        switch (item.getSeverity()) {
                            case WARNING: {
                                msg.setType(MessageType.WARNING);
                                break;
                            }
                            case MESSAGE: {
                                msg.setType(MessageType.MESSAGE);
                                break;
                            }
                            default: {
                                msg.setType(MessageType.ERROR);
                            }
                        }
                    }
                    messages.add(msg);
                }
            }
            for (ValidationMessage item : AirProductHelper.getContractRelations((Product)product)) {
                ContractType contractType = GeneralProductHelper.getContractType((EntityReference)item.getDescription());
                if (contractType == ContractType.VENDOR || filterContractType != null && filterContractType != contractType) continue;
                EntityReference<Organization> blankOwner = organizations.blankOwner;
                ContractRelationDescription description = (ContractRelationDescription)EntityStorage.get().resolve(item.getDescription()).getEntity();
                EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getSupplier());
                EntityReference customer = contractType == ContractType.CLIENT ? organizations.client : GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getCustomer());
                EntityContainer<Contract> contract = EntityStorage.get().resolve(item.getGeneralData().getContractData().getManualContract());
                if (null == contract) {
                    contract = AirRulesHelper.getContract(contractType, product, blankOwner, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer);
                }
                if (contract != null) {
                    RulesHelper.applyRules(contract, proxyList, (BaseProduct)product, (RuleAction)action, (String)ruleCategory);
                    continue;
                }
                Collection contracts = (Collection)AirRulesHelper.collectOldContracts(contractType, product, blankOwner, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer).getFirst();
                for (EntityContainer ctr : contracts) {
                    RulesHelper.applyRules((EntityContainer)ctr, proxyList, (BaseProduct)product, (RuleAction)action, (String)ruleCategory);
                }
            }
            return (RuleProxy)proxyList.get(0);
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
            }
            log.error("unable to create proxy", (Throwable)e);
            return null;
        }
    }

    public static void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages) throws Exception {
        AirRulesHelper.applyRules(bookingContainer, forced, simulate, messages, null, null);
    }

    public static void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params) throws Exception {
        AirRulesHelper.applyRules(bookingContainer, forced, simulate, messages, null, params);
    }

    public static void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, ObjectFilter<Product> filter, Map<Parameter, Object> params) throws Exception {
        AirRulesHelper.applyRules(bookingContainer, forced, simulate, messages, filter, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyRules(EntityContainer<BookingFile> bookingContainer, boolean forced, boolean simulate, List<Message> messages, ObjectFilter<Product> filter, Map<Parameter, Object> params, DebugInfo info) throws Exception {
        boolean enabledTracing = info != null || !simulate && ObjectCreationSettingsHelper.isCreateRulesDebugInfo(((BookingFile)bookingContainer.getEntity()).getNumber());
        VoidProductVirtualizationHelper.resetRulesAppliedFlag(bookingContainer);
        BookingFile bookingFile = (BookingFile)bookingContainer.getEntity();
        List<Product> products = AirRulesHelper.prepareProducts(bookingContainer, forced, simulate, messages, enabledTracing);
        if (products.isEmpty()) {
            log.debug("products collection is empty in booking " + TextUtil.buildFullNumber((CompositeNumber)bookingFile));
            return;
        }
        HashMap<PaymentType, List<Commission>> result = new HashMap<PaymentType, List<Commission>>();
        VoidProductVirtualizationHelper.virtualizeVoidProducts(products, messages, info);
        for (Product product : products) {
            if (filter != null && !filter.accept((Object)product)) continue;
            RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy = null;
            String productTitle = AirRulesHelper.getProductTitle(product);
            AirRulesHelper.deleteRulesValidationMessages(product);
            log.debug(String.format("analyzing product \"%s\"", productTitle));
            try {
                proxy = AirRulesHelper.createRuleProxy(product, enabledTracing);
            }
            catch (Throwable e) {
                log.error("unable to create proxy", e);
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CANT_APPLY_RULES, (Throwable)e, (Object[])new Object[0]));
                BspProductVirtualizationHelper.devirtualize(product, proxy == null ? null : proxy.getTracer());
                VoidProductVirtualizationHelper.devirtualizeVoidProducts(product, messages, info);
                continue;
            }
            try {
                AirProductHelper.clearCommissionsExceptManuallyCalculated((Product)product, (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE || ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus()) ? 1 : 0) != 0);
                TchDirectContractsHelper.clearDirectContract(product);
                BspProductVirtualizationHelper.virtualize(product, proxy.getTracer());
                ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
                ProductRelatedOrganizations organizations = AirRulesHelper.collectOrganizations(product, validationMessages);
                product.getValidationMessages().addAll(validationMessages);
                EntityReference<Organization> vendor = organizations.blankOwner;
                EntityReference agencyRef = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY);
                AirTripartiteContractRulesHelper.AirTripartiteContractRulesResult tripartiteContractsData = AirTripartiteContractRulesHelper.applyTripartiteContracts(product, proxy, (EntityReference<Organization>)agencyRef);
                if (proxy.getAppliedRuleCategories().contains(AviaTripartiteContractActions.AVIA_PUBLIC_FARE_DISCOUNT.getId())) {
                    boolean hasRemarkPublicFareDiscount = false;
                    for (ReservationRemark r : product.getReservation().getReservationRemarks()) {
                        if (!TextUtil.isSame((String)r.getRemarkText(), (String)AviaTripartiteContractActions.AVIA_PUBLIC_FARE_DISCOUNT.getId())) continue;
                        hasRemarkPublicFareDiscount = true;
                        break;
                    }
                    if (!hasRemarkPublicFareDiscount && proxy.getActionSet() instanceof AviaTripartiteContractActionSet) {
                        AviaTripartiteContractActionSet as = (AviaTripartiteContractActionSet)proxy.getActionSet();
                        ReservationRemark rr = new ReservationRemark();
                        StringBuilder sb = new StringBuilder(AviaTripartiteContractActions.AVIA_PUBLIC_FARE_DISCOUNT.getId());
                        if (as.getPublicFareDiscount() != null && as.getPublicFareDiscount().getValue() != null) {
                            sb.append("*");
                            if (as.getPublicFareDiscount().getCurrency() == null) {
                                sb.append("DP");
                            } else {
                                sb.append("DA");
                            }
                            BigDecimal value = as.getPublicFareDiscount().getValue().setScale(0, RoundingMode.HALF_UP);
                            sb.append(value);
                            if (!TextUtil.isBlank((String)as.getPublicFareDiscount().getTicketDesignator())) {
                                sb.append("-").append(as.getPublicFareDiscount().getTicketDesignator());
                            }
                        }
                        rr.setRemarkText(sb.toString());
                        rr.setRemarkDate(new Date());
                        product.getReservation().getReservationRemarks().add(rr);
                    }
                }
                String initTrace = proxy.getTracer().getTrace();
                GeneralProductHelper.RelationData last = new GeneralProductHelper.RelationData((BaseProduct)product);
                for (AirProductContractRelationData contractRelation : AirProductHelper.getContractRelations((Product)product)) {
                    List customerInfos;
                    List contracts;
                    boolean separateSupplierFees;
                    EntityReference customer;
                    ContractCustomerInfo customerInfo;
                    Map<String, RuleResultValue> tripartiteResults;
                    boolean vendorContract;
                    ContractType contractType;
                    block31: {
                        contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
                        EntityContainer descriptionCtr = EntityStorage.get().resolve(contractRelation.getDescription());
                        PredefinedContractorType predefinedType = ((ContractorDescription)EntityStorage.get().resolve(((ContractRelationDescription)descriptionCtr.getEntity()).getSupplier()).getEntity()).getPredefinedType();
                        vendorContract = predefinedType != null ? contractType == ContractType.VENDOR && predefinedType == PredefinedContractorType.SUPPLIER : contractType == ContractType.VENDOR;
                        EntityContainer relationDescription = EntityStorage.get().resolve(contractRelation.getDescription());
                        if (contractType == null || relationDescription == null) {
                            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u0438\u043f\u0443 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u0445 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439 {0}", (Object[])new Object[]{contractRelation.getDescription()}));
                            continue;
                        }
                        tripartiteResults = tripartiteContractsData.commissions.get(contractType);
                        proxy.getAppliedRules().clear();
                        proxy.getAppliedRuleCategories().clear();
                        proxy.getTracer().clear();
                        proxy.setActionSet((Object)AirRulesHelper.createProductActionSet(proxy));
                        if (tripartiteResults != null) {
                            proxy.getAppliedRuleCategories().addAll(tripartiteResults.keySet());
                            ((ProductCommissionActionSet)proxy.getActionSet()).getResults().putAll(tripartiteResults);
                        }
                        log.debug("analyzing contract of type " + contractRelation.getDescription());
                        customerInfo = null;
                        EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)((ContractRelationDescription)relationDescription.getEntity()).getSupplier());
                        customer = contractType == ContractType.CLIENT ? organizations.client : GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)((ContractRelationDescription)relationDescription.getEntity()).getCustomer());
                        EntityContainer customerCtr = EntityStorage.get().resolve(customer);
                        separateSupplierFees = customerCtr != null && ((Organization)customerCtr.getEntity()).isSeparateSupplierFees();
                        try {
                            EntityContainer<Contract> contract = EntityStorage.get().resolve(contractRelation.getGeneralData().getContractData().getManualContract());
                            if (null == contract) {
                                contract = AirRulesHelper.getContract(contractType, product, vendor, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer);
                            }
                            if (contract != null) {
                                contracts = Collections.singletonList(contract);
                                customerInfos = null;
                                break block31;
                            }
                            MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> collectRes = AirRulesHelper.collectOldContracts(contractType, product, vendor, (EntityReference<Organization>)supplier, (EntityReference<Organization>)customer);
                            contracts = (List)collectRes.getFirst();
                            customerInfos = (List)collectRes.getSecond();
                            if (customerInfos == null || customerInfos.size() <= 0) break block31;
                            customerInfo = (ContractCustomerInfo)customerInfos.get(0);
                        }
                        catch (Exception e) {
                            log.error(String.format("failed collecting contracts of type %s for product %s", contractRelation.getDescription(), product), (Throwable)e);
                            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_ERROR_FINDING_CONTRACT, (Throwable)e, (Object[])new Object[]{contractRelation.getDescription()}));
                            AirRulesHelper.updateServiceData(product, contractRelation, last, Collections.emptyList(), (EntityReference<Organization>)customer);
                            last = new GeneralProductHelper.RelationData((BaseContractRelationData)contractRelation, last);
                            AirRulesHelper.cleanupFops(contractRelation);
                            AirRulesHelper.updatePreviouslyCalculatedCommissions(proxy, contractRelation, null, tripartiteResults != null, separateSupplierFees);
                            if (product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.REFUND) continue;
                            AirRulesHelper.setPreviousContract(product, contractRelation);
                            continue;
                        }
                    }
                    ExchangeRateData rateData = AirRulesHelper.updateServiceData(product, contractRelation, last, contracts, (EntityReference<Organization>)customer);
                    last = new GeneralProductHelper.RelationData((BaseContractRelationData)contractRelation, last);
                    ((ProductPropertySet)proxy.getPropertySet()).updateContractRelationData(contractRelation);
                    if (vendorContract && TchRulesHelper.isEmdWithZeroPrice(product)) continue;
                    if (contracts.isEmpty()) {
                        log.debug(String.format("no contracts of type \"%s\" was collected", contractRelation.getDescription()));
                        product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_MISSING_CONTRACT_OF_TYPE, (Object[])new Object[]{contractRelation.getDescription()}));
                        AirRulesHelper.cleanupFops(contractRelation);
                        AirRulesHelper.updatePreviouslyCalculatedCommissions(proxy, contractRelation, rateData, tripartiteResults != null, separateSupplierFees);
                        if (product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.REFUND) continue;
                        AirRulesHelper.setPreviousContract(product, contractRelation);
                        continue;
                    }
                    if (vendorContract) {
                        if (tripartiteContractsData.hasTripartiteContracts) {
                            proxy.getTracer().traceLogic("\u0421\u0443\u0431\u0441\u0438\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b \u043d\u0435 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u044b, \u0442\u0430\u043a \u043a\u0430\u043a \u0443\u0436\u0435 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d \u0442\u0440\u0435\u0445\u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                        }
                        if (!tripartiteContractsData.hasTripartiteContracts) {
                            AirSubsidizedContractRulesHelper.applySubsidizedContracts(product, contracts, (ProductPropertySet)proxy.getPropertySet(), proxy.getTracer());
                        }
                        TchDirectContractsHelper.applyContracts(product, contracts, customerInfo);
                    }
                    Map<Product, RuleProxy<ProductPropertySet, ProductCommissionActionSet>> vProducts = AirRulesHelper.virtualize(product, proxy, contractType, initTrace);
                    for (Map.Entry<Product, RuleProxy<ProductPropertySet, ProductCommissionActionSet>> entry : vProducts.entrySet()) {
                        AirProductContractRelationData relationData;
                        Product vProduct = entry.getKey();
                        if (product != vProduct) {
                            relationData = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)vProduct), (EntityReference)contractRelation.getDescription());
                            if (vendorContract) {
                                AirRulesHelper.updateServiceData(vProduct, relationData, new GeneralProductHelper.RelationData((BaseProduct)vProduct), contracts, (EntityReference<Organization>)customer);
                            }
                        } else {
                            relationData = contractRelation;
                        }
                        AirRulesHelper.applyRules(vProduct, entry.getValue(), result, contracts, relationData, rateData, bookingContainer, simulate, tripartiteResults != null, separateSupplierFees, params, customerInfos, info, enabledTracing);
                        log.debug(relationData.getCommissions().toString());
                    }
                    AirRulesHelper.devirtualize(product, vProducts.keySet());
                    if (product.getStatus() == ProductStatus.EXCHANGE || product.getStatus() == ProductStatus.REFUND && !((ProductCommissionActionSet)proxy.getActionSet()).hasRefundCommissions()) {
                        AirRulesHelper.setPreviousContract(product, contractRelation);
                    }
                    if (vendorContract) {
                        HashSet<GeneralProductHelper.CommissionType> commissionTypes = !MiscUtil.equals((Object)product.getBlankOwnerRef(), (Object)AirProductHelper.getSupplier((Product)product)) ? Collections.singleton(GeneralProductHelper.CommissionType.STANDARD) : new HashSet<GeneralProductHelper.CommissionType>(Arrays.asList(GeneralProductHelper.CommissionType.STANDARD, GeneralProductHelper.CommissionType.BSP));
                        Collection commissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, (Set)commissionTypes, null);
                        Double rate = AirProductHelper.calculateCommissionsRateAsDouble((Collection)commissions, (boolean)true);
                        BigDecimal commValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)commissions);
                        ((ProductPropertySet)proxy.getPropertySet()).setVendorCommissionRate(rate);
                        ((ProductPropertySet)proxy.getPropertySet()).setVendorCommissionValue(commValue == null ? null : Double.valueOf(commValue.doubleValue()));
                        initTrace = initTrace + L10nResourcesManager.getStr((String)Messages.AirRulesHelper_vendorCommissionRate, (Object[])new Object[]{"", rate, commValue});
                    }
                    if (((ProductPropertySet)proxy.getPropertySet()).getBspCommissionEquivalentValue() != null) continue;
                    BigDecimal commissionEquivalentValue = MiscUtil.guarded((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)contractRelation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null)));
                    ((ProductPropertySet)proxy.getPropertySet()).setBspCommissionEquivalentValue(commissionEquivalentValue);
                    initTrace = initTrace + String.format("\nbsp commission equivalent value was set to %s", commissionEquivalentValue);
                }
                AirRulesHelper.updateManuallyCalculatedFees(product);
                messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.AirRulesHelper_productApplyRules, (Object[])new Object[]{productTitle}));
                BspProductVirtualizationHelper.devirtualize(product, proxy == null ? null : proxy.getTracer());
            }
            catch (Throwable throwable) {
                BspProductVirtualizationHelper.devirtualize(product, proxy == null ? null : proxy.getTracer());
                VoidProductVirtualizationHelper.devirtualizeVoidProducts(product, messages, info);
                throw throwable;
            }
            VoidProductVirtualizationHelper.devirtualizeVoidProducts(product, messages, info);
        }
    }

    private static void setPreviousContract(Product product, AirProductContractRelationData contractRelation) {
        Product prev = product.getPreviousProduct();
        if (null == prev || prev.getTicketType() == TicketType.FAKE) {
            return;
        }
        AirProductContractRelationData prevRelation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prev), (EntityReference)contractRelation.getDescription());
        if (null == prevRelation) {
            return;
        }
        ContractRelationGeneralData generalData = contractRelation.getGeneralData();
        ContractRelationGeneralData prevGeneralData = prevRelation.getGeneralData();
        generalData.setContract(prevGeneralData.getContract());
        ContractRelationContractData contractData = generalData.getContractData();
        if (contractData.getManualContract() == null) {
            contractData.setContract(prevGeneralData.getContractData().getContract());
        }
    }

    @Deprecated
    public static NestedEntityReference<Contract, ContractCustomerInfo> buildContractNestedRef(List<EntityContainer<Contract>> contracts, EntityReference<Organization> customerRef, Date date) {
        for (EntityContainer<Contract> ctr : contracts) {
            for (ContractCustomerInfo item : ((Contract)ctr.getEntity()).getCustomers()) {
                EntityReference itemCustomer;
                if (item.getCustomer() == null || !(itemCustomer = item.getCustomer()).equals(customerRef) || item.getStartDate() != null && item.getStartDate().after(date) || item.getEndDate() != null && item.getEndDate().before(date)) continue;
                return new NestedEntityReference(ctr, (BaseEntity)item);
            }
        }
        return null;
    }

    private static void applyTravelPolicy(Product product, AirProductContractRelationData contractRelation, boolean traceEnabled) {
        if (GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) != ContractType.CLIENT) {
            return;
        }
        try {
            AirRulesProductHandler.ifPresent(h -> h.applyTravelPolicy(product, contractRelation, traceEnabled));
        }
        catch (Throwable e) {
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_RULE_APPLY_TRAVEL_POLICY_ERROR, (Throwable)e, (Object[])new Object[0]));
        }
    }

    private static ExchangeRateData updateServiceData(Product product, AirProductContractRelationData contractRelation, GeneralProductHelper.RelationData last, List<EntityContainer<Contract>> contracts, EntityReference<Organization> customerRef) {
        AirProductContractRelationData prevRelation;
        BigDecimal correct;
        Product previousProduct;
        EntityContainer<Contract> contractCtr;
        ContractRelationGeneralData generalData = contractRelation.getGeneralData();
        if (contracts.size() == 1 && ((Contract)contracts.get(0).getEntity()).isNewModel()) {
            contractCtr = contracts.get(0);
            generalData.setContract(((Contract)contractCtr.getEntity()).getCustomers().isEmpty() ? null : new NestedEntityReference(contractCtr, (BaseEntity)((Contract)contractCtr.getEntity()).getCustomers().get(0)));
        } else {
            Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler((BaseProduct)product).findIssueDate((BaseProduct)product), Date::new);
            NestedEntityReference<Contract, ContractCustomerInfo> ref = AirRulesHelper.buildContractNestedRef(contracts, customerRef, date);
            contractCtr = ref != null ? (EntityContainer)contracts.stream().filter(c -> ref.getUid().equals(c.getUid())).findFirst().orElse(null) : null;
            generalData.setContract(ref);
        }
        generalData.getContractData().setContract(contractCtr != null ? contractCtr.toReference() : null);
        generalData.setTranslateSupplierFees(null);
        ProductStatus productStatus = product.getStatus();
        Date productDate = GeneralProductHelper.getProductDate((BaseProduct)product);
        EntityReference supplier = GeneralProductHelper.getSupplier((BaseProduct)product);
        ExchangeRateData rateData = RulesHelper.getExchangeRateData(contracts, customerRef, (Date)productDate, (EntityReference)supplier, (String)last.getCurrency(), (boolean)true, (EntityReference)contractRelation.getDescription(), (List)product.getValidationMessages());
        generalData.setCurrency((DictionaryReference)(rateData != null ? rateData.getCurrency() : new CurrencyInfoReference(last.getCurrency())));
        generalData.setRate(rateData);
        String currency = generalData.getCurrency() != null ? generalData.getCurrency().getCode() : DictHelper.getLocalCurrency();
        ContractRelationServiceData serviceData = contractRelation.getServiceData();
        BigDecimal oldCorrect = serviceData.getDetalization().getCorrectVat();
        GeneralProductHelper.updateServiceData((BaseProduct)product, (BaseContractRelationData)contractRelation, (GeneralProductHelper.RelationData)last);
        if (rateData != null) {
            last.setUpdateFops(true);
        }
        if (last.shouldUpdateFops()) {
            BigDecimal currentPaymentPrice;
            BigDecimal paymentPrice;
            BigDecimal addToServiceFop;
            Date operationDate = GeneralProductHelper.getOperationDate((BaseProduct)product);
            for (ProductFop fop : contractRelation.getFops()) {
                if (!AirProductHelper.isServiceFop((ProductFop)fop) || fop.getAmount() == null || currency.equals(fop.getAmount().getCurrency())) continue;
                fop.getAmount().setValue(AirRulesHelper.getMoneyValue(fop.getAmount(), currency, operationDate, (EntityReference<Organization>)supplier));
                fop.getAmount().setCurrency(currency);
            }
            previousProduct = product.getPreviousProduct();
            if (previousProduct != null && previousProduct.getStatus() == ProductStatus.EXCHANGE && previousProduct.getPreviousProduct() != null) {
                BigDecimal currentExchangePrice;
                BigDecimal addToExchangeFop;
                AirProductContractRelationData prevSellRelation;
                BigDecimal prevExchangePrice = BigDecimal.ZERO;
                Product prevSellProduct = previousProduct.getPreviousProduct();
                AirProductContractRelationData airProductContractRelationData = prevSellRelation = prevSellProduct != null ? AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prevSellProduct), (EntityReference)contractRelation.getDescription()) : null;
                if (prevSellRelation != null) {
                    prevExchangePrice = prevSellRelation.getFops().stream().filter(AirProductHelper::isServiceFop).map(f -> AirRulesHelper.getMoneyValue(f.getAmount(), currency, operationDate, (EntityReference<Organization>)supplier)).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (BigDecimal.ZERO.compareTo(addToExchangeFop = prevExchangePrice.subtract(currentExchangePrice = contractRelation.getFops().stream().filter(f -> f.getType() == PaymentType.TICKET).map(f -> AirRulesHelper.getMoneyValue(f.getAmount(), currency, operationDate, (EntityReference<Organization>)supplier)).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add))) != 0) {
                    BigDecimal surcharge;
                    ProductFop exchangeFop = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.TICKET).filter(f -> currency.equals(f.getAmount() != null && f.getAmount().getCurrency() != null ? f.getAmount().getCurrency() : DictHelper.getLocalCurrency())).findFirst().orElse(null);
                    if (null == exchangeFop) {
                        exchangeFop = new ProductFop();
                        exchangeFop.setType(PaymentType.TICKET);
                    }
                    if (exchangeFop.getAmount() == null) {
                        Money money = new Money();
                        money.setValue(BigDecimal.ZERO);
                        money.setCurrency(currency);
                        exchangeFop.setAmount(money);
                    }
                    if (exchangeFop.getAmount().getValue() == null) {
                        exchangeFop.getAmount().setValue(BigDecimal.ZERO);
                    }
                    if (BigDecimal.ZERO.compareTo(surcharge = exchangeFop.getAmount().getValue().add(addToExchangeFop)) > 0) {
                        surcharge = BigDecimal.ZERO;
                    }
                    exchangeFop.getAmount().setValue(surcharge);
                }
            }
            if (BigDecimal.ZERO.compareTo(addToServiceFop = (paymentPrice = serviceData.getPaymentPrice()).subtract(currentPaymentPrice = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).map(f -> AirRulesHelper.getMoneyValue(f.getAmount(), currency, operationDate, (EntityReference<Organization>)supplier)).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).subtract(contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).flatMap(f -> f.getCommissions().stream()).filter(c -> GeneralProductHelper.isHiddenFee((EntityReference)c.getCommissionProperties())).map(BaseCommission::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)))) != 0) {
                ProductFop serviceFop = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.CASH).filter(f -> currency.equals(f.getAmount() != null && f.getAmount().getCurrency() != null ? f.getAmount().getCurrency() : DictHelper.getLocalCurrency())).findFirst().orElse(null);
                if (null == serviceFop) {
                    serviceFop = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.INVOICE).filter(f -> currency.equals(f.getAmount() != null && f.getAmount().getCurrency() != null ? f.getAmount().getCurrency() : DictHelper.getLocalCurrency())).findFirst().orElse(null);
                }
                if (null == serviceFop) {
                    serviceFop = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).filter(f -> currency.equals(f.getAmount() != null && f.getAmount().getCurrency() != null ? f.getAmount().getCurrency() : DictHelper.getLocalCurrency())).findFirst().orElse(null);
                }
                if (null == serviceFop) {
                    serviceFop = new ProductFop();
                    serviceFop.setType(PaymentType.CASH);
                    OnCreateFopListener.fire((BaseProduct)product, (Fop)serviceFop, (ContractType)GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()));
                }
                if (serviceFop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(currency);
                    serviceFop.setAmount(money);
                }
                if (serviceFop.getAmount().getValue() == null) {
                    serviceFop.getAmount().setValue(BigDecimal.ZERO);
                }
                serviceFop.getAmount().setValue(serviceFop.getAmount().getValue().add(addToServiceFop));
                if (!contractRelation.getFops().contains(serviceFop)) {
                    contractRelation.getFops().add(serviceFop);
                }
            }
        }
        if (BigDecimal.ZERO.compareTo(correct = MiscUtil.guarded((BigDecimal)serviceData.getDetalization().getCorrectVat()).subtract(MiscUtil.guarded((BigDecimal)oldCorrect))) != 0) {
            ProductFop serviceFop = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.CASH).filter(f -> currency.equals(f.getAmount() != null && f.getAmount().getCurrency() != null ? f.getAmount().getCurrency() : DictHelper.getLocalCurrency())).findFirst().orElse(null);
            if (null == serviceFop) {
                serviceFop = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).filter(f -> f.getType() == PaymentType.INVOICE).filter(f -> currency.equals(f.getAmount() != null && f.getAmount().getCurrency() != null ? f.getAmount().getCurrency() : DictHelper.getLocalCurrency())).findFirst().orElse(null);
            }
            if (null == serviceFop) {
                serviceFop = contractRelation.getFops().stream().filter(AirProductHelper::isServiceFop).filter(f -> currency.equals(f.getAmount() != null && f.getAmount().getCurrency() != null ? f.getAmount().getCurrency() : DictHelper.getLocalCurrency())).findFirst().orElse(null);
            }
            if (null == serviceFop) {
                serviceFop = new ProductFop();
                serviceFop.setType(PaymentType.CASH);
                OnCreateFopListener.fire((BaseProduct)product, (Fop)serviceFop, (ContractType)GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()));
            }
            if (serviceFop.getAmount() == null) {
                Money money = new Money();
                money.setValue(BigDecimal.ZERO);
                money.setCurrency(currency);
                serviceFop.setAmount(money);
            }
            if (serviceFop.getAmount().getValue() == null) {
                serviceFop.getAmount().setValue(BigDecimal.ZERO);
            }
            serviceFop.getAmount().setValue(serviceFop.getAmount().getValue().add(correct));
        }
        if ((ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus) && (previousProduct = product.getPreviousProduct()) != null && (prevRelation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)previousProduct), (EntityReference)contractRelation.getDescription())) != null) {
            String prevCurrency;
            ContractRelationGeneralData prevGeneralData = prevRelation.getGeneralData();
            String string = prevCurrency = prevGeneralData.getCurrency() != null ? prevGeneralData.getCurrency().getCode() : DictHelper.getLocalCurrency();
            if (Objects.equals(currency, prevCurrency)) {
                return prevRelation.getGeneralData().getRate();
            }
        }
        return rateData;
    }

    private static BigDecimal getMoneyValue(Money amount, String currency, Date operationDate, EntityReference<Organization> supplier) {
        if (amount == null || amount.getValue() == null) {
            return null;
        }
        if (currency.equals(amount.getCurrency())) {
            return amount.getValue();
        }
        CurrencyRateType rateType = MulticurrencyHelper.getCurrencyRateType((String)currency, (boolean)true);
        CurrencyRate rate = DictHelper.findExactCurrencyRate((String)(amount.getCurrency() != null ? amount.getCurrency() : DictHelper.getLocalCurrency()), (String)currency, (Date)(operationDate == null ? new Date() : operationDate), (CurrencyRateType)rateType, null, supplier);
        if (rate != null) {
            return amount.getValue().multiply(BigDecimal.valueOf(rate.getRate()));
        }
        return amount.getValue();
    }

    private static void deleteRulesValidationMessages(Product product) {
        product.getValidationMessages().removeIf(validationMessage -> validationMessage.getCategory() == ValidationMessageCategory.RULES);
    }

    private static void devirtualize(Product product, Set<Product> vProducts) throws Exception {
        if ("99A".equals(product.getBlankOwnerNumber()) || "99\u0410".equals(product.getBlankOwnerNumber())) {
            TchRulesHelper.deVirtualize(new ArrayList<Product>(vProducts));
        } else if ("870".equals(product.getBlankOwnerNumber())) {
            ClassOfServiceVirtualizationHelper.deVirtualize(new ArrayList<Product>(vProducts));
        } else if ("421".equals(product.getBlankOwnerNumber())) {
            S7VirtualizationHelper.deVirtualize(new ArrayList<Product>(vProducts));
        }
        ExternalTicketVirtualizationHelper.devirtualize(product, vProducts);
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            for (AppliedRule rule : product.getReservation().getBookingFile().getAppliedRules()) {
                for (Product prod : vProducts) {
                    if (!prod.getUid().equals(rule.getProductUid())) continue;
                    rule.setProductUid(product.getUid());
                }
            }
        }
    }

    private static boolean applyRules(Product product, RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, EntityContainer<Contract> contract, EntityContainer<? extends BaseRulesContainer> container) throws Exception {
        proxy.getTracer().traceLogic(String.format("container applied: %s", container.toReference()));
        HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
        RulesHelper.applyContainerRules(container, Collections.singletonList(proxy), (BaseProduct)product);
        LinkedHashSet appliedRulesLocal = new LinkedHashSet(proxy.getAppliedRules());
        appliedRulesLocal.removeAll(appliedRulesBefore);
        if (!appliedRulesLocal.isEmpty()) {
            List appliedRules = RulesHelper.calcAppliedRulesToBooking(proxy, appliedRulesLocal, Collections.singletonList(container), (BaseProduct)product, contract);
            product.getReservation().getBookingFile().getAppliedRules().addAll(appliedRules);
            return true;
        }
        return false;
    }

    private static void applyRules(Product product, RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, Map<PaymentType, List<Commission>> result, Collection<EntityContainer<Contract>> contracts, AirProductContractRelationData contractRelation, ExchangeRateData rateData, EntityContainer<BookingFile> bookingCtr, boolean simulate, boolean hasTripartiteContracts, boolean separateSupplierFees, Map<Parameter, Object> params, List<ContractCustomerInfo> customerInfos, DebugInfo info, boolean traceEnabled) throws Exception {
        ContractActionsProvider cap;
        EntityContainer<Contract> contract = null;
        boolean translateSupplierFees = true;
        boolean contractSet = false;
        ContractType contractRelationContractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
        boolean technicalProviderContract = contractRelationContractType == ContractType.TECHNICAL_PROVIDER;
        boolean vendorContract = contractRelationContractType == ContractType.VENDOR;
        try {
            block2: for (EntityContainer<Contract> ctr : contracts) {
                log.debug("applying contract " + ctr.toReference());
                proxy.getTracer().traceLogic(String.format("contract applied: %s", ctr.toReference()));
                if (((Contract)ctr.getEntity()).isNewModel()) {
                    Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler((BaseProduct)product).findIssueDate((BaseProduct)product), Date::new);
                    List rules = ProfileHelper.getRuleContainersData(ctr, (Date)date);
                    for (ProfileHelper.RuleContainerData data : rules) {
                        proxy.setProxyType(Targets.PRODUCT_COMMISSION.getId());
                        if (technicalProviderContract) {
                            proxy.setProxyType("technical_fee_model_contract".equals(data.getContainer().getUid()) ? Targets.TECHNICAL_FEE.getId() : Targets.TECHNICAL_FEE_SYSTEM.getId());
                        }
                        if (!AirRulesHelper.applyRules(product, proxy, ctr, (EntityContainer<? extends BaseRulesContainer>)data.getContainer())) continue;
                        if (contract == null) {
                            contract = ctr;
                        }
                        if (contractSet || data.isTranslateSupplierFees() == null) continue;
                        contract = ctr;
                        translateSupplierFees = data.isTranslateSupplierFees();
                        contractSet = true;
                    }
                    continue;
                }
                proxy.setProxyType(Targets.PRODUCT_COMMISSION.getId());
                if (!AirRulesHelper.applyRules(product, proxy, ctr, ctr)) continue;
                if (contract == null) {
                    contract = ctr;
                }
                if (contractSet) continue;
                for (ContractCustomerInfo customerInfo : customerInfos) {
                    if (CollectionUtil.find((Iterable)((Contract)ctr.getEntity()).getCustomers(), (String)customerInfo.getUid()) == null) continue;
                    contract = ctr;
                    translateSupplierFees = customerInfo.isTranslateSupplierFees();
                    contractRelation.getGeneralData().setContract(new NestedEntityReference(ctr, (BaseEntity)customerInfo));
                    contractRelation.getGeneralData().getContractData().setContract(ctr.toReference());
                    contractSet = true;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("failed applying rules from contracts of type %s for product %s", contractRelation.getDescription(), product), (Throwable)e);
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_ERROR_APPLYING_RULES, (Throwable)e, (Object[])new Object[]{contractRelation.getDescription()}));
            proxy.getTracer().traceError(String.format("failed applying rules: contract type %s", contractRelation.getDescription()), (Throwable)e);
            AirRulesHelper.cleanupFops(contractRelation);
            AirRulesHelper.updatePreviouslyCalculatedCommissions(proxy, contractRelation, rateData, hasTripartiteContracts, separateSupplierFees);
            return;
        }
        if (proxy.getActionSet() != null && (cap = (ContractActionsProvider)proxy.getActionSet()).isTranslateSupplierFee() != null) {
            translateSupplierFees = cap.isTranslateSupplierFee();
        }
        if (contract != null) {
            contractRelation.getGeneralData().setTranslateSupplierFees(Boolean.valueOf(translateSupplierFees));
            List<Commission> commissions = ((ProductCommissionActionSet)proxy.getActionSet()).createCommissions(contractRelation, translateSupplierFees, separateSupplierFees, rateData, AirProductHelper.getContractRelations((Product)product), new LinkedHashSet<ValidationMessage>());
            if (result.isEmpty()) {
                for (PaymentType pt : ((ProductCommissionActionSet)proxy.getActionSet()).getAllowedPaymentTypes()) {
                    result.put(pt, new ArrayList());
                }
            }
            for (RuleResultValue rrv : ((ProductCommissionActionSet)proxy.getActionSet()).getResults().values()) {
                EntityContainer pfpCtr;
                PaymentFeeProperties pfp;
                if (!rrv.getTarget().getType().isAssignableFrom(PaymentFeeProperties.class) || !result.containsKey((pfp = (PaymentFeeProperties)(pfpCtr = EntityStorage.get().resolve(rrv.getTarget())).getEntity()).getPaymentType())) continue;
                Double ptCommissionRate = null;
                BigDecimal ptCommissionValue = null;
                String ptCommissionCurrencyCode = null;
                if (pfp.isRate()) {
                    ptCommissionRate = rrv.getValue();
                } else {
                    ptCommissionValue = BigDecimal.valueOf(rrv.getValue());
                    ptCommissionCurrencyCode = rrv.getCurrencyCode();
                }
                Commission commission = new Commission();
                commission.setContractType(contractRelationContractType);
                if (ptCommissionValue != null && ptCommissionCurrencyCode != null) {
                    Money money = new Money();
                    money.setCurrency(ptCommissionCurrencyCode);
                    money.setValue(ptCommissionValue);
                    commission.setAmount(money);
                }
                if (ptCommissionRate != null) {
                    commission.setRate(ptCommissionRate);
                }
                commission.setRoundingMode(pfp.getRoundingMode());
                commission.setRoundingValue(pfp.getRoundingValue());
                commission.setCommissionProperties(pfpCtr.toReference());
                Product prod = ((ProductCommissionActionSet)proxy.getActionSet()).getProduct();
                HashMap<String, PaymentType> originalPts = new HashMap<String, PaymentType>();
                boolean fakeClientFopRequired = true;
                List clientFops = Objects.requireNonNull(AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)prod), (ContractType)ContractType.CLIENT)).getFops();
                for (ProductFop pf : clientFops) {
                    originalPts.put(pf.getUid(), pf.getType());
                    pf.setType(pfp.getPaymentType());
                    if (!AirProductHelper.isServiceFop((ProductFop)pf)) continue;
                    fakeClientFopRequired = false;
                }
                ProductFop fakeFop = null;
                if (fakeClientFopRequired) {
                    fakeFop = new ProductFop();
                    fakeFop.setType(pfp.getPaymentType());
                    Money m = new Money();
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
                    m.setValue(handler.calculateProductPrice((BaseProduct)prod, ContractType.CLIENT).getTotal());
                    m.setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null));
                    fakeFop.setAmount(m);
                    clientFops.add(fakeFop);
                }
                ((ProductCommissionActionSet)proxy.getActionSet()).updatePaymentFeeAmount(commission, contractRelation, new ArrayList<ValidationMessage>(), !pfp.isChargeOnRefund());
                if (fakeFop != null) {
                    clientFops.remove(fakeFop);
                }
                for (ProductFop pf : clientFops) {
                    pf.setType((PaymentType)originalPts.get(pf.getUid()));
                }
                result.get(pfp.getPaymentType()).add(commission);
            }
            AirRulesHelper.setManualCommissionsAppliedFlags(product, commissions, contractRelationContractType);
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_RULE_WAS_APPLIED, (Object[])new Object[]{contractRelation.getDescription()}));
            proxy.getTracer().traceLogic(String.format("rules applied: contract type = %s", contractRelation.getDescription()));
            log.debug(String.format("rules applied: contract type = %s", contractRelation.getDescription()));
        } else {
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_ONE_RULE_WAS_APPLIED, (Object[])new Object[]{contractRelation.getDescription()}));
            proxy.getTracer().traceLogic(String.format("rules were not applied: contract type = %s", contractRelation.getDescription()));
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                proxy.getTracer().traceLogic("trying to copy commissions from related sell");
            }
            AirRulesHelper.cleanupFops(contractRelation);
            AirRulesHelper.updatePreviouslyCalculatedCommissions(proxy, contractRelation, rateData, hasTripartiteContracts, separateSupplierFees);
            log.warn(String.format("rules were not applied: contract type = %s", contractRelation.getDescription()));
        }
        AirRulesHelper.applyTravelPolicy(product, contractRelation, traceEnabled);
        if (vendorContract) {
            product.setSabreExcludeCommissionQualifier(((ProductCommissionActionSet)proxy.getActionSet()).isSabreExcludeCommissionQualifier());
        }
        product.setContractRulesApplied(true);
        if (info != null) {
            info.startBlock("trace");
            info.message(String.format("trace of %s (%s)", AirRulesHelper.getProductTitle(product), contractRelation.getDescription()));
            info.message(proxy.getTracer().getTrace());
            info.endBlock();
        }
        if (!simulate && ObjectCreationSettingsHelper.isCreateRulesDebugInfo(((BookingFile)bookingCtr.getEntity()).getNumber()) || params != null && Boolean.TRUE.equals(params.get(Parameter.CREATE_LOG_DOCUMENT))) {
            AirRulesHelper.saveLogDocument(proxy, bookingCtr, product, contractRelation, params);
        }
        if (LoggerFactory.getLogger((String)"com.gridnine.xtrip.RULE_PROXY_TRACE").isDebugEnabled()) {
            AirRulesHelper.traceToLog(proxy, product, contractRelation);
        }
    }

    private static Map<Product, RuleProxy<ProductPropertySet, ProductCommissionActionSet>> virtualize(Product product, RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, ContractType contractType, String initTrace) throws Exception {
        ArrayList<Product> vTickets = new ArrayList<Product>();
        List<Product> externalVirtualProducts = ExternalTicketVirtualizationHelper.virturalize(product, contractType);
        for (Product vProduct : externalVirtualProducts) {
            if (AirProductHelper.isTCHTicket((Product)product)) {
                if (AirProductHelper.isSpecialSchemeTCHTicket((Product)product)) {
                    try {
                        TchSpecialSchemeVirtualizationHelper.virtualize(vProduct, vTickets);
                    }
                    catch (Exception e) {
                        log.error(String.format("failed handling product with carrier code \"%s\": %s", product.getTourCode(), product), (Throwable)e);
                        product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CANT_VIRTUALIZE_TICKET_SPECIAL_SCHEME, (Throwable)e, (Object[])new Object[0]));
                    }
                    continue;
                }
                log.debug("blank owner is TCH, virtualizing");
                try {
                    TchRulesHelper.correctFops(vProduct);
                    TchRulesHelper.virtualize(vProduct, vTickets);
                }
                catch (Exception e) {
                    log.error("failed handling TCH: " + product, (Throwable)e);
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CANT_VIRTUALIZE_TICKET_99A, (Throwable)e, (Object[])new Object[0]));
                }
                continue;
            }
            if (contractType == ContractType.VENDOR && "870".equals(product.getBlankOwnerNumber())) {
                log.debug("blank owner number is  \"870\", virtualizing");
                try {
                    ClassOfServiceVirtualizationHelper.virtualize(vProduct, vTickets);
                }
                catch (Exception e) {
                    log.error("failed handling product with vendor code \"870\": " + AirRulesHelper.getProductTitle(product), (Throwable)e);
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CANT_VIRTUALIZE_TICKET_870, (Throwable)e, (Object[])new Object[0]));
                }
                continue;
            }
            if (contractType == ContractType.VENDOR && "421".equals(product.getBlankOwnerNumber())) {
                log.debug("blank owner number is  \"421\", virtualizing");
                try {
                    S7VirtualizationHelper.virtualize(vProduct, vTickets);
                }
                catch (Exception e) {
                    log.error("failed handling product with vendor code \"421\": " + AirRulesHelper.getProductTitle(product), (Throwable)e);
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CANT_VIRTUALIZE_TICKET_421, (Throwable)e, (Object[])new Object[0]));
                }
                continue;
            }
            vTickets.add(vProduct);
            log.debug("product was added to product list");
        }
        LinkedHashMap<Product, RuleProxy<ProductPropertySet, ProductCommissionActionSet>> result = new LinkedHashMap<Product, RuleProxy<ProductPropertySet, ProductCommissionActionSet>>();
        for (Product prod : vTickets) {
            if (prod == product) {
                proxy.getTracer().setTrace(initTrace);
                result.put(prod, proxy);
                continue;
            }
            RuleProxy proxy2 = new RuleProxy();
            proxy2.setProxyDate(prod.getIssueDate());
            proxy2.setProxyType(Targets.PRODUCT_COMMISSION.getId());
            ProductPropertySet ps = AirRulesHelper.createProductPropertySet((RuleProxy<ProductPropertySet, ProductCommissionActionSet>)proxy2);
            try {
                ps.init(prod);
                proxy2.setPropertySet((Object)ps);
                TchSpecialSchemeVirtualizationHelper.updateProxy((RuleProxy<ProductPropertySet, ProductCommissionActionSet>)proxy2, contractType);
                S7VirtualizationHelper.updateProxy((RuleProxy<ProductPropertySet, ProductCommissionActionSet>)proxy2);
            }
            catch (Exception e) {
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_ERROR_APPLYING_CONTRACTS, (Throwable)e, (Object[])new Object[0]));
                continue;
            }
            ProductCommissionActionSet as = AirRulesHelper.createProductActionSet((RuleProxy<ProductPropertySet, ProductCommissionActionSet>)proxy2);
            proxy2.setActionSet((Object)as);
            result.put(prod, (RuleProxy<ProductPropertySet, ProductCommissionActionSet>)proxy2);
        }
        return result;
    }

    private static void traceToLog(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, Product product, AirProductContractRelationData contractRelation) {
        try {
            String trace = proxy.getTracer().getTrace();
            String productTitle = AirRulesHelper.getProductTitle(product).replaceAll("[\\\\/:*?\"<>|]", "");
            Calendar cal = Calendar.getInstance();
            String filename = String.format("%s_%s.txt", TextUtil.isBlank((String)productTitle) ? MiscUtil.getSimpleClassName(product.getClass()) + product.getUid() : productTitle, contractRelation != null ? contractRelation.getDescription() : null);
            File file = new File(Environment.getRootFolder(), String.format("logs/rules/%s/%s/%s/%s", cal.get(1), cal.get(2), cal.get(5), filename));
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                log.error("unable to create folder " + file.getParentFile());
                return;
            }
            if (file.exists() && !file.canWrite()) {
                log.error("unable to write to log file " + file);
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                IoUtil.copyStream((InputStream)new ByteArrayInputStream(trace.getBytes(StandardCharsets.UTF_8)), (OutputStream)fos, (int)256);
            }
        }
        catch (Throwable e) {
            log.error("unable to trace log", e);
        }
    }

    private static void updatePreviouslyCalculatedCommissions(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, AirProductContractRelationData contractRelation, ExchangeRateData rateData, boolean hasTripartiteCommissions, boolean separateSupplierFees) {
        if (((ProductPropertySet)proxy.getPropertySet()).getProduct().getStatus() == ProductStatus.REFUND || ((ProductPropertySet)proxy.getPropertySet()).getProduct().getStatus() == ProductStatus.EXCHANGE || hasTripartiteCommissions) {
            try {
                List<Commission> commissions = ((ProductCommissionActionSet)proxy.getActionSet()).createCommissions(contractRelation, separateSupplierFees, rateData, AirProductHelper.getContractRelations((Product)((ProductPropertySet)proxy.getPropertySet()).getProduct()), new ArrayList<ValidationMessage>());
                if (commissions.isEmpty()) {
                    log.debug("no commission was added");
                    return;
                }
                if (!hasTripartiteCommissions) {
                    ((ProductPropertySet)proxy.getPropertySet()).getProduct().getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_COMMISION_WAS_PARTIALLY_REFUNDED, (Object[])new Object[]{contractRelation.getDescription()}));
                }
            }
            catch (Throwable e) {
                log.error("unable to update refunded commissions", e);
                ((ProductPropertySet)proxy.getPropertySet()).getProduct().getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_COMMISSION_UPDATE_FAILED, (Throwable)e, (Object[])new Object[]{contractRelation.getDescription()}));
            }
        }
    }

    private static void cleanupFops(AirProductContractRelationData contractRelation) {
        Iterator it = contractRelation.getFops().iterator();
        while (it.hasNext()) {
            EntityContainer ctr;
            ProductFop fop = (ProductFop)it.next();
            if (AirProductHelper.isServiceFop((ProductFop)fop) || (ctr = EntityStorage.get().resolve(((Commission)fop.getCommissions().get(0)).getCommissionProperties())) != null && ctr.getEntity() instanceof FeeProperties && ((FeeProperties)ctr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED || ctr != null && ctr.getEntity() instanceof CommissionProperties && ((CommissionProperties)ctr.getEntity()).isManuallyCalculated() || ctr != null && ctr.getEntity() instanceof DiscountProperties && ((DiscountProperties)ctr.getEntity()).getType() == DiscountType.MANUALLY_CALCULATED) continue;
            it.remove();
        }
    }

    static String getProductTitle(Product product) {
        return product.getSystemNumber() != null ? product.getSystemNumber() : (product.getTraveller() != null ? product.getTraveller().getName() : "?");
    }

    /*
     * Could not resolve type clashes
     */
    private static void updateManuallyCalculatedFees(Product product) throws Exception {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)product)) {
            Object comm2;
            String equivalentCurrency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            Date operationDate = GeneralProductHelper.getOperationDate((BaseProduct)product);
            ExchangeRateData rate = relation.getGeneralData().getRate();
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object comm2 : relation.getCommissions()) {
                FeeProperties prop;
                EntityContainer ctr;
                if (comm2.getEquivalentAmount() == null || (ctr = EntityStorage.get().resolve(comm2.getCommissionProperties())) == null || !(ctr.getEntity() instanceof FeeProperties) || (prop = (FeeProperties)ctr.getEntity()).getType() != FeeType.MANUALLY_CALCULATED) continue;
                comm2.setRoundingMode(prop.getRoundingMode());
                comm2.setRoundingValue(prop.getRoundingValue());
                AirRulesHelper.updateManuallyCalculatedFeeAmount((Commission)comm2, equivalentCurrency, operationDate, rate);
                boolean found = false;
                for (ProductFop fop : relation.getFops()) {
                    if (!fop.getCommissions().contains(comm2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                list.add(comm2);
            }
            if (list.isEmpty()) continue;
            ProductFop productFop = null;
            comm2 = relation.getFops().iterator();
            while (comm2.hasNext()) {
                ProductFop fop = (ProductFop)comm2.next();
                if (fop.getType() == PaymentType.TICKET) continue;
                productFop = fop;
                break;
            }
            ProductFop fop = new ProductFop();
            if (productFop != null) {
                fop.setAgent(productFop.getAgent());
                fop.setCard(productFop.getCard());
                fop.setType(productFop.getType());
            } else {
                fop.setAgent(product.getCashier() == null ? com.gridnine.xtrip.server.model.helpers.ProfileDao.findCurrentAgent(null) : product.getCashier());
                fop.setType(PaymentType.CASH);
            }
            BigDecimal value = BigDecimal.ZERO;
            for (Commission comm3 : list) {
                value = value.add(comm3.getEquivalentAmount());
            }
            fop.setOperationDate(new Date());
            fop.setAmount(SystemHelper.getMoney((double)value.doubleValue(), (String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
            fop.getCommissions().addAll(list);
            relation.getFops().add(fop);
        }
    }

    private static void updateManuallyCalculatedFeeAmount(Commission commission, String equivalentCurrency, Date operationDate, ExchangeRateData rate) {
        Money money = commission.getAmount();
        if (null == money || money.getCurrency() == null || money.getValue() == null || equivalentCurrency.equals(money.getCurrency())) {
            return;
        }
        ExchangeRateData rateData = rate != null ? rate : MulticurrencyHelper.buildExchangeRateData((String)money.getCurrency(), (String)equivalentCurrency, null, (Date)operationDate, null, (boolean)true);
        rateData.setRoundingMode(commission.getRoundingMode());
        rateData.setRoundingValue(commission.getRoundingValue());
        commission.setEquivalentAmount(RulesHelper.convert((BigDecimal)money.getValue(), (ExchangeRateData)rateData));
    }

    private static void setManualCommissionsAppliedFlags(Product product, List<Commission> commissions, ContractType contractType) {
        Boolean productManualDiscountApplied;
        Boolean productManualCommissionApplied;
        boolean manualFeeApplied = false;
        boolean manualCommissionApplied = false;
        boolean manualDiscountApplied = false;
        for (Commission commission : commissions) {
            EntityContainer properties = EntityStorage.get().resolve(commission.getCommissionProperties());
            if (properties == null) continue;
            if (properties.getEntity() instanceof FeeProperties && ((FeeProperties)properties.getEntity()).getType() == FeeType.MANUALLY_CALCULATED) {
                manualFeeApplied = true;
            }
            if (properties.getEntity() instanceof CommissionProperties && ((CommissionProperties)properties.getEntity()).isManuallyCalculated()) {
                manualCommissionApplied = true;
            }
            if (!(properties.getEntity() instanceof DiscountProperties) || ((DiscountProperties)properties.getEntity()).getType() != DiscountType.MANUALLY_CALCULATED) continue;
            manualDiscountApplied = true;
        }
        Boolean productManualFeeApplied = (Boolean)product.getManualFeeAppliedFlags().get(contractType);
        if (productManualFeeApplied == null || !productManualFeeApplied.booleanValue()) {
            product.getManualFeeAppliedFlags().put(contractType, manualFeeApplied);
        }
        if ((productManualCommissionApplied = (Boolean)product.getManualCommissionAppliedFlags().get(contractType)) == null || !productManualCommissionApplied.booleanValue()) {
            product.getManualCommissionAppliedFlags().put(contractType, manualCommissionApplied);
        }
        if ((productManualDiscountApplied = (Boolean)product.getManualDiscountAppliedFlags().get(contractType)) == null || !productManualDiscountApplied.booleanValue()) {
            product.getManualDiscountAppliedFlags().put(contractType, manualDiscountApplied);
        }
    }

    private static void saveLogDocument(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, EntityContainer<BookingFile> container, Product product, AirProductContractRelationData contractRelation, Map<Parameter, Object> params) throws Exception {
        EntityReference owner;
        String contractType;
        String productTitle;
        String name;
        DocumentType documentType;
        EntityContainer ctr = new EntityContainer(Document.class);
        ctr.setCreated(new Date());
        ctr.setModified(ctr.getCreated());
        ctr.setCreatedBy(LogicalStorage.get().getUser());
        ctr.setModifiedBy(ctr.getCreatedBy());
        ctr.getVersionInfo().setDataSource("air-rules-helper");
        String trace = proxy.getTracer().getTrace();
        Document document = (Document)ctr.getEntity();
        document.setContentType(ContentType.TEXT);
        byte[] content = trace.getBytes(StandardCharsets.UTF_8);
        document.setContent(content);
        document.setCheckSum(MiscUtil.getCheckSum((byte[])content));
        DocumentType documentType2 = documentType = params != null ? (DocumentType)params.get(Parameter.LOG_DOCUMENT_TYPE) : null;
        if (null == documentType) {
            documentType = DocumentType.DEBUG_RULES;
        }
        document.setType(documentType);
        String string = name = params != null ? (String)params.get(Parameter.LOG_DOCUMENT_NAME) : null;
        if (TextUtil.isBlank((String)name)) {
            name = "Log for product ${product} for contract of type ${contractType}";
        }
        if (TextUtil.isBlank((String)(productTitle = AirRulesHelper.getProductTitle(product)))) {
            productTitle = "?";
        }
        String string2 = contractType = contractRelation != null ? String.valueOf(contractRelation.getDescription()) : "?";
        if (TextUtil.isBlank((String)contractType)) {
            contractType = "?";
        }
        name = name.replace("${product}", productTitle).replace("${contractType}", contractType);
        document.setName(name);
        document.setDescription(document.getName());
        document.setTitle(document.getName());
        EntityReference entityReference = owner = params != null ? (EntityReference)params.get(Parameter.LOG_DOCUMENT_OWNER) : null;
        if (null == owner) {
            owner = container.toReference();
        }
        document.setOwner(owner);
        document.setCreated(ctr.getCreated());
        String navigationKey = product.getUid();
        if (navigationKey.startsWith("TCH_VIRTUAL:") || navigationKey.startsWith("CLASS_OF_SERVICE_VIRTUAL:")) {
            navigationKey = navigationKey.substring(navigationKey.indexOf("|") + 1);
        }
        if (navigationKey.startsWith("TCH_SPECIAL_SCHEME_VIRTUALIZATION")) {
            navigationKey = navigationKey.substring(navigationKey.indexOf("|") + 1, navigationKey.lastIndexOf("|"));
        }
        document.setNavigationKey(navigationKey);
        EntityStorage.get().save(ctr, false);
    }

    private static RuleProxy<ProductPropertySet, ProductCommissionActionSet> createRuleProxy(Product product, boolean enableTracing) throws Exception {
        RuleProxy result = new RuleProxy();
        result.getTracer().setDisabled(!enableTracing);
        ProductPropertySet propSet = AirRulesHelper.createProductPropertySet((RuleProxy<ProductPropertySet, ProductCommissionActionSet>)result);
        propSet.init(product);
        result.setProxyType(Targets.PRODUCT_COMMISSION.getId());
        result.setProxyDate(product.getIssueDate());
        result.setPropertySet((Object)propSet);
        result.setActionSet((Object)AirRulesHelper.createProductActionSet((RuleProxy<ProductPropertySet, ProductCommissionActionSet>)result));
        return result;
    }

    private static ProductPropertySet createProductPropertySet(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy) {
        AirRulesProductHandler airProductHandler = AirRulesProductHandler.get();
        if (airProductHandler != null) {
            return airProductHandler.createPropertySet(proxy);
        }
        return new ProductPropertySet(proxy);
    }

    private static ProductCommissionActionSet createProductActionSet(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy) {
        AirRulesProductHandler airProductHandler = AirRulesProductHandler.get();
        if (airProductHandler != null) {
            return airProductHandler.createActionSet(proxy);
        }
        return new ProductCommissionActionSet(proxy, (ProductPropertySet)proxy.getPropertySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Product> prepareProducts(EntityContainer<BookingFile> bookingCtr, boolean forced, boolean simulate, List<Message> messages, boolean enabledTracing) throws Exception {
        ArrayList<Product> result = new ArrayList<Product>();
        BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!Product.class.equals(baseProduct.getClass())) continue;
                Product product = (Product)baseProduct;
                log.debug(String.format("analyzing product \u2116 = \"%s\", traveller = \"%s\"", product.getSystemNumber(), product.getTraveller() != null ? product.getTraveller().getName() : null));
                if (product.isChecked()) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AirRulesHelper_productDontApplyRulesChecked, (Object[])new Object[]{AirRulesHelper.getProductTitle(product)}));
                    log.debug("product is checked, skipping");
                    continue;
                }
                if (product.isContractRulesApplied() && !forced) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AirRulesHelper_productDontApplyRulesApplyEarlier, (Object[])new Object[]{AirRulesHelper.getProductTitle(product)}));
                    log.debug("contract rules for product were already applied, skipping");
                    continue;
                }
                if (ShipmentHelper.hasRelatedShipment((BaseProduct)product)) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AirRulesHelper_productHasShimpent, (Object[])new Object[]{GeneralProductHelper.getProductTitle((BaseProduct)product)}));
                    log.debug(String.format("product %s has related shipment, skipping", GeneralProductHelper.getProductTitle((BaseProduct)product)));
                    ArrayList products2 = new ArrayList();
                    products2.add(XCloneHelper.clone((XCloneable)product));
                    DebugInfo info = null;
                    VoidProductVirtualizationHelper.virtualizeVoidProducts(products2, messages, info);
                    Iterator iterator = products2.iterator();
                    while (iterator.hasNext()) {
                        Product product2 = (Product)iterator.next();
                        product2.getValidationMessages().clear();
                        RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy = null;
                        try {
                            try {
                                proxy = AirRulesHelper.createRuleProxy(product2, enabledTracing);
                            }
                            catch (Throwable e) {
                                log.error("unable to create proxy", e);
                                product2.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CANT_APPLY_RULES, (Throwable)e, (Object[])new Object[0]));
                                BspProductVirtualizationHelper.devirtualize(product2, proxy == null ? null : proxy.getTracer());
                                VoidProductVirtualizationHelper.devirtualizeVoidProducts(product2, messages, info);
                                product.getValidationMessages().addAll(product2.getValidationMessages());
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            BspProductVirtualizationHelper.devirtualize(product2, proxy == null ? null : proxy.getTracer());
                            VoidProductVirtualizationHelper.devirtualizeVoidProducts(product2, messages, info);
                            product.getValidationMessages().addAll(product2.getValidationMessages());
                            throw throwable;
                        }
                        BspProductVirtualizationHelper.virtualize(product2, proxy.getTracer());
                        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
                        ProductRelatedOrganizations organizations = AirRulesHelper.collectOrganizations(product2, validationMessages);
                        product2.getValidationMessages().addAll(validationMessages);
                        EntityReference agencyRef = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY);
                        AirTripartiteContractRulesHelper.applyTripartiteContracts(product2, proxy, (EntityReference<Organization>)agencyRef);
                        product.getTripartiteContractDetails().setIssuedUnder3d(product2.getTripartiteContractDetails().isIssuedUnder3d());
                        BspProductVirtualizationHelper.devirtualize(product2, proxy == null ? null : proxy.getTracer());
                        VoidProductVirtualizationHelper.devirtualizeVoidProducts(product2, messages, info);
                        product.getValidationMessages().addAll(product2.getValidationMessages());
                    }
                    product.getReservation().getBookingFile().getAppliedRules().removeIf(appliedRule -> appliedRule.isTravelPolicyRule() && product.getUid().equals(appliedRule.getProductUid()));
                    List contractRelations = AirProductHelper.getContractRelations((Product)product);
                    for (AirProductContractRelationData contractRelation : contractRelations) {
                        AirRulesHelper.applyTravelPolicy(product, contractRelation, enabledTracing);
                    }
                    continue;
                }
                bookingFile.getAppliedRules().removeIf(appliedRule -> product.getUid().equals(appliedRule.getProductUid()));
                if (!simulate && ObjectCreationSettingsHelper.isCreateRulesDebugInfo(((BookingFile)bookingCtr.getEntity()).getNumber())) {
                    AirRulesHelper.deleteLogDocument((EntityReference<BookingFile>)bookingCtr.toReference(), product.getUid());
                }
                if (product.getTicketType() != null && !GeneralProductRulesHelper.VALID_TICKET_TYPES.contains(product.getTicketType())) {
                    AirProductHelper.clearCommissionsExceptManuallyCalculated((Product)product, ((product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) && product.getPreviousProduct() != null && product.getPreviousProduct().getTicketType() == TicketType.FAKE || ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus()) ? 1 : 0) != 0);
                    AirRulesHelper.deleteRulesValidationMessages(product);
                    log.debug(String.format("product is not in %s, skipping", GeneralProductRulesHelper.VALID_TICKET_TYPES));
                    continue;
                }
                if (product.getStatus() == ProductStatus.EXCHANGE && product.getNextProduct() != null && product.getNextProduct().getMcoCategory() == MCOCategory.VOUCHER) {
                    for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)product)) {
                        item.getCommissions().clear();
                        item.getFops().removeIf(productFop -> !AirProductHelper.isServiceFop((ProductFop)productFop));
                    }
                    AirRulesHelper.deleteRulesValidationMessages(product);
                    product.setContractRulesApplied(true);
                    log.debug("product is exchanged on VOUCHER, skipping");
                    continue;
                }
                ProductCategory productCategory = product.getProductCategory();
                if (productCategory != ProductCategory.AIR && productCategory != ProductCategory.MCO && productCategory != ProductCategory.EXCESS_BAGAGE) {
                    log.debug("product is neither \"AIR\" nor \"MCO\" nor \"EXCESS_BAGAGE\", skipping");
                    continue;
                }
                result.add(product);
                log.debug("product was added to product list");
            }
        }
        result.sort(new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                int res = TextUtil.compare((String)AirRulesHelper.getProductTitle(o1), (String)AirRulesHelper.getProductTitle(o2), (boolean)false, (boolean)false);
                if (res != 0) {
                    return res;
                }
                return this.getStatusOrder(o1.getStatus()) - this.getStatusOrder(o2.getStatus());
            }

            private int getStatusOrder(ProductStatus status) {
                if (status == ProductStatus.SELL) {
                    return 1;
                }
                if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                    return 2;
                }
                return 0;
            }
        });
        return result;
    }

    private static void deleteLogDocument(EntityReference<BookingFile> reference, String uid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.DEBUG_RULES));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), reference));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)"navigationKey", (Object)uid), SearchCriterion.eq((String)"navigationKey", null)}));
        for (EntityContainer doc : StorageHelper.getEntityContainers((SearchQuery)query, BasicDocumentIndex.class)) {
            EntityStorage.get().delete(doc);
        }
    }

    public static EntityContainer<Contract> getContract(ContractType contractType, Product product, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer) throws Exception {
        String productTitle = AirRulesHelper.getProductTitle(product);
        if (customer == null) {
            switch (contractType) {
                case VENDOR: {
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_VENDOR_CONTRACT_DIDNT_APPIED_AGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case SUBAGENCY: {
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_SUBAGENCY_CONTRACT_DIDNT_APPIED_SUBAGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case CLIENT: {
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CLIENT_CONTRACT_DIDNT_APPIED_CUSTOMER_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
            }
            return null;
        }
        EntityReference<Organization> correctedSupplier = supplier;
        if (supplier == null && contractType == ContractType.VENDOR) {
            if (blankOwner == null) {
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_AND_BLANKOWNER, (Object[])new Object[]{productTitle}));
                return null;
            }
            correctedSupplier = blankOwner;
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_TRY_BLANKOWNER, (Object[])new Object[]{productTitle, correctedSupplier}));
        }
        List<ContractIndex> contractIndices = AirRulesHelper.getContractIndices(contractType, product, blankOwner, customer, correctedSupplier);
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        if (contractIndices.isEmpty() && allAgenciesProfile != null) {
            contractIndices = AirRulesHelper.getContractIndices(contractType, product, blankOwner, customer, (EntityReference<Organization>)allAgenciesProfile);
        }
        if (contractIndices.isEmpty()) {
            if (contractType.equals((Object)ContractType.CLIENT) && allClientsProfile != null) {
                contractIndices = AirRulesHelper.getContractIndices(contractType, product, blankOwner, (EntityReference<Organization>)allClientsProfile, correctedSupplier);
            } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                contractIndices = AirRulesHelper.getContractIndices(contractType, product, blankOwner, (EntityReference<Organization>)allAgenciesProfile, correctedSupplier);
            }
        }
        if (contractIndices.isEmpty()) {
            if (contractType.equals((Object)ContractType.CLIENT) && allAgenciesProfile != null && allClientsProfile != null) {
                contractIndices = AirRulesHelper.getContractIndices(contractType, product, blankOwner, (EntityReference<Organization>)allClientsProfile, (EntityReference<Organization>)allAgenciesProfile);
            } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                contractIndices = AirRulesHelper.getContractIndices(contractType, product, blankOwner, (EntityReference<Organization>)allAgenciesProfile, (EntityReference<Organization>)allAgenciesProfile);
            }
        }
        return GeneralProductRulesHelper.getContract(product, contractType, contractIndices, null);
    }

    private static List<ContractIndex> getContractIndices(ContractType contractType, Product product, EntityReference<Organization> blankOwner, EntityReference<Organization> customer, EntityReference<Organization> correctedSupplier) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), correctedSupplier));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), customer));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)contractType));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), blankOwner), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null)}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.provider.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.transferProvider.name(), null));
        Date date = product.getIssueDate();
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        return new ArrayList<ContractIndex>(EntityStorage.get().search(ContractIndex.class, query).getData());
    }

    public static MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> collectOldContracts(ContractType contractType, Product product, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer) {
        return AirRulesHelper.collectOldContracts(contractType, product, blankOwner, supplier, customer, null);
    }

    public static MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> collectOldContracts(ContractType contractType, Product product, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, Date forceDate) {
        Date date;
        String productTitle = AirRulesHelper.getProductTitle(product);
        List emptyList = Collections.emptyList();
        if (customer == null) {
            switch (contractType) {
                case VENDOR: {
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_VENDOR_CONTRACT_DIDNT_APPIED_AGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case SUBAGENCY: {
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_SUBAGENCY_CONTRACT_DIDNT_APPIED_SUBAGENCY_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
                case CLIENT: {
                    product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CLIENT_CONTRACT_DIDNT_APPIED_CUSTOMER_NOT_DEFINED, (Object[])new Object[]{productTitle}));
                    break;
                }
            }
            return new MiscUtil.Pair(emptyList, null);
        }
        EntityReference<Organization> correctedSupplier = supplier;
        if (supplier == null && contractType == ContractType.VENDOR) {
            if (blankOwner == null) {
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_AND_BLANKOWNER, (Object[])new Object[]{productTitle}));
                return new MiscUtil.Pair(emptyList, null);
            }
            correctedSupplier = blankOwner;
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_NO_VENDOR_TRY_BLANKOWNER, (Object[])new Object[]{productTitle, correctedSupplier}));
        }
        final EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        final EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        HashSet<EntityReference<Organization>> suppliers = new HashSet<EntityReference<Organization>>();
        HashSet<EntityReference<Organization>> customers = new HashSet<EntityReference<Organization>>();
        suppliers.add(correctedSupplier);
        customers.add(customer);
        if (allAgenciesProfile != null) {
            switch (contractType) {
                case VENDOR: {
                    customers.add(allAgenciesProfile);
                    break;
                }
                case SUBAGENCY: {
                    customers.add(allAgenciesProfile);
                    suppliers.add(allAgenciesProfile);
                    break;
                }
                case CLIENT: {
                    suppliers.add(allAgenciesProfile);
                }
            }
        }
        if (allClientsProfile != null && contractType == ContractType.CLIENT) {
            customers.add(allClientsProfile);
        }
        if (contractType == ContractType.VENDOR) {
            suppliers.add(null);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), null), SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)false)}));
        query.getCriteria().getCriterions().add(AirRulesHelper.toCriterion(ContractCustomerIndex.Property.supplier.name(), suppliers));
        query.getCriteria().getCriterions().add(AirRulesHelper.toCriterion(ContractCustomerIndex.Property.customer.name(), customers));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), blankOwner), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), null)}));
        }
        Date date2 = date = forceDate != null ? forceDate : product.getIssueDate();
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        ArrayList<EntityContainer> result = new ArrayList<EntityContainer>();
        final HashMap<EntityReference, EntityContainer> contractsMap = new HashMap<EntityReference, EntityContainer>();
        ArrayList<ContractCustomerIndex> contractIndexes = new ArrayList<ContractCustomerIndex>(EntityStorage.get().search(ContractCustomerIndex.class, query).getData());
        for (ContractCustomerIndex item : contractIndexes) {
            contractsMap.put(item.getSource(), EntityStorage.get().resolve(item.getSource()));
        }
        contractIndexes.sort(new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                int index2;
                EntityContainer ctr1 = (EntityContainer)contractsMap.get(o1.getSource());
                EntityContainer ctr2 = (EntityContainer)contractsMap.get(o2.getSource());
                if (((Contract)ctr1.getEntity()).getPriority() != ((Contract)ctr2.getEntity()).getPriority()) {
                    return ((Contract)ctr1.getEntity()).getPriority() > ((Contract)ctr2.getEntity()).getPriority() ? -1 : 1;
                }
                int index1 = this.getGeneralityIndex(o1);
                if (index1 != (index2 = this.getGeneralityIndex(o2))) {
                    return index1 > index2 ? 1 : -1;
                }
                if (((Contract)ctr1.getEntity()).isTypicalContract() != ((Contract)ctr2.getEntity()).isTypicalContract()) {
                    return ((Contract)ctr1.getEntity()).isTypicalContract() ? 1 : -1;
                }
                return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }

            private int getGeneralityIndex(ContractCustomerIndex o1) {
                return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getCustomer()) ? 2 : 0) + (allClientsProfile != null && allClientsProfile.equals((Object)o1.getCustomer()) ? 1 : 0);
            }
        });
        ArrayList<ContractCustomerInfo> customerInfos = new ArrayList<ContractCustomerInfo>();
        block11: for (ContractCustomerIndex index : contractIndexes) {
            EntityContainer ctr = (EntityContainer)contractsMap.get(index.getSource());
            if (!result.contains(ctr)) {
                result.add(ctr);
            }
            if (TextUtil.isBlank((String)index.getNumber())) continue;
            for (ContractCustomerInfo info : ((Contract)ctr.getEntity()).getCustomers()) {
                if (!info.getUid().equals(index.getNavigationKey())) continue;
                customerInfos.add(info);
                continue block11;
            }
        }
        return new MiscUtil.Pair(result, customerInfos);
    }

    private static SearchCriterion toCriterion(String propertyName, Set<EntityReference<Organization>> suppliers) {
        if (suppliers.size() == 1) {
            return SearchCriterion.eq((String)propertyName, suppliers.iterator().next());
        }
        ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> item : suppliers) {
            crits.add(SearchCriterion.eq((String)propertyName, item));
        }
        return SearchCriterion.or((SearchCriterion[])crits.toArray(new SearchCriterion[0]));
    }

    @Deprecated
    static void addValidationMessage(Product product, ValidationMessageSeverity severity, Throwable e, String key, Object ... parameters) {
        ValidationMessage result = new ValidationMessage();
        result.setSeverity(severity);
        result.setCategory(ValidationMessageCategory.RULES);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        result.setDetails(TextUtil.getExceptionStackTrace((Throwable)e));
        product.getValidationMessages().add(result);
    }

    static ProductRelatedOrganizations collectOrganizations(Product product, List<ValidationMessage> messages) throws Exception {
        String productTitle = AirRulesHelper.getProductTitle(product);
        EntityReference vendor = product.getBlankOwnerRef();
        if (vendor == null) {
            Set<EntityReference<Organization>> vendors;
            if (messages != null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_TRY_GET_BLANKOWNER_FROM_VALIDATOR));
            }
            EntityReference entityReference = vendor = !(vendors = com.gridnine.xtrip.server.model.helpers.ProfileDao.getVendorsForProduct(product)).isEmpty() ? vendors.iterator().next() : null;
            if (vendors.size() > 1 && messages != null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_MORE_THAN_ONE_BLANKOWNER, (Object[])new Object[]{vendor}));
            }
        }
        EntityReference supplier = AirProductHelper.getSupplier((Product)product);
        EntityReference agencyRef = AirProductHelper.getAgency((Product)product);
        if (supplier == null || agencyRef == null) {
            if (messages != null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_TRY_GET_AGENCY_FROM_VALIDATOR));
            }
            List validators = ValidatorHelper.getValidators((Product)product);
            if (supplier == null) {
                EntityReference entityReference = supplier = !validators.isEmpty() ? ((ValidatorIndex)validators.get(0)).getSupplier() : null;
                if (validators.size() > 1 && messages != null) {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_MORE_THAN_ONE_VENDOR, (Object[])new Object[]{productTitle, supplier}));
                }
            }
            if (agencyRef == null) {
                EntityReference entityReference = agencyRef = !validators.isEmpty() ? ((ValidatorIndex)validators.get(0)).getAgency() : null;
                if (validators.size() > 1 && messages != null) {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_MORE_THAN_ONE_AGENCY, (Object[])new Object[]{productTitle, agencyRef}));
                }
            }
        }
        if (agencyRef == null) {
            agencyRef = product.getReservation().getBookingFile().getAgency();
            if (messages != null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_TRY_GET_AGENCY_FROM_MAINTAB, (Object[])new Object[]{productTitle}));
            }
        }
        SalesChain salesChain = AirProductHelper.getSalesChain((Product)product);
        SalesChain correctedSalesChain = new SalesChain();
        correctedSalesChain.setDescription(salesChain.getDescription());
        correctedSalesChain.getContractors().addAll(salesChain.getContractors());
        for (Contractor item : correctedSalesChain.getContractors()) {
            EntityContainer ctr;
            if (item.getContractor() != null || (ctr = EntityStorage.get().resolve(item.getDescription())) == null) continue;
            if (((ContractorDescription)ctr.getEntity()).getPredefinedType() == PredefinedContractorType.AGENCY) {
                item.setContractor(agencyRef);
                continue;
            }
            if (((ContractorDescription)ctr.getEntity()).getPredefinedType() != PredefinedContractorType.SUPPLIER) continue;
            item.setContractor(supplier);
        }
        return new ProductRelatedOrganizations((EntityReference<Organization>)vendor, (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), salesChain);
    }
}

