/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.AviaSubsidizedActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AirSubsidizedContractRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(AirSubsidizedContractRulesHelper.class);

    static void applySubsidizedContracts(Product product, List<EntityContainer<Contract>> contracts, ProductPropertySet propertySet, RuleLogTracer tracer) {
        tracer.traceLogic("\u041f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u043c \u0441\u0443\u0431\u0441\u0443\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        try {
            ArrayList<RuleProxy> proxyList = new ArrayList<RuleProxy>();
            RuleProxy proxy = new RuleProxy();
            ProductPropertySet propSet = new ProductPropertySet(proxy);
            propSet.init(product);
            proxy.setProxyType(Targets.AVIA_SUBSIDIZED.getId());
            proxy.setProxyDate(product.getIssueDate());
            proxy.setPropertySet((Object)propSet);
            proxy.setActionSet((Object)new AviaSubsidizedActionSet(proxy, propSet));
            proxyList.add(proxy);
            EntityReference appliedContract = null;
            for (EntityContainer<Contract> ctr : contracts) {
                log.debug("applying contract " + ctr.toReference());
                HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
                List rules = RulesHelper.applyRules(ctr, proxyList, (BaseProduct)product);
                tracer.traceLogic(String.format("subsidized contract applied: contract = %s", ctr.toReference()));
                HashSet appliedRulesLocal = new HashSet(proxy.getAppliedRules());
                appliedRulesLocal.removeAll(appliedRulesBefore);
                if (appliedRulesLocal.isEmpty()) continue;
                if (appliedContract == null) {
                    appliedContract = ctr.toReference();
                }
                List appliedRules = RulesHelper.calcAppliedRulesToBooking((RuleProxy)proxy, appliedRulesLocal, (List)rules, (BaseProduct)product, ctr);
                product.getReservation().getBookingFile().getAppliedRules().addAll(appliedRules);
            }
            product.getTripartiteContractDetails().setContract(appliedContract);
            AviaSubsidizedActionSet actionSet = (AviaSubsidizedActionSet)proxy.getActionSet();
            if (!product.isIgnoreContractsForSubsidizedTariffFlag()) {
                if (actionSet.isSubsidized()) {
                    product.setSubsidizedTariff(true);
                    tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u0443\u0431\u0441\u0443\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0432 true");
                } else {
                    product.setSubsidizedTariff(false);
                    tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u0443\u0431\u0441\u0443\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0432 false");
                }
            } else {
                tracer.traceLogic("\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u043c \u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0443\u0436\u0435 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043ds");
            }
            boolean issuedUnder3d = Boolean.TRUE.equals(actionSet.getIssuedUnder3d());
            product.getTripartiteContractDetails().setIssuedUnder3d(issuedUnder3d);
            proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d \u043f\u043e 3d \u0432 " + issuedUnder3d);
            product.getTripartiteContractDetails().setTourcodeType(actionSet.getCalculationIndicator());
            tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0442\u0438\u043f \u0442\u0443\u0440\u043a\u043e\u0434\u0430 \u0432 " + actionSet.getCalculationIndicator());
            product.getTripartiteContractDetails().setPublicFareDiscount(actionSet.getPublicFareDiscount());
            tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0441\u043a\u0438\u0434\u043a\u0443 \u043e\u0442 \u043e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0432 " + actionSet.getPublicFareDiscount());
            product.getTripartiteContractDetails().setSubstitutePassengerType(actionSet.getSubstitutePassengerType());
            tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 " + actionSet.getSubstitutePassengerType());
            product.getTripartiteContractDetails().getSubstituteBrandIds().clear();
            product.getTripartiteContractDetails().getSubstituteBrandIds().putAll(actionSet.getSubstituteBrandIds());
            tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0437\u0430\u043c\u0435\u043d\u044f\u0435\u043c\u044b\u0435 brand id " + actionSet.getSubstituteBrandIds().entrySet().stream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(",")));
            if (!TextUtil.isBlank((String)actionSet.getContractCode())) {
                product.getTripartiteContractDetails().setContractCode(actionSet.getContractCode());
                tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + actionSet.getContractCode());
            } else {
                tracer.traceLogic("\u043d\u0435 \u043c\u0435\u043d\u044f\u0435\u043c \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0432 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430\u0445 \u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e \u043a\u043e\u0434\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            }
            product.getTripartiteContractDetails().setTripartiteContractRemark(actionSet.getTripartiteContractRemark());
            tracer.traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c 3D \u0440\u0435\u043c\u0430\u0440\u043a\u0443 " + actionSet.getTripartiteContractRemark());
        }
        catch (Throwable e2) {
            log.error(String.format("failed applying tripartite contracts for product %s", AirRulesHelper.getProductTitle(product)), e2);
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_SYSTEM_ERROR, (Throwable)e2, (Object[])new Object[0]));
        }
    }

    private AirSubsidizedContractRulesHelper() {
    }
}

