/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.profile.AviaTripartiteContractVendorData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.AviaTripartiteContractActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import com.gridnine.xtrip.server.model.helpers.TripartiteHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AirTripartiteContractRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(AirTripartiteContractRulesHelper.class);

    static AirTripartiteContractRulesResult applyTripartiteContracts(Product product, RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy, EntityReference<Organization> agencyRef) {
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        if (product.getTripartiteContractDetails().isNotApplyTripartiteContracts()) {
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        List<EntityContainer<TripartiteContract>> contracts = null;
        try {
            contracts = AirTripartiteContractRulesHelper.collectContracts(agencyRef, product, proxy);
        }
        catch (Throwable e2) {
            log.error(String.format("failed collecting tripartite contracts for product %s", AirRulesHelper.getProductTitle(product)), e2);
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_SYSTEM_ERROR, (Throwable)e2, (Object[])new Object[0]));
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        if (contracts.isEmpty()) {
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        proxy.setActionSet((Object)new AviaTripartiteContractActionSet(proxy, (ProductPropertySet)proxy.getPropertySet()));
        EntityContainer<TripartiteContract> contract = contracts.get(0);
        product.getTripartiteContractDetails().setTripartiteContract(contract.toReference());
        try {
            for (EntityContainer<TripartiteContract> ctr : contracts) {
                log.debug("applying contract " + ctr.toReference());
                ArrayList proxyList = new ArrayList();
                proxyList.add(proxy);
                HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
                RuleSet rules = AirTripartiteContractRulesHelper.applyRules(ctr, proxyList);
                proxy.getTracer().traceLogic(String.format("contract applied: contract = %s", ctr.toReference()));
                HashSet appliedRulesLocal = new HashSet(proxy.getAppliedRules());
                appliedRulesLocal.removeAll(appliedRulesBefore);
                if (appliedRulesLocal.isEmpty()) continue;
                proxy.getTracer().traceLogic(String.format("some rules applied: contract = %s", ctr.toReference()));
                for (String ruleUid : proxy.getAppliedRules()) {
                    RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                    if (rule == null) {
                        log.error(String.format("unable to find rule with uid %s in contract %s", ruleUid, ctr));
                        proxy.getTracer().traceWarn(String.format("unable to find rule: contract=%s, uid=%s", ctr.toReference(), ruleUid), null);
                        continue;
                    }
                    String logStr = String.format("rule \u2116 %s was applied", Integer.toString(rules.getRules().indexOf(rule) + 1));
                    proxy.getTracer().traceLogic(logStr);
                    log.debug(logStr);
                    AppliedRule ruleInfo = new AppliedRule();
                    ruleInfo.setCalculationDate(new Date());
                    ruleInfo.setContract(ctr.toReference());
                    ruleInfo.setProductUid(product.getUid());
                    ruleInfo.setRuleUid(rule.getUid());
                    ruleInfo.setRuleName(rule.getName());
                    ruleInfo.setRuleDescription(rule.getRestrictionsInfo());
                    product.getReservation().getBookingFile().getAppliedRules().add(ruleInfo);
                }
            }
        }
        catch (Throwable e3) {
            log.error(String.format("failed applying tripartite contracts for product %s", AirRulesHelper.getProductTitle(product)), e3);
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_SYSTEM_ERROR, (Throwable)e3, (Object[])new Object[0]));
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        AviaTripartiteContractActionSet actionSet = (AviaTripartiteContractActionSet)proxy.getActionSet();
        boolean issuedUnder3d = Boolean.TRUE.equals(actionSet.getIssuedUnder3d());
        product.getTripartiteContractDetails().setIssuedUnder3d(issuedUnder3d);
        proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d \u043f\u043e 3d \u0432 " + issuedUnder3d);
        product.getTripartiteContractDetails().setTourcodeType(actionSet.getCalculationIndicator());
        proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0442\u0438\u043f \u0442\u0443\u0440\u043a\u043e\u0434\u0430 \u0432 " + actionSet.getCalculationIndicator());
        product.getTripartiteContractDetails().setPublicFareDiscount(actionSet.getPublicFareDiscount());
        proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0441\u043a\u0438\u0434\u043a\u0443 \u043e\u0442 \u043e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0432 " + actionSet.getPublicFareDiscount());
        product.getTripartiteContractDetails().setSubstitutePassengerType(actionSet.getSubstitutePassengerType());
        proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 " + actionSet.getSubstitutePassengerType());
        product.getTripartiteContractDetails().getSubstituteBrandIds().clear();
        product.getTripartiteContractDetails().getSubstituteBrandIds().putAll(actionSet.getSubstituteBrandIds());
        proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0437\u0430\u043c\u0435\u043d\u044f\u0435\u043c\u044b\u0435 brand id " + actionSet.getSubstituteBrandIds().entrySet().stream().map(e -> String.join((CharSequence)"->", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(", ")));
        product.getTripartiteContractDetails().setUsePersonDiscountCard(actionSet.getUsePersonDiscountCard());
        if (!TextUtil.isBlank((String)actionSet.getContractCode())) {
            product.getTripartiteContractDetails().setContractCode(actionSet.getContractCode());
            proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + actionSet.getContractCode());
        } else {
            proxy.getTracer().traceLogic("\u043d\u0435 \u043c\u0435\u043d\u044f\u0435\u043c \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0432 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430\u0445 \u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e \u043a\u043e\u0434\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
        product.getTripartiteContractDetails().setTripartiteContractRemark(actionSet.getTripartiteContractRemark());
        proxy.getTracer().traceLogic("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c 3D \u0440\u0435\u043c\u0430\u0440\u043a\u0443 " + actionSet.getContractCode());
        HashMap<ContractType, Map<String, RuleResultValue>> result = new HashMap<ContractType, Map<String, RuleResultValue>>();
        for (Map.Entry<String, RuleResultValue> entry : ((ProductCommissionActionSet)proxy.getActionSet()).getResults().entrySet()) {
            RuleResultValue value = entry.getValue();
            ContractType contractType = value.getTarget() != null && FeeProperties.class.equals((Object)value.getTarget().getType()) ? ContractType.CLIENT : ContractType.VENDOR;
            HashMap<String, RuleResultValue> values = (HashMap<String, RuleResultValue>)result.get(contractType);
            if (values == null) {
                values = new HashMap<String, RuleResultValue>();
                result.put(contractType, values);
            }
            values.put(entry.getKey(), entry.getValue());
        }
        return new AirTripartiteContractRulesResult(result, true);
    }

    private static List<EntityContainer<TripartiteContract>> collectContracts(EntityReference<Organization> agencyRef, final Product prod, RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy) throws Exception {
        ArrayList<EntityContainer<TripartiteContract>> result = new ArrayList<EntityContainer<TripartiteContract>>();
        if (agencyRef == null) {
            proxy.getTracer().traceWarn(String.format("no agency defined for product %s, unable to apply tripartite contract", AirRulesHelper.getProductTitle(prod)), null);
            prod.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_AGENCY_NOT_DEFINED));
            return result;
        }
        if (prod.getReservation().getBookingFile().getCustomerProfile() == null) {
            proxy.getTracer().traceWarn(String.format("no client defined for product %s, unable to apply tripartite contract", AirRulesHelper.getProductTitle(prod)), null);
            prod.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_CLIENT_NOT_DEFINED));
            return result;
        }
        if (prod.getCarrier() == null) {
            proxy.getTracer().traceWarn(String.format("no carrier defined for product %s, unable to apply tripartite contract", AirRulesHelper.getProductTitle(prod)), null);
            prod.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_CARRIER_NOT_DEFINED));
            return result;
        }
        SearchQuery query = TripartiteHelper.initMainQueryForTripartite(agencyRef, (EntityReference<Organization>)prod.getReservation().getBookingFile().getCustomerProfile());
        DictionaryReference allAirlinesProfile = ProfileDao.findAllAirlinesProfile();
        final Airline carrier = (Airline)DictionaryCache.get().resolveReference(prod.getCarrier());
        SearchCriterion airlineSearchCriterion = carrier != null && carrier.getAlliance() != null ? SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorAirlines.name(), (Object)prod.getCarrier().getCode()), SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorAlliances.name(), (Object)carrier.getAlliance().getCode())}) : SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorAirlines.name(), (Object)prod.getCarrier().getCode());
        if (allAirlinesProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{airlineSearchCriterion, SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorAirlines.name(), (Object)allAirlinesProfile.getCode())}));
        } else {
            query.getCriteria().getCriterions().add(airlineSearchCriterion);
        }
        Date date = prod.getIssueDate();
        Date dayEnd = null;
        Date dayStart = null;
        if (date != null) {
            dayEnd = MiscUtil.setDayEndTime((Date)date);
            dayStart = MiscUtil.clearTime((Date)date);
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.firstStartDate.name(), null), SearchCriterion.le((String)TripartiteContractIndex.Property.firstStartDate.name(), (Object)dayEnd)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.lastEndDate.name(), null), SearchCriterion.ge((String)TripartiteContractIndex.Property.lastEndDate.name(), (Object)dayStart)}));
        }
        List indexes = EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
        block0: for (TripartiteContractIndex index : indexes) {
            EntityContainer ctr = EntityStorage.get().resolve(index.getSource());
            if (date != null) {
                TripartiteContractCustomerInfo info2;
                for (TripartiteContractCustomerInfo info2 : ((TripartiteContract)ctr.getEntity()).getCustomers()) {
                    if (!prod.getReservation().getBookingFile().getCustomerProfile().equals((Object)info2.getCustomer())) continue;
                    if (!AirTripartiteContractRulesHelper.isAppropriateDate(info2, dayStart, dayEnd)) continue block0;
                    result.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
                    continue block0;
                }
                Iterator iterator = ((TripartiteContract)ctr.getEntity()).getCustomers().iterator();
                if (!iterator.hasNext() || !AirTripartiteContractRulesHelper.isAppropriateDate(info2 = (TripartiteContractCustomerInfo)iterator.next(), dayStart, dayEnd)) continue;
                result.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
                continue;
            }
            result.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
        }
        Collections.sort(result, new Comparator<EntityContainer<TripartiteContract>>(){

            @Override
            public int compare(EntityContainer<TripartiteContract> o1, EntityContainer<TripartiteContract> o2) {
                int c = Integer.compare(this.getOrder(o1), this.getOrder(o2));
                return c != 0 ? c : MiscUtil.compare((Date)TripartiteHelper.findContractIssueDate(o1), (Date)TripartiteHelper.findContractIssueDate(o2), (boolean)false);
            }

            private int getOrder(EntityContainer<TripartiteContract> o) {
                AviaTripartiteContractVendorData data = ((TripartiteContract)o.getEntity()).getAviaVendorData();
                if (data.getAirlines().stream().anyMatch(a -> Objects.equals(prod.getCarrier().getCode(), a.getCode())) || carrier != null && carrier.getAlliance() != null && data.getAlliances().stream().anyMatch(a -> Objects.equals(carrier.getAlliance().getCode(), a.getCode()))) {
                    return 0;
                }
                return 1;
            }
        });
        return result;
    }

    private static boolean isAppropriateDate(TripartiteContractCustomerInfo info, Date dayStart, Date dayEnd) {
        if (info.getStartDate() != null && info.getStartDate().after(dayEnd)) {
            return false;
        }
        return info.getEndDate() == null || !info.getEndDate().before(dayStart);
    }

    private static RuleSet applyRules(EntityContainer<TripartiteContract> contract, List<RuleProxy<?, ?>> proxyList) throws Exception {
        RuleSet result = ((TripartiteContract)contract.getEntity()).getRuleSet();
        long start = System.currentTimeMillis();
        RuleEngine.applyRules(proxyList, (RuleSet)result);
        MiscUtil.logTiming((long)start, (String)String.format("contract %s applied to the product %s", contract.toReference(), HandlersRegistry.get().findProductHandler(Product.class).generateShortProductName((BaseProduct)((ProductPropertySet)proxyList.get(0).getPropertySet()).getProduct())));
        return result;
    }

    private AirTripartiteContractRulesHelper() {
    }

    static class AirTripartiteContractRulesResult {
        final Map<ContractType, Map<String, RuleResultValue>> commissions;
        final boolean hasTripartiteContracts;

        AirTripartiteContractRulesResult(Map<ContractType, Map<String, RuleResultValue>> commissionsValue, boolean hasTripartiteContractsValue) {
            this.commissions = commissionsValue;
            this.hasTripartiteContracts = hasTripartiteContractsValue;
        }
    }
}

