/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECManager;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BspProductVirtualizationHelper {
    private static final Logger log = LoggerFactory.getLogger(BspProductVirtualizationHelper.class);
    private static final ThreadLocal<SalesChain> salesChains = new ThreadLocal();
    private static final EntityReference<ContractRelationDescription> contractRelationRef = new EntityReference("temp-vendor-to-vendor-relation", ContractRelationDescription.class, "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 vendor-to-vendor  (\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c)");
    private static final EntityReference<ContractorDescription> superSupplierRef = new EntityReference("temp-super-supplier", ContractorDescription.class, "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 super supplier  (\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c)");

    static void virtualize(Product prod, RuleLogTracer tracer) throws Exception {
        MiscUtil.Pair<List<EntityContainer<Contract>>, List<ContractCustomerInfo>> contracts;
        EntityContainer<Contract> contract;
        boolean useSeparateBspContract;
        EntityReference supplierRef;
        SalesChain salesChain;
        List relations;
        block11: {
            EntityReference customerRef;
            block10: {
                salesChains.remove();
                if (!AirProductHelper.isBSPTicket((Product)prod)) {
                    BspProductVirtualizationHelper.traceLogic(tracer, "prod is not BSP, skipping BSP virtualization");
                    return;
                }
                relations = AirProductHelper.getContractRelations((Product)prod);
                if (relations.size() == 0) {
                    BspProductVirtualizationHelper.traceLogic(tracer, "relations size is 0, skipping BSP virtualization");
                    return;
                }
                EntityContainer descrCtr = EntityStorage.get().resolve(((AirProductContractRelationData)relations.get(0)).getDescription());
                if (descrCtr == null) {
                    BspProductVirtualizationHelper.traceLogic(tracer, "unable to load description of first relation, skipping BSP virtualization");
                    return;
                }
                salesChain = AirProductHelper.getSalesChain((Product)prod);
                supplierRef = GeneralProductHelper.getContractor((SalesChain)salesChain, (EntityReference)((ContractRelationDescription)descrCtr.getEntity()).getSupplier());
                if (supplierRef == null) {
                    BspProductVirtualizationHelper.traceLogic(tracer, "unable to define supplier, skipping BSP virtualization");
                    return;
                }
                if (supplierRef.equals((Object)prod.getBlankOwnerRef())) {
                    BspProductVirtualizationHelper.traceLogic(tracer, "blank owner equals supplier, skipping BSP virtualization");
                    return;
                }
                useSeparateBspContract = false;
                customerRef = GeneralProductHelper.getContractor((SalesChain)salesChain, (EntityReference)((ContractRelationDescription)descrCtr.getEntity()).getCustomer());
                contract = AirRulesHelper.getContract(ContractType.VENDOR, prod, (EntityReference<Organization>)prod.getBlankOwnerRef(), (EntityReference<Organization>)supplierRef, (EntityReference<Organization>)customerRef);
                if (contract == null) break block10;
                if (!((Contract)contract.getEntity()).isUseSeparateBSPContract()) break block11;
                useSeparateBspContract = true;
                BspProductVirtualizationHelper.traceLogic(tracer, String.format("found useSeparateBSPContract in %s", ((Contract)contract.getEntity()).getNumber()));
                break block11;
            }
            contracts = AirRulesHelper.collectOldContracts(ContractType.VENDOR, prod, (EntityReference<Organization>)prod.getBlankOwnerRef(), (EntityReference<Organization>)supplierRef, (EntityReference<Organization>)customerRef);
            if (contracts.getSecond() != null) {
                for (ContractCustomerInfo customerInfo : (List)contracts.getSecond()) {
                    if (!customerInfo.isUseSeparateBSPContract()) continue;
                    useSeparateBspContract = true;
                    BspProductVirtualizationHelper.traceLogic(tracer, String.format("found useSeparateBSPContract in %s", customerInfo.getNumber()));
                    break;
                }
            }
        }
        if (!useSeparateBspContract) {
            BspProductVirtualizationHelper.traceLogic(tracer, "no flag useSeparateBSPContract found, skipping BSP virtualization");
            return;
        }
        contract = AirRulesHelper.getContract(ContractType.VENDOR, prod, (EntityReference<Organization>)prod.getBlankOwnerRef(), (EntityReference<Organization>)prod.getBlankOwnerRef(), (EntityReference<Organization>)supplierRef);
        contracts = null;
        if (null == contract) {
            contracts = AirRulesHelper.collectOldContracts(ContractType.VENDOR, prod, (EntityReference<Organization>)prod.getBlankOwnerRef(), (EntityReference<Organization>)prod.getBlankOwnerRef(), (EntityReference<Organization>)supplierRef);
        }
        if (null == contract && ((List)contracts.getFirst()).isEmpty()) {
            BspProductVirtualizationHelper.traceLogic(tracer, String.format("no vendor contract collected between %s and %s, skipping BSP virtualization", prod.getBlankOwnerRef(), supplierRef));
            return;
        }
        SalesChain newSalesChain = BspProductVirtualizationHelper.getNewSalesChain(salesChain, (EntityReference<Organization>)prod.getBlankOwnerRef());
        salesChains.set(salesChain);
        AirProductHelper.setSalesChain((Product)prod, (SalesChain)newSalesChain);
        EntityContainer newSalesChainDescrCtr = EntityStorage.get().resolve(newSalesChain.getDescription());
        AirProductContractRelationData relation = (AirProductContractRelationData)XCloneHelper.clone((XCloneable)((XCloneable)relations.get(0)), (boolean)true);
        relation.setDescription((EntityReference)((SalesChainDescription)newSalesChainDescrCtr.getEntity()).getContractRelations().get(0));
        relations.add(0, relation);
        BspProductVirtualizationHelper.traceLogic(tracer, "product virtualized");
    }

    private static SalesChain getNewSalesChain(SalesChain salesChain, EntityReference<Organization> blankOwnerRef) throws Exception {
        EntityContainer salesChainDescrCtr = EntityStorage.get().resolve(salesChain.getDescription());
        int size = ((SalesChainDescription)salesChainDescrCtr.getEntity()).getContractRelations().size();
        String newSalesChainUid = String.format("temp-sales-chain-%s", Integer.toString(size + 1));
        EntityReference newSalesChainRef = new EntityReference(newSalesChainUid, SalesChainDescription.class, newSalesChainUid);
        EntityReference supplierDescrRef = GeneralProductHelper.findPredefinedContractorDescription((PredefinedContractorType)PredefinedContractorType.SUPPLIER);
        EntityContainer newSalesChainDescCtr = EntityStorage.get().resolve(newSalesChainRef);
        if (newSalesChainDescCtr == null) {
            EntityContainer contractRelationCtr;
            EntityContainer superSupplierDescrCtr = EntityStorage.get().resolve(superSupplierRef);
            if (superSupplierDescrCtr == null) {
                superSupplierDescrCtr = new EntityContainer(superSupplierRef.getType(), superSupplierRef.getUid());
                ((ContractorDescription)superSupplierDescrCtr.getEntity()).getName().setStringValue(supplierDescrRef.getCaption());
                ((ContractorDescription)superSupplierDescrCtr.getEntity()).setPredefinedType(PredefinedContractorType.SUPER_SUPPLIER);
                superSupplierDescrCtr = BspProductVirtualizationHelper.saveAdnInvalidateCache(superSupplierDescrCtr, false);
            }
            if ((contractRelationCtr = EntityStorage.get().resolve(contractRelationRef)) == null) {
                contractRelationCtr = new EntityContainer(contractRelationRef.getType(), contractRelationRef.getUid());
                ((ContractRelationDescription)contractRelationCtr.getEntity()).setSupplier(superSupplierRef);
                ((ContractRelationDescription)contractRelationCtr.getEntity()).setCustomer(supplierDescrRef);
                contractRelationCtr = BspProductVirtualizationHelper.saveAdnInvalidateCache(contractRelationCtr, false);
            }
            newSalesChainDescCtr = new EntityContainer(SalesChainDescription.class, newSalesChainUid);
            ((SalesChainDescription)newSalesChainDescCtr.getEntity()).getContractRelations().add(contractRelationRef);
            ((SalesChainDescription)newSalesChainDescCtr.getEntity()).getContractRelations().addAll(((SalesChainDescription)salesChainDescrCtr.getEntity()).getContractRelations());
            newSalesChainDescCtr = BspProductVirtualizationHelper.saveAdnInvalidateCache(newSalesChainDescCtr, false);
        }
        SalesChain result = new SalesChain();
        result.setDescription(newSalesChainRef);
        Contractor blankOwnerContractor = new Contractor();
        blankOwnerContractor.setDescription(superSupplierRef);
        blankOwnerContractor.setContractor(blankOwnerRef);
        result.getContractors().add(blankOwnerContractor);
        result.getContractors().addAll(salesChain.getContractors());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void devirtualize(Product prod, RuleLogTracer tracer) throws Exception {
        if (salesChains.get() == null) {
            return;
        }
        SalesChain oldSalesChain = salesChains.get();
        try {
            List relations = AirProductHelper.getContractRelations((Product)prod);
            AirProductContractRelationData relation = (AirProductContractRelationData)relations.remove(0);
            List commissions = relation.getCommissions();
            Collection filteredCommissions = GeneralProductHelper.filterCommissions((Collection)commissions, (Set)GeneralProductHelper.commissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, (Set)GeneralProductHelper.standardCommissionCategories);
            if (tracer != null) {
                BspProductVirtualizationHelper.traceLogic(tracer, String.format("%s (%s unfiltered) commissions calculated for virtualized relation", Integer.toString(filteredCommissions.size()), Integer.toString(commissions.size())));
            }
            relation = (AirProductContractRelationData)relations.get(0);
            ArrayList lst = new ArrayList(filteredCommissions);
            lst.addAll(relation.getCommissions());
            relation.getCommissions().clear();
            relation.getCommissions().addAll(lst);
        }
        finally {
            salesChains.remove();
            AirProductHelper.setSalesChain((Product)prod, (SalesChain)oldSalesChain);
        }
    }

    private static <E extends BaseEntity> EntityContainer<E> saveAdnInvalidateCache(EntityContainer<E> ctr, boolean withCheckPoint) throws Exception {
        AECManager manager = (AECManager)Environment.getPublished(EntityCacheManager.class);
        manager.invalidate(new ModificationData((XSerializable)ctr.toReference(), Collections.emptyList()));
        return EntityStorage.get().save(ctr, false);
    }

    private static void traceLogic(RuleLogTracer tracer, String message) {
        log.debug(message);
        tracer.traceLogic(message);
    }

    private BspProductVirtualizationHelper() {
    }
}

