/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers.rules;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ClassOfServiceVirtualizationHelper {
    static final String CLASS_OF_SERVICE_VIRTUAL_TICKET_PREFFIX = "CLASS_OF_SERVICE_VIRTUAL:";

    /*
     * WARNING - void declaration
     */
    static void virtualize(Product ticket, List<Product> result) throws Exception {
        result.add(ticket);
        if (!"870".equals(ticket.getCarrierNumber())) {
            return;
        }
        if (ticket.getProductCategory() != ProductCategory.AIR && (ticket.getProductCategory() != ProductCategory.MCO || ticket.getMcoCategory() != MCOCategory.PTA)) {
            return;
        }
        LinkedHashMap classOfServices = new LinkedHashMap();
        for (SegmentTariff st : ticket.getSegmentTariffs()) {
            LinkedHashSet<void> segmentClassOfServices = new LinkedHashSet<void>();
            for (Segment segment : st.getSegments()) {
                void var8_13;
                void var8_11;
                String string = segment.getClassOfSvcCode();
                if (TextUtil.isBlank((String)string) && !TextUtil.isBlank((String)segment.getFareBasis())) {
                    String string2 = segment.getFareBasis().trim().substring(0, 1).toUpperCase();
                }
                if (TextUtil.isBlank((String)var8_11)) {
                    String string3 = "";
                }
                segmentClassOfServices.add(var8_13);
            }
            List<Object> tariffs = null;
            for (Map.Entry entry : classOfServices.entrySet()) {
                Set key = (Set)entry.getKey();
                List value = (List)entry.getValue();
                if (!key.containsAll(segmentClassOfServices) || !segmentClassOfServices.containsAll(key)) continue;
                tariffs = value;
                break;
            }
            if (tariffs == null) {
                tariffs = new ArrayList<SegmentTariff>();
                classOfServices.put(segmentClassOfServices, tariffs);
            }
            tariffs.add(st);
        }
        if (classOfServices.size() < 2) {
            return;
        }
        ArrayList<ProductFare> totalFares = new ArrayList<ProductFare>();
        HashMap<SegmentTariff, ArrayList<ProductFare>> segmentFares = new HashMap<SegmentTariff, ArrayList<ProductFare>>();
        BigDecimal totalFare = BigDecimal.ZERO;
        BigDecimal segmentFare = BigDecimal.ZERO;
        for (ProductFare productFare : ticket.getFares()) {
            if (productFare.getEquivalentFare() == null) continue;
            if (productFare.getSegmentTariff() == null) {
                totalFares.add(productFare);
                totalFare = totalFare.add(productFare.getEquivalentFare());
                continue;
            }
            ArrayList<ProductFare> lst = (ArrayList<ProductFare>)segmentFares.get(productFare.getSegmentTariff());
            if (lst == null) {
                lst = new ArrayList<ProductFare>();
                segmentFares.put(productFare.getSegmentTariff(), lst);
            }
            lst.add(productFare);
            segmentFare = segmentFare.add(productFare.getEquivalentFare());
        }
        if (totalFare.doubleValue() > 0.0 && Math.abs(totalFare.subtract(segmentFare).doubleValue()) > 0.01) {
            ticket.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.COSVH_FARE_NOT_EQUAL_SUM, (Object[])new Object[]{totalFare.doubleValue(), segmentFare.doubleValue()}));
            return;
        }
        for (List list : classOfServices.values()) {
            Product vTicket = new Product();
            AirProductHelper.copy((Product)ticket, (Product)vTicket, (boolean)false);
            vTicket.setUid(CLASS_OF_SERVICE_VIRTUAL_TICKET_PREFFIX + vTicket.getUid() + '|' + ticket.getUid());
            result.add(vTicket);
            vTicket.getValidationMessages().clear();
            vTicket.getFares().clear();
            vTicket.getSegmentTariffs().clear();
            vTicket.getSegmentTariffs().addAll(list);
            for (SegmentTariff st : list) {
                List fares = (List)segmentFares.get(st);
                if (fares == null) continue;
                vTicket.getFares().addAll(fares);
            }
        }
    }

    static void deVirtualize(List<Product> products) {
        Product ticket;
        LinkedHashMap<Product, ArrayList<Product>> productMap = new LinkedHashMap<Product, ArrayList<Product>>();
        for (Product product : products) {
            if (!product.getUid().startsWith(CLASS_OF_SERVICE_VIRTUAL_TICKET_PREFFIX)) continue;
            ticket = (Product)BookingHelper.findProduct((BookingFile)product.getReservation().getBookingFile(), (String)product.getUid().substring(product.getUid().indexOf(124) + 1));
            if (ticket == null) {
                AirRulesHelper.log.warn("can't find original product for virtual one");
                continue;
            }
            ArrayList<Product> lst = (ArrayList<Product>)productMap.get(ticket);
            if (lst == null) {
                lst = new ArrayList<Product>();
                productMap.put(ticket, lst);
            }
            lst.add(product);
        }
        for (Map.Entry entry : productMap.entrySet()) {
            ticket = (Product)entry.getKey();
            for (AirProductContractRelationData contractRelation : AirProductHelper.getContractRelations((Product)ticket)) {
                Iterator it = contractRelation.getCommissions().iterator();
                while (it.hasNext()) {
                    Commission comm = (Commission)it.next();
                    if (comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
                    it.remove();
                }
            }
            for (Product product : (List)entry.getValue()) {
                for (AirProductContractRelationData contractRelation : AirProductHelper.getContractRelations((Product)product)) {
                    AirProductContractRelationData ticketCR = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)ticket), (EntityReference)contractRelation.getDescription());
                    for (Commission comm : contractRelation.getCommissions()) {
                        if (comm.getCommissionProperties() != null && !CommissionProperties.class.isAssignableFrom(comm.getCommissionProperties().getType())) continue;
                        if (!product.getSegmentTariffs().isEmpty()) {
                            comm.setSegmentTariff((SegmentTariff)product.getSegmentTariffs().get(0));
                        }
                        ticketCR.getCommissions().add(comm);
                    }
                }
                for (ValidationMessage message : product.getValidationMessages()) {
                    if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                    ticket.getValidationMessages().add(message);
                }
                products.remove(product);
                ticket.getReservation().getProducts().remove(product);
                ticket.setContractRulesApplied(true);
            }
        }
    }

    private ClassOfServiceVirtualizationHelper() {
    }
}

